/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import jd.controlling.downloadcontroller.DiskSpaceManager;
import jd.controlling.downloadcontroller.DiskSpaceReservation;
import jd.controlling.downloadcontroller.DownloadSession;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.linkcollector.LinknameCleaner;
import jd.plugins.download.DownloadLinkDownloadable;
import jd.plugins.download.raf.FileBytesCache;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.controlling.UniqueAlltimeID;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.CFG_EXTRACTION;
import org.jdownloader.extensions.extraction.ExtractionConfig;
import org.jdownloader.extensions.extraction.ExtractionEvent;
import org.jdownloader.extensions.extraction.ExtractionException;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.ExtractionInfo;
import org.jdownloader.extensions.extraction.ExtractionProgress;
import org.jdownloader.extensions.extraction.ExtractionQueue;
import org.jdownloader.extensions.extraction.FileSignatures;
import org.jdownloader.extensions.extraction.IExtraction;
import org.jdownloader.extensions.extraction.IO_MODE;
import org.jdownloader.extensions.extraction.Item;
import org.jdownloader.extensions.extraction.bindings.downloadlink.DownloadLinkArchiveFile;
import org.jdownloader.extensions.extraction.bindings.file.FileArchiveFile;
import org.jdownloader.extensions.extraction.multi.ArchiveType;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.IfFileExistsAction;

public class ExtractionController
extends QueueAction<Void, RuntimeException>
implements GenericConfigEventListener<Enum> {
    private List<String> passwordList;
    private Exception exception;
    private final Archive archive;
    private final IExtraction extractor;
    private ScheduledFuture<?> timer;
    private ExtractionEvent.Type latestEvent;
    private final AtomicLong completeBytes = new AtomicLong(0L);
    private final AtomicLong processedBytes = new AtomicLong(0L);
    private volatile IO_MODE crcHashing = IO_MODE.NORMAL;
    private final boolean applyFilenameRegexReplaceMapToExtractionPaths = CFG_EXTRACTION.CFG.isApplyFilenameRegexReplaceMapToExtractionPaths();
    private final ExtractionExtension extension;
    private final LogSource logger;
    private FileSignatures fileSignatures = null;
    private IfFileExistsAction ifFileExistsAction;
    private File extractToFolder;
    private boolean successful = false;
    private boolean askForUnknownPassword = false;
    private Item currentActiveItem;
    private final ExtractionProgress extractionProgress;
    protected final FileBytesCache fileBytesCache;
    private final UniqueAlltimeID uniqueID = new UniqueAlltimeID();

    public boolean isSameArchive(Archive archive) {
        if (archive == null) {
            return false;
        }
        if (this.getArchive() == archive) {
            return true;
        }
        if (!StringUtils.equals((String)this.getArchive().getArchiveID(), (String)archive.getArchiveID())) {
            return false;
        }
        if (this.getArchive().getArchiveType() != archive.getArchiveType() || this.getArchive().getSplitType() != archive.getSplitType()) {
            return false;
        }
        if (this.getArchive().getArchiveFiles().size() != archive.getArchiveFiles().size()) {
            return false;
        }
        String thisFirstFilePath = this.getArchive().getArchiveFiles().get(0).getFilePath();
        String otherFirstFilePath = archive.getArchiveFiles().get(0).getFilePath();
        File thisFolder = this.getArchive().getFolder();
        File otherFolder = archive.getFolder();
        if (!StringUtils.equals((String)thisFirstFilePath, (String)otherFirstFilePath)) {
            return false;
        }
        return thisFolder.equals(otherFolder);
    }

    public boolean isOutDatedArchive(Archive archive) {
        if (archive == null) {
            return false;
        }
        if (this.getArchive().getArchiveType() != archive.getArchiveType() || this.getArchive().getSplitType() != archive.getSplitType()) {
            return false;
        }
        String thisFirstFilePath = this.getArchive().getArchiveFiles().get(0).getFilePath();
        String otherFirstFilePath = archive.getArchiveFiles().get(0).getFilePath();
        File thisFolder = this.getArchive().getFolder();
        File otherFolder = archive.getFolder();
        if (!StringUtils.equals((String)thisFirstFilePath, (String)otherFirstFilePath)) {
            return false;
        }
        if (!thisFolder.equals(otherFolder)) {
            return false;
        }
        return this.getArchive().getArchiveFiles().size() < archive.getArchiveFiles().size();
    }

    public long getCompleteBytes() {
        return this.completeBytes.get();
    }

    public void setCompleteBytes(long completeBytes) {
        this.completeBytes.set(Math.max(0L, completeBytes));
    }

    public long getProcessedBytes() {
        return this.processedBytes.get();
    }

    public void setProcessedBytes(long processedBytes) {
        this.processedBytes.set(Math.max(0L, processedBytes));
    }

    public IO_MODE getIOModeForCrcHashing() {
        IO_MODE mode = this.crcHashing;
        switch (mode) {
            case PAUSE: 
            case THROTTLE: {
                if (!DownloadLinkDownloadable.isCrcHashingInProgress()) break;
                return mode;
            }
        }
        return IO_MODE.NORMAL;
    }

    public void addProcessedBytesAndPauseIfNeeded(long processedBytes) {
        try {
            if (!IO_MODE.NORMAL.equals((Object)this.getIOModeForCrcHashing())) {
                block6: while (true) {
                    switch (this.getIOModeForCrcHashing()) {
                        case PAUSE: {
                            Thread.sleep(1000L);
                            continue block6;
                        }
                        case THROTTLE: {
                            Thread.sleep(100L);
                        }
                    }
                    break;
                }
            }
        }
        catch (InterruptedException e) {
            this.logger.log((Throwable)e);
        }
        this.processedBytes.addAndGet(Math.max(0L, processedBytes));
    }

    public UniqueAlltimeID getUniqueID() {
        return this.uniqueID;
    }

    public FileBytesCache getFileBytesCache() {
        return this.fileBytesCache;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public File getExtractToFolder() {
        return this.extractToFolder;
    }

    public FileSignatures getFileSignatures() {
        if (this.fileSignatures == null) {
            this.fileSignatures = new FileSignatures();
        }
        return this.fileSignatures;
    }

    public ExtractionProgress getExtractionProgress() {
        return this.extractionProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postRun() {
        ExtractionExtension extractionExtension = this.extension;
        synchronized (extractionExtension) {
            ArrayList<ExtractionController> removeList = new ArrayList<ExtractionController>();
            for (ExtractionController ec : this.getExtractionQueue().getJobs()) {
                if (!ec.isSameArchive(this.archive)) continue;
                removeList.add(ec);
            }
            for (ExtractionController ec : removeList) {
                if (ec == this) continue;
                this.getExtractionQueue().remove(ec);
            }
        }
    }

    ExtractionController(ExtractionExtension extractionExtension, Archive archiv, IExtraction extractor) {
        this.archive = archiv;
        this.logger = LogController.CL((boolean)false);
        this.logger.setAllowTimeoutFlush(false);
        this.logger.info("Extraction of" + this.archive);
        this.extractor = extractor;
        this.extractionProgress = new ExtractionProgress(this, 0L, 0L, null);
        extractor.setExtractionController(this);
        this.extension = extractionExtension;
        extractor.setLogger(this.logger);
        this.passwordList = new CopyOnWriteArrayList<String>();
        this.archive.setExtractionController(this);
        this.fileBytesCache = DownloadSession.getDownloadWriteCache();
        CFG_EXTRACTION.IOMODE_CRCHASHING.getEventSender().addListener((EventListener)((Object)this), true);
        this.crcHashing = (IO_MODE)((Object)CFG_EXTRACTION.IOMODE_CRCHASHING.getValue());
    }

    public ExtractionQueue getExtractionQueue() {
        return (ExtractionQueue)super.getQueue();
    }

    public boolean kill() {
        if (this.gotStarted()) {
            this.logger.info("abort extraction");
            this.logger.flush();
        } else {
            this.logger.close();
        }
        if (super.kill()) {
            if (this.gotStarted()) {
                this.extension.getEventSender().fireEvent((DefaultEvent)new ExtractionEvent(this, ExtractionEvent.Type.CLEANUP));
            }
            return true;
        }
        return false;
    }

    public LogSource getLogger() {
        return this.logger;
    }

    protected boolean allowAsync() {
        return true;
    }

    private boolean checkPassword(String pw, boolean optimized) throws ExtractionException {
        this.logger.info("Check Password: '" + pw + "'");
        if (StringUtils.isEmpty((String)pw)) {
            return false;
        }
        this.fireEvent(ExtractionEvent.Type.PASSWORT_CRACKING);
        return this.extractor.findPassword(this, pw, optimized);
    }

    private void fireEvent(ExtractionEvent.Type event) {
        this.latestEvent = event;
        ExtractionExtension.getInstance().fireEvent(new ExtractionEvent(this, event));
    }

    public ExtractionEvent.Type getLatestEvent() {
        return this.latestEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Void run() {
        List<String> pwList;
        block123: {
            block124: {
                Iterator<String> iterator;
                String correctPW;
                boolean isPasswordFindOptimizationEnabled;
                block125: {
                    ArchiveFile firstArchiveFile = this.archive.getArchiveFiles().get(0);
                    try {
                        Iterator<ArchiveFile> iterator2;
                        this.fireEvent(ExtractionEvent.Type.START);
                        this.archive.onStartExtracting();
                        this.logger.info("Date:" + new Date());
                        this.logger.info("Start Extracting");
                        this.logger.info("Archive Setup: \r\n" + JSonStorage.toString((Object)this.archive.getSettings()));
                        this.logger.info("Start unpacking of " + firstArchiveFile.getFilePath());
                        for (ArchiveFile archiveFile : this.archive.getArchiveFiles()) {
                            DownloadLinkArchiveFile downloadLinkArchiveFile;
                            if (!archiveFile.exists(true)) {
                                if (archiveFile instanceof DownloadLinkArchiveFile) {
                                    downloadLinkArchiveFile = (DownloadLinkArchiveFile)archiveFile;
                                    this.logger.info("Missing (DownloadLinkArchiveFile)File: " + archiveFile.getFilePath() + "|FileArchiveFileExists:" + downloadLinkArchiveFile.isFileArchiveFileExists());
                                } else if (archiveFile instanceof FileArchiveFile) {
                                    this.logger.info("Missing (FileArchiveFile)File: " + archiveFile.getFilePath());
                                } else {
                                    this.logger.info("Missing File: " + archiveFile.getFilePath());
                                }
                                this.logger.info("Could not find archive file " + archiveFile.getFilePath());
                                this.archive.addMissingFile(archiveFile);
                                continue;
                            }
                            if (archiveFile instanceof DownloadLinkArchiveFile) {
                                downloadLinkArchiveFile = (DownloadLinkArchiveFile)archiveFile;
                                this.logger.info(" (DownloadLinkArchiveFile)File:" + archiveFile.getFilePath() + "|FileArchiveFileExists:" + downloadLinkArchiveFile.isFileArchiveFileExists() + "|FileSize:" + archiveFile.getFileSize());
                                continue;
                            }
                            if (archiveFile instanceof FileArchiveFile) {
                                this.logger.info(" (FileArchiveFile)File:" + archiveFile.getFilePath() + "|FileSize:" + archiveFile.getFileSize());
                                continue;
                            }
                            this.logger.info(" File:" + archiveFile.getFilePath() + "|FileSize:" + archiveFile.getFileSize());
                        }
                        if (this.archive.getMissingFiles().size() > 0) {
                            this.fireEvent(ExtractionEvent.Type.FILE_NOT_FOUND);
                            this.logger.info("Failed");
                            iterator2 = null;
                            return iterator2;
                        }
                        if (this.gotKilled()) {
                            iterator2 = null;
                            return iterator2;
                        }
                        this.logger.info("Prepare - " + new Date());
                        if (this.extractor.prepare()) {
                            if (!this.archive.isProtected()) break block123;
                            isPasswordFindOptimizationEnabled = ((ExtractionConfig)this.getExtension().getSettings()).isPasswordFindOptimizationEnabled();
                            this.logger.info("Archive is Protected - " + new Date());
                            if (!StringUtils.isEmpty((String)this.archive.getFinalPassword()) && !this.checkPassword(this.archive.getFinalPassword(), false)) {
                                this.logger.info("Password " + this.archive.getFinalPassword() + " is invalid, try to find correct one");
                                this.archive.setFinalPassword(null);
                            }
                            if (!StringUtils.isEmpty((String)this.archive.getFinalPassword())) break block124;
                            this.logger.info("Try to find password");
                            List<String> spwList = this.archive.getSettings().getPasswords();
                            if (spwList != null) {
                                this.passwordList.addAll(spwList);
                            }
                            this.passwordList.addAll(this.archive.getFactory().getGuessedPasswordList(this.archive));
                            this.passwordList.add(this.archive.getName());
                            pwList = this.extractor.getConfig().getPasswordList();
                            if (pwList == null) {
                                pwList = new ArrayList<String>();
                            }
                            this.passwordList.addAll(pwList);
                            this.fireEvent(ExtractionEvent.Type.START_CRACK_PASSWORD);
                            this.logger.info("Start password finding for " + this.archive + " - " + new Date());
                            correctPW = null;
                            iterator = this.passwordList.iterator();
                            break block125;
                        }
                        this.logger.info("ExitCode(Prepare failed): " + this.archive.getExitCode());
                        switch (this.archive.getExitCode()) {
                            case 3: {
                                this.fireEvent(ExtractionEvent.Type.EXTRACTION_FAILED_CRC);
                                return null;
                            }
                        }
                        this.fireEvent(ExtractionEvent.Type.EXTRACTION_FAILED);
                        return null;
                    }
                    catch (Exception e) {
                        this.exception = e;
                        this.logger.log((Throwable)e);
                        this.fireEvent(ExtractionEvent.Type.EXTRACTION_FAILED);
                        return null;
                    }
                    finally {
                        try {
                            try {
                                this.extractor.close();
                            }
                            catch (Throwable throwable) {}
                            if (this.gotKilled()) {
                                this.logger.clear();
                            }
                            this.fireEvent(ExtractionEvent.Type.CLEANUP);
                            this.archive.onCleanUp();
                        }
                        finally {
                            this.logger.close();
                        }
                    }
                }
                while (iterator.hasNext()) {
                    String password = iterator.next();
                    if (password == null) continue;
                    if (this.gotKilled()) {
                        return null;
                    }
                    if (this.checkPassword(password, isPasswordFindOptimizationEnabled)) {
                        correctPW = password;
                        this.logger.info("Found password: \"" + correctPW + "\" - " + new Date());
                        break;
                    }
                    String trimmed = password.trim();
                    if (trimmed.length() == password.length() || !this.checkPassword(trimmed, isPasswordFindOptimizationEnabled)) continue;
                    correctPW = trimmed;
                    this.logger.info("Found password: \"" + correctPW + "\" - " + new Date());
                    break;
                }
                if (correctPW == null) {
                    this.fireEvent(ExtractionEvent.Type.PASSWORD_NEEDED_TO_CONTINUE);
                    this.logger.info("Ask for password");
                    this.logger.info("Found no password in passwordlist " + this.archive);
                    if (this.gotKilled()) {
                        return null;
                    }
                    if (!this.checkPassword(this.archive.getFinalPassword(), false)) {
                        this.fireEvent(ExtractionEvent.Type.EXTRACTION_FAILED);
                        this.logger.info("No password found for " + this.archive);
                        this.logger.info("Failed");
                        return null;
                    }
                }
                this.fireEvent(ExtractionEvent.Type.PASSWORD_FOUND);
                this.logger.info("Found password for " + this.archive + "->" + this.archive.getFinalPassword() + " - " + new Date());
            }
            if (StringUtils.isNotEmpty((String)this.archive.getFinalPassword())) {
                this.getExtension().addPassword(this.archive.getFinalPassword());
            }
        }
        this.extractToFolder = this.getExtension().getFinalExtractToFolder(this.archive, false);
        this.logger.info("Extract To: " + this.extractToFolder + " - " + new Date());
        DiskSpaceReservation extractReservation = new DiskSpaceReservation(){

            public long getSize() {
                long completeSize = Math.max(ExtractionController.this.getCompleteBytes(), ExtractionController.this.archive.getContentView().getTotalSize());
                long ret = completeSize - ExtractionController.this.getProcessedBytes();
                return ret;
            }

            public File getDestination() {
                return ExtractionController.this.getExtractToFolder();
            }

            public Object getOwner() {
                return ExtractionController.this;
            }

            public LogInterface getLogger() {
                return ExtractionController.this.getLogger();
            }
        };
        DiskSpaceManager.DISKSPACERESERVATIONRESULT reservationResult = DownloadWatchDog.getInstance().getSession().getDiskSpaceManager().checkAndReserve(extractReservation, (Object)this);
        try {
            switch (reservationResult) {
                case FAILED: {
                    this.fireEvent(ExtractionEvent.Type.NOT_ENOUGH_SPACE);
                    pwList = null;
                    return pwList;
                }
                case INVALIDDESTINATION: {
                    this.fireEvent(ExtractionEvent.Type.EXTRACTION_FAILED);
                    pwList = null;
                    return pwList;
                }
            }
            this.fireEvent(ExtractionEvent.Type.OPEN_ARCHIVE_SUCCESS);
            if (!this.getExtractToFolder().exists() && !FileCreationManager.getInstance().mkdir(this.getExtractToFolder())) {
                this.logger.info("Could not create subpath: " + this.getExtractToFolder());
                this.logger.info("Failed");
                this.fireEvent(ExtractionEvent.Type.EXTRACTION_FAILED);
                pwList = null;
                return pwList;
            }
            this.logger.info("Execute unpacking of:" + this.archive);
            this.logger.info("Extract to " + this.getExtractToFolder());
            this.logger.info("Use Password: " + this.archive.getFinalPassword() + "|PW Protected:" + this.archive.isProtected() + ":" + this.archive.isPasswordRequiredToOpen());
            ScheduledExecutorService scheduler = null;
            try {
                this.logger.info("Start Extracting " + this.extractor + " - " + new Date());
                scheduler = DelayedRunnable.getNewScheduledExecutorService();
                this.timer = scheduler.scheduleWithFixedDelay(new Runnable(){

                    @Override
                    public void run() {
                        ExtractionController.this.fireEvent(ExtractionEvent.Type.EXTRACTING);
                    }
                }, 1L, 1L, TimeUnit.SECONDS);
                this.extractor.extract(this);
            }
            finally {
                this.extractor.close();
                this.logger.info("Extractor Returned - " + new Date());
                if (this.timer != null) {
                    this.timer.cancel(false);
                }
                if (scheduler != null) {
                    scheduler.shutdown();
                }
                if (this.extractor.getLastAccessedArchiveFile() != null) {
                    this.logger.info("Last used File: " + this.extractor.getLastAccessedArchiveFile());
                }
                this.fireEvent(ExtractionEvent.Type.EXTRACTING);
            }
        }
        finally {
            DownloadWatchDog.getInstance().getSession().getDiskSpaceManager().free(extractReservation, (Object)this);
        }
        if (this.gotKilled()) {
            return null;
        }
        if (this.extractor.getException() != null) {
            this.exception = this.extractor.getException();
            this.logger.log((Throwable)this.exception);
        }
        if (this.exception != null) {
            this.logger.log((Throwable)this.exception);
        }
        this.logger.info("ExitCode: " + this.archive.getExitCode());
        switch (this.archive.getExitCode()) {
            case 0: {
                this.logger.info("Unpacking successful for " + this.archive);
                this.archive.getSettings().setExtractionInfo(new ExtractionInfo(this.getExtractToFolder(), this.archive));
                this.logger.info("Info: \r\n" + JSonStorage.serializeToJson((Object)new ExtractionInfo(this.getExtractToFolder(), this.archive)));
                this.logger.info("Successful");
                this.successful = true;
                this.fireEvent(ExtractionEvent.Type.FINISHED);
                this.logger.clear();
                return null;
            }
            case 4: {
                this.fireEvent(ExtractionEvent.Type.FILE_NOT_FOUND);
                return null;
            }
            case 3: {
                this.fireEvent(ExtractionEvent.Type.EXTRACTION_FAILED_CRC);
                return null;
            }
            case 255: {
                this.fireEvent(ExtractionEvent.Type.EXTRACTION_FAILED);
                return null;
            }
            case 9: {
                this.fireEvent(ExtractionEvent.Type.EXTRACTION_FAILED);
                return null;
            }
            case 5: {
                this.exception = new ExtractionException("Write to disk error");
                this.fireEvent(ExtractionEvent.Type.EXTRACTION_FAILED);
                return null;
            }
            case 2: {
                this.fireEvent(ExtractionEvent.Type.EXTRACTION_FAILED);
                return null;
            }
            case 1: {
                this.fireEvent(ExtractionEvent.Type.EXTRACTION_FAILED);
                return null;
            }
            default: {
                this.fireEvent(ExtractionEvent.Type.EXTRACTION_FAILED);
            }
        }
        return null;
    }

    void removeArchiveFiles() {
        Archive archive = this.getArchive();
        FileCreationManager.DeleteOption remove = archive.getFactory().isDeepExtraction() ? FileCreationManager.DeleteOption.NULL : this.getExtension().getRemoveFilesAfterExtractAction(archive);
        if (remove == null) {
            return;
        }
        if (FileCreationManager.DeleteOption.NO_DELETE.equals((Object)remove)) {
            return;
        }
        if (ArchiveType.RAR_MULTI.equals(archive.getArchiveType())) {
            HashSet<String> done = new HashSet<String>();
            for (ArchiveFile link : archive.getArchiveFiles()) {
                String filePath;
                File file;
                if (!done.add(link.getName()) || !(file = new File(filePath = link.getFilePath().replaceFirst("(?i)\\.rar$", ".rev"))).exists() || !file.isFile()) continue;
                this.logger.info("Deleting rar recovery volume " + file.getAbsolutePath());
                if (file.delete()) continue;
                this.logger.warning("Could not deleting rar recovery volume " + file.getAbsolutePath());
            }
        }
        for (ArchiveFile link : archive.getArchiveFiles()) {
            link.deleteFile(remove);
        }
    }

    public ExtractionExtension getExtension() {
        return this.extension;
    }

    public Exception getException() {
        return this.exception;
    }

    public int getCrackProgress() {
        return this.extractor.getCrackProgress();
    }

    public int getPasswordListSize() {
        return this.passwordList.size();
    }

    public void go() throws Exception {
        this.run();
    }

    public Archive getArchive() {
        return this.archive;
    }

    public void setExeption(Exception e) {
        this.exception = e;
    }

    public void setIfFileExistsAction(IfFileExistsAction ifExistsAction) {
        this.ifFileExistsAction = ifExistsAction;
    }

    public IfFileExistsAction getIfFileExistsAction() {
        return this.ifFileExistsAction;
    }

    public boolean isAskForUnknownPassword() {
        return this.askForUnknownPassword;
    }

    public void setAskForUnknownPassword(boolean askForUnknownPassword) {
        this.askForUnknownPassword = askForUnknownPassword;
    }

    public void setCurrentActiveItem(Item item) {
        if (this.currentActiveItem != item) {
            if (this.currentActiveItem != null && item != null && StringUtils.equals((String)this.currentActiveItem.getPath(), (String)item.getPath())) {
                return;
            }
            this.currentActiveItem = item;
            this.fireEvent(ExtractionEvent.Type.ACTIVE_ITEM);
        }
    }

    public Item getCurrentActiveItem() {
        return this.currentActiveItem;
    }

    public double getProgress() {
        double percent = (double)this.getProcessedBytes() * 100.0 / (double)Math.max(1L, this.getCompleteBytes());
        return percent;
    }

    public void onConfigValidatorError(KeyHandler<Enum> keyHandler, Enum invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Enum> keyHandler, Enum newValue) {
        if (keyHandler == CFG_EXTRACTION.IOMODE_CRCHASHING) {
            IO_MODE newMode = (IO_MODE)newValue;
            this.crcHashing = newMode == null ? IO_MODE.NORMAL : newMode;
        }
    }

    public String getCleanedExtractionPath(String inputPath) {
        String[] pathSegments = inputPath.split("(/|\\\\)");
        StringBuilder cleanpath = new StringBuilder();
        boolean newSegmentAdded = false;
        for (String pathSegment : pathSegments) {
            String cleanedSegment;
            if (newSegmentAdded) {
                cleanpath.append(File.separator);
                newSegmentAdded = false;
            }
            if ((cleanedSegment = this.applyFilenameRegexReplaceMapToExtractionPaths ? LinknameCleaner.cleanFilename((String)pathSegment) : CrossSystem.alleviatePathParts((String)pathSegment, (boolean)true)).length() <= 0) continue;
            cleanpath.append(cleanedSegment);
            newSegmentAdded = true;
        }
        return cleanpath.toString();
    }
}

