/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import jd.SecondLevelLaunch;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.PackageControllerModifyVetoListener;
import jd.plugins.AddonPanel;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.shutdown.ShutdownVetoException;
import org.appwork.shutdown.ShutdownVetoListener;
import org.appwork.uio.UIOManager;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.JVMVersion;
import org.appwork.utils.ModifyLock;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.controlling.FileCreationListener;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.controlling.contextmenu.ActionData;
import org.jdownloader.controlling.contextmenu.ContextMenuManager;
import org.jdownloader.controlling.contextmenu.MenuContainerRoot;
import org.jdownloader.controlling.contextmenu.MenuExtenderHandler;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.controlling.contextmenu.SeparatorData;
import org.jdownloader.controlling.packagizer.PackagizerController;
import org.jdownloader.extensions.AbstractExtension;
import org.jdownloader.extensions.ExtensionConfigPanel;
import org.jdownloader.extensions.StartException;
import org.jdownloader.extensions.StopException;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFactory;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.CFG_EXTRACTION;
import org.jdownloader.extensions.extraction.DummyArchive;
import org.jdownloader.extensions.extraction.ExtractionConfig;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionEvent;
import org.jdownloader.extensions.extraction.ExtractionEventSender;
import org.jdownloader.extensions.extraction.ExtractionListenerIcon;
import org.jdownloader.extensions.extraction.ExtractionListenerList;
import org.jdownloader.extensions.extraction.ExtractionQueue;
import org.jdownloader.extensions.extraction.IExtraction;
import org.jdownloader.extensions.extraction.actions.ExtractAction;
import org.jdownloader.extensions.extraction.bindings.crawledlink.CrawledLinkArchiveFile;
import org.jdownloader.extensions.extraction.bindings.crawledlink.CrawledLinkFactory;
import org.jdownloader.extensions.extraction.bindings.downloadlink.DownloadLinkArchiveFactory;
import org.jdownloader.extensions.extraction.bindings.file.FileArchiveFactory;
import org.jdownloader.extensions.extraction.bindings.file.FileArchiveFile;
import org.jdownloader.extensions.extraction.contextmenu.ArchivesSubMenu;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.ArchiveValidator;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.CleanupSubMenu;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.action.AbortExtractionAction;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.action.AutoExtractEnabledToggleAction;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.action.CleanupAutoDeleteFilesEnabledToggleAction;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.action.CleanupAutoDeleteLinksEnabledToggleAction;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.action.ExtractArchiveNowAction;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.action.SetExtractPasswordAction;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.action.SetExtractToAction;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.action.ValidateArchivesAction;
import org.jdownloader.extensions.extraction.gui.bubble.ExtractionBubbleSupport;
import org.jdownloader.extensions.extraction.gui.config.ExtractionConfigPanel;
import org.jdownloader.extensions.extraction.multi.ArchiveException;
import org.jdownloader.extensions.extraction.multi.CheckException;
import org.jdownloader.extensions.extraction.multi.Multi;
import org.jdownloader.extensions.extraction.multi.Zip4J;
import org.jdownloader.extensions.extraction.split.HJSplit;
import org.jdownloader.extensions.extraction.split.HachaSplit;
import org.jdownloader.extensions.extraction.split.UnixSplit;
import org.jdownloader.extensions.extraction.split.XtreamSplit;
import org.jdownloader.extensions.extraction.translate.ExtractionTranslation;
import org.jdownloader.gui.mainmenu.MenuManagerMainmenu;
import org.jdownloader.gui.mainmenu.container.ExtensionsMenuContainer;
import org.jdownloader.gui.mainmenu.container.OptionalContainer;
import org.jdownloader.gui.notify.AbstractBubbleSupport;
import org.jdownloader.gui.notify.BubbleNotify;
import org.jdownloader.gui.toolbar.MenuManagerMainToolbar;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.gui.views.downloads.context.submenu.MoreMenuContainer;
import org.jdownloader.gui.views.downloads.contextmenumanager.MenuManagerDownloadTableContext;
import org.jdownloader.gui.views.linkgrabber.contextmenu.LinkGrabberMoreSubMenu;
import org.jdownloader.gui.views.linkgrabber.contextmenu.MenuManagerLinkgrabberTableContext;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.IfFileExistsAction;
import org.jdownloader.settings.staticreferences.CFG_LINKGRABBER;
import org.jdownloader.translate._JDT;

public class ExtractionExtension
extends AbstractExtension<ExtractionConfig, ExtractionTranslation>
implements FileCreationListener,
MenuExtenderHandler,
PackageControllerModifyVetoListener<FilePackage, DownloadLink> {
    private ExtractionQueue extractionQueue = new ExtractionQueue();
    private ExtractionEventSender eventSender = new ExtractionEventSender();
    private final Set<IExtraction> extractors = new CopyOnWriteArraySet<IExtraction>();
    private ExtractionConfigPanel configPanel;
    private static ExtractionExtension INSTANCE;
    private ExtractionListenerIcon statusbarListener = null;
    private ShutdownVetoListener listener = null;
    private boolean lazyInitOnStart = false;
    private final Object PWLOCK = new Object();
    private ExtractionBubbleSupport bubbleSupport;
    public static final ThreadLocal<Map<Object, Object>> ARCHIVE_FACTORY_OPTIMIZATION;

    public ExtractionEventSender getEventSender() {
        return this.eventSender;
    }

    public ExtractionExtension() throws StartException {
        this.setTitle(((ExtractionTranslation)this.T).name());
        INSTANCE = this;
    }

    public boolean isDefaultEnabled() {
        return true;
    }

    public static ExtractionExtension getInstance() {
        return INSTANCE;
    }

    private void initExtractors() {
        this.addExtractor(new UnixSplit(this));
        this.addExtractor(new XtreamSplit(this));
        this.addExtractor(new HachaSplit(this));
        this.addExtractor(new HJSplit(this));
        try {
            if (JVMVersion.isMinimum((long)JVMVersion.JAVA_1_7)) {
                this.addExtractor(new Zip4J(this));
            }
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            // empty catch block
        }
        this.addExtractor(new Multi(this));
    }

    public void addExtractor(IExtraction extractor) {
        this.extractors.add(extractor);
        extractor.setLogger(this.logger);
    }

    public ExtractionController addToQueue(Archive archive, boolean forceAskForUnknownPassword) {
        return this.addToQueue(null, archive, forceAskForUnknownPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExtractionController getQueuedExtractionController(Archive archive) {
        ExtractionQueue extractionQueue = this.extractionQueue;
        synchronized (extractionQueue) {
            for (ExtractionController ec : this.extractionQueue.getJobs()) {
                if (ec.isSameArchive(archive)) {
                    return ec;
                }
                if (!ec.isOutDatedArchive(archive) || !this.extractionQueue.remove(ec)) continue;
                this.logger.info("removed outdated Archive(" + ec.getArchive().getArchiveID() + "|started:" + ec.gotStarted());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtractionController addToQueue(Object caller, Archive archive, boolean forceAskForUnknownPassword) {
        ExtractionController controller;
        if (archive == null) {
            return null;
        }
        if (archive.getArchiveFiles().size() == 0) {
            this.logger.info("Empty Archive(" + archive.getArchiveID() + "|" + caller + "):" + archive.getName());
            return null;
        }
        ExtractionController ec = this.getQueuedExtractionController(archive);
        if (ec != null) {
            return ec;
        }
        DummyArchive dummyArchive = null;
        try {
            dummyArchive = this.createDummyArchive(archive);
        }
        catch (CheckException e) {
            this.logger.log((Throwable)e);
        }
        if (dummyArchive == null || !dummyArchive.isComplete()) {
            if (dummyArchive == null) {
                this.logger.info("Incomplete Archive(" + archive.getArchiveID() + "|" + caller + "):" + archive.getName());
            } else {
                this.logger.info("Incomplete Archive(" + archive.getArchiveID() + "|" + caller + "):" + dummyArchive.toString());
            }
            return null;
        }
        IExtraction extractor = this.getExtractorInstanceByFactory(archive.getFactory());
        if (extractor == null) {
            this.logger.info("Unsupported Archive(" + archive.getArchiveID() + "|" + caller + "):" + archive.getName());
            return null;
        }
        this.logger.info("Supported Archive(" + archive.getArchiveID() + "|" + caller + "):" + dummyArchive.toString());
        ExtractionQueue extractionQueue = this.extractionQueue;
        synchronized (extractionQueue) {
            ec = this.getQueuedExtractionController(archive);
            if (ec != null) {
                return ec;
            }
            controller = new ExtractionController(this, archive, extractor);
            controller.setAskForUnknownPassword(forceAskForUnknownPassword);
            controller.setIfFileExistsAction(this.getIfFileExistsAction(archive));
            extractor.setConfig((ExtractionConfig)this.getSettings());
            this.extractionQueue.addAsynch(controller);
        }
        this.fireEvent(new ExtractionEvent(controller, ExtractionEvent.Type.QUEUED));
        archive.getFactory().fireArchiveAddedToQueue(archive);
        return controller;
    }

    public boolean isRemoveDownloadLinksAfterExtractEnabled(Archive archive) {
        switch (archive.getSettings().getRemoveDownloadLinksAfterExtraction()) {
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
        }
        return ((ExtractionConfig)this.getSettings()).isDeleteArchiveDownloadlinksAfterExtraction();
    }

    public FileCreationManager.DeleteOption getRemoveFilesAfterExtractAction(Archive archive) {
        switch (archive.getSettings().getRemoveFilesAfterExtraction()) {
            case FALSE: {
                return FileCreationManager.DeleteOption.NO_DELETE;
            }
            case TRUE: {
                switch (((ExtractionConfig)this.getSettings()).getDeleteArchiveFilesAfterExtractionAction()) {
                    case NO_DELETE: 
                    case RECYCLE: {
                        return FileCreationManager.DeleteOption.RECYCLE;
                    }
                }
                return FileCreationManager.DeleteOption.NULL;
            }
        }
        return ((ExtractionConfig)this.getSettings()).getDeleteArchiveFilesAfterExtractionAction();
    }

    public String getIconKey() {
        return "extract";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortAll() {
        ExtractionQueue extractionQueue = this.extractionQueue;
        synchronized (extractionQueue) {
            this.extractionQueue.killQueue();
        }
    }

    public Archive buildArchive(ArchiveFactory factory) throws ArchiveException {
        Archive existing;
        if (Boolean.FALSE.equals(factory.isPartOfAnArchive())) {
            return null;
        }
        ExtractionController ec = this.getExtractionController(factory);
        Archive archive = existing = ec != null ? ec.getArchive() : null;
        if (existing == null) {
            Throwable throwable = null;
            boolean deepInspection = !(factory instanceof CrawledLinkFactory);
            for (IExtraction extractor : this.extractors) {
                try {
                    Archive archive2;
                    if (Boolean.FALSE.equals(extractor.isSupported(factory, deepInspection)) || (archive2 = extractor.buildArchive(factory, deepInspection)) == null) continue;
                    for (ArchiveFile archiveFile : archive2.getArchiveFiles()) {
                        archiveFile.setArchive(archive2);
                    }
                    return archive2;
                }
                catch (Throwable e) {
                    throwable = e;
                    this.logger.log(e);
                }
            }
            if (throwable == null) {
                factory.setPartOfAnArchive(false);
            }
        }
        return existing;
    }

    public DummyArchive createDummyArchive(Archive archive) throws CheckException {
        if (archive == null) {
            return null;
        }
        ArchiveFactory factory = archive.getFactory();
        if (Boolean.FALSE.equals(factory.isPartOfAnArchive())) {
            return null;
        }
        boolean deepInspection = !(factory instanceof CrawledLinkFactory);
        for (IExtraction extractor : this.extractors) {
            try {
                DummyArchive dummyArchive;
                if (Boolean.FALSE.equals(extractor.isSupported(factory, deepInspection)) || (dummyArchive = extractor.checkComplete(archive)) == null) continue;
                return dummyArchive;
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
        }
        return null;
    }

    public boolean isComplete(Archive archive) {
        try {
            DummyArchive ret = archive != null ? this.createDummyArchive(archive) : null;
            boolean isComplete = ret != null && ret.isComplete();
            return isComplete;
        }
        catch (CheckException e) {
            this.logger.log((Throwable)e);
            return false;
        }
    }

    private IExtraction getExtractorInstanceByFactory(ArchiveFactory factory) {
        if (Boolean.FALSE.equals(factory.isPartOfAnArchive())) {
            return null;
        }
        for (IExtraction extractor : this.extractors) {
            try {
                if (!Boolean.TRUE.equals(extractor.isSupported(factory, true))) continue;
                IExtraction ret = (IExtraction)extractor.getClass().getConstructor(((Object)((Object)this)).getClass()).newInstance(new Object[]{this});
                ret.setLogger(extractor.logger);
                return ret;
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
        return null;
    }

    protected void stop() throws StopException {
        ShutdownController.getInstance().removeShutdownVetoListener(this.listener);
        LinkCollector.getInstance().setArchiver(null);
        if (!Application.isHeadless()) {
            MenuManagerDownloadTableContext.getInstance().unregisterExtender((MenuExtenderHandler)this);
            MenuManagerLinkgrabberTableContext.getInstance().unregisterExtender((MenuExtenderHandler)this);
            MenuManagerMainmenu.getInstance().unregisterExtender((MenuExtenderHandler)this);
            MenuManagerMainToolbar.getInstance().unregisterExtender((MenuExtenderHandler)this);
        }
        DownloadController.getInstance().removeVetoListener((PackageControllerModifyVetoListener)this);
        FileCreationManager.getInstance().getEventSender().removeListener((EventListener)((Object)this));
        if (!Application.isHeadless()) {
            SecondLevelLaunch.GUI_COMPLETE.executeWhenReached(new Runnable(){

                @Override
                public void run() {
                    new EDTRunner(){

                        protected void runInEDT() {
                            if (ExtractionExtension.this.statusbarListener != null) {
                                ExtractionExtension.this.statusbarListener.cleanup();
                                ExtractionExtension.this.eventSender.removeListener(ExtractionExtension.this.statusbarListener);
                            }
                            if (ExtractionExtension.this.bubbleSupport != null) {
                                ExtractionExtension.this.eventSender.removeListener(ExtractionExtension.this.bubbleSupport);
                                BubbleNotify.getInstance().unregisterTypes((AbstractBubbleSupport)ExtractionExtension.this.bubbleSupport);
                            }
                        }
                    };
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPassword(String pw) {
        if (StringUtils.isEmpty((String)pw)) {
            return;
        }
        Object object = this.PWLOCK;
        synchronized (object) {
            List<String> pwList = ((ExtractionConfig)this.getSettings()).getPasswordList();
            if (pwList == null) {
                pwList = new ArrayList<String>();
            }
            pwList.remove(pw);
            pwList.add(0, pw);
            ((ExtractionConfig)this.getSettings()).setPasswordList(pwList);
        }
    }

    public boolean isHeadlessRunnable() {
        return true;
    }

    protected void start() throws StartException {
        this.lazyInitOnceOnStart();
        if (!Application.isHeadless()) {
            MenuManagerDownloadTableContext.getInstance().registerExtender((MenuExtenderHandler)this);
            MenuManagerLinkgrabberTableContext.getInstance().registerExtender((MenuExtenderHandler)this);
            MenuManagerMainmenu.getInstance().registerExtender((MenuExtenderHandler)this);
            MenuManagerMainToolbar.getInstance().registerExtender((MenuExtenderHandler)this);
        }
        LinkCollector.getInstance().setArchiver(this);
        DownloadController.getInstance().addVetoListener((PackageControllerModifyVetoListener)this);
        FileCreationManager.getInstance().getEventSender().addListener((EventListener)((Object)this));
        if (!Application.isHeadless()) {
            SecondLevelLaunch.GUI_COMPLETE.executeWhenReached(new Runnable(){

                @Override
                public void run() {
                    new EDTRunner(){

                        protected void runInEDT() {
                            if (ExtractionExtension.this.statusbarListener != null) {
                                ExtractionExtension.this.statusbarListener.cleanup();
                            }
                            ExtractionExtension.this.eventSender.addListener(ExtractionExtension.this.statusbarListener = new ExtractionListenerIcon(ExtractionExtension.this));
                            ExtractionExtension.this.bubbleSupport = new ExtractionBubbleSupport(((ExtractionTranslation)ExtractionExtension.this.T).bubbletype(), CFG_EXTRACTION.BUBBLE_ENABLED_IF_ARCHIVE_EXTRACTION_IS_IN_PROGRESS);
                            ExtractionExtension.this.eventSender.addListener(ExtractionExtension.this.bubbleSupport, true);
                            BubbleNotify.getInstance().registerType((AbstractBubbleSupport)ExtractionExtension.this.bubbleSupport);
                        }
                    };
                }
            });
        }
        this.listener = new ShutdownVetoListener(){

            public void onShutdownVetoRequest(ShutdownRequest request) throws ShutdownVetoException {
                if (request.hasVetos()) {
                    return;
                }
                if (request.isSilent()) {
                    if (!ExtractionExtension.this.extractionQueue.isEmpty()) {
                        throw new ShutdownVetoException("ExtractionExtension is still running", (ShutdownVetoListener)this);
                    }
                } else if (!ExtractionExtension.this.extractionQueue.isEmpty()) {
                    if (UIOManager.I().showConfirmDialog(544, _JDT.T.Extraction_onShutdownRequest_(), _JDT.T.Extraction_onShutdownRequest_msg(), NewTheme.I().getIcon("extract", 32), _JDT.T.literally_yes(), null)) {
                        return;
                    }
                    throw new ShutdownVetoException("ExtractionExtension is still running", (ShutdownVetoListener)this);
                }
            }

            public long getShutdownVetoPriority() {
                return 0L;
            }

            public void onShutdown(ShutdownRequest request) {
            }

            public void onShutdownVeto(ShutdownRequest request) {
            }
        };
        ShutdownController.getInstance().addShutdownVetoListener(this.listener);
    }

    private void lazyInitOnceOnStart() {
        if (this.lazyInitOnStart) {
            return;
        }
        this.lazyInitOnStart = true;
        this.initExtractors();
        this.eventSender.addListener(new ExtractionListenerList());
        Iterator<IExtraction> it = this.extractors.iterator();
        ArrayList<IExtraction> remove = new ArrayList<IExtraction>();
        while (it.hasNext()) {
            IExtraction extractor = it.next();
            if (extractor.isAvailable(this)) continue;
            this.logger.severe("Extractor " + extractor.getClass().getName() + " plugin could not be initialized");
            remove.add(extractor);
        }
        this.extractors.removeAll(remove);
    }

    void fireEvent(ExtractionEvent event) {
        this.eventSender.fireEvent((DefaultEvent)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCommand(String command, String ... parameters) {
        if (command.equalsIgnoreCase("add-passwords") || command.equalsIgnoreCase("add-passwords") || command.equalsIgnoreCase("p")) {
            Object object = this.PWLOCK;
            synchronized (object) {
                List<String> lst = ((ExtractionConfig)this.getSettings()).getPasswordList();
                ArrayList<String> ret = new ArrayList<String>();
                if (lst != null) {
                    ret.addAll(lst);
                }
                List<String> newPws = Arrays.asList(parameters);
                ret.removeAll(newPws);
                ret.addAll(0, newPws);
                ((ExtractionConfig)this.getSettings()).setPasswordList(ret);
                this.logger.info("Added Passwords: " + newPws + " New List Size: " + ret.size());
            }
        }
    }

    protected void initExtension() throws StartException {
        ArchiveValidator.EXTENSION = this;
    }

    public boolean hasConfigPanel() {
        return true;
    }

    public String getDescription() {
        return ((ExtractionTranslation)this.T).description();
    }

    public AddonPanel<ExtractionExtension> getGUI() {
        return null;
    }

    public ExtensionConfigPanel<ExtractionExtension> getConfigPanel() {
        if (this.configPanel != null) {
            return this.configPanel;
        }
        return (ExtensionConfigPanel)new EDTHelper<ExtractionConfigPanel>(){

            public ExtractionConfigPanel edtRun() {
                if (ExtractionExtension.this.configPanel != null) {
                    return ExtractionExtension.this.configPanel;
                }
                ExtractionExtension.this.configPanel = new ExtractionConfigPanel(ExtractionExtension.this);
                return ExtractionExtension.this.configPanel;
            }
        }.getReturnValue();
    }

    public ExtractionQueue getJobQueue() {
        return this.extractionQueue;
    }

    public boolean cancel(ExtractionController controller) {
        boolean ret;
        boolean wasInProgress = this.getJobQueue().isInProgress(controller);
        if (wasInProgress) {
            ret = true;
            if (!controller.isFinished() && !controller.gotKilled()) {
                controller.kill();
            }
        } else {
            ret = this.getJobQueue().remove(controller);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExtractionController> getExtractionControllers(Object archiveFactory) {
        ArrayList<ExtractionController> ret = new ArrayList<ExtractionController>();
        ExtractionQueue extractionQueue = this.extractionQueue;
        synchronized (extractionQueue) {
            for (ExtractionController ec : this.extractionQueue.getJobs()) {
                Archive archive = ec.getArchive();
                if (!archive.contains(archiveFactory)) continue;
                ret.add(ec);
            }
        }
        if (ret.size() > 0) {
            return ret;
        }
        return null;
    }

    public ExtractionController getExtractionController(Object archiveFactory) {
        List<ExtractionController> ret = this.getExtractionControllers(archiveFactory);
        if (ret != null && ret.size() > 0) {
            return ret.get(0);
        }
        return null;
    }

    private boolean matchesDeepExtractionBlacklist(File[] fileList) {
        String[] patternStrings = ((ExtractionConfig)this.getSettings()).getDeepExtractionBlacklistPatterns();
        if (fileList != null && fileList.length > 0 && patternStrings != null && patternStrings.length > 0) {
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            for (String patternString : patternStrings) {
                try {
                    if (!StringUtils.isNotEmpty((String)patternString) || patternString.startsWith("##")) continue;
                    patterns.add(Pattern.compile(patternString));
                }
                catch (Throwable e) {
                    this.logger.log(e);
                }
            }
            if (patterns.size() > 0) {
                for (File file : fileList) {
                    for (Pattern pattern : patterns) {
                        String path;
                        if (!pattern.matcher(path = file.getAbsolutePath()).matches()) continue;
                        this.logger.info("Skip deep extraction: " + pattern.toString() + " matches file " + path);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void onNewFile(Object caller, File[] fileList) {
        if (fileList == null || fileList.length == 0) {
            return;
        }
        try {
            if (caller instanceof SingleDownloadController) {
                Archive archive;
                DownloadLink link = ((SingleDownloadController)caller).getDownloadLink();
                if (this.getExtractionController(link) == null && (archive = this.buildArchive(new DownloadLinkArchiveFactory(link))) != null && this.isAutoExtractEnabled(archive)) {
                    this.addToQueue(caller, archive, false);
                }
            } else if (caller instanceof ExtractionController) {
                if (((ExtractionConfig)this.getSettings()).isDeepExtractionEnabled() && !this.matchesDeepExtractionBlacklist(fileList)) {
                    ArrayList<File> files = new ArrayList<File>(fileList.length);
                    for (File file : fileList) {
                        if (this.getExtractionController(file) != null) continue;
                        files.add(file);
                    }
                    if (files.size() > 0) {
                        List<String> archiveSettingsPasswords;
                        ExtractionController con = (ExtractionController)((Object)caller);
                        ArrayList<String> knownPasswords = new ArrayList<String>();
                        String usedPassword = con.getArchive().getFinalPassword();
                        if (StringUtils.isNotEmpty((String)usedPassword)) {
                            knownPasswords.add(usedPassword);
                        }
                        if ((archiveSettingsPasswords = con.getArchive().getSettings().getPasswords()) != null) {
                            knownPasswords.addAll(archiveSettingsPasswords);
                        }
                        ArrayList<FileArchiveFactory> archiveFactories = new ArrayList<FileArchiveFactory>(files.size());
                        for (File archiveStartFile : files) {
                            archiveFactories.add(new FileArchiveFactory(archiveStartFile, con.getArchive()));
                        }
                        List<Archive> newArchives = ArchiveValidator.getArchivesFromPackageChildren(archiveFactories);
                        for (Archive newArchive : newArchives) {
                            if (newArchive == null || !this.isAutoExtractEnabled(newArchive)) continue;
                            ArchiveFile firstArchiveFile = newArchive.getArchiveFiles().get(0);
                            if (firstArchiveFile instanceof FileArchiveFile) {
                                newArchive.getSettings().setExtractPath(((FileArchiveFile)firstArchiveFile).getFile().getParent());
                            }
                            newArchive.getSettings().setPasswords(knownPasswords);
                            this.addToQueue(caller, newArchive, false);
                        }
                    }
                }
            } else {
                ArrayList<File> files = new ArrayList<File>(fileList.length);
                for (File file : fileList) {
                    if (this.getExtractionController(file) != null) continue;
                    files.add(file);
                }
                List<Archive> newArchives = ArchiveValidator.getArchivesFromPackageChildren(files);
                for (Archive newArchive : newArchives) {
                    if (newArchive == null || !this.isAutoExtractEnabled(newArchive)) continue;
                    this.addToQueue(caller, newArchive, false);
                }
            }
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
        }
    }

    public boolean isAutoExtractEnabled(Archive archive) {
        switch (archive.getSettings().getAutoExtract()) {
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
            case UNSET: {
                return CFG_LINKGRABBER.AUTO_EXTRACTION_ENABLED.isEnabled();
            }
        }
        return false;
    }

    public Archive getArchiveByFactory(ArchiveFactory clf) {
        try {
            return this.buildArchive(clf);
        }
        catch (ArchiveException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Archive> getArchivesFromPackageChildren(List<? extends Object> nodes, Set<String> ignoreArchiveIDs, final int maxArchives) {
        final HashMap packageChildrenCache = new HashMap();
        final HashSet<String> skipArchiveIDSet = new HashSet<String>();
        final ArrayList archives = new ArrayList();
        ArrayList optimizeArchives = new ArrayList();
        if (ignoreArchiveIDs != null) {
            skipArchiveIDSet.addAll(ignoreArchiveIDs);
        }
        final AtomicBoolean abortFlag = new AtomicBoolean(false);
        final LinkedList<? extends Object> linkedNodes = new LinkedList<Object>();
        if (nodes != null) {
            linkedNodes.addAll(nodes);
        }
        ArrayList<Thread> helperThreads = new ArrayList<Thread>();
        for (int threadIndex = 0; threadIndex < 8; ++threadIndex) {
            Thread helperThread = new Thread("getArchivesFromPackageChildren:thread=" + threadIndex + "|nodesIdentityHashCode=" + System.identityHashCode(nodes) + "|size=" + nodes.size()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final List<AbstractPackageChildrenNode> getCachedPackageChildren(AbstractPackageChildrenNode childNode) {
                    CopyOnWriteArrayList<AbstractPackageChildrenNode> packageChildren;
                    block12: {
                        AbstractPackageNode parentNode = (AbstractPackageNode)childNode.getParentNode();
                        if (parentNode == null) {
                            return null;
                        }
                        File directory = LinkTreeUtils.getDownloadDirectory((AbstractNode)parentNode);
                        packageChildren = null;
                        Map map = packageChildrenCache;
                        synchronized (map) {
                            packageChildren = (CopyOnWriteArrayList<AbstractPackageChildrenNode>)packageChildrenCache.get(parentNode);
                            if (packageChildren != null) {
                                break block12;
                            }
                            ModifyLock modifyLock = parentNode.getModifyLock();
                            boolean readL = modifyLock.readLock();
                            try {
                                packageChildren = new CopyOnWriteArrayList<AbstractPackageChildrenNode>(parentNode.getChildren());
                                packageChildrenCache.put(parentNode, packageChildren);
                            }
                            finally {
                                modifyLock.readUnlock(readL);
                            }
                            if (directory != null && !packageChildrenCache.containsKey(directory)) {
                                File[] files = directory.listFiles();
                                if (files != null) {
                                    packageChildrenCache.put(directory, new CopyOnWriteArrayList<File>(files));
                                } else {
                                    packageChildrenCache.put(directory, null);
                                }
                            }
                            return packageChildren;
                        }
                    }
                    if (packageChildren.indexOf(childNode) != -1) {
                        return packageChildren;
                    }
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final boolean optimizeCachedPackageChildren(AbstractPackageChildrenNode childNode) {
                    List packageChildren;
                    AbstractPackageNode parent = (AbstractPackageNode)childNode.getParentNode();
                    if (parent == null) {
                        return false;
                    }
                    Map map = packageChildrenCache;
                    synchronized (map) {
                        packageChildren = (List)packageChildrenCache.get(parent);
                    }
                    return packageChildren != null && packageChildren.remove(childNode);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final boolean optimizeCachedPackageChildren(FileArchiveFile fileArchiveFile) {
                    List files;
                    if (fileArchiveFile == null) {
                        return false;
                    }
                    File file = fileArchiveFile.getFile();
                    Map map = packageChildrenCache;
                    synchronized (map) {
                        files = (List)packageChildrenCache.get(file.getParentFile());
                    }
                    return files != null && files.remove(file);
                }

                private int optimizeCachedPackageChildren(Archive archive) {
                    int removed = 0;
                    List<ArchiveFile> archiveFiles = archive.getArchiveFiles();
                    for (ArchiveFile archiveFile : archiveFiles) {
                        if (archiveFile instanceof CrawledLinkArchiveFile) {
                            CrawledLinkArchiveFile cla = (CrawledLinkArchiveFile)archiveFile;
                            for (CrawledLink cl : cla.getLinks()) {
                                if (!this.optimizeCachedPackageChildren((AbstractPackageChildrenNode)cl)) continue;
                                ++removed;
                            }
                            if (!this.optimizeCachedPackageChildren(cla.getFileArchiveFile())) continue;
                            ++removed;
                            continue;
                        }
                        if (archiveFile instanceof DownloadLinkArchiveFactory) {
                            DownloadLinkArchiveFactory dla = (DownloadLinkArchiveFactory)archiveFile;
                            for (DownloadLink dl : dla.getDownloadLinks()) {
                                if (!this.optimizeCachedPackageChildren((AbstractPackageChildrenNode)dl)) continue;
                                ++removed;
                            }
                            if (!this.optimizeCachedPackageChildren(dla.getFileArchiveFile())) continue;
                            ++removed;
                            continue;
                        }
                        if (!(archiveFile instanceof FileArchiveFile) || !this.optimizeCachedPackageChildren((FileArchiveFile)archiveFile)) continue;
                        ++removed;
                    }
                    return removed;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    ARCHIVE_FACTORY_OPTIMIZATION.set(packageChildrenCache);
                    try {
                        while (!abortFlag.get()) {
                            ArchiveFactory af;
                            List<AbstractPackageChildrenNode> packageChildren;
                            Object child;
                            block23: {
                                block21: {
                                    block22: {
                                        block20: {
                                            LinkedList linkedList = linkedNodes;
                                            // MONITORENTER : linkedList
                                            child = linkedNodes.poll();
                                            if (child == null) break block20;
                                            // MONITOREXIT : linkedList
                                            if (!(child instanceof CrawledLink)) break block21;
                                            break block22;
                                        }
                                        if (linkedNodes.size() == 0) {
                                            // MONITOREXIT : linkedList
                                            return;
                                        }
                                        // MONITOREXIT : linkedList
                                        continue;
                                    }
                                    CrawledLink cl = (CrawledLink)child;
                                    packageChildren = this.getCachedPackageChildren((AbstractPackageChildrenNode)cl);
                                    if (packageChildren == null) continue;
                                    af = new CrawledLinkFactory(cl);
                                    break block23;
                                }
                                if (child instanceof DownloadLink) {
                                    DownloadLink dl = (DownloadLink)child;
                                    packageChildren = this.getCachedPackageChildren((AbstractPackageChildrenNode)dl);
                                    if (packageChildren == null) continue;
                                    af = new DownloadLinkArchiveFactory(dl);
                                } else if (child instanceof File) {
                                    af = new FileArchiveFactory((File)child);
                                    packageChildren = null;
                                } else {
                                    if (!(child instanceof ArchiveFactory)) continue;
                                    af = (ArchiveFactory)child;
                                    packageChildren = null;
                                }
                            }
                            Archive archive = ExtractionExtension.this.getArchiveByFactory(af);
                            if (archive == null) {
                                if (child instanceof FileArchiveFile) {
                                    this.optimizeCachedPackageChildren((FileArchiveFile)child);
                                    continue;
                                }
                                if (packageChildren == null) continue;
                                packageChildren.remove(child);
                                continue;
                            }
                            ArrayList arrayList = archives;
                            // MONITORENTER : arrayList
                            if (!abortFlag.get() && skipArchiveIDSet.add(archive.getArchiveID())) {
                                archives.add(archive);
                                this.optimizeCachedPackageChildren(archive);
                                if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
                                    System.out.println("found archives:" + archives.size());
                                }
                                if (maxArchives > 0 && archives.size() >= maxArchives) {
                                    abortFlag.set(true);
                                    // MONITOREXIT : arrayList
                                    return;
                                }
                            }
                            // MONITOREXIT : arrayList
                        }
                        return;
                    }
                    finally {
                        ARCHIVE_FACTORY_OPTIMIZATION.set(null);
                    }
                }
            };
            helperThreads.add(helperThread);
            helperThread.setDaemon(true);
            helperThread.start();
        }
        for (Thread helperThread : helperThreads) {
            try {
                helperThread.join();
            }
            catch (InterruptedException e) {
                abortFlag.set(true);
            }
        }
        ArrayList arrayList = archives;
        synchronized (arrayList) {
            return new ArrayList<Archive>(archives);
        }
    }

    public IfFileExistsAction getIfFileExistsAction(Archive archive) {
        IfFileExistsAction ret = archive.getSettings()._getIfFileExistsAction();
        if (ret == null) {
            ret = ((ExtractionConfig)this.getSettings()).getIfFileExistsAction();
        }
        return ret;
    }

    public File getFinalExtractToFolder(Archive archive, boolean raw) {
        String path = null;
        if (StringUtils.isEmpty(path) && !StringUtils.isEmpty((String)(path = archive.getSettings().getExtractPath()))) {
            if (!raw) {
                path = PackagizerController.replaceDynamicTags((String)path, (String)"%PACKAGENAME%", null);
            }
            path = archive.getFactory().createExtractSubPath(path, archive);
            File ret = new File(path);
            ret = this.appendSubFolder(archive, ret);
            return ret;
        }
        if (((ExtractionConfig)this.getSettings()).isCustomExtractionPathEnabled()) {
            path = ((ExtractionConfig)this.getSettings()).getCustomExtractionPath();
        }
        if (StringUtils.isEmpty((String)path)) {
            path = archive.getFactory().createDefaultExtractToPath(archive);
        }
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        if (!raw) {
            path = PackagizerController.replaceDynamicTags((String)path, (String)"%PACKAGENAME%", null);
        }
        path = archive.getFactory().createExtractSubPath(path, archive);
        File ret = new File(path);
        ret = this.appendSubFolder(archive, ret);
        return ret;
    }

    protected File appendSubFolder(Archive archive, File ret) {
        if (!((ExtractionConfig)this.getSettings()).isSubpathEnabled()) {
            return ret;
        }
        if (archive.getContentView().getFileCount() < ((ExtractionConfig)this.getSettings()).getSubPathMinFilesTreshhold()) {
            this.logger.info("No Subfolder because Root contains only " + archive.getContentView().getFileCount() + " files");
            return ret;
        }
        if (archive.getContentView().getDirectoryCount() < ((ExtractionConfig)this.getSettings()).getSubPathMinFoldersTreshhold()) {
            this.logger.info("No Subfolder because Root contains only " + archive.getContentView().getDirectoryCount() + " folders");
            return ret;
        }
        if (archive.getContentView().getDirectoryCount() + archive.getContentView().getFileCount() < ((ExtractionConfig)this.getSettings()).getSubPathMinFilesOrFoldersTreshhold()) {
            this.logger.info("No Subfolder because Root contains only " + (archive.getContentView().getDirectoryCount() + archive.getContentView().getFileCount()) + " files and folders");
            return ret;
        }
        String sub = ((ExtractionConfig)this.getSettings()).getSubPath();
        if (!StringUtils.isEmpty((String)sub) && !StringUtils.isEmpty((String)(sub = archive.getFactory().createExtractSubPath(sub, archive)))) {
            sub = sub.trim();
            ret = new File(ret, sub);
        }
        return ret;
    }

    public Set<IExtraction> getExtractors() {
        return this.extractors;
    }

    public MenuItemData updateMenuModel(ContextMenuManager manager, MenuContainerRoot mr) {
        if (manager instanceof MenuManagerMainToolbar) {
            return this.updateMainToolbar(mr);
        }
        if (manager instanceof MenuManagerMainmenu) {
            return this.updateMainMenu(mr);
        }
        if (manager instanceof MenuManagerDownloadTableContext || manager instanceof MenuManagerLinkgrabberTableContext) {
            int addonLinkIndex = 0;
            for (int i = 0; i < mr.getItems().size(); ++i) {
                if (!(mr.getItems().get(i) instanceof MoreMenuContainer) && !(mr.getItems().get(i) instanceof LinkGrabberMoreSubMenu)) continue;
                addonLinkIndex = i;
                break;
            }
            ArchivesSubMenu root = new ArchivesSubMenu();
            if (manager instanceof MenuManagerDownloadTableContext) {
                root.add(new MenuItemData(new ActionData(ExtractArchiveNowAction.class)));
                root.add(new MenuItemData(new ActionData(AbortExtractionAction.class)));
            }
            root.add(new MenuItemData(new ActionData(ValidateArchivesAction.class)));
            root.add((MenuItemData)new SeparatorData());
            root.add(new MenuItemData(new ActionData(AutoExtractEnabledToggleAction.class)));
            root.add(new MenuItemData(new ActionData(SetExtractToAction.class)));
            root.add(new MenuItemData(new ActionData(SetExtractPasswordAction.class)));
            CleanupSubMenu cleanup = new CleanupSubMenu();
            cleanup.add(new MenuItemData(new ActionData(CleanupAutoDeleteFilesEnabledToggleAction.class)));
            cleanup.add(new MenuItemData(new ActionData(CleanupAutoDeleteLinksEnabledToggleAction.class)));
            root.add((MenuItemData)cleanup);
            if (addonLinkIndex != -1) {
                mr.getItems().add(addonLinkIndex, root);
            } else {
                mr.getItems().add(root);
            }
            return null;
        }
        return null;
    }

    private MenuItemData updateMainMenu(MenuContainerRoot mr) {
        ExtensionsMenuContainer container = new ExtensionsMenuContainer();
        container.add(ExtractAction.class);
        return container;
    }

    private MenuItemData updateMainToolbar(MenuContainerRoot mr) {
        OptionalContainer opt = new OptionalContainer(false);
        opt.add(ExtractAction.class);
        return opt;
    }

    public List<DownloadLink> onAskToRemovePackage(Object asker, FilePackage pkg, List<DownloadLink> children) {
        return this.onAskToRemoveChildren(asker, children);
    }

    public List<DownloadLink> onAskToRemoveChildren(Object asker, List<DownloadLink> children) {
        ArrayList<DownloadLink> ret = new ArrayList<DownloadLink>(children.size());
        for (DownloadLink dlink : children) {
            ExtractionController ec = this.getExtractionController(dlink);
            if (ec != null) {
                if (asker instanceof ExtractionController && asker == ec) {
                    ret.add(dlink);
                    continue;
                }
                this.logger.info("Link (" + dlink.toString() + ") is in active Archive do not remove: " + ec.getArchive().getArchiveID());
                continue;
            }
            ret.add(dlink);
        }
        return ret;
    }

    public void onNewFolder(Object caller, File folder) {
    }

    static {
        ARCHIVE_FACTORY_OPTIMIZATION = new ThreadLocal();
    }
}

