/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction;

import java.util.regex.Pattern;

public class Signature {
    private final String id;
    private final Pattern signatur;
    private final String desc;
    private final Pattern extensionSure;
    private final Pattern extensionUnsure;

    public Signature(String id, String signaturPattern, String desc, String ext) {
        this(id, signaturPattern, desc, ext, null);
    }

    public Signature(String id, String signaturPattern, String desc, String ext, String unsureext) {
        this.id = id;
        this.signatur = signaturPattern != null ? Pattern.compile(signaturPattern, 2) : null;
        this.extensionSure = ext != null ? Pattern.compile(ext, 2) : null;
        this.extensionUnsure = unsureext != null ? Pattern.compile(unsureext, 2) : null;
        this.desc = desc;
    }

    public String toString() {
        return "SignatureID:" + this.getId();
    }

    public boolean isPrecisePatternStart() {
        return this.signatur != null && !this.signatur.pattern().startsWith(".");
    }

    public String getDesc() {
        return this.desc;
    }

    public Pattern getExtensionSure() {
        return this.extensionSure;
    }

    public Pattern getExtensionUnsure() {
        return this.extensionUnsure;
    }

    public String getId() {
        return this.id;
    }

    public Pattern getSignatur() {
        return this.signatur;
    }

    public boolean matches(CharSequence sig) {
        return this.signatur != null && this.signatur.matcher(sig).matches();
    }
}

