/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileFilter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import jd.gui.UserIO;
import org.appwork.storage.config.annotations.LabelInterface;
import org.appwork.swing.components.ExtMergedIcon;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.ProgressDialog;
import org.jdownloader.controlling.contextmenu.ActionContext;
import org.jdownloader.controlling.contextmenu.Customizer;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ExtractionConfig;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionEvent;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.ExtractionListener;
import org.jdownloader.extensions.extraction.IExtraction;
import org.jdownloader.extensions.extraction.ValidateArchiveAction;
import org.jdownloader.extensions.extraction.bindings.file.FileArchiveFactory;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.AbstractExtractionContextAction;
import org.jdownloader.extensions.extraction.multi.ArchiveException;
import org.jdownloader.extensions.extraction.translate.T;
import org.jdownloader.gui.views.DownloadFolderChooserDialog;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.images.AbstractIcon;

public class ExtractAction
extends AbstractExtractionContextAction
implements ActionContext {
    private static final long serialVersionUID = 1612595219577059496L;
    private ExtractToPathLogic extractToPathLogic = ExtractToPathLogic.EXTRACT_TO_ARCHIVE_PARENT;

    public static String getTranslationForExtractToPathLogic() {
        return T.T.ExtractAction_getTranslationForExtractToPathLogic();
    }

    @Customizer(link="#getTranslationForExtractToPathLogic")
    public ExtractToPathLogic getExtractToPathLogic() {
        return this.extractToPathLogic;
    }

    @Override
    protected void requestUpdateSelection() {
    }

    public void setExtractToPathLogic(ExtractToPathLogic extractToPathLogic) {
        this.extractToPathLogic = extractToPathLogic;
    }

    public ExtractAction() {
        this.setName(T.T.menu_tools_extract_files());
        this.setIconKey("extract");
    }

    public boolean isEnabled() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new Thread("Extracting"){

            @Override
            public void run() {
                final javax.swing.filechooser.FileFilter fileFilter = new javax.swing.filechooser.FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        if (pathname.isDirectory()) {
                            return true;
                        }
                        FileArchiveFactory factory = new FileArchiveFactory(pathname);
                        for (IExtraction extractor : ((ExtractionExtension)ExtractAction.this._getExtension()).getExtractors()) {
                            boolean deepInspection = false;
                            if (Boolean.FALSE.equals(extractor.isSupported(factory, false))) continue;
                            try {
                                Archive archive = extractor.buildArchive(factory, false);
                                if (archive == null || !factory.getName().equals(archive.getArchiveFiles().get(0).getName())) continue;
                                return true;
                            }
                            catch (ArchiveException e) {
                                ((ExtractionExtension)ExtractAction.this._getExtension()).getLogger().log((Throwable)e);
                            }
                        }
                        return false;
                    }

                    @Override
                    public String getDescription() {
                        return T.T.plugins_optional_extraction_filefilter();
                    }
                };
                File[] dialogFiles = UserIO.getInstance().requestFileChooser("_EXTRATION_", null, Integer.valueOf(2), fileFilter, Boolean.valueOf(true), null, null);
                final ArrayList<File> files = new ArrayList<File>();
                if (dialogFiles != null) {
                    for (File dialogFile : dialogFiles) {
                        if (dialogFile.isFile()) {
                            files.add(dialogFile);
                            continue;
                        }
                        if (!dialogFile.isDirectory()) continue;
                        dialogFile.listFiles(new FileFilter(){

                            @Override
                            public boolean accept(File pathname) {
                                if (pathname.isDirectory()) {
                                    return false;
                                }
                                if (fileFilter.accept(pathname)) {
                                    files.add(pathname);
                                    return true;
                                }
                                return false;
                            }
                        });
                    }
                }
                if (files.size() == 0) {
                    return;
                }
                try {
                    File extractTo = null;
                    if (ExtractAction.this.getExtractToPathLogic() == ExtractToPathLogic.ASK_ONCE) {
                        extractTo = DownloadFolderChooserDialog.open(null, (boolean)false, (String)"Extract To");
                    }
                    for (final File archiveStartFile : files) {
                        try {
                            final Archive archive = ((ExtractionExtension)ExtractAction.this._getExtension()).buildArchive(new FileArchiveFactory(archiveStartFile));
                            if (archive == null) continue;
                            switch (ExtractAction.this.getExtractToPathLogic()) {
                                case USE_CUSTOMEXTRACTIONPATH: {
                                    archive.getSettings().setExtractPath(((ExtractionConfig)((ExtractionExtension)ExtractAction.this._getExtension()).getSettings()).getCustomExtractionPath());
                                    break;
                                }
                                case ASK_FOR_FOR_EVERY_ARCHIVE: {
                                    File path;
                                    if (((ExtractionConfig)((ExtractionExtension)ExtractAction.this._getExtension()).getSettings()).isCustomExtractionPathEnabled()) {
                                        path = DownloadFolderChooserDialog.open((File)new File(((ExtractionConfig)((ExtractionExtension)ExtractAction.this._getExtension()).getSettings()).getCustomExtractionPath()), (boolean)false, (String)"Extract To");
                                        archive.getSettings().setExtractPath(path.getAbsolutePath());
                                        break;
                                    }
                                    path = DownloadFolderChooserDialog.open((File)archiveStartFile.getParentFile(), (boolean)false, (String)"Extract To");
                                    archive.getSettings().setExtractPath(path.getAbsolutePath());
                                    break;
                                }
                                case ASK_ONCE: {
                                    archive.getSettings().setExtractPath(extractTo.getAbsolutePath());
                                    break;
                                }
                                case EXTRACT_TO_ARCHIVE_PARENT: {
                                    archive.getSettings().setExtractPath(archiveStartFile.getParentFile().getAbsolutePath());
                                }
                            }
                            ProgressDialog dialog = new ProgressDialog(new ProgressDialog.ProgressGetter(){
                                private volatile ExtractionController controller = null;
                                private final DecimalFormat format = new DecimalFormat("00.00");

                                public void run() throws Exception {
                                    if (((ExtractionExtension)ExtractAction.this._getExtension()).isComplete(archive)) {
                                        this.controller = ((ExtractionExtension)ExtractAction.this._getExtension()).addToQueue(archive, true);
                                        if (this.controller != null) {
                                            ExtractionListener listener = new ExtractionListener(){

                                                @Override
                                                public void onExtractionEvent(ExtractionEvent event) {
                                                    if (event.getCaller() == controller) {
                                                        switch ((ExtractionEvent.Type)((Object)event.getType())) {
                                                            case CLEANUP: {
                                                                ((ExtractionExtension)ExtractAction.this._getExtension()).getEventSender().removeListener(this);
                                                                break;
                                                            }
                                                            case EXTRACTION_FAILED: 
                                                            case EXTRACTION_FAILED_CRC: {
                                                                if (controller.getException() != null) {
                                                                    Dialog.getInstance().showExceptionDialog(T.T.extraction_failed(archiveStartFile.getName()), controller.getException().getLocalizedMessage(), (Throwable)controller.getException());
                                                                    break;
                                                                }
                                                                Dialog.getInstance().showErrorDialog(T.T.extraction_failed(archiveStartFile.getName()));
                                                            }
                                                        }
                                                    }
                                                }
                                            };
                                            try {
                                                ((ExtractionExtension)ExtractAction.this._getExtension()).getEventSender().addListener(listener, true);
                                                while (!this.controller.isFinished()) {
                                                    Thread.sleep(1000L);
                                                }
                                            }
                                            catch (InterruptedException e) {
                                                this.controller.kill();
                                                throw e;
                                            }
                                        }
                                    } else {
                                        new ValidateArchiveAction((ExtractionExtension)ExtractAction.this._getExtension(), archive).actionPerformed(null);
                                    }
                                }

                                public String getString() {
                                    ExtractionController lController = this.controller;
                                    if (lController != null) {
                                        return T.T.extractprogress_label(this.format.format(lController.getProgress()) + " %", lController.getArchive().getExtractedFiles().size() + "");
                                    }
                                    return this.format.format(0.0) + " %";
                                }

                                public int getProgress() {
                                    ExtractionController lController = this.controller;
                                    if (lController == null) {
                                        return 0;
                                    }
                                    return Math.min(99, (int)lController.getProgress());
                                }

                                public String getLabelString() {
                                    return null;
                                }
                            }, 0, T.T.extracting_archive(archive.getName()), T.T.extracting_wait(archive.getName()), (Icon)new ExtMergedIcon((Icon)new AbstractIcon("extract", 32)).add((Icon)new AbstractIcon("media-playback-start", 24), 6, 6), null, null){

                                public Dialog.ModalityType getModalityType() {
                                    return Dialog.ModalityType.MODELESS;
                                }
                            };
                            UIOManager.I().show(null, (UserIODefinition)dialog);
                            dialog.throwCloseExceptions();
                        }
                        catch (ArchiveException e1) {
                            ((ExtractionExtension)ExtractAction.this._getExtension()).getLogger().log((Throwable)e1);
                        }
                    }
                }
                catch (DialogClosedException e) {
                    e.printStackTrace();
                }
                catch (DialogCanceledException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    @Override
    protected void onActionPerformed(ActionEvent e, List<Archive> archives, SelectionInfo<?, ?> selectionInfo) {
    }

    public static enum ExtractToPathLogic implements LabelInterface
    {
        ASK_FOR_FOR_EVERY_ARCHIVE{

            public String getLabel() {
                return T.T.EXTRACTTOPATHLOGIC_ASK_FOR_EVERY_ARCHIVE();
            }
        }
        ,
        EXTRACT_TO_ARCHIVE_PARENT{

            public String getLabel() {
                return T.T.EXTRACTTOPATHLOGIC_EXTRACT_TO_ARCHIVE_PARENT();
            }
        }
        ,
        ASK_ONCE{

            public String getLabel() {
                return T.T.EXTRACTTOPATHLOGIC_ASK_ONCE();
            }
        }
        ,
        USE_CUSTOMEXTRACTIONPATH{

            public String getLabel() {
                return T.T.EXTRACTTOPATHLOGIC_USE_CUSTOMEXTRACTIONPATH();
            }
        };

    }
}

