/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.bindings.crawledlink;

import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledLinkProperty;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.DownloadLink;
import jd.plugins.LinkInfo;
import org.appwork.utils.StringUtils;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionStatus;
import org.jdownloader.extensions.extraction.bindings.file.FileArchiveFile;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;

public class CrawledLinkArchiveFile
implements ArchiveFile {
    private final List<CrawledLink> links;
    private final String name;
    private volatile long size;
    private final AtomicReference<Object> exists = new AtomicReference<Object>(null);
    private final int hashCode;
    private volatile ExtractionStatus status = null;

    @Override
    public LinkInfo getLinkInfo() {
        return this.getLinks().get(0).getLinkInfo();
    }

    public CrawledLinkArchiveFile(CrawledLink l) {
        this.links = new CopyOnWriteArrayList<CrawledLink>();
        this.links.add(l);
        this.name = l.getName();
        this.size = Math.max(0L, l.getSize());
        this.hashCode = (this.getClass() + this.name).hashCode();
    }

    public List<CrawledLink> getLinks() {
        return this.links;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean contains(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null) {
            if (obj instanceof String) {
                return this.getFilePath().equals(obj);
            }
            if (obj instanceof ArchiveFile && StringUtils.equals((String)this.getFilePath(), (String)((ArchiveFile)obj).getFilePath())) {
                return true;
            }
            if (obj instanceof CrawledLinkArchiveFile) {
                for (CrawledLink dl : ((CrawledLinkArchiveFile)obj).getLinks()) {
                    if (!this.getLinks().contains(dl)) continue;
                    return true;
                }
            } else if (obj instanceof CrawledLink && this.getLinks().contains(obj)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Boolean isComplete() {
        if (this.isFileArchiveFileExists()) {
            return Boolean.TRUE;
        }
        for (CrawledLink crawledLink : this.getLinks()) {
            DownloadLink downloadLink = crawledLink.getDownloadLink();
            if (downloadLink == null) continue;
            switch (downloadLink.getAvailableStatus()) {
                case TRUE: {
                    return Boolean.TRUE;
                }
                case UNCHECKABLE: 
                case UNCHECKED: {
                    return null;
                }
            }
        }
        return Boolean.FALSE;
    }

    public String toString() {
        return "CrawledLink: " + this.name + " Complete:" + this.isComplete();
    }

    @Override
    public String getFilePath() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setStatus(ExtractionController controller, ExtractionStatus status) {
        this.status = status;
    }

    @Override
    public ExtractionStatus getStatus() {
        ExtractionStatus status = this.status;
        if (status != null) {
            return status;
        }
        return ExtractionStatus.NA;
    }

    @Override
    public void setMessage(ExtractionController controller, String plugins_optional_extraction_status_notenoughspace) {
    }

    @Override
    public void setProgress(ExtractionController controller, long value, long max, Color color) {
    }

    @Override
    public long getFileSize() {
        if (this.exists()) {
            return Math.max(this.size, new File(LinkTreeUtils.getDownloadDirectory((AbstractNode)((AbstractNode)this.getLinks().get(0))), this.getName()).length());
        }
        return Math.max(0L, this.size);
    }

    public void addMirror(CrawledLink link) {
        this.getLinks().add(link);
        this.size = Math.max(Math.max(0L, link.getSize()), this.size);
    }

    public DownloadLink.AvailableStatus getAvailableStatus() {
        DownloadLink.AvailableStatus ret = null;
        for (CrawledLink downloadLink : this.getLinks()) {
            switch (downloadLink.getLinkState()) {
                case ONLINE: {
                    return DownloadLink.AvailableStatus.TRUE;
                }
                case TEMP_UNKNOWN: {
                    ret = DownloadLink.AvailableStatus.UNCHECKED;
                    break;
                }
                case UNKNOWN: {
                    if (ret == DownloadLink.AvailableStatus.UNCHECKED) break;
                    ret = DownloadLink.AvailableStatus.UNCHECKABLE;
                    break;
                }
                case OFFLINE: {
                    if (ret != null) break;
                    ret = DownloadLink.AvailableStatus.FALSE;
                }
            }
        }
        return ret;
    }

    @Override
    public void onCleanedUp(ExtractionController controller) {
    }

    @Override
    public void setArchive(Archive archive) {
        if (archive != null) {
            List<String> existingPasswords;
            String archiveID = archive.getArchiveID();
            boolean mergeSourcePasswords = false;
            for (CrawledLink crawledLink : this.getLinks()) {
                crawledLink.setArchiveID(archiveID);
                DownloadLink downloadLink = crawledLink.getDownloadLink();
                if (downloadLink == null || downloadLink.getSourcePluginPasswordList() == null) continue;
                mergeSourcePasswords = true;
            }
            boolean mergeArchiveInfos = false;
            for (CrawledLink link : this.getLinks()) {
                if (!link.hasArchiveInfo()) continue;
                mergeArchiveInfos = true;
                break;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (mergeSourcePasswords) {
                existingPasswords = archive.getSettings().getPasswords();
                String finalPassword = archive.getSettings().getFinalPassword();
                if (StringUtils.isNotEmpty((String)finalPassword) && (existingPasswords == null || !existingPasswords.contains(finalPassword))) {
                    arrayList.add(finalPassword);
                }
                for (CrawledLink crawledLink : this.getLinks()) {
                    List sourcePluginPasswords;
                    DownloadLink downloadLink = crawledLink.getDownloadLink();
                    if (downloadLink == null || (sourcePluginPasswords = downloadLink.getSourcePluginPasswordList()) == null) continue;
                    for (String sourcePluginPassword : sourcePluginPasswords) {
                        if (!StringUtils.isNotEmpty((String)sourcePluginPassword) || existingPasswords != null && existingPasswords.contains(sourcePluginPassword)) continue;
                        arrayList.add(sourcePluginPassword);
                    }
                }
            }
            if (mergeArchiveInfos) {
                existingPasswords = archive.getSettings().getPasswords();
                for (CrawledLink link : this.getLinks()) {
                    if (!link.hasArchiveInfo()) continue;
                    for (String archivePassword : link.getArchiveInfo().getExtractionPasswords()) {
                        if (!StringUtils.isNotEmpty((String)archivePassword) || existingPasswords != null && existingPasswords.contains(archivePassword)) continue;
                        arrayList.add(archivePassword);
                    }
                }
            }
            if (arrayList.size() > 0) {
                existingPasswords = archive.getSettings().getPasswords();
                if (existingPasswords != null) {
                    arrayList.addAll(existingPasswords);
                }
                archive.getSettings().setPasswords(arrayList);
            }
        }
    }

    @Override
    public void setPartOfAnArchive(Boolean b) {
        for (CrawledLink link : this.getLinks()) {
            DownloadLink dlLink = link.getDownloadLink();
            if (dlLink == null) continue;
            dlLink.setPartOfAnArchive(b);
        }
    }

    @Override
    public Boolean isPartOfAnArchive() {
        Boolean ret = null;
        for (CrawledLink link : this.getLinks()) {
            Boolean newRet;
            DownloadLink dlLink = link.getDownloadLink();
            if (dlLink == null || (newRet = dlLink.isPartOfAnArchive()) == null) continue;
            if (Boolean.TRUE.equals(newRet)) {
                return newRet;
            }
            if (ret != null) continue;
            ret = newRet;
        }
        return ret;
    }

    @Override
    public boolean exists() {
        return this.exists(false);
    }

    public FileArchiveFile getFileArchiveFile() {
        Object ret = this.exists.get();
        if (ret instanceof FileArchiveFile) {
            return (FileArchiveFile)ret;
        }
        return null;
    }

    @Override
    public boolean isFileArchiveFileExists() {
        Object ret = this.exists.get();
        if (ret instanceof FileArchiveFile) {
            return ((FileArchiveFile)ret).exists();
        }
        return false;
    }

    @Override
    public void deleteFile(FileCreationManager.DeleteOption option) {
        this.invalidateExists();
    }

    @Override
    public boolean exists(boolean ignoreCache) {
        Object ret;
        Object object = ret = ignoreCache ? null : this.exists.get();
        if (ret instanceof FileArchiveFile) {
            return ((FileArchiveFile)ret).exists(ignoreCache);
        }
        if (ret instanceof Boolean) {
            return (Boolean)ret;
        }
        Boolean fileExists = new File(LinkTreeUtils.getDownloadDirectory((AbstractNode)((AbstractNode)this.getLinks().get(0))), this.getName()).exists();
        this.exists.compareAndSet(null, fileExists);
        return fileExists;
    }

    protected void setExists(FileArchiveFile archiveFile) {
        this.exists.set(archiveFile);
    }

    protected void setExists(boolean b) {
        this.exists.set(b);
    }

    @Override
    public void notifyChanges(Object type) {
        for (CrawledLink link : this.getLinks()) {
            link.firePropertyChanged(CrawledLinkProperty.Property.ARCHIVE, type);
        }
    }

    @Override
    public void removePluginProgress(ExtractionController controller) {
    }

    @Override
    public void invalidateExists() {
        this.exists.set(null);
    }

    @Override
    public String getArchiveID() {
        List<CrawledLink> links = this.getLinks();
        if (links.size() == 0) {
            return null;
        }
        if (links.size() == 1) {
            return links.get(0).getArchiveID();
        }
        HashMap<String, ArchiveFile.ArchiveID> scores = new HashMap<String, ArchiveFile.ArchiveID>();
        for (CrawledLink crawledLink : this.getLinks()) {
            String archiveID = crawledLink.getArchiveID();
            if (archiveID == null) continue;
            ArchiveFile.ArchiveID score = (ArchiveFile.ArchiveID)scores.get(archiveID);
            if (score == null) {
                score = new ArchiveFile.ArchiveID(archiveID);
                scores.put(archiveID, score);
            }
            score.increaseScore();
        }
        if (scores.size() == 0) {
            return null;
        }
        if (scores.size() == 1) {
            return ((ArchiveFile.ArchiveID)scores.values().iterator().next()).getArchiveID();
        }
        ArchiveFile.ArchiveID ret = null;
        for (ArchiveFile.ArchiveID score : scores.values()) {
            if (ret != null && ret.getScore() >= score.getScore()) continue;
            ret = score;
        }
        return ret.getArchiveID();
    }
}

