/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.contextmenu.downloadlist;

import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import org.appwork.controlling.SingleReachableState;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.gui.views.SelectionInfo;

public class ArchiveValidator {
    public static volatile ExtractionExtension EXTENSION;
    private static final WeakHashMap<SelectionInfo, ArchiveValidation> RESULTS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArchiveValidation validate(final SelectionInfo<?, ?> selection, boolean async) {
        if (EXTENSION != null) {
            ArchiveValidation result;
            boolean newResult;
            WeakHashMap<SelectionInfo, ArchiveValidation> weakHashMap = RESULTS;
            synchronized (weakHashMap) {
                ArchiveValidation existingResult = RESULTS.get(selection);
                if (existingResult != null) {
                    newResult = false;
                    result = existingResult;
                } else {
                    newResult = true;
                    result = new ArchiveValidation();
                    RESULTS.put(selection, result);
                }
            }
            if (newResult) {
                if (async && selection.getChildren().size() > 0) {
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            try {
                                result.archives = ArchiveValidator.getArchivesFromPackageChildren(selection.getChildren());
                            }
                            finally {
                                result.state.setReached();
                            }
                        }
                    };
                    thread.setDaemon(true);
                    thread.setName("ArchiveValidation");
                    thread.start();
                } else {
                    try {
                        result.archives = selection.getChildren().size() > 0 ? ArchiveValidator.getArchivesFromPackageChildren(selection.getChildren()) : new ArrayList<Archive>(0);
                    }
                    finally {
                        result.state.setReached();
                    }
                }
                return result;
            }
            if (!async) {
                try {
                    result.waitForReached();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return result;
        }
        ArchiveValidation ret = new ArchiveValidation();
        ret.state.setReached();
        ret.archives = new ArrayList<Archive>(0);
        return ret;
    }

    public static List<Archive> getArchivesFromPackageChildren(List<? extends Object> nodes) {
        return ArchiveValidator.getArchivesFromPackageChildren(nodes, -1);
    }

    public static List<Archive> getArchivesFromPackageChildren(List<? extends Object> nodes, int maxArchives) {
        ExtractionExtension extractor = EXTENSION;
        if (extractor != null) {
            return extractor.getArchivesFromPackageChildren(nodes, null, maxArchives);
        }
        return new ArrayList<Archive>(0);
    }

    static {
        RESULTS = new WeakHashMap();
    }

    public static class ArchiveValidation {
        protected final SingleReachableState state = new SingleReachableState("ArchiveValidation");
        protected volatile List<Archive> archives = null;

        public void executeWhenReached(Runnable run) {
            this.state.executeWhenReached(run);
        }

        public List<Archive> getArchives() {
            return this.archives;
        }

        public boolean isFinished() {
            return this.state.isReached();
        }

        public void waitForReached() throws InterruptedException {
            this.state.waitForReached();
        }
    }
}

