/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.appwork.swing.components.circlebar.CircledProgressBar;
import org.appwork.swing.components.circlebar.IconPainter;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtCircleProgressColumn;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.renderer.RenderLabel;
import org.appwork.utils.swing.renderer.RendererMigPanel;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionEvent;
import org.jdownloader.extensions.extraction.multi.ArchiveType;
import org.jdownloader.extensions.extraction.split.SplitType;
import org.jdownloader.extensions.extraction.translate.T;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.NewTheme;

public class ExtractionJobTableModel
extends ExtTableModel<ExtractionController> {
    private static final long serialVersionUID = 7585295834599426087L;

    public ExtractionJobTableModel() {
        super("ExtractionJobTableModel4");
    }

    protected void initColumns() {
        this.addColumn((ExtColumn)new ExtTextColumn<ExtractionController>(T.T.tooltip_NameColumn()){
            private static final long serialVersionUID = -7294960809807602558L;
            Object lastType;
            Icon lastIcon;
            {
                this.lastType = null;
                this.lastIcon = null;
            }

            public boolean isSortable(ExtractionController obj) {
                return false;
            }

            protected String getTooltipText(ExtractionController value) {
                return value.getArchive().getName();
            }

            public int getDefaultWidth() {
                return 200;
            }

            protected Icon getIcon(ExtractionController value) {
                Enum type = value.getArchive().getArchiveType();
                if (type == null) {
                    type = value.getArchive().getSplitType();
                }
                if (this.lastType != type) {
                    this.lastType = type;
                    try {
                        this.lastIcon = type instanceof ArchiveType ? CrossSystem.getMime().getFileIcon(((ArchiveType)type).getIconExtension(), 16, 16) : (type instanceof SplitType ? CrossSystem.getMime().getFileIcon(((SplitType)type).getIconExtension(), 16, 16) : NewTheme.I().getIcon("extract", 16));
                    }
                    catch (Throwable e) {
                        this.lastIcon = NewTheme.I().getIcon("extract", 16);
                    }
                }
                return this.lastIcon;
            }

            public String getStringValue(ExtractionController value) {
                return value.getArchive().getName();
            }
        });
        this.addColumn((ExtColumn)new ExtTextColumn<ExtractionController>(_GUI.T.lit_status()){
            private static final long serialVersionUID = -5325290576078384961L;

            public boolean isSortable(ExtractionController obj) {
                return false;
            }

            public int getDefaultWidth() {
                return 150;
            }

            public String getStringValue(ExtractionController value) {
                ExtractionEvent.Type event = value.getLatestEvent();
                if (event != null) {
                    switch (event) {
                        case START: {
                            return T.T.plugins_optional_extraction_status_openingarchive2();
                        }
                        case START_CRACK_PASSWORD: {
                            return "Start password finding";
                        }
                        case PASSWORT_CRACKING: {
                            try {
                                return T.T.plugins_optional_extraction_status_crackingpass_progress((double)(10000 * value.getCrackProgress() / value.getPasswordListSize()) / 100.0);
                            }
                            catch (Throwable e) {
                                return T.T.plugins_optional_extraction_status_crackingpass_progress(0.0);
                            }
                        }
                        case PASSWORD_FOUND: {
                            return T.T.plugins_optional_extraction_status_passfound();
                        }
                        case EXTRACTING: {
                            int size = value.getArchive().getExtractedFiles().size();
                            if (size > 0) {
                                return T.T.plugins_optional_extraction_status_extracting_filename(value.getArchive().getExtractedFiles().get(size - 1).getName());
                            }
                            return T.T.plugins_optional_extraction_status_extracting2();
                        }
                        case FINISHED: {
                            return T.T.plugins_optional_extraction_status_extractok();
                        }
                        case NOT_ENOUGH_SPACE: {
                            return T.T.plugins_optional_extraction_status_notenoughspace();
                        }
                        case FILE_NOT_FOUND: {
                            return T.T.plugins_optional_extraction_filenotfound();
                        }
                    }
                    return "";
                }
                return "";
            }
        });
        ExtCircleProgressColumn<ExtractionController> sorter = new ExtCircleProgressColumn<ExtractionController>(_GUI.T.lit_progress()){
            private static final long serialVersionUID = -7238552518783596726L;
            private RendererMigPanel panel;
            private RenderLabel label;
            private DecimalFormat format;
            {
                this.renderer = this.determinatedRenderer = new CircledProgressBar();
                this.determinatedRenderer.setValueClipPainter(new IconPainter(){
                    private Dimension dimension = new Dimension(20, 20);

                    public void paint(CircledProgressBar bar, Graphics2D g2, Shape shape, int diameter, double progress) {
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g2.setColor(ExtractionJobTableModel.this.getTable().getForeground());
                        Area a = new Area(shape);
                        a.intersect(new Area(new Ellipse2D.Float(-diameter / 2, -diameter / 2, diameter, diameter)));
                        g2.fill(a);
                    }

                    public Dimension getPreferredSize() {
                        return this.dimension;
                    }
                });
                this.determinatedRenderer.setNonvalueClipPainter(new IconPainter(){
                    private Dimension dimension = new Dimension(20, 20);

                    public void paint(CircledProgressBar bar, Graphics2D g2, Shape shape, int diameter, double progress) {
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        g2.setColor(ExtractionJobTableModel.this.getTable().getBackground());
                        Area a = new Area(shape);
                        a.intersect(new Area(new Ellipse2D.Float(-diameter / 2, -diameter / 2, diameter, diameter)));
                        g2.fill(a);
                    }

                    public Dimension getPreferredSize() {
                        return this.dimension;
                    }
                });
                this.panel = new RendererMigPanel("ins 0", "[][grow,fill]", "[]");
                this.panel.add((Component)this.determinatedRenderer, (Object)"width 20!,height 20!");
                this.label = new RenderLabel();
                this.format = new DecimalFormat("00.00");
                this.panel.add((Component)this.label);
            }

            protected String getString(ExtractionController value) {
                return "fdfd";
            }

            public JComponent getRendererComponent(ExtractionController value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getRendererComponent((Object)value, isSelected, hasFocus, row, column);
                return this.panel;
            }

            public void configureRendererComponent(ExtractionController value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.configureRendererComponent((Object)value, isSelected, hasFocus, row, column);
                this.label.setText(this.format.format(value.getProgress()) + " %");
            }

            public void resetRenderer() {
                super.resetRenderer();
                this.determinatedRenderer.setForeground(ExtractionJobTableModel.this.getTable().getForeground());
                this.determinatedRenderer.setBorder(BorderFactory.createEmptyBorder(1, 5, 1, 1));
            }

            public int getDefaultWidth() {
                return 80;
            }

            protected long getMax(ExtractionController value) {
                return Math.max(1L, value.getCompleteBytes());
            }

            protected long getValue(ExtractionController value) {
                return value.getProcessedBytes();
            }
        };
        this.addColumn((ExtColumn)sorter);
        this.setSortColumn((ExtColumn)sorter);
    }
}

