/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.gui.bubble;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import org.appwork.storage.config.handler.BooleanKeyHandler;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionEvent;
import org.jdownloader.extensions.extraction.ExtractionListener;
import org.jdownloader.extensions.extraction.gui.bubble.ExtractionBubble;
import org.jdownloader.extensions.extraction.gui.bubble.ExtractionBubbleContent;
import org.jdownloader.gui.notify.AbstractBubbleSupport;
import org.jdownloader.gui.notify.BubbleNotify;
import org.jdownloader.gui.notify.Element;
import org.jdownloader.gui.notify.gui.AbstractNotifyWindow;

public class ExtractionBubbleSupport
extends AbstractBubbleSupport
implements ExtractionListener {
    private ArrayList<Element> elements;
    private final WeakHashMap<ExtractionController, ExtractionBubbleWrapper> map = new WeakHashMap();

    public ExtractionBubbleSupport(String bubbletype, BooleanKeyHandler bubbleEnabledIfArchiveExtractionIsInProgress) {
        super(bubbletype, bubbleEnabledIfArchiveExtractionIsInProgress);
        this.elements = new ArrayList();
        ExtractionBubbleContent.fillElements(this.elements);
    }

    @Override
    public void onExtractionEvent(ExtractionEvent event) {
        if (this.isEnabled()) {
            ExtractionBubbleWrapper wrapper = null;
            switch ((ExtractionEvent.Type)((Object)event.getType())) {
                case START: {
                    wrapper = this.getExtractionBubbleWrapper((ExtractionController)((Object)event.getCaller()), true);
                    if (wrapper == null) break;
                    this.show(wrapper);
                    break;
                }
                default: {
                    ExtractionBubble bubble;
                    wrapper = this.getExtractionBubbleWrapper((ExtractionController)((Object)event.getCaller()), true);
                    if (wrapper == null || (bubble = wrapper.getBubble()) == null) break;
                    bubble.refresh(event);
                    if (!ExtractionEvent.Type.CLEANUP.equals(event.getType())) break;
                    this.remove((ExtractionController)((Object)event.getCaller()));
                    bubble.stop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtractionBubbleWrapper remove(ExtractionController caller) {
        WeakHashMap<ExtractionController, ExtractionBubbleWrapper> weakHashMap = this.map;
        synchronized (weakHashMap) {
            return this.map.remove((Object)caller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtractionBubbleWrapper getExtractionBubbleWrapper(ExtractionController caller, boolean allowNull) {
        WeakHashMap<ExtractionController, ExtractionBubbleWrapper> weakHashMap = this.map;
        synchronized (weakHashMap) {
            ExtractionBubbleWrapper ret = this.map.get((Object)caller);
            if (ret == null && !allowNull) {
                ret = new ExtractionBubbleWrapper(caller);
                ret = this.map.put(caller, ret);
            }
            return ret;
        }
    }

    public List<Element> getElements() {
        return this.elements;
    }

    private class ExtractionBubbleWrapper
    implements BubbleNotify.AbstractNotifyWindowFactory {
        private final WeakReference<ExtractionController> caller;
        private volatile ExtractionBubble bubble = null;

        private ExtractionBubble getBubble() {
            return this.bubble;
        }

        private ExtractionBubbleWrapper(ExtractionController caller) {
            this.caller = new WeakReference<ExtractionController>(caller);
        }

        public AbstractNotifyWindow<?> buildAbstractNotifyWindow() {
            ExtractionController controller = (ExtractionController)((Object)this.caller.get());
            if (controller == null || controller.isFinished()) {
                return null;
            }
            this.bubble = new ExtractionBubble(ExtractionBubbleSupport.this, controller);
            return this.bubble;
        }
    }
}

