/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.gui.config;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import jd.controlling.TaskQueue;
import jd.gui.swing.jdgui.views.settings.components.Checkbox;
import jd.gui.swing.jdgui.views.settings.components.ComboBox;
import jd.gui.swing.jdgui.views.settings.components.FolderChooser;
import jd.gui.swing.jdgui.views.settings.components.SettingsComponent;
import jd.gui.swing.jdgui.views.settings.components.Spinner;
import jd.gui.swing.jdgui.views.settings.components.TextArea;
import jd.gui.swing.jdgui.views.settings.components.TextInput;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.jdownloader.actions.AppAction;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.extensions.AbstractExtension;
import org.jdownloader.extensions.ExtensionConfigPanel;
import org.jdownloader.extensions.extraction.ExtractionConfig;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.multi.Multi;
import org.jdownloader.extensions.extraction.translate.T;
import org.jdownloader.gui.settings.Pair;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.settings.IfFileExistsAction;
import org.jdownloader.settings.staticreferences.CFG_LINKGRABBER;
import org.jdownloader.utils.JDFileUtils;

public class ExtractionConfigPanel
extends ExtensionConfigPanel<ExtractionExtension> {
    private static final long serialVersionUID = 1L;
    private Pair<Checkbox> toggleCustomizedPath;
    private Pair<FolderChooser> customPath;
    private Pair<Checkbox> toggleUseSubpath;
    private Pair<Spinner> subPathMinFiles;
    private Pair<? extends TextInput> subPath;
    private Pair<ComboBox<FileCreationManager.DeleteOption>> toggleDeleteArchives;
    private Pair<ComboBox<IfFileExistsAction>> toggleOverwriteExisting;
    private Pair<TextArea> blacklist;
    private Pair<Checkbox> toggleUseOriginalFileDate;
    private Pair<TextArea> passwordlist;
    private Pair<Checkbox> toggleDeleteArchiveDownloadLinks;
    private Pair<Checkbox> toggleDefaultEnabled = this.addPair(T.T.settings_auto_extract_default(), null, (SettingsComponent)new Checkbox());
    private Pair<Spinner> subPathMinFolders;
    private Pair<Spinner> subPathMinFilesOrFolders;

    protected String getHeaderName(ExtractionExtension plg) {
        return super.getHeaderName((AbstractExtension)plg) + ": (7Zip Binding Version: " + Multi.getSevenZipJBindingVersion() + ")";
    }

    public ExtractionConfigPanel(ExtractionExtension plg) {
        super((AbstractExtension)plg);
        this.addHeader(T.T.settings_extractto(), (Icon)new AbstractIcon("folder", 32));
        this.toggleCustomizedPath = this.addPair(T.T.settings_extract_to_archive_folder(), null, (SettingsComponent)new Checkbox());
        this.customPath = this.addPair(T.T.settings_extract_to_path(), null, (SettingsComponent)new FolderChooser());
        this.customPath.setConditionPair(this.toggleCustomizedPath);
        this.toggleUseSubpath = this.addPair(T.T.settings_use_subpath(), null, (SettingsComponent)new Checkbox());
        this.subPath = this.addPair(T.T.settings_subpath(), null, (SettingsComponent)new TextInput(){

            public JPopupMenu getPopupMenu(MouseEvent event, AbstractAction cutAction, AbstractAction copyAction, AbstractAction pasteAction, AbstractAction deleteAction, AbstractAction selectAction) {
                JPopupMenu menu = new JPopupMenu();
                JMenu sub = new JMenu(T.T.properties());
                sub.add((Action)new AppAction(){
                    {
                        this.setName(T.T.packagename());
                    }

                    public void actionPerformed(ActionEvent e) {
                        if (StringUtils.isEmpty((String)this.getText())) {
                            this.setText("%PACKAGENAME%");
                        } else {
                            int car = this.getCaretPosition();
                            try {
                                this.getDocument().insertString(car, "%PACKAGENAME%", null);
                            }
                            catch (BadLocationException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                });
                sub.add((Action)new AppAction(){
                    {
                        this.setName(T.T.archivename());
                    }

                    public void actionPerformed(ActionEvent e) {
                        if (StringUtils.isEmpty((String)this.getText())) {
                            this.setText("%ARCHIVENAME%");
                        } else {
                            int car = this.getCaretPosition();
                            try {
                                this.getDocument().insertString(car, "%ARCHIVENAME%", null);
                            }
                            catch (BadLocationException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                });
                sub.add((Action)new AppAction(){
                    {
                        this.setName(T.T.subfolder());
                    }

                    public void actionPerformed(ActionEvent e) {
                        if (StringUtils.isEmpty((String)this.getText())) {
                            this.setText("%SUBFOLDER%");
                        } else {
                            int car = this.getCaretPosition();
                            try {
                                this.getDocument().insertString(car, "%SUBFOLDER%", null);
                            }
                            catch (BadLocationException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                });
                sub.add((Action)new AppAction(){
                    {
                        this.setName(T.T.hoster());
                    }

                    public void actionPerformed(ActionEvent e) {
                        if (StringUtils.isEmpty((String)this.getText())) {
                            this.setText("%HOSTER%");
                        } else {
                            int car = this.getCaretPosition();
                            try {
                                this.getDocument().insertString(car, "%HOSTER%", null);
                            }
                            catch (BadLocationException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                });
                sub.add((Action)new AppAction(){
                    {
                        this.setName(T.T.date());
                    }

                    public void actionPerformed(ActionEvent e) {
                        if (StringUtils.isEmpty((String)this.getText())) {
                            this.setText("$DATE:dd.MM.yyyy$");
                        } else {
                            int car = this.getCaretPosition();
                            try {
                                this.getDocument().insertString(car, "$DATE:dd.MM.yyyy$", null);
                            }
                            catch (BadLocationException e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                });
                menu.add(sub);
                menu.add(new JSeparator());
                menu.add(cutAction);
                menu.add(copyAction);
                menu.add(pasteAction);
                menu.add(deleteAction);
                menu.add(selectAction);
                return menu;
            }
        });
        this.subPath.setConditionPair(this.toggleUseSubpath);
        Spinner spinner = new Spinner(0, Integer.MAX_VALUE);
        spinner.setFormat("# " + T.T.files2());
        String lblConstraints = "gapleft 37,aligny center,alignx right";
        this.subPathMinFiles = this.addPair(T.T.settings_subpath_minnum3(), lblConstraints, null, (SettingsComponent)spinner);
        this.subPathMinFiles.setConditionPair(this.toggleUseSubpath);
        Spinner spinner2 = new Spinner(0, Integer.MAX_VALUE);
        spinner2.setFormat("# " + T.T.folders());
        this.subPathMinFolders = this.addPair(T.T.and(), lblConstraints, null, (SettingsComponent)spinner2);
        this.subPathMinFolders.setConditionPair(this.toggleUseSubpath);
        Spinner spinner3 = new Spinner(0, Integer.MAX_VALUE);
        spinner3.setFormat("# " + T.T.files_and_folders());
        this.subPathMinFilesOrFolders = this.addPair(T.T.and(), lblConstraints, null, (SettingsComponent)spinner3);
        this.subPathMinFilesOrFolders.setConditionPair(this.toggleUseSubpath);
        this.addHeader(T.T.settings_various(), (Icon)new AbstractIcon("settings", 32));
        FileCreationManager.DeleteOption[] deleteOptions = JDFileUtils.isTrashSupported() ? new FileCreationManager.DeleteOption[]{FileCreationManager.DeleteOption.NO_DELETE, FileCreationManager.DeleteOption.RECYCLE, FileCreationManager.DeleteOption.NULL} : new FileCreationManager.DeleteOption[]{FileCreationManager.DeleteOption.NO_DELETE, FileCreationManager.DeleteOption.NULL};
        this.toggleDeleteArchives = this.addPair(T.T.settings_remove_after_extract(), null, (SettingsComponent)new ComboBox<FileCreationManager.DeleteOption>(deleteOptions){

            protected String valueToString(FileCreationManager.DeleteOption value) {
                switch (value) {
                    case RECYCLE: {
                        return T.T.delete_to_trash();
                    }
                    case NO_DELETE: {
                        return T.T.dont_delete();
                    }
                    case NULL: {
                        return T.T.final_delete();
                    }
                }
                return null;
            }
        });
        this.toggleDeleteArchiveDownloadLinks = this.addPair(T.T.settings_remove_after_extract_downloadlink(), null, (SettingsComponent)new Checkbox());
        this.toggleOverwriteExisting = this.addPair(T.T.settings_if_file_exists(), null, (SettingsComponent)new ComboBox((Object[])IfFileExistsAction.values()));
        this.addHeader(T.T.settings_multi(), (Icon)new AbstractIcon("settings", 32));
        this.toggleUseOriginalFileDate = this.addPair(T.T.settings_multi_use_original_file_date(), null, (SettingsComponent)new Checkbox());
        this.blacklist = this.addPair(T.T.settings_blacklist_regex(), null, (SettingsComponent)new TextArea());
        this.addHeader(T.T.settings_passwords(), (Icon)new AbstractIcon("password", 32));
        this.passwordlist = this.addPair(T.T.settings_passwordlist(), null, (SettingsComponent)new TextArea());
        Component pwTextArea = ((TextArea)this.passwordlist.getComponent()).getViewport().getView();
        ((JTextArea)pwTextArea).setEditable(false);
    }

    public void updateContents() {
        TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(Queue.QueuePriority.HIGH){

            protected Void run() throws RuntimeException {
                String blackListPatternsString;
                final ExtractionConfig s = (ExtractionConfig)((ExtractionExtension)ExtractionConfigPanel.this.extension).getSettings();
                String path = s.getCustomExtractionPath();
                if (path == null) {
                    path = new File(((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getDefaultDownloadFolder(), "extracted").getAbsolutePath();
                }
                final String finalPath = path;
                String[] blackListPatterns = s.getBlacklistPatterns();
                if (blackListPatterns == null || blackListPatterns.length == 0) {
                    blackListPatternsString = "";
                } else if (blackListPatterns.length == 1) {
                    blackListPatternsString = blackListPatterns[0];
                } else {
                    StringBuilder sb = new StringBuilder();
                    String separator = System.getProperty("line.separator");
                    for (String pw : blackListPatterns) {
                        sb.append(pw);
                        sb.append(separator);
                    }
                    blackListPatternsString = sb.toString();
                }
                new EDTRunner(){

                    protected void runInEDT() {
                        ((Checkbox)ExtractionConfigPanel.this.toggleDefaultEnabled.getComponent()).setSelected(CFG_LINKGRABBER.AUTO_EXTRACTION_ENABLED.isEnabled());
                        ((Checkbox)ExtractionConfigPanel.this.toggleCustomizedPath.getComponent()).setSelected(s.isCustomExtractionPathEnabled());
                        ((FolderChooser)ExtractionConfigPanel.this.customPath.getComponent()).setText(finalPath);
                        ((ComboBox)ExtractionConfigPanel.this.toggleDeleteArchives.getComponent()).setSelectedItem((Object)s.getDeleteArchiveFilesAfterExtractionAction());
                        ((Checkbox)ExtractionConfigPanel.this.toggleDeleteArchiveDownloadLinks.getComponent()).setSelected(s.isDeleteArchiveDownloadlinksAfterExtraction());
                        ((ComboBox)ExtractionConfigPanel.this.toggleOverwriteExisting.getComponent()).setSelectedItem((Object)s.getIfFileExistsAction());
                        ((Checkbox)ExtractionConfigPanel.this.toggleUseSubpath.getComponent()).setSelected(s.isSubpathEnabled());
                        ((TextInput)ExtractionConfigPanel.this.subPath.getComponent()).setText(s.getSubPath());
                        ((Spinner)ExtractionConfigPanel.this.subPathMinFiles.getComponent()).setValue(s.getSubPathMinFilesTreshhold());
                        ((Spinner)ExtractionConfigPanel.this.subPathMinFolders.getComponent()).setValue(s.getSubPathMinFoldersTreshhold());
                        ((Spinner)ExtractionConfigPanel.this.subPathMinFilesOrFolders.getComponent()).setValue(s.getSubPathMinFilesOrFoldersTreshhold());
                        ((TextArea)ExtractionConfigPanel.this.blacklist.getComponent()).setText(blackListPatternsString);
                        ((Checkbox)ExtractionConfigPanel.this.toggleUseOriginalFileDate.getComponent()).setSelected(s.isUseOriginalFileDate());
                    }
                }.waitForEDT();
                return null;
            }
        });
        TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(Queue.QueuePriority.HIGH){

            protected Void run() throws RuntimeException {
                String pwListString;
                ExtractionConfig s = (ExtractionConfig)((ExtractionExtension)ExtractionConfigPanel.this.extension).getSettings();
                List<String> pwList = s.getPasswordList();
                if (pwList == null || pwList.size() == 0) {
                    pwListString = "";
                } else if (pwList.size() == 1) {
                    pwListString = pwList.get(0);
                } else {
                    StringBuilder sb = new StringBuilder();
                    String separator = System.getProperty("line.separator");
                    for (String pw : pwList) {
                        sb.append(pw);
                        sb.append(separator);
                    }
                    pwListString = sb.toString();
                }
                new EDTRunner(){

                    protected void runInEDT() {
                        ((TextArea)ExtractionConfigPanel.this.passwordlist.getComponent()).setText(pwListString);
                        Component pwTextArea = ((TextArea)ExtractionConfigPanel.this.passwordlist.getComponent()).getViewport().getView();
                        ((JTextArea)pwTextArea).setEditable(true);
                    }
                }.waitForEDT();
                return null;
            }
        });
    }

    public void save() {
        TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                final ExtractionConfig s = (ExtractionConfig)((ExtractionExtension)ExtractionConfigPanel.this.extension).getSettings();
                new EDTRunner(){

                    protected void runInEDT() {
                        CFG_LINKGRABBER.AUTO_EXTRACTION_ENABLED.setValue((Object)((Checkbox)ExtractionConfigPanel.this.toggleDefaultEnabled.getComponent()).isSelected());
                        s.setCustomExtractionPathEnabled(((Checkbox)ExtractionConfigPanel.this.toggleCustomizedPath.getComponent()).isSelected());
                        if (((Checkbox)ExtractionConfigPanel.this.toggleCustomizedPath.getComponent()).isSelected()) {
                            s.setCustomExtractionPath(((FolderChooser)ExtractionConfigPanel.this.customPath.getComponent()).getText());
                        } else {
                            s.setCustomExtractionPath(((FolderChooser)ExtractionConfigPanel.this.customPath.getComponent()).getText(Boolean.valueOf(false)));
                        }
                        s.setDeleteArchiveFilesAfterExtractionAction((FileCreationManager.DeleteOption)((ComboBox)ExtractionConfigPanel.this.toggleDeleteArchives.getComponent()).getSelectedItem());
                        s.setDeleteArchiveDownloadlinksAfterExtraction(((Checkbox)ExtractionConfigPanel.this.toggleDeleteArchiveDownloadLinks.getComponent()).isSelected());
                        s.setIfFileExistsAction((IfFileExistsAction)((ComboBox)ExtractionConfigPanel.this.toggleOverwriteExisting.getComponent()).getSelectedItem());
                        s.setSubpathEnabled(((Checkbox)ExtractionConfigPanel.this.toggleUseSubpath.getComponent()).isSelected());
                        s.setSubPath(((TextInput)ExtractionConfigPanel.this.subPath.getComponent()).getText());
                        try {
                            s.setSubPathMinFilesTreshhold((Integer)((Spinner)ExtractionConfigPanel.this.subPathMinFiles.getComponent()).getValue());
                        }
                        catch (Throwable e) {
                            LoggerFactory.getDefaultLogger().log(e);
                        }
                        try {
                            s.setSubPathMinFoldersTreshhold((Integer)((Spinner)ExtractionConfigPanel.this.subPathMinFolders.getComponent()).getValue());
                        }
                        catch (Throwable e) {
                            LoggerFactory.getDefaultLogger().log(e);
                        }
                        try {
                            s.setSubPathMinFilesOrFoldersTreshhold((Integer)((Spinner)ExtractionConfigPanel.this.subPathMinFilesOrFolders.getComponent()).getValue());
                        }
                        catch (Throwable e) {
                            LoggerFactory.getDefaultLogger().log(e);
                        }
                        s.setUseOriginalFileDate(((Checkbox)ExtractionConfigPanel.this.toggleUseOriginalFileDate.getComponent()).isSelected());
                    }
                };
                TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                    protected Void run() throws RuntimeException {
                        String txt = (String)new EDTHelper<String>(){

                            public String edtRun() {
                                return ((TextArea)ExtractionConfigPanel.this.passwordlist.getComponent()).getText();
                            }
                        }.getReturnValue();
                        String[] list = txt.split("[\r\n]{1,2}");
                        LinkedHashSet<String> passwords = new LinkedHashSet<String>();
                        for (String pw : list) {
                            if (!StringUtils.isNotEmpty((String)pw)) continue;
                            passwords.add(pw);
                        }
                        s.setPasswordList(new ArrayList<String>(passwords));
                        return null;
                    }
                });
                TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                    protected Void run() throws RuntimeException {
                        String txt = (String)new EDTHelper<String>(){

                            public String edtRun() {
                                return ((TextArea)ExtractionConfigPanel.this.blacklist.getComponent()).getText();
                            }
                        }.getReturnValue();
                        String[] list = Regex.getLines((String)txt);
                        LinkedHashSet<String> ignoreList = new LinkedHashSet<String>();
                        for (String ss : list) {
                            ignoreList.add(ss);
                        }
                        s.setBlacklistPatterns(ignoreList.toArray(new String[ignoreList.size()]));
                        return null;
                    }
                });
                return null;
            }
        });
    }
}

