/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.multi;

import java.util.concurrent.atomic.AtomicReference;
import net.sf.sevenzipjbinding.ISequentialOutStream;
import net.sf.sevenzipjbinding.SevenZipException;
import org.appwork.utils.Regex;
import org.appwork.utils.ReusableByteArrayOutputStream;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.FileSignatures;
import org.jdownloader.extensions.extraction.Signature;
import org.jdownloader.extensions.extraction.multi.MultiSevenZipException;

public class SignatureCheckingOutStream
implements ISequentialOutStream {
    private final AtomicReference<Signature> passwordFound;
    private final FileSignatures filesignatures;
    private final ReusableByteArrayOutputStream buffer;
    private int signatureMinLength = 32;
    private final long maxPWCheckSize;
    private String itemName;
    private long itemSize = -1L;
    private final boolean optimized;
    private boolean ignoreWrite = false;
    private final ExtractionController ctrl;
    private Signature lastSignature = null;

    public SignatureCheckingOutStream(ExtractionController ctrl, AtomicReference<Signature> passwordFound, FileSignatures filesignatures, ReusableByteArrayOutputStream buffer, long maxPWCheckSize, boolean optimized) {
        this.passwordFound = passwordFound;
        this.filesignatures = filesignatures;
        this.buffer = buffer;
        this.maxPWCheckSize = maxPWCheckSize;
        this.optimized = optimized;
        this.ctrl = ctrl;
    }

    public int write(byte[] data, int off, int len) throws SevenZipException {
        if (this.ctrl.gotKilled()) {
            throw new MultiSevenZipException("Extraction has been aborted", 255);
        }
        if (!this.ignoreWrite) {
            int toWrite = Math.min(this.buffer.free(), len);
            if (toWrite > 0) {
                this.buffer.write(data, off, toWrite);
            } else {
                this.ignoreWrite = true;
            }
            if (this.buffer.size() >= this.signatureMinLength) {
                StringBuilder magic = new StringBuilder();
                for (int i = 0; i < this.buffer.size() - 1; ++i) {
                    String s = Integer.toHexString(this.buffer.getInternalBuffer()[i]);
                    s = s.length() < 2 ? "0" + s : s;
                    s = s.substring(s.length() - 2);
                    magic.append(s);
                }
                Signature signature = this.filesignatures.getSignature(magic, this.itemName);
                if (signature != null) {
                    if (signature.isPrecisePatternStart()) {
                        this.passwordFound.set(signature);
                        return 0;
                    }
                    this.lastSignature = signature;
                }
            }
        }
        if (this.itemSize >= 0L && this.itemSize <= this.maxPWCheckSize || !this.optimized || this.lastSignature != null) {
            return len;
        }
        return 0;
    }

    public int write(byte[] data) throws SevenZipException {
        return this.write(data, 0, data.length);
    }

    public Signature getLastSignature() {
        return this.lastSignature;
    }

    public void reset() {
        this.buffer.reset();
        this.signatureMinLength = 32;
        this.itemName = null;
        this.itemSize = -1L;
        this.lastSignature = null;
    }

    public long getWritten() {
        return this.buffer.size();
    }

    public void setSignatureLength(String itemName, long itemSize) {
        this.signatureMinLength = new Regex(itemName, ".+\\.(iso|udf)").matches() ? 37000 : (new Regex(itemName, ".+\\.mp3").matches() ? 512 : 32);
        this.itemName = itemName;
        this.itemSize = itemSize;
    }
}

