/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.split;

import java.io.File;
import java.util.List;
import jd.controlling.linkcrawler.CrawledLink;
import jd.plugins.DownloadLink;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.jdownloader.controlling.filter.CompiledFiletypeFilter;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFactory;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.DummyArchive;
import org.jdownloader.extensions.extraction.DummyArchiveFile;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionControllerException;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.IExtraction;
import org.jdownloader.extensions.extraction.bindings.crawledlink.CrawledLinkFactory;
import org.jdownloader.extensions.extraction.bindings.downloadlink.DownloadLinkArchiveFactory;
import org.jdownloader.extensions.extraction.multi.ArchiveException;
import org.jdownloader.extensions.extraction.multi.CheckException;
import org.jdownloader.extensions.extraction.split.SplitType;
import org.jdownloader.extensions.extraction.split.SplitUtil;

public class HachaSplit
extends IExtraction {
    private final SplitType splitType = SplitType.HACHA_SPLIT;
    private final ExtractionExtension extension;

    @Override
    public Archive buildArchive(ArchiveFactory link, boolean allowDeepInspection) throws ArchiveException {
        return SplitType.createArchive(link, this.splitType, allowDeepInspection);
    }

    public HachaSplit(ExtractionExtension extension) {
        this.extension = extension;
    }

    @Override
    public boolean findPassword(ExtractionController controller, String password, boolean optimized) {
        return true;
    }

    @Override
    public void extract(ExtractionController ctrl) {
        Archive archive = this.getExtractionController().getArchive();
        ArchiveFile firstArchiveFile = archive.getArchiveFiles().get(0);
        String[] matches = this.splitType.getMatches(firstArchiveFile.getFilePath());
        if (matches != null) {
            try {
                HachaHeader hachaHeader = HachaSplit.parseHachaHeader(firstArchiveFile);
                if (SplitUtil.merge(this.getExtractionController(), hachaHeader.getFileName(), hachaHeader.getHeaderSize(), this.getConfig())) {
                    archive.setExitCode(0);
                } else if (archive.getExitCode() == -1) {
                    archive.setExitCode(2);
                }
                return;
            }
            catch (ExtractionControllerException e) {
                this.setException(e);
                archive.setExitCode(e.getExitCode());
            }
            catch (Exception e) {
                this.setException(e);
                archive.setExitCode(2);
            }
        } else {
            archive.setExitCode(2);
        }
    }

    @Override
    public boolean isAvailable(ExtractionExtension extractionExtension) {
        return true;
    }

    @Override
    public int getCrackProgress() {
        return 100;
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public void close() {
    }

    @Override
    public DummyArchive checkComplete(Archive archive) throws CheckException {
        if (archive.getSplitType() == this.splitType) {
            try {
                DummyArchive dummyArchive = new DummyArchive(archive, this.splitType);
                for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
                    dummyArchive.add(new DummyArchiveFile(archiveFile));
                }
                if (dummyArchive.isComplete()) {
                    ArchiveFile firstFile = archive.getArchiveFiles().get(0);
                    String firstArchiveFile = firstFile.getFilePath();
                    String partNumberOfFirstArchiveFile = this.splitType.getPartNumberString(firstArchiveFile);
                    if (this.splitType.getFirstPartIndex() != this.splitType.getPartNumber(partNumberOfFirstArchiveFile)) {
                        throw new CheckException("Wrong firstArchiveFile(" + firstArchiveFile + ") for Archive(" + archive.getName() + ")");
                    }
                    if (firstFile.exists()) {
                        HachaHeader hachaHeader = HachaSplit.parseHachaHeader(firstFile);
                        if (hachaHeader == null) {
                            throw new CheckException("HachaHeader not found");
                        }
                        List<ArchiveFile> missingArchiveFiles = SplitType.getMissingArchiveFiles(archive, this.splitType, hachaHeader.getNumberOfParts());
                        if (missingArchiveFiles != null) {
                            for (ArchiveFile missingArchiveFile : missingArchiveFiles) {
                                dummyArchive.add(new DummyArchiveFile(missingArchiveFile));
                            }
                        }
                        if (dummyArchive.getSize() < hachaHeader.getNumberOfParts()) {
                            throw new CheckException("Missing archiveParts(" + hachaHeader.getNumberOfParts() + "!=" + dummyArchive.getSize() + ") for Archive(" + archive.getName() + ")");
                        }
                        if (dummyArchive.getSize() > hachaHeader.getNumberOfParts()) {
                            throw new CheckException("Too many archiveParts(" + hachaHeader.getNumberOfParts() + "!=" + dummyArchive.getSize() + ") for Archive(" + archive.getName() + ")");
                        }
                    }
                }
                return dummyArchive;
            }
            catch (CheckException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new CheckException("Cannot check Archive(" + archive.getName() + ")", e);
            }
        }
        return null;
    }

    public static HachaHeader parseHachaHeader(ArchiveFile archiveFile) throws Exception {
        byte[] hachaHeaderBytes;
        if (archiveFile != null && archiveFile.exists() && (hachaHeaderBytes = IO.readFile((File)new File(archiveFile.getFilePath()), (int)1024)).length > 9) {
            String hachaHeaderString = new String(hachaHeaderBytes, 9, hachaHeaderBytes.length - 9, "US-ASCII");
            String[] parsedHachaHeader = new Regex(hachaHeaderString, "\\?{5}(.*?)\\?{5}(\\d+)\\?{5}(\\d+)\\?{5}").getRow(0);
            long fileSize = Long.parseLong(parsedHachaHeader[1]);
            int headerSize = 29 + parsedHachaHeader[0].length() + parsedHachaHeader[1].length() + parsedHachaHeader[2].length();
            long completeSize = fileSize + (long)headerSize;
            long segmentSize = Long.parseLong(parsedHachaHeader[2]);
            int numberOfParts = (int)(completeSize / segmentSize) + (completeSize % segmentSize == 0L ? 0 : 1);
            return new HachaHeader(parsedHachaHeader[0], headerSize, fileSize, numberOfParts);
        }
        return null;
    }

    @Override
    public Boolean isSupported(ArchiveFactory factory, boolean allowDeepInspection) {
        if (this.splitType.matches(factory.getFilePath())) {
            if (factory instanceof DownloadLinkArchiveFactory) {
                for (DownloadLink link : ((DownloadLinkArchiveFactory)factory).getDownloadLinks()) {
                    CompiledFiletypeFilter.CompiledFiletypeExtension hint = CompiledFiletypeFilter.getExtensionsFilterInterface((String)link.getMimeHint());
                    if (hint == null || hint.isSameExtensionGroup((CompiledFiletypeFilter.ExtensionsFilterInterface)CompiledFiletypeFilter.ArchiveExtensions.NUM)) continue;
                    return false;
                }
            } else if (factory instanceof CrawledLinkFactory) {
                for (CrawledLink link : ((CrawledLinkFactory)factory).getLinks()) {
                    CompiledFiletypeFilter.CompiledFiletypeExtension hint;
                    DownloadLink dlLink = link.getDownloadLink();
                    if (dlLink == null || (hint = CompiledFiletypeFilter.getExtensionsFilterInterface((String)dlLink.getMimeHint())) == null || hint.isSameExtensionGroup((CompiledFiletypeFilter.ExtensionsFilterInterface)CompiledFiletypeFilter.ArchiveExtensions.NUM)) continue;
                    return false;
                }
            }
            if (allowDeepInspection) {
                try {
                    Archive archive = SplitType.createArchive(factory, this.splitType, allowDeepInspection);
                    return archive != null && this.splitType == archive.getSplitType();
                }
                catch (ArchiveException e) {
                    this.getLogger().log((Throwable)e);
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static class HachaHeader {
        protected final String fileName;
        protected final long fileSize;
        protected final int headerSize;
        protected final int numberOfParts;

        public String getFileName() {
            return this.fileName;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public int getNumberOfParts() {
            return this.numberOfParts;
        }

        public int getHeaderSize() {
            return this.headerSize;
        }

        protected HachaHeader(String fileName, int headerSize, long fileSize, int numberOfParts) {
            this.fileName = fileName;
            this.fileSize = fileSize;
            this.headerSize = headerSize;
            this.numberOfParts = numberOfParts;
        }
    }
}

