/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.extraction.split;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.WeakHashMap;
import org.appwork.utils.IO;
import org.appwork.utils.awfc.AWFCUtils;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFactory;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.DummyArchive;
import org.jdownloader.extensions.extraction.DummyArchiveFile;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.IExtraction;
import org.jdownloader.extensions.extraction.multi.ArchiveException;
import org.jdownloader.extensions.extraction.multi.CheckException;
import org.jdownloader.extensions.extraction.split.SplitType;

public class XtreamSplit
extends IExtraction {
    private static final int HEADER_SIZE = 104;
    private boolean md5 = false;
    private File outputFile;
    private final WeakHashMap<ArchiveFile, byte[]> hashes = new WeakHashMap();
    private final SplitType splitType = SplitType.XTREMSPLIT;
    private final ExtractionExtension extension;

    public XtreamSplit(ExtractionExtension extension) {
        this.extension = extension;
    }

    @Override
    public Archive buildArchive(ArchiveFactory link, boolean allowDeepInspection) throws ArchiveException {
        return SplitType.createArchive(link, this.splitType, allowDeepInspection);
    }

    @Override
    public boolean findPassword(ExtractionController controller, String password, boolean optimized) {
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void extract(ExtractionController ctrl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 26[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isAvailable(ExtractionExtension extractionExtension) {
        return true;
    }

    @Override
    public int getCrackProgress() {
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepare() {
        boolean bl;
        Archive archive = this.getExtractionController().getArchive();
        ArchiveFile firstArchiveFile = archive.getArchiveFiles().get(0);
        this.outputFile = new File(firstArchiveFile.getFilePath().replaceFirst("\\.[\\d]+\\.xtm$", ""));
        FileInputStream in = null;
        try {
            in = new FileInputStream(firstArchiveFile.getFilePath());
            AWFCUtils awfc = new AWFCUtils((InputStream)in);
            in.skip(40L);
            byte[] buffer = new byte[awfc.ensureRead()];
            awfc.ensureRead(buffer.length, buffer);
            in.skip(50 - buffer.length);
            String filename = new String(buffer, "UTF-8");
            if (filename != null && filename.trim().length() != 0) {
                this.outputFile = new File(this.outputFile.getAbsolutePath().replace(this.outputFile.getName(), filename));
            } else {
                this.logger.warning("Could not read from XtremSplit file " + this.outputFile.getAbsolutePath());
            }
            this.md5 = awfc.ensureRead() == 1;
            buffer = new byte[4];
            awfc.ensureRead(4, buffer);
            int numberOfFiles = ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN).getInt();
            buffer = new byte[8];
            awfc.ensureRead(8, buffer);
            in.close();
            if (numberOfFiles > archive.getArchiveFiles().size()) {
                this.logger.warning("Archive incomplete: " + numberOfFiles + "!=" + archive.getArchiveFiles().size());
                archive.setExitCode(4);
                boolean bl2 = false;
                return bl2;
            }
            if (this.md5) {
                File lastFile = new File(archive.getArchiveFiles().get(numberOfFiles - 1).getFilePath());
                final RandomAccessFile raf = IO.open((File)lastFile, (String)"r");
                try {
                    awfc = new AWFCUtils(new InputStream(){

                        @Override
                        public int read() throws IOException {
                            return raf.read();
                        }

                        @Override
                        public int read(byte[] b, int off, int len) throws IOException {
                            return raf.read(b, off, len);
                        }
                    });
                    raf.seek(lastFile.length() - (long)(32 * numberOfFiles));
                    buffer = new byte[32];
                    for (int i = 0; i < numberOfFiles; ++i) {
                        awfc.ensureRead(32, buffer);
                        this.hashes.put(archive.getArchiveFiles().get(i), buffer);
                    }
                }
                finally {
                    if (raf != null) {
                        raf.close();
                    }
                }
            }
            bl = true;
        }
        catch (Exception e) {
            this.setException(e);
            archive.setExitCode(2);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    @Override
    public void close() {
        this.hashes.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DummyArchive checkComplete(Archive archive) throws CheckException {
        if (archive.getSplitType() == this.splitType) {
            try {
                DummyArchive dummyArchive = new DummyArchive(archive, this.splitType);
                for (ArchiveFile archiveFile : archive.getArchiveFiles()) {
                    dummyArchive.add(new DummyArchiveFile(archiveFile));
                }
                ArchiveFile firstFile = archive.getArchiveFiles().get(0);
                if (dummyArchive.isComplete() && firstFile.exists()) {
                    String firstArchiveFile = firstFile.getFilePath();
                    String partNumberOfFirstArchiveFile = this.splitType.getPartNumberString(firstArchiveFile);
                    if (this.splitType.getFirstPartIndex() != this.splitType.getPartNumber(partNumberOfFirstArchiveFile)) {
                        throw new CheckException("Wrong firstArchiveFile(" + firstArchiveFile + ") for Archive(" + archive.getName() + ")");
                    }
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream(firstArchiveFile);
                        AWFCUtils awfc = new AWFCUtils((InputStream)is);
                        ((InputStream)is).skip(40L);
                        byte[] buffer = new byte[awfc.ensureRead()];
                        awfc.ensureRead(buffer.length, buffer);
                        ((InputStream)is).skip(50 - buffer.length);
                        awfc.ensureRead();
                        buffer = new byte[4];
                        awfc.ensureRead(4, buffer);
                        int numberOfParts = ByteBuffer.wrap(buffer).order(ByteOrder.LITTLE_ENDIAN).getInt();
                        ((InputStream)is).close();
                        List<ArchiveFile> missingArchiveFiles = SplitType.getMissingArchiveFiles(archive, this.splitType, numberOfParts);
                        if (missingArchiveFiles != null) {
                            for (ArchiveFile missingArchiveFile : missingArchiveFiles) {
                                dummyArchive.add(new DummyArchiveFile(missingArchiveFile));
                            }
                        }
                        if (dummyArchive.getSize() < numberOfParts) {
                            throw new CheckException("Missing archiveParts(" + numberOfParts + "!=" + dummyArchive.getSize() + ") for Archive(" + archive.getName() + ")");
                        }
                        if (dummyArchive.getSize() > numberOfParts) {
                            throw new CheckException("Too many archiveParts(" + numberOfParts + "!=" + dummyArchive.getSize() + ") for Archive(" + archive.getName() + ")");
                        }
                    }
                    finally {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                }
                return dummyArchive;
            }
            catch (CheckException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new CheckException("Cannot check Archive(" + archive.getName() + ")", e);
            }
        }
        return null;
    }

    @Override
    public Boolean isSupported(ArchiveFactory factory, boolean allowDeepInspection) {
        if (this.splitType.matches(factory.getFilePath())) {
            if (allowDeepInspection) {
                try {
                    Archive archive = SplitType.createArchive(factory, this.splitType, allowDeepInspection);
                    return archive != null && this.splitType == archive.getSplitType();
                }
                catch (ArchiveException e) {
                    this.getLogger().log((Throwable)e);
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

