/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.protocol.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.model.DiscoveryOptions;
import org.fourthline.cling.model.Location;
import org.fourthline.cling.model.NetworkAddress;
import org.fourthline.cling.model.message.IncomingDatagramMessage;
import org.fourthline.cling.model.message.UpnpRequest;
import org.fourthline.cling.model.message.discovery.IncomingSearchRequest;
import org.fourthline.cling.model.message.discovery.OutgoingSearchResponse;
import org.fourthline.cling.model.message.discovery.OutgoingSearchResponseDeviceType;
import org.fourthline.cling.model.message.discovery.OutgoingSearchResponseRootDevice;
import org.fourthline.cling.model.message.discovery.OutgoingSearchResponseServiceType;
import org.fourthline.cling.model.message.discovery.OutgoingSearchResponseUDN;
import org.fourthline.cling.model.message.header.DeviceTypeHeader;
import org.fourthline.cling.model.message.header.MXHeader;
import org.fourthline.cling.model.message.header.RootDeviceHeader;
import org.fourthline.cling.model.message.header.STAllHeader;
import org.fourthline.cling.model.message.header.ServiceTypeHeader;
import org.fourthline.cling.model.message.header.UDNHeader;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.model.meta.Device;
import org.fourthline.cling.model.meta.DeviceIdentity;
import org.fourthline.cling.model.meta.LocalDevice;
import org.fourthline.cling.model.types.DeviceType;
import org.fourthline.cling.model.types.ServiceType;
import org.fourthline.cling.model.types.UDN;
import org.fourthline.cling.protocol.ReceivingAsync;
import org.fourthline.cling.transport.RouterException;

public class ReceivingSearch
extends ReceivingAsync<IncomingSearchRequest> {
    private static final Logger log = Logger.getLogger(ReceivingSearch.class.getName());
    private static final boolean LOG_ENABLED = log.isLoggable(Level.FINE);
    protected final Random randomGenerator = new Random();

    public ReceivingSearch(UpnpService upnpService, IncomingDatagramMessage<UpnpRequest> inputMessage) {
        super(upnpService, new IncomingSearchRequest(inputMessage));
    }

    @Override
    protected void execute() throws RouterException {
        if (this.getUpnpService().getRouter() == null) {
            log.fine("Router hasn't completed initialization, ignoring received search message");
            return;
        }
        if (!((IncomingSearchRequest)this.getInputMessage()).isMANSSDPDiscover()) {
            log.fine("Invalid search request, no or invalid MAN ssdp:discover header: " + this.getInputMessage());
            return;
        }
        UpnpHeader searchTarget = ((IncomingSearchRequest)this.getInputMessage()).getSearchTarget();
        if (searchTarget == null) {
            log.fine("Invalid search request, did not contain ST header: " + this.getInputMessage());
            return;
        }
        List<NetworkAddress> activeStreamServers = this.getUpnpService().getRouter().getActiveStreamServers(((IncomingSearchRequest)this.getInputMessage()).getLocalAddress());
        if (activeStreamServers.size() == 0) {
            log.fine("Aborting search response, no active stream servers found (network disabled?)");
            return;
        }
        for (NetworkAddress activeStreamServer : activeStreamServers) {
            this.sendResponses(searchTarget, activeStreamServer);
        }
    }

    @Override
    protected boolean waitBeforeExecution() throws InterruptedException {
        Integer mx = ((IncomingSearchRequest)this.getInputMessage()).getMX();
        if (mx == null) {
            log.fine("Invalid search request, did not contain MX header: " + this.getInputMessage());
            return false;
        }
        if (mx > 120 || mx <= 0) {
            mx = MXHeader.DEFAULT_VALUE;
        }
        if (this.getUpnpService().getRegistry().getLocalDevices().size() > 0) {
            int sleepTime = this.randomGenerator.nextInt(mx * 1000);
            log.fine("Sleeping " + sleepTime + " milliseconds to avoid flooding with search responses");
            Thread.sleep(sleepTime);
        }
        return true;
    }

    protected void sendResponses(UpnpHeader searchTarget, NetworkAddress activeStreamServer) throws RouterException {
        if (searchTarget instanceof STAllHeader) {
            this.sendSearchResponseAll(activeStreamServer);
        } else if (searchTarget instanceof RootDeviceHeader) {
            this.sendSearchResponseRootDevices(activeStreamServer);
        } else if (searchTarget instanceof UDNHeader) {
            this.sendSearchResponseUDN((UDN)searchTarget.getValue(), activeStreamServer);
        } else if (searchTarget instanceof DeviceTypeHeader) {
            this.sendSearchResponseDeviceType((DeviceType)searchTarget.getValue(), activeStreamServer);
        } else if (searchTarget instanceof ServiceTypeHeader) {
            this.sendSearchResponseServiceType((ServiceType)searchTarget.getValue(), activeStreamServer);
        } else {
            log.warning("Non-implemented search request target: " + searchTarget.getClass());
        }
    }

    protected void sendSearchResponseAll(NetworkAddress activeStreamServer) throws RouterException {
        if (LOG_ENABLED) {
            log.fine("Responding to 'all' search with advertisement messages for all local devices");
        }
        for (LocalDevice localDevice : this.getUpnpService().getRegistry().getLocalDevices()) {
            List<OutgoingSearchResponse> serviceTypeMsgs;
            if (this.isAdvertisementDisabled(localDevice)) continue;
            if (LOG_ENABLED) {
                log.finer("Sending root device messages: " + localDevice);
            }
            List<OutgoingSearchResponse> rootDeviceMsgs = this.createDeviceMessages(localDevice, activeStreamServer);
            for (OutgoingSearchResponse upnpMessage : rootDeviceMsgs) {
                this.getUpnpService().getRouter().send(upnpMessage);
            }
            if (localDevice.hasEmbeddedDevices()) {
                for (LocalDevice embeddedDevice : (LocalDevice[])localDevice.findEmbeddedDevices()) {
                    if (LOG_ENABLED) {
                        log.finer("Sending embedded device messages: " + embeddedDevice);
                    }
                    List<OutgoingSearchResponse> embeddedDeviceMsgs = this.createDeviceMessages(embeddedDevice, activeStreamServer);
                    for (OutgoingSearchResponse upnpMessage : embeddedDeviceMsgs) {
                        this.getUpnpService().getRouter().send(upnpMessage);
                    }
                }
            }
            if ((serviceTypeMsgs = this.createServiceTypeMessages(localDevice, activeStreamServer)).size() <= 0) continue;
            if (LOG_ENABLED) {
                log.finer("Sending service type messages");
            }
            for (OutgoingSearchResponse upnpMessage : serviceTypeMsgs) {
                this.getUpnpService().getRouter().send(upnpMessage);
            }
        }
    }

    protected List<OutgoingSearchResponse> createDeviceMessages(LocalDevice device, NetworkAddress activeStreamServer) {
        ArrayList<OutgoingSearchResponse> msgs = new ArrayList<OutgoingSearchResponse>();
        if (device.isRoot()) {
            msgs.add(new OutgoingSearchResponseRootDevice((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation(activeStreamServer, device), device));
        }
        msgs.add(new OutgoingSearchResponseUDN((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation(activeStreamServer, device), device));
        msgs.add(new OutgoingSearchResponseDeviceType((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation(activeStreamServer, device), device));
        for (OutgoingSearchResponse msg : msgs) {
            this.prepareOutgoingSearchResponse(msg);
        }
        return msgs;
    }

    protected List<OutgoingSearchResponse> createServiceTypeMessages(LocalDevice device, NetworkAddress activeStreamServer) {
        ArrayList<OutgoingSearchResponse> msgs = new ArrayList<OutgoingSearchResponse>();
        for (ServiceType serviceType : device.findServiceTypes()) {
            OutgoingSearchResponseServiceType message = new OutgoingSearchResponseServiceType((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation(activeStreamServer, device), device, serviceType);
            this.prepareOutgoingSearchResponse(message);
            msgs.add(message);
        }
        return msgs;
    }

    protected void sendSearchResponseRootDevices(NetworkAddress activeStreamServer) throws RouterException {
        log.fine("Responding to root device search with advertisement messages for all local root devices");
        for (LocalDevice device : this.getUpnpService().getRegistry().getLocalDevices()) {
            if (this.isAdvertisementDisabled(device)) continue;
            OutgoingSearchResponseRootDevice message = new OutgoingSearchResponseRootDevice((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation(activeStreamServer, device), device);
            this.prepareOutgoingSearchResponse(message);
            this.getUpnpService().getRouter().send(message);
        }
    }

    protected void sendSearchResponseUDN(UDN udn, NetworkAddress activeStreamServer) throws RouterException {
        Device device = this.getUpnpService().getRegistry().getDevice(udn, false);
        if (device != null && device instanceof LocalDevice) {
            if (this.isAdvertisementDisabled((LocalDevice)device)) {
                return;
            }
            log.fine("Responding to UDN device search: " + udn);
            OutgoingSearchResponseUDN message = new OutgoingSearchResponseUDN((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation(activeStreamServer, (LocalDevice)device), (LocalDevice)device);
            this.prepareOutgoingSearchResponse(message);
            this.getUpnpService().getRouter().send(message);
        }
    }

    protected void sendSearchResponseDeviceType(DeviceType deviceType, NetworkAddress activeStreamServer) throws RouterException {
        log.fine("Responding to device type search: " + deviceType);
        Collection<Device> devices = this.getUpnpService().getRegistry().getDevices(deviceType);
        for (Device device : devices) {
            if (!(device instanceof LocalDevice) || this.isAdvertisementDisabled((LocalDevice)device)) continue;
            log.finer("Sending matching device type search result for: " + device);
            OutgoingSearchResponseDeviceType message = new OutgoingSearchResponseDeviceType((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation(activeStreamServer, (LocalDevice)device), (LocalDevice)device);
            this.prepareOutgoingSearchResponse(message);
            this.getUpnpService().getRouter().send(message);
        }
    }

    protected void sendSearchResponseServiceType(ServiceType serviceType, NetworkAddress activeStreamServer) throws RouterException {
        log.fine("Responding to service type search: " + serviceType);
        Collection<Device> devices = this.getUpnpService().getRegistry().getDevices(serviceType);
        for (Device device : devices) {
            if (!(device instanceof LocalDevice) || this.isAdvertisementDisabled((LocalDevice)device)) continue;
            log.finer("Sending matching service type search result: " + device);
            OutgoingSearchResponseServiceType message = new OutgoingSearchResponseServiceType((IncomingDatagramMessage)this.getInputMessage(), this.getDescriptorLocation(activeStreamServer, (LocalDevice)device), (LocalDevice)device, serviceType);
            this.prepareOutgoingSearchResponse(message);
            this.getUpnpService().getRouter().send(message);
        }
    }

    protected Location getDescriptorLocation(NetworkAddress activeStreamServer, LocalDevice device) {
        return new Location(activeStreamServer, this.getUpnpService().getConfiguration().getNamespace().getDescriptorPathString(device));
    }

    protected boolean isAdvertisementDisabled(LocalDevice device) {
        DiscoveryOptions options = this.getUpnpService().getRegistry().getDiscoveryOptions(((DeviceIdentity)device.getIdentity()).getUdn());
        return options != null && !options.isAdvertised();
    }

    protected void prepareOutgoingSearchResponse(OutgoingSearchResponse message) {
    }
}

