/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.protocol.sync;

import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fourthline.cling.UpnpService;
import org.fourthline.cling.binding.xml.DescriptorBindingException;
import org.fourthline.cling.binding.xml.DeviceDescriptorBinder;
import org.fourthline.cling.binding.xml.ServiceDescriptorBinder;
import org.fourthline.cling.model.message.StreamRequestMessage;
import org.fourthline.cling.model.message.StreamResponseMessage;
import org.fourthline.cling.model.message.UpnpRequest;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.model.message.header.ContentTypeHeader;
import org.fourthline.cling.model.message.header.ServerHeader;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.model.meta.Icon;
import org.fourthline.cling.model.meta.LocalDevice;
import org.fourthline.cling.model.meta.LocalService;
import org.fourthline.cling.model.resource.DeviceDescriptorResource;
import org.fourthline.cling.model.resource.IconResource;
import org.fourthline.cling.model.resource.Resource;
import org.fourthline.cling.model.resource.ServiceDescriptorResource;
import org.fourthline.cling.protocol.ReceivingSync;
import org.fourthline.cling.transport.RouterException;
import org.seamless.util.Exceptions;

public class ReceivingRetrieval
extends ReceivingSync<StreamRequestMessage, StreamResponseMessage> {
    private static final Logger log = Logger.getLogger(ReceivingRetrieval.class.getName());

    public ReceivingRetrieval(UpnpService upnpService, StreamRequestMessage inputMessage) {
        super(upnpService, inputMessage);
    }

    @Override
    protected StreamResponseMessage executeSync() throws RouterException {
        if (!((StreamRequestMessage)this.getInputMessage()).hasHostHeader()) {
            log.fine("Ignoring message, missing HOST header: " + this.getInputMessage());
            return new StreamResponseMessage(new UpnpResponse(UpnpResponse.Status.PRECONDITION_FAILED));
        }
        URI requestedURI = ((UpnpRequest)((StreamRequestMessage)this.getInputMessage()).getOperation()).getURI();
        Resource foundResource = this.getUpnpService().getRegistry().getResource(requestedURI);
        if (foundResource == null && (foundResource = this.onResourceNotFound(requestedURI)) == null) {
            log.fine("No local resource found: " + this.getInputMessage());
            return null;
        }
        return this.createResponse(requestedURI, foundResource);
    }

    protected StreamResponseMessage createResponse(URI requestedURI, Resource resource) {
        StreamResponseMessage response;
        block5: {
            try {
                if (DeviceDescriptorResource.class.isAssignableFrom(resource.getClass())) {
                    log.fine("Found local device matching relative request URI: " + requestedURI);
                    LocalDevice device = (LocalDevice)resource.getModel();
                    DeviceDescriptorBinder deviceDescriptorBinder = this.getUpnpService().getConfiguration().getDeviceDescriptorBinderUDA10();
                    String deviceDescriptor = deviceDescriptorBinder.generate(device, this.getRemoteClientInfo(), this.getUpnpService().getConfiguration().getNamespace());
                    response = new StreamResponseMessage(deviceDescriptor, new ContentTypeHeader(ContentTypeHeader.DEFAULT_CONTENT_TYPE));
                    break block5;
                }
                if (ServiceDescriptorResource.class.isAssignableFrom(resource.getClass())) {
                    log.fine("Found local service matching relative request URI: " + requestedURI);
                    LocalService service = (LocalService)resource.getModel();
                    ServiceDescriptorBinder serviceDescriptorBinder = this.getUpnpService().getConfiguration().getServiceDescriptorBinderUDA10();
                    String serviceDescriptor = serviceDescriptorBinder.generate(service);
                    response = new StreamResponseMessage(serviceDescriptor, new ContentTypeHeader(ContentTypeHeader.DEFAULT_CONTENT_TYPE));
                    break block5;
                }
                if (IconResource.class.isAssignableFrom(resource.getClass())) {
                    log.fine("Found local icon matching relative request URI: " + requestedURI);
                    Icon icon = (Icon)resource.getModel();
                    response = new StreamResponseMessage(icon.getData(), icon.getMimeType());
                    break block5;
                }
                log.fine("Ignoring GET for found local resource: " + resource);
                return null;
            }
            catch (DescriptorBindingException ex) {
                log.warning("Error generating requested device/service descriptor: " + ex.toString());
                log.log(Level.WARNING, "Exception root cause: ", Exceptions.unwrap((Throwable)ex));
                response = new StreamResponseMessage(UpnpResponse.Status.INTERNAL_SERVER_ERROR);
            }
        }
        response.getHeaders().add(UpnpHeader.Type.SERVER, new ServerHeader());
        return response;
    }

    protected Resource onResourceNotFound(URI requestedURIPath) {
        return null;
    }
}

