/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.transport.impl;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fourthline.cling.model.message.Connection;
import org.fourthline.cling.model.message.StreamRequestMessage;
import org.fourthline.cling.model.message.StreamResponseMessage;
import org.fourthline.cling.model.message.UpnpHeaders;
import org.fourthline.cling.model.message.UpnpMessage;
import org.fourthline.cling.model.message.UpnpRequest;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.protocol.ProtocolFactory;
import org.fourthline.cling.transport.spi.UpnpStream;
import org.seamless.util.Exceptions;
import org.seamless.util.io.IO;

public abstract class HttpExchangeUpnpStream
extends UpnpStream {
    private static Logger log = Logger.getLogger(UpnpStream.class.getName());
    private HttpExchange httpExchange;

    public HttpExchangeUpnpStream(ProtocolFactory protocolFactory, HttpExchange httpExchange) {
        super(protocolFactory);
        this.httpExchange = httpExchange;
    }

    public HttpExchange getHttpExchange() {
        return this.httpExchange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            byte[] bodyBytes;
            log.fine("Processing HTTP request: " + this.getHttpExchange().getRequestMethod() + " " + this.getHttpExchange().getRequestURI());
            StreamRequestMessage requestMessage = new StreamRequestMessage(UpnpRequest.Method.getByHttpName(this.getHttpExchange().getRequestMethod()), this.getHttpExchange().getRequestURI());
            if (((UpnpRequest)requestMessage.getOperation()).getMethod().equals((Object)UpnpRequest.Method.UNKNOWN)) {
                log.fine("Method not supported by UPnP stack: " + this.getHttpExchange().getRequestMethod());
                throw new RuntimeException("Method not supported: " + this.getHttpExchange().getRequestMethod());
            }
            ((UpnpRequest)requestMessage.getOperation()).setHttpMinorVersion(this.getHttpExchange().getProtocol().toUpperCase(Locale.ROOT).equals("HTTP/1.1") ? 1 : 0);
            log.fine("Created new request message: " + requestMessage);
            requestMessage.setConnection(this.createConnection());
            requestMessage.setHeaders(new UpnpHeaders(this.getHttpExchange().getRequestHeaders()));
            InputStream is = null;
            try {
                is = this.getHttpExchange().getRequestBody();
                bodyBytes = IO.readBytes((InputStream)is);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
            log.fine("Reading request body bytes: " + bodyBytes.length);
            if (bodyBytes.length > 0 && requestMessage.isContentTypeMissingOrText()) {
                log.fine("Request contains textual entity body, converting then setting string on message");
                requestMessage.setBodyCharacters(bodyBytes);
            } else if (bodyBytes.length > 0) {
                log.fine("Request contains binary entity body, setting bytes on message");
                requestMessage.setBody(UpnpMessage.BodyType.BYTES, bodyBytes);
            } else {
                log.fine("Request did not contain entity body");
            }
            StreamResponseMessage responseMessage = this.process(requestMessage);
            if (responseMessage != null) {
                log.fine("Preparing HTTP response message: " + responseMessage);
                this.getHttpExchange().getResponseHeaders().putAll((Map<? extends String, ? extends List<String>>)((Object)responseMessage.getHeaders()));
                byte[] responseBodyBytes = responseMessage.hasBody() ? responseMessage.getBodyBytes() : null;
                int contentLength = responseBodyBytes != null ? responseBodyBytes.length : -1;
                log.fine("Sending HTTP response message: " + responseMessage + " with content length: " + contentLength);
                this.getHttpExchange().sendResponseHeaders(((UpnpResponse)responseMessage.getOperation()).getStatusCode(), contentLength);
                if (contentLength > 0) {
                    log.fine("Response message has body, writing bytes to stream...");
                    OutputStream os = null;
                    try {
                        os = this.getHttpExchange().getResponseBody();
                        IO.writeBytes((OutputStream)os, (byte[])responseBodyBytes);
                        os.flush();
                    }
                    finally {
                        if (os != null) {
                            os.close();
                        }
                    }
                }
            } else {
                log.fine("Sending HTTP response status: 404");
                this.getHttpExchange().sendResponseHeaders(404, -1L);
            }
            this.responseSent(responseMessage);
        }
        catch (Throwable t) {
            log.fine("Exception occured during UPnP stream processing: " + t);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Cause: " + Exceptions.unwrap((Throwable)t), Exceptions.unwrap((Throwable)t));
            }
            try {
                this.httpExchange.sendResponseHeaders(500, -1L);
            }
            catch (IOException ex) {
                log.warning("Couldn't send error response: " + ex);
            }
            this.responseException(t);
        }
    }

    protected abstract Connection createConnection();
}

