/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.transport.impl.apache;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.util.EntityUtils;
import org.fourthline.cling.model.UnsupportedDataException;
import org.fourthline.cling.model.message.Connection;
import org.fourthline.cling.model.message.StreamRequestMessage;
import org.fourthline.cling.model.message.StreamResponseMessage;
import org.fourthline.cling.model.message.UpnpHeaders;
import org.fourthline.cling.model.message.UpnpMessage;
import org.fourthline.cling.model.message.UpnpOperation;
import org.fourthline.cling.model.message.UpnpRequest;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.protocol.ProtocolFactory;
import org.fourthline.cling.transport.impl.apache.HeaderUtil;
import org.fourthline.cling.transport.spi.UpnpStream;
import org.seamless.util.Exceptions;

public abstract class HttpServerConnectionUpnpStream
extends UpnpStream {
    private static final Logger log = Logger.getLogger(UpnpStream.class.getName());
    protected final HttpServerConnection connection;
    protected final BasicHttpProcessor httpProcessor = new BasicHttpProcessor();
    protected final HttpService httpService;
    protected final HttpParams params;

    protected HttpServerConnectionUpnpStream(ProtocolFactory protocolFactory, HttpServerConnection connection, HttpParams params) {
        super(protocolFactory);
        this.connection = connection;
        this.params = params;
        this.httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        this.httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        this.httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        this.httpService = new UpnpHttpService((HttpProcessor)this.httpProcessor, (ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(), (HttpResponseFactory)new DefaultHttpResponseFactory());
        this.httpService.setParams(params);
    }

    public HttpServerConnection getConnection() {
        return this.connection;
    }

    @Override
    public void run() {
        try {
            while (!Thread.interrupted() && this.connection.isOpen()) {
                log.fine("Handling request on open connection...");
                BasicHttpContext context = new BasicHttpContext(null);
                this.httpService.handleRequest(this.connection, (HttpContext)context);
            }
        }
        catch (ConnectionClosedException ex) {
            log.fine("Client closed connection");
            this.responseException(ex);
        }
        catch (SocketTimeoutException ex) {
            log.fine("Server-side closed socket (this is 'normal' behavior of Apache HTTP Core!): " + ex.getMessage());
        }
        catch (IOException ex) {
            log.warning("I/O exception during HTTP request processing: " + ex.getMessage());
            this.responseException(ex);
        }
        catch (HttpException ex) {
            throw new UnsupportedDataException("Request malformed: " + ex.getMessage(), ex);
        }
        finally {
            try {
                this.connection.shutdown();
            }
            catch (IOException ex) {
                log.fine("Error closing connection: " + ex.getMessage());
            }
        }
    }

    protected abstract Connection createConnection();

    protected class UpnpHttpService
    extends HttpService {
        public UpnpHttpService(HttpProcessor processor, ConnectionReuseStrategy reuse, HttpResponseFactory responseFactory) {
            super(processor, reuse, responseFactory);
        }

        protected void doService(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext ctx) throws HttpException, IOException {
            StreamResponseMessage responseMsg;
            StreamRequestMessage requestMessage;
            log.fine("Processing HTTP request: " + httpRequest.getRequestLine().toString());
            String requestMethod = httpRequest.getRequestLine().getMethod();
            String requestURI = httpRequest.getRequestLine().getUri();
            try {
                requestMessage = new StreamRequestMessage(UpnpRequest.Method.getByHttpName(requestMethod), URI.create(requestURI));
            }
            catch (IllegalArgumentException e) {
                String msg = "Invalid request URI: " + requestURI + ": " + e.getMessage();
                log.warning(msg);
                throw new HttpException(msg, (Throwable)e);
            }
            if (((UpnpRequest)requestMessage.getOperation()).getMethod().equals((Object)UpnpRequest.Method.UNKNOWN)) {
                log.fine("Method not supported by UPnP stack: " + requestMethod);
                throw new MethodNotSupportedException("Method not supported: " + requestMethod);
            }
            log.fine("Created new request message: " + requestMessage);
            int requestHttpMinorVersion = httpRequest.getProtocolVersion().getMinor();
            ((UpnpRequest)requestMessage.getOperation()).setHttpMinorVersion(requestHttpMinorVersion);
            requestMessage.setConnection(HttpServerConnectionUpnpStream.this.createConnection());
            requestMessage.setHeaders(new UpnpHeaders((Map<String, List<String>>)HeaderUtil.get((HttpMessage)httpRequest)));
            if (httpRequest instanceof HttpEntityEnclosingRequest) {
                log.fine("Request contains entity body, setting on UPnP message");
                HttpEntityEnclosingRequest entityEnclosingHttpRequest = (HttpEntityEnclosingRequest)httpRequest;
                HttpEntity entity = entityEnclosingHttpRequest.getEntity();
                byte[] data = EntityUtils.toByteArray((HttpEntity)entity);
                if (data != null) {
                    if (requestMessage.isContentTypeMissingOrText()) {
                        log.fine("HTTP request message contains text entity");
                        requestMessage.setBodyCharacters(data);
                    } else {
                        log.fine("HTTP request message contains binary entity");
                        requestMessage.setBody(UpnpMessage.BodyType.BYTES, data);
                    }
                } else {
                    log.fine("HTTP request message has no entity");
                }
            } else {
                log.fine("Request did not contain entity body");
            }
            try {
                responseMsg = HttpServerConnectionUpnpStream.this.process(requestMessage);
            }
            catch (RuntimeException ex) {
                log.fine("Exception occurred during UPnP stream processing: " + ex);
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "Cause: " + Exceptions.unwrap((Throwable)ex), Exceptions.unwrap((Throwable)ex));
                }
                log.fine("Sending HTTP response: 500");
                httpResponse.setStatusCode(500);
                HttpServerConnectionUpnpStream.this.responseException(ex);
                return;
            }
            if (responseMsg != null) {
                log.fine("Sending HTTP response message: " + responseMsg);
                httpResponse.setStatusLine((StatusLine)new BasicStatusLine(new ProtocolVersion("HTTP", 1, ((UpnpResponse)responseMsg.getOperation()).getHttpMinorVersion()), ((UpnpResponse)responseMsg.getOperation()).getStatusCode(), ((UpnpResponse)responseMsg.getOperation()).getStatusMessage()));
                log.fine("Response status line: " + httpResponse.getStatusLine());
                httpResponse.setParams(this.getResponseParams((UpnpOperation)requestMessage.getOperation()));
                HeaderUtil.add((HttpMessage)httpResponse, responseMsg.getHeaders());
                if (responseMsg.hasBody() && responseMsg.getBodyType().equals((Object)UpnpMessage.BodyType.BYTES)) {
                    httpResponse.setEntity((HttpEntity)new ByteArrayEntity(responseMsg.getBodyBytes()));
                } else if (responseMsg.hasBody() && responseMsg.getBodyType().equals((Object)UpnpMessage.BodyType.STRING)) {
                    StringEntity responseEntity = new StringEntity(responseMsg.getBodyString(), "UTF-8");
                    httpResponse.setEntity((HttpEntity)responseEntity);
                }
            } else {
                log.fine("Sending HTTP response: 404");
                httpResponse.setStatusCode(404);
            }
            HttpServerConnectionUpnpStream.this.responseSent(responseMsg);
        }

        protected HttpParams getResponseParams(UpnpOperation operation) {
            BasicHttpParams localParams = new BasicHttpParams();
            return new DefaultedHttpParams((HttpParams)localParams, HttpServerConnectionUpnpStream.this.params);
        }
    }
}

