/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.eventscripter;

import java.io.File;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import jd.SecondLevelLaunch;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.DownloadLinkCandidateResult;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.DownloadWatchDogProperty;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.downloadcontroller.event.DownloadWatchdogListener;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkCollectorCrawler;
import jd.controlling.linkcollector.LinkCollectorEvent;
import jd.controlling.linkcollector.LinkCollectorListener;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import jd.controlling.reconnect.Reconnecter;
import jd.controlling.reconnect.ReconnecterEvent;
import jd.controlling.reconnect.ReconnecterListener;
import jd.plugins.AddonPanel;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import org.appwork.remoteapi.events.EventObject;
import org.appwork.remoteapi.events.Subscriber;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.Application;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.Dialog;
import org.jdownloader.api.RemoteAPIController;
import org.jdownloader.captcha.event.ChallengeResponseListener;
import org.jdownloader.captcha.v2.AbstractResponse;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.ChallengeResponseController;
import org.jdownloader.captcha.v2.ChallengeSolver;
import org.jdownloader.captcha.v2.solverjob.ResponseList;
import org.jdownloader.captcha.v2.solverjob.SolverJob;
import org.jdownloader.controlling.FileCreationListener;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.controlling.contextmenu.ContextMenuManager;
import org.jdownloader.controlling.contextmenu.MenuContainerRoot;
import org.jdownloader.controlling.contextmenu.MenuExtenderHandler;
import org.jdownloader.controlling.contextmenu.MenuItemData;
import org.jdownloader.controlling.packagizer.PackagizerController;
import org.jdownloader.controlling.packagizer.PackagizerControllerListener;
import org.jdownloader.extensions.AbstractExtension;
import org.jdownloader.extensions.ExtensionConfigPanel;
import org.jdownloader.extensions.StartException;
import org.jdownloader.extensions.StopException;
import org.jdownloader.extensions.eventscripter.CFG_EVENT_CALLER;
import org.jdownloader.extensions.eventscripter.EventScripterConfig;
import org.jdownloader.extensions.eventscripter.EventScripterConfigPanel;
import org.jdownloader.extensions.eventscripter.EventScripterTranslation;
import org.jdownloader.extensions.eventscripter.EventTrigger;
import org.jdownloader.extensions.eventscripter.GenericEventScriptTriggerContextMenuAction;
import org.jdownloader.extensions.eventscripter.GenericEventScriptTriggerMainmenuAction;
import org.jdownloader.extensions.eventscripter.GenericEventScriptTriggerToolbarAction;
import org.jdownloader.extensions.eventscripter.IntervalController;
import org.jdownloader.extensions.eventscripter.ScriptEntry;
import org.jdownloader.extensions.eventscripter.ScriptThread;
import org.jdownloader.extensions.eventscripter.sandboxobjects.ArchiveSandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.CrawledLinkSandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.CrawlerJobSandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.DownloadLinkSandBox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.DownloadlistSelectionSandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.EventSandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.FilePackageSandBox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.HTTPProxySandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.LinkgrabberSelectionSandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.PackagizerLinkSandbox;
import org.jdownloader.extensions.extraction.ExtractionController;
import org.jdownloader.extensions.extraction.ExtractionEvent;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.ExtractionListener;
import org.jdownloader.gui.jdtrayicon.MenuManagerTrayIcon;
import org.jdownloader.gui.mainmenu.MenuManagerMainmenu;
import org.jdownloader.gui.mainmenu.container.OptionalContainer;
import org.jdownloader.gui.toolbar.MenuManagerMainToolbar;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.downloads.MenuManagerDownloadTabBottomBar;
import org.jdownloader.gui.views.downloads.contextmenumanager.MenuManagerDownloadTableContext;
import org.jdownloader.gui.views.linkgrabber.bottombar.MenuManagerLinkgrabberTabBottombar;
import org.jdownloader.gui.views.linkgrabber.contextmenu.MenuManagerLinkgrabberTableContext;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.tools.shell.Global;

public class EventScripterExtension
extends AbstractExtension<EventScripterConfig, EventScripterTranslation>
implements MenuExtenderHandler,
DownloadWatchdogListener,
GenericConfigEventListener<Object>,
FileCreationListener,
LinkCollectorListener,
PackagizerControllerListener,
ExtractionListener,
ReconnecterListener,
ChallengeResponseListener {
    private EventScripterConfigPanel configPanel = null;
    private volatile List<ScriptEntry> entries = new ArrayList<ScriptEntry>();
    private final AtomicReference<Subscriber> subscriber = new AtomicReference<Object>(null);
    private IntervalController intervalController;

    public boolean isHeadlessRunnable() {
        return true;
    }

    public boolean hasConfigPanel() {
        return true;
    }

    public EventScripterExtension() throws StartException {
        this.setTitle(((EventScripterTranslation)this.T).title());
    }

    public String getIconKey() {
        return "event";
    }

    protected void stop() throws StopException {
        ChallengeResponseController.getInstance().getEventSender().removeListener((EventListener)((Object)this));
        Reconnecter.getInstance().getEventSender().removeListener((EventListener)((Object)this));
        PackagizerController.getInstance().getEventSender().removeListener((EventListener)((Object)this));
        DownloadWatchDog.getInstance().getEventSender().removeListener((EventListener)((Object)this));
        CFG_EVENT_CALLER.SCRIPTS.getEventSender().removeListener((EventListener)((Object)this));
        FileCreationManager.getInstance().getEventSender().removeListener((EventListener)((Object)this));
        LinkCollector.getInstance().getEventsender().removeListener((EventListener)((Object)this));
        Subscriber old = this.subscriber.getAndSet(null);
        if (old != null) {
            RemoteAPIController.getInstance().getEventsapi().removeSubscriber(old);
        }
        if (!Application.isHeadless()) {
            MenuManagerTrayIcon.getInstance().unregisterExtender((MenuExtenderHandler)this);
            MenuManagerMainToolbar.getInstance().unregisterExtender((MenuExtenderHandler)this);
            MenuManagerMainmenu.getInstance().unregisterExtender((MenuExtenderHandler)this);
            MenuManagerDownloadTabBottomBar.getInstance().unregisterExtender((MenuExtenderHandler)this);
            MenuManagerDownloadTableContext.getInstance().unregisterExtender((MenuExtenderHandler)this);
            MenuManagerLinkgrabberTabBottombar.getInstance().unregisterExtender((MenuExtenderHandler)this);
            MenuManagerLinkgrabberTableContext.getInstance().unregisterExtender((MenuExtenderHandler)this);
        }
        SecondLevelLaunch.EXTENSIONS_LOADED.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                ExtractionExtension instance = ExtractionExtension.getInstance();
                if (instance != null) {
                    instance.getEventSender().removeListener((EventListener)((Object)EventScripterExtension.this));
                }
            }
        });
    }

    protected void start() throws StartException {
        ChallengeResponseController.getInstance().getEventSender().addListener((EventListener)((Object)this));
        Reconnecter.getInstance().getEventSender().addListener((EventListener)((Object)this));
        PackagizerController.getInstance().getEventSender().addListener((EventListener)((Object)this));
        LinkCollector.getInstance().getEventsender().addListener((EventListener)((Object)this));
        FileCreationManager.getInstance().getEventSender().addListener((EventListener)((Object)this));
        DownloadWatchDog.getInstance().getEventSender().addListener((EventListener)((Object)this));
        if (!Application.isHeadless()) {
            MenuManagerMainToolbar.getInstance().registerExtender((MenuExtenderHandler)this);
            MenuManagerMainmenu.getInstance().registerExtender((MenuExtenderHandler)this);
            MenuManagerDownloadTabBottomBar.getInstance().registerExtender((MenuExtenderHandler)this);
            MenuManagerDownloadTableContext.getInstance().registerExtender((MenuExtenderHandler)this);
            MenuManagerLinkgrabberTabBottombar.getInstance().registerExtender((MenuExtenderHandler)this);
            MenuManagerLinkgrabberTableContext.getInstance().registerExtender((MenuExtenderHandler)this);
            MenuManagerTrayIcon.getInstance().registerExtender((MenuExtenderHandler)this);
        }
        SecondLevelLaunch.EXTENSIONS_LOADED.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                ExtractionExtension instance = ExtractionExtension.getInstance();
                if (instance != null) {
                    instance.getEventSender().addListener((EventListener)((Object)EventScripterExtension.this));
                }
            }
        });
        CFG_EVENT_CALLER.SCRIPTS.getEventSender().addListener((EventListener)((Object)this));
        ArrayList<ScriptEntry> loadedEntries = ((EventScripterConfig)this.getSettings()).getScripts();
        this.entries = loadedEntries == null ? new ArrayList<ScriptEntry>() : new ArrayList<ScriptEntry>(loadedEntries);
        if (!Application.isHeadless()) {
            this.configPanel = (EventScripterConfigPanel)((Object)new EDTHelper<EventScripterConfigPanel>(){

                public EventScripterConfigPanel edtRun() {
                    return new EventScripterConfigPanel(EventScripterExtension.this);
                }
            }.getReturnValue());
        }
        this.intervalController = new IntervalController(this);
        SecondLevelLaunch.INIT_COMPLETE.executeWhenReached(new Runnable(){

            @Override
            public void run() {
                new Thread(){

                    @Override
                    public void run() {
                        EventScripterExtension.this.setupRemoteAPIListener(EventScripterExtension.this.entries);
                        for (ScriptEntry script : EventScripterExtension.this.entries) {
                            if (!script.isEnabled() || !EventTrigger.ON_JDOWNLOADER_STARTED.equals((Object)script.getEventTrigger()) || !StringUtils.isNotEmpty((String)script.getScript())) continue;
                            try {
                                HashMap<String, Object> props = new HashMap<String, Object>();
                                EventScripterExtension.this.runScript(script, props);
                            }
                            catch (Throwable e) {
                                EventScripterExtension.this.getLogger().log(e);
                            }
                        }
                    }
                }.start();
            }
        });
    }

    private void setupRemoteAPIListener(List<ScriptEntry> scriptEntries) {
        Subscriber old;
        if (scriptEntries != null) {
            for (ScriptEntry script : this.entries) {
                if (!script.isEnabled() || !StringUtils.isNotEmpty((String)script.getScript()) || EventTrigger.ON_OUTGOING_REMOTE_API_EVENT != script.getEventTrigger()) continue;
                Subscriber subscriber = new Subscriber(new Pattern[]{Pattern.compile(".*")}, new Pattern[0]){

                    public boolean isAlive() {
                        return super.isAlive() && EventScripterExtension.this.subscriber.get() == this;
                    }

                    public boolean isExpired() {
                        return false;
                    }

                    protected void push(EventObject event) {
                        EventSandbox eventSandbox = null;
                        for (ScriptEntry script : EventScripterExtension.this.entries) {
                            if (!script.isEnabled() || !StringUtils.isNotEmpty((String)script.getScript()) || EventTrigger.ON_OUTGOING_REMOTE_API_EVENT != script.getEventTrigger()) continue;
                            try {
                                HashMap<String, Object> props = new HashMap<String, Object>();
                                if (eventSandbox == null) {
                                    eventSandbox = new EventSandbox(event);
                                }
                                props.put("event", eventSandbox);
                                EventScripterExtension.this.runScript(script, props);
                            }
                            catch (Throwable e) {
                                EventScripterExtension.this.getLogger().log(e);
                            }
                        }
                    }

                    public void push(List<EventObject> events) {
                        if (events != null) {
                            for (EventObject event : events) {
                                this.push(event);
                            }
                        }
                    }
                };
                Subscriber old2 = this.subscriber.getAndSet(subscriber);
                if (old2 != null) {
                    RemoteAPIController.getInstance().getEventsapi().removeSubscriber(old2);
                }
                RemoteAPIController.getInstance().getEventsapi().addSubscriber(subscriber);
                return;
            }
        }
        if ((old = (Subscriber)this.subscriber.getAndSet(null)) != null) {
            RemoteAPIController.getInstance().getEventsapi().removeSubscriber(old);
        }
    }

    public List<ScriptEntry> getEntries() {
        return this.entries;
    }

    public String getDescription() {
        return ((EventScripterTranslation)this.T).description();
    }

    public AddonPanel<EventScripterExtension> getGUI() {
        return null;
    }

    protected void initExtension() throws StartException {
    }

    public boolean isQuickToggleEnabled() {
        return true;
    }

    public MenuItemData updateMenuModel(ContextMenuManager manager, MenuContainerRoot mr) {
        if (manager instanceof MenuManagerMainmenu) {
            OptionalContainer opt = new OptionalContainer(false);
            opt.add(GenericEventScriptTriggerMainmenuAction.class);
            return opt;
        }
        if (manager instanceof MenuManagerDownloadTabBottomBar) {
            OptionalContainer opt = new OptionalContainer(false);
            opt.add(GenericEventScriptTriggerMainmenuAction.class);
            return opt;
        }
        if (manager instanceof MenuManagerDownloadTableContext) {
            OptionalContainer opt = new OptionalContainer(false);
            opt.add(GenericEventScriptTriggerContextMenuAction.class);
            return opt;
        }
        if (manager instanceof MenuManagerLinkgrabberTableContext) {
            OptionalContainer opt = new OptionalContainer(false);
            opt.add(GenericEventScriptTriggerContextMenuAction.class);
            return opt;
        }
        if (manager instanceof MenuManagerLinkgrabberTabBottombar) {
            OptionalContainer opt = new OptionalContainer(false);
            opt.add(GenericEventScriptTriggerMainmenuAction.class);
            return opt;
        }
        if (manager instanceof MenuManagerTrayIcon) {
            OptionalContainer opt = new OptionalContainer(false);
            opt.add(GenericEventScriptTriggerMainmenuAction.class);
            return opt;
        }
        if (manager instanceof MenuManagerMainToolbar) {
            OptionalContainer opt = new OptionalContainer(false);
            opt.add(GenericEventScriptTriggerToolbarAction.class);
            return opt;
        }
        return null;
    }

    public ExtensionConfigPanel<?> getConfigPanel() {
        return this.configPanel;
    }

    public void onDownloadWatchdogDataUpdate() {
    }

    public void onDownloadWatchdogStateIsIdle() {
    }

    public void onDownloadWatchdogStateIsPause() {
        for (ScriptEntry script : this.entries) {
            if (!script.isEnabled() || !EventTrigger.ON_DOWNLOADS_PAUSE.equals((Object)script.getEventTrigger()) || !StringUtils.isNotEmpty((String)script.getScript())) continue;
            try {
                HashMap<String, Object> props = new HashMap<String, Object>();
                this.runScript(script, props);
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
    }

    public void onDownloadWatchdogStateIsRunning() {
        for (ScriptEntry script : this.entries) {
            if (!script.isEnabled() || !EventTrigger.ON_DOWNLOADS_RUNNING.equals((Object)script.getEventTrigger()) || !StringUtils.isNotEmpty((String)script.getScript())) continue;
            try {
                HashMap<String, Object> props = new HashMap<String, Object>();
                this.runScript(script, props);
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
    }

    public void onDownloadWatchdogStateIsStopped() {
        for (ScriptEntry script : this.entries) {
            if (!script.isEnabled() || !EventTrigger.ON_DOWNLOADS_STOPPED.equals((Object)script.getEventTrigger()) || !StringUtils.isNotEmpty((String)script.getScript())) continue;
            try {
                HashMap<String, Object> props = new HashMap<String, Object>();
                this.runScript(script, props);
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
    }

    public void onDownloadWatchdogStateIsStopping() {
    }

    public void onDownloadControllerStart(SingleDownloadController downloadController, DownloadLinkCandidate candidate) {
        DownloadLinkSandBox downloadLinkSandBox = null;
        FilePackageSandBox filePackageSandBox = null;
        HTTPProxySandbox proxySandbox = null;
        for (ScriptEntry script : this.entries) {
            if (!script.isEnabled() || !EventTrigger.ON_DOWNLOAD_CONTROLLER_START.equals((Object)script.getEventTrigger()) || !StringUtils.isNotEmpty((String)script.getScript())) continue;
            try {
                HashMap<String, Object> props = new HashMap<String, Object>();
                if (filePackageSandBox == null) {
                    filePackageSandBox = new FilePackageSandBox(downloadController.getDownloadLink().getParentNode());
                }
                if (downloadLinkSandBox == null) {
                    downloadLinkSandBox = new DownloadLinkSandBox(downloadController.getDownloadLink());
                }
                if (proxySandbox == null) {
                    proxySandbox = new HTTPProxySandbox(downloadController.getProxySelector());
                }
                props.put("link", downloadLinkSandBox);
                props.put("package", filePackageSandBox);
                props.put("proxy", proxySandbox);
                this.runScript(script, props);
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
    }

    public void runScript(ScriptEntry script, Map<String, Object> props) {
        this.runScript(script, props, false);
    }

    public void runScript(ScriptEntry script, Map<String, Object> props, final boolean testRun) {
        final boolean isSynchronous = script.getEventTrigger().isSynchronous(script.getEventTriggerSettings());
        new ScriptThread(this, script, props, this.getLogger()){

            @Override
            protected boolean isTestRun() {
                return testRun;
            }

            @Override
            public boolean isSynchronous() {
                return isSynchronous;
            }
        }.start();
    }

    public void onDownloadControllerStopped(SingleDownloadController downloadController, DownloadLinkCandidate candidate, DownloadLinkCandidateResult result) {
        DownloadLinkSandBox downloadLinkSandBox = null;
        HTTPProxySandbox proxySandbox = null;
        DownloadLink dlLink = downloadController.getDownloadLink();
        FilePackage fp = dlLink.getParentNode();
        FilePackageSandBox filePackageSandBox = new FilePackageSandBox(fp);
        for (ScriptEntry script : this.entries) {
            HashMap<String, Object> props;
            if (!script.isEnabled() || !EventTrigger.ON_DOWNLOAD_CONTROLLER_STOPPED.equals((Object)script.getEventTrigger()) && !EventTrigger.ON_PACKAGE_FINISHED.equals((Object)script.getEventTrigger()) || !StringUtils.isNotEmpty((String)script.getScript())) continue;
            if (EventTrigger.ON_DOWNLOAD_CONTROLLER_STOPPED.equals((Object)script.getEventTrigger())) {
                try {
                    props = new HashMap<String, Object>();
                    if (downloadLinkSandBox == null) {
                        downloadLinkSandBox = new DownloadLinkSandBox(dlLink);
                    }
                    if (proxySandbox == null) {
                        proxySandbox = new HTTPProxySandbox(downloadController.getProxySelector());
                    }
                    props.put("link", downloadLinkSandBox);
                    props.put("package", filePackageSandBox);
                    props.put("proxy", proxySandbox);
                    this.runScript(script, props);
                }
                catch (Throwable e) {
                    this.getLogger().log(e);
                }
            }
            if (!EventTrigger.ON_PACKAGE_FINISHED.equals((Object)script.getEventTrigger()) || !filePackageSandBox.isFinished()) continue;
            try {
                props = new HashMap();
                if (downloadLinkSandBox == null) {
                    downloadLinkSandBox = new DownloadLinkSandBox(dlLink);
                }
                props.put("link", downloadLinkSandBox);
                props.put("package", filePackageSandBox);
                this.runScript(script, props);
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
    }

    public void onDownloadWatchDogPropertyChange(DownloadWatchDogProperty propertyChange) {
    }

    public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
    }

    public synchronized void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
        ArrayList<ScriptEntry> entries = ((EventScripterConfig)this.getSettings()).getScripts();
        this.entries = entries == null ? new ArrayList<ScriptEntry>() : new ArrayList<ScriptEntry>(entries);
        this.setupRemoteAPIListener(entries);
        this.intervalController.update();
    }

    public void save(final List<ScriptEntry> tableData) {
        new Thread(){

            @Override
            public void run() {
                ArrayList<ScriptEntry> entries = new ArrayList<ScriptEntry>(tableData);
                EventScripterExtension.this.setupRemoteAPIListener(entries);
                ((EventScripterConfig)EventScripterExtension.this.getSettings()).setScripts(entries);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestCompile(EventTrigger eventTrigger, String script) {
        Context cx = Context.enter();
        cx.setOptimizationLevel(-1);
        cx.setLanguageVersion(150);
        Global scope = new Global();
        scope.init(cx);
        try {
            Script fcn = cx.compileString(script, "", 1, null);
            Dialog.getInstance().showMessageDialog(_GUI.T.lit_successfull());
        }
        catch (Throwable e1) {
            Dialog.getInstance().showExceptionDialog(((EventScripterTranslation)this.T).syntax_error(), e1.getMessage(), e1);
        }
        finally {
            Context.exit();
        }
    }

    public synchronized void addScriptEntry(ScriptEntry newScript) {
        if (newScript != null) {
            ArrayList<ScriptEntry> newEntries = new ArrayList<ScriptEntry>(this.entries);
            newEntries.add(newScript);
            this.save(newEntries);
        }
    }

    public synchronized void removeScriptEntries(List<ScriptEntry> entries2) {
        if (entries2 != null) {
            ArrayList<ScriptEntry> newEntries = new ArrayList<ScriptEntry>(this.entries);
            newEntries.removeAll(entries2);
            this.save(newEntries);
        }
    }

    public void onNewFile(Object caller, File[] fileList) {
        for (ScriptEntry script : this.entries) {
            if (!script.isEnabled() || !EventTrigger.ON_NEW_FILE.equals((Object)script.getEventTrigger()) || !StringUtils.isNotEmpty((String)script.getScript())) continue;
            try {
                HashMap<String, Object> props = new HashMap<String, Object>();
                String[] pathes = new String[fileList.length];
                for (int i = 0; i < fileList.length; ++i) {
                    pathes[i] = fileList[i].getAbsolutePath();
                }
                props.put("files", pathes);
                props.put("caller", caller == null ? null : caller.getClass().getName());
                this.runScript(script, props);
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
    }

    public void onLinkCollectorAbort(LinkCollectorEvent event) {
    }

    public void onLinkCollectorFilteredLinksAvailable(LinkCollectorEvent event) {
    }

    public void onLinkCollectorFilteredLinksEmpty(LinkCollectorEvent event) {
    }

    public void onLinkCollectorDataRefresh(LinkCollectorEvent event) {
    }

    public void onLinkCollectorStructureRefresh(LinkCollectorEvent event) {
    }

    public void onLinkCollectorContentRemoved(LinkCollectorEvent event) {
    }

    public void onLinkCollectorContentAdded(LinkCollectorEvent event) {
    }

    public void onLinkCollectorLinkAdded(LinkCollectorEvent event, CrawledLink link) {
        PackagizerLinkSandbox packagizerLinkSandbox = null;
        CrawledLinkSandbox crawledLinkSandbox = null;
        for (ScriptEntry script : this.entries) {
            if (!script.isEnabled() || !EventTrigger.ON_NEW_LINK.equals((Object)script.getEventTrigger()) || !StringUtils.isNotEmpty((String)script.getScript())) continue;
            try {
                HashMap<String, Object> props = new HashMap<String, Object>();
                if (packagizerLinkSandbox == null) {
                    packagizerLinkSandbox = new PackagizerLinkSandbox(link);
                }
                if (crawledLinkSandbox == null) {
                    crawledLinkSandbox = new CrawledLinkSandbox(link);
                }
                props.put("link", packagizerLinkSandbox);
                props.put("crawledLink", crawledLinkSandbox);
                this.runScript(script, props);
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
    }

    public void onLinkCollectorDupeAdded(LinkCollectorEvent event, CrawledLink link) {
    }

    public void onLinkCrawlerAdded(LinkCollectorCrawler crawler) {
    }

    public void onLinkCrawlerStarted(LinkCollectorCrawler crawler) {
    }

    public void onLinkCrawlerStopped(LinkCollectorCrawler crawler) {
    }

    public void onLinkCrawlerNewJob(LinkCollectingJob job) {
        CrawlerJobSandbox crawlerJobSandbox = null;
        for (ScriptEntry script : this.entries) {
            if (!script.isEnabled() || !EventTrigger.ON_NEW_CRAWLER_JOB.equals((Object)script.getEventTrigger()) || !StringUtils.isNotEmpty((String)script.getScript())) continue;
            try {
                HashMap<String, Object> props = new HashMap<String, Object>();
                if (crawlerJobSandbox == null) {
                    crawlerJobSandbox = new CrawlerJobSandbox(job);
                }
                props.put("job", crawlerJobSandbox);
                this.runScript(script, props);
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
    }

    public void onPackagizerUpdate() {
    }

    public void onPackagizerRunBeforeLinkcheck(CrawledLink link, PackagizerControllerListener.STATE state) {
        PackagizerLinkSandbox packagizerLinkSandbox = null;
        for (ScriptEntry script : this.entries) {
            if (!script.isEnabled() || !EventTrigger.ON_PACKAGIZER.equals((Object)script.getEventTrigger()) || !StringUtils.isNotEmpty((String)script.getScript())) continue;
            try {
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("linkcheckDone", false);
                props.put("state", state.name());
                if (packagizerLinkSandbox == null) {
                    packagizerLinkSandbox = new PackagizerLinkSandbox(link);
                }
                props.put("link", packagizerLinkSandbox);
                this.runScript(script, props);
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
    }

    public void onPackagizerRunAfterLinkcheck(CrawledLink link, PackagizerControllerListener.STATE state) {
        PackagizerLinkSandbox packagizerLinkSandbox = null;
        for (ScriptEntry script : this.entries) {
            if (!script.isEnabled() || !EventTrigger.ON_PACKAGIZER.equals((Object)script.getEventTrigger()) || !StringUtils.isNotEmpty((String)script.getScript())) continue;
            try {
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("linkcheckDone", true);
                props.put("state", state.name());
                if (packagizerLinkSandbox == null) {
                    packagizerLinkSandbox = new PackagizerLinkSandbox(link);
                }
                props.put("link", packagizerLinkSandbox);
                this.runScript(script, props);
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
    }

    public void onExtractionEvent(ExtractionEvent event) {
        HashMap<String, Object> props;
        ArchiveSandbox archiveSandbox = null;
        for (ScriptEntry script : this.entries) {
            if (!script.isEnabled() || !EventTrigger.ON_GENERIC_EXTRACTION.equals((Object)script.getEventTrigger()) || !StringUtils.isNotEmpty((String)script.getScript())) continue;
            try {
                props = new HashMap<String, Object>();
                if (archiveSandbox == null) {
                    archiveSandbox = new ArchiveSandbox(((ExtractionController)event.getCaller()).getArchive());
                }
                props.put("archive", archiveSandbox);
                props.put("event", ((ExtractionEvent.Type)event.getType()).name());
                this.runScript(script, props);
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
        switch ((ExtractionEvent.Type)event.getType()) {
            case FINISHED: {
                for (ScriptEntry script : this.entries) {
                    if (!script.isEnabled() || !EventTrigger.ON_ARCHIVE_EXTRACTED.equals((Object)script.getEventTrigger()) || !StringUtils.isNotEmpty((String)script.getScript())) continue;
                    try {
                        props = new HashMap();
                        if (archiveSandbox == null) {
                            archiveSandbox = new ArchiveSandbox(((ExtractionController)event.getCaller()).getArchive());
                        }
                        props.put("archive", archiveSandbox);
                        props.put("event", ((ExtractionEvent.Type)event.getType()).name());
                        this.runScript(script, props);
                    }
                    catch (Throwable e) {
                        this.getLogger().log(e);
                    }
                }
                break;
            }
        }
    }

    public void refreshScripts() {
        if (this.intervalController != null) {
            this.intervalController.update();
        }
        if (this.configPanel != null) {
            new EDTRunner(){

                protected void runInEDT() {
                    EventScripterExtension.this.configPanel.refresh();
                }
            };
        }
    }

    public void triggerAction(String name, String iconKey, String shortCutString, EventTrigger downloadTableContextMenuButton, SelectionInfo selectionInfo) {
        for (ScriptEntry script : this.entries) {
            if (!script.isEnabled() || downloadTableContextMenuButton != script.getEventTrigger() || !StringUtils.isNotEmpty((String)script.getScript())) continue;
            try {
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("name", name);
                props.put("icon", iconKey);
                props.put("shortCutString", shortCutString);
                props.put("menu", downloadTableContextMenuButton.name());
                if (selectionInfo != null && selectionInfo.getController() == DownloadController.getInstance()) {
                    props.put("dlSelection", new DownloadlistSelectionSandbox((SelectionInfo<FilePackage, DownloadLink>)selectionInfo));
                } else if (selectionInfo != null && selectionInfo.getController() == LinkCollector.getInstance()) {
                    props.put("lgSelection", new LinkgrabberSelectionSandbox((SelectionInfo<CrawledPackage, CrawledLink>)selectionInfo));
                }
                this.runScript(script, props);
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
    }

    public void onAfterReconnect(ReconnecterEvent event) {
        for (ScriptEntry script : this.entries) {
            if (!script.isEnabled() || !EventTrigger.RECONNECT_AFTER.equals((Object)script.getEventTrigger()) || !StringUtils.isNotEmpty((String)script.getScript())) continue;
            try {
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("result", event.getResult() + "");
                props.put("method", event.getPlugin().getClass().getSimpleName());
                this.runScript(script, props);
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
    }

    public void onBeforeReconnect(ReconnecterEvent event) {
        for (ScriptEntry script : this.entries) {
            if (!script.isEnabled() || !EventTrigger.RECONNECT_BEFORE.equals((Object)script.getEventTrigger()) || !StringUtils.isNotEmpty((String)script.getScript())) continue;
            try {
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("method", event.getPlugin().getClass().getSimpleName());
                this.runScript(script, props);
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
    }

    public void onNewJobAnswer(SolverJob<?> job, AbstractResponse<?> response) {
    }

    public void onJobDone(SolverJob<?> job) {
        Challenge captchaChallenge = job.getChallenge();
        DownloadLinkSandBox downloadLinkSandbox = null;
        for (ScriptEntry script : this.entries) {
            if (!script.isEnabled() || !EventTrigger.CAPTCHA_CHALLENGE_AFTER.equals((Object)script.getEventTrigger()) || !StringUtils.isNotEmpty((String)script.getScript())) continue;
            try {
                HashMap<String, Object> props = new HashMap<String, Object>();
                ArrayList<String> solver = new ArrayList<String>();
                for (ChallengeSolver s : job.getSolverList()) {
                    solver.add(s.getService().getID() + "." + s.getClass().getSimpleName());
                }
                props.put("solved", job.isSolved());
                props.put("solver", solver.toArray(new String[0]));
                ResponseList resp = job.getResponse();
                props.put("result", resp == null ? null : resp.getValue());
                props.put("hasPendingJobs", ChallengeResponseController.getInstance().hasPendingJobs());
                props.put("getCaptchaName", captchaChallenge.getTypeID());
                props.put("getCaptchaHost", captchaChallenge.getHost());
                props.put("isAccountCheck", captchaChallenge.isCreatedInsideAccountChecker());
                if (captchaChallenge.getDownloadLink() != null) {
                    if (downloadLinkSandbox == null) {
                        downloadLinkSandbox = new DownloadLinkSandBox(captchaChallenge.getDownloadLink());
                    }
                    props.put("link", downloadLinkSandbox);
                }
                this.runScript(script, props);
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
    }

    public void onNewJob(SolverJob<?> job) {
        Challenge captchaChallenge = job.getChallenge();
        DownloadLinkSandBox downloadLinkSandbox = null;
        for (ScriptEntry script : this.entries) {
            if (!script.isEnabled() || !EventTrigger.CAPTCHA_CHALLENGE_BEFORE.equals((Object)script.getEventTrigger()) || !StringUtils.isNotEmpty((String)script.getScript())) continue;
            try {
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("hasPendingJobs", ChallengeResponseController.getInstance().hasPendingJobs());
                props.put("getCaptchaName", captchaChallenge.getTypeID());
                props.put("getCaptchaHost", captchaChallenge.getHost());
                props.put("isAccountCheck", captchaChallenge.isCreatedInsideAccountChecker());
                if (captchaChallenge.getDownloadLink() != null) {
                    if (downloadLinkSandbox == null) {
                        downloadLinkSandbox = new DownloadLinkSandBox(captchaChallenge.getDownloadLink());
                    }
                    props.put("link", downloadLinkSandbox);
                }
                this.runScript(script, props);
            }
            catch (Throwable e) {
                this.getLogger().log(e);
            }
        }
    }

    public void onJobSolverEnd(ChallengeSolver<?> solver, SolverJob<?> job) {
    }

    public void onJobSolverStart(ChallengeSolver<?> solver, SolverJob<?> job) {
    }

    public void onNewFolder(Object caller, File folder) {
    }

    public void onLinkCrawlerFinished() {
    }
}

