/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.eventscripter;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.swing.MigPanel;
import org.appwork.swing.exttable.ExtColumn;
import org.appwork.swing.exttable.ExtTableHeaderRenderer;
import org.appwork.swing.exttable.ExtTableModel;
import org.appwork.swing.exttable.columns.ExtCheckColumn;
import org.appwork.swing.exttable.columns.ExtComboColumn;
import org.appwork.swing.exttable.columns.ExtComponentColumn;
import org.appwork.swing.exttable.columns.ExtTextColumn;
import org.appwork.uio.CloseReason;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.ProgressDialog;
import org.appwork.utils.swing.renderer.RenderLabel;
import org.appwork.utils.swing.renderer.RendererMigPanel;
import org.jdownloader.extensions.eventscripter.CFG_EVENT_CALLER;
import org.jdownloader.extensions.eventscripter.EventScripterExtension;
import org.jdownloader.extensions.eventscripter.EventTrigger;
import org.jdownloader.extensions.eventscripter.JavaScriptEditorDialog;
import org.jdownloader.extensions.eventscripter.ScriptEntry;
import org.jdownloader.extensions.eventscripter.T;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.images.NewTheme;
import org.jdownloader.settings.staticreferences.CFG_GUI;

public class EventScripterTableModel
extends ExtTableModel<ScriptEntry>
implements GenericConfigEventListener<Object> {
    private EventScripterExtension extension;
    private static final String SORT_ORIGINAL = "ORIGINAL";

    public EventScripterTableModel(EventScripterExtension extension) {
        super("EventCallerTableModel");
        this.extension = extension;
        CFG_EVENT_CALLER.SCRIPTS.getEventSender().addListener((EventListener)((Object)this));
        this.update();
    }

    public void update() {
        new EDTRunner(){

            protected void runInEDT() {
                ArrayList<ScriptEntry> scripts = CFG_EVENT_CALLER.CFG.getScripts();
                if (scripts == null || scripts.size() == 0) {
                    scripts = EventScripterTableModel.this.getDefaultScriptList();
                }
                EventScripterTableModel.this._fireTableStructureChanged(scripts, true);
            }
        };
    }

    protected ArrayList<ScriptEntry> getDefaultScriptList() {
        ArrayList<ScriptEntry> ret = new ArrayList<ScriptEntry>();
        ScriptEntry dfScript = new ScriptEntry();
        dfScript.setName(T.T.example_script_name());
        dfScript.setEventTrigger(EventTrigger.ON_DOWNLOAD_CONTROLLER_STOPPED);
        dfScript.setScript(null);
        dfScript.setEnabled(false);
        ret.add(dfScript);
        return ret;
    }

    protected void initColumns() {
        this.addColumn((ExtColumn)new ExtCheckColumn<ScriptEntry>(_GUI.T.lit_enabled()){
            private static final long serialVersionUID = 1515656228974789237L;

            public ExtTableHeaderRenderer getHeaderRenderer(JTableHeader jTableHeader) {
                ExtTableHeaderRenderer ret = new ExtTableHeaderRenderer((ExtColumn)this, jTableHeader){
                    private final Icon ok;
                    private static final long serialVersionUID = 3224931991570756349L;
                    {
                        this.ok = NewTheme.I().getIcon("ok", 14);
                    }

                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        this.setIcon(this.ok);
                        this.setHorizontalAlignment(0);
                        this.setText(null);
                        return this;
                    }
                };
                return ret;
            }

            public int getMaxWidth() {
                return 30;
            }

            public boolean isHidable() {
                return false;
            }

            public boolean isEditable(ScriptEntry obj) {
                return true;
            }

            protected boolean getBooleanValue(ScriptEntry value) {
                return value.isEnabled();
            }

            protected void setBooleanValue(boolean value, ScriptEntry object) {
                object.setEnabled(value);
                EventScripterTableModel.this.extension.save(EventScripterTableModel.this.getTableData());
            }
        });
        this.addColumn((ExtColumn)new ExtTextColumn<ScriptEntry>(_GUI.T.lit_name()){

            public String getStringValue(ScriptEntry value) {
                return value.getName();
            }

            protected void setStringValue(String value, ScriptEntry object) {
                object.setName(value);
                EventScripterTableModel.this.extension.save(EventScripterTableModel.this.getTableData());
            }

            public boolean isEditable(ScriptEntry obj) {
                return true;
            }
        });
        this.addColumn((ExtColumn)new ExtComboColumn<ScriptEntry, EventTrigger>(T.T.event_trigger(), new DefaultComboBoxModel<EventTrigger>(EventTrigger.values())){

            protected String modelItemToString(EventTrigger selectedItem, ScriptEntry value) {
                return selectedItem.getLabel();
            }

            protected EventTrigger getSelectedItem(ScriptEntry object) {
                return object.getEventTrigger();
            }

            protected void setSelectedItem(ScriptEntry object, EventTrigger value) {
                object.setEventTrigger(value);
                EventScripterTableModel.this.extension.save(EventScripterTableModel.this.getTableData());
            }
        });
        this.addColumn((ExtColumn)new ExtComponentColumn<ScriptEntry>(T.T.edit_script()){
            private JButton editorBtn;
            private JButton rendererBtn;
            private ScriptEntry editing;
            protected MigPanel editor;
            protected RendererMigPanel renderer;
            private RenderLabel label;
            {
                this.editorBtn = new JButton("");
                this.editorBtn.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (editing != null) {
                            String script;
                            ProgressDialog p = new ProgressDialog(new ProgressDialog.ProgressGetter(){

                                public void run() throws Exception {
                                }

                                public String getString() {
                                    return null;
                                }

                                public int getProgress() {
                                    return -1;
                                }

                                public String getLabelString() {
                                    return null;
                                }
                            }, 0, T.T.loading_editor_title(), "", null);
                            UIOManager.I().show(null, (UserIODefinition)p);
                            JavaScriptEditorDialog d = new JavaScriptEditorDialog(EventScripterTableModel.this.extension, editing);
                            UIOManager.I().show(null, (UserIODefinition)d);
                            if (d.getCloseReason() == CloseReason.OK && (script = d.getScript()) != null) {
                                editing.setEventTriggerSettings(d.getEventTriggerSetup());
                                editing.setScript(script);
                                EventScripterTableModel.this.extension.save(EventScripterTableModel.this.getTableData());
                            }
                        }
                    }
                });
                this.label = new RenderLabel();
                this.rendererBtn = new JButton("");
                this.editor = new MigPanel("ins 1", "[grow,fill]", "[18!]"){

                    public void requestFocus() {
                    }
                };
                this.editor.add((Component)this.editorBtn);
                this.renderer = new RendererMigPanel("ins 1", "[grow,fill]", "[18!]");
                this.renderer.add((Component)this.rendererBtn);
                this.setClickcount(1);
            }

            public boolean isResizable() {
                return true;
            }

            public boolean isAutoWidthEnabled() {
                return true;
            }

            protected boolean isDefaultResizable() {
                return true;
            }

            public boolean isHidable() {
                return false;
            }

            public int getDefaultWidth() {
                return 80;
            }

            public boolean isSortable(ScriptEntry obj) {
                return false;
            }

            protected JComponent getInternalEditorComponent(ScriptEntry value, boolean isSelected, int row, int column) {
                return this.editor;
            }

            public boolean onSingleClick(MouseEvent e, ScriptEntry obj) {
                return super.onSingleClick(e, (Object)obj);
            }

            protected JComponent getInternalRendererComponent(ScriptEntry value, boolean isSelected, boolean hasFocus, int row, int column) {
                return this.renderer;
            }

            public boolean isEnabled(ScriptEntry obj) {
                return true;
            }

            public void configureRendererComponent(ScriptEntry value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.rendererBtn.setIcon((Icon)new AbstractIcon("wait", 16));
                this.rendererBtn.setText(_GUI.T.lit_edit());
            }

            public void configureEditorComponent(ScriptEntry value, boolean isSelected, int row, int column) {
                this.editing = value;
                this.editorBtn.setIcon((Icon)new AbstractIcon("wait", 16));
                this.editorBtn.setText(_GUI.T.lit_edit());
            }

            public void resetEditor() {
            }

            public void resetRenderer() {
            }
        });
    }

    public List<ScriptEntry> sort(List<ScriptEntry> data, ExtColumn<ScriptEntry> column) {
        if (column == null || column.getSortOrderIdentifier() == SORT_ORIGINAL) {
            return super.sort(data, null);
        }
        return super.sort(data, column);
    }

    public String getNextSortIdentifier(String sortOrderIdentifier) {
        if (sortOrderIdentifier == null) {
            sortOrderIdentifier = CFG_GUI.CFG.isPrimaryTableSorterDesc() ? "DESC" : "ASC";
        }
        if (CFG_GUI.CFG.isPrimaryTableSorterDesc()) {
            if (sortOrderIdentifier.equals(SORT_ORIGINAL)) {
                return "DESC";
            }
            if (sortOrderIdentifier.equals("DESC")) {
                return "ASC";
            }
            return SORT_ORIGINAL;
        }
        if (sortOrderIdentifier.equals(SORT_ORIGINAL)) {
            return "ASC";
        }
        if (sortOrderIdentifier.equals("ASC")) {
            return "DESC";
        }
        return SORT_ORIGINAL;
    }

    public Icon getSortIcon(String sortOrderIdentifier) {
        if (SORT_ORIGINAL.equals(sortOrderIdentifier)) {
            return null;
        }
        return super.getSortIcon(sortOrderIdentifier);
    }

    public void onConfigValidatorError(KeyHandler<Object> keyHandler, Object invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Object> keyHandler, Object newValue) {
        this.update();
    }
}

