/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.eventscripter;

import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import jd.http.Browser;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.simplejson.MinimalMemoryMap;
import org.appwork.uio.CloseReason;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.ExceptionDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.Application;
import org.appwork.utils.IO;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.reflection.Clazz;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.ExceptionDialog;
import org.jdownloader.controlling.UniqueAlltimeID;
import org.jdownloader.extensions.eventscripter.EnvironmentException;
import org.jdownloader.extensions.eventscripter.EventScripterExtension;
import org.jdownloader.extensions.eventscripter.ScriptAPI;
import org.jdownloader.extensions.eventscripter.ScriptEntry;
import org.jdownloader.extensions.eventscripter.T;
import org.jdownloader.extensions.eventscripter.sandboxobjects.ScriptEnvironment;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.myjdownloader.client.json.JsonMap;
import org.jdownloader.scripting.JSRhinoPermissionRestricter;
import org.jdownloader.scripting.JSShutterDelegate;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;
import org.mozilla.javascript.tools.shell.Global;

public class ScriptThread
extends Thread
implements JSShutterDelegate {
    private final ScriptEntry script;
    private final Map<String, Object> props;
    private Global scope;
    private Context cx;
    private final LogSource logger;
    private final EventScripterExtension extension;
    private boolean checkPermissions = true;
    private boolean disableOnException = true;
    private boolean notifyOnException = true;
    private boolean advancedAlert = false;
    private final List<ReentrantReadWriteLock> locks = new ArrayList<ReentrantReadWriteLock>();
    private final Set<String> permissions = new HashSet<String>();
    private static final WeakHashMap<Object, UniqueAlltimeID> SCRIPTLOCKS = new WeakHashMap();
    private List<Class<?>> visibleClasses = null;
    private final HashSet<String> loadedLibrary = new HashSet();

    public boolean isNotifyOnException() {
        return this.notifyOnException;
    }

    public void setNotifyOnException(boolean notifyOnException) {
        this.notifyOnException = notifyOnException;
    }

    public boolean isDisableOnException() {
        return this.disableOnException;
    }

    public void setDisableOnException(boolean disableOnException) {
        this.disableOnException = disableOnException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPermissionSet(String permission) {
        Set<String> set = this.permissions;
        synchronized (set) {
            return permission != null && this.permissions.contains(permission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPermissionSet(String permission) {
        if (permission != null) {
            Set<String> set = this.permissions;
            synchronized (set) {
                this.permissions.add(permission);
            }
        }
    }

    public boolean isCheckPermissions() {
        return this.checkPermissions;
    }

    public void setCheckPermissions(boolean checkPermissions) {
        this.checkPermissions = checkPermissions;
    }

    public boolean isAdvancedAlert() {
        return this.advancedAlert;
    }

    public void setAdvancedAlert(boolean advancedAlert) {
        this.advancedAlert = advancedAlert;
    }

    public LogSource getLogger() {
        return this.logger;
    }

    public ScriptThread(EventScripterExtension eventScripterExtension, ScriptEntry script, Map<String, Object> props, LogSource logSource) {
        this.script = script;
        this.props = props;
        this.logger = logSource;
        this.extension = eventScripterExtension;
    }

    @Override
    public void start() {
        this.startThread();
        if (!this.isTestRun() && this.isSynchronous() && (Application.isHeadless() || !SwingUtilities.isEventDispatchThread())) {
            try {
                this.join();
            }
            catch (InterruptedException e) {
                this.getLogger().log((Throwable)e);
            }
        }
    }

    protected void startThread() {
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getScriptLock(ScriptEntry script) {
        WeakHashMap<Object, UniqueAlltimeID> weakHashMap = SCRIPTLOCKS;
        synchronized (weakHashMap) {
            for (Map.Entry<Object, UniqueAlltimeID> scriptLock : SCRIPTLOCKS.entrySet()) {
                if (scriptLock.getValue().getID() != script.getID()) continue;
                return scriptLock.getKey();
            }
            Object scriptLock = new Object();
            SCRIPTLOCKS.put(scriptLock, new UniqueAlltimeID(script.getID()));
            return scriptLock;
        }
    }

    public boolean isSynchronous() {
        return false;
    }

    protected boolean isTestRun() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.isSynchronous() && !this.isTestRun()) {
            Object scriptLock;
            Object object = scriptLock = ScriptThread.getScriptLock(this.script);
            synchronized (object) {
                if (this.script.isEnabled()) {
                    this.executeScipt();
                }
            }
        } else if (this.script.isEnabled()) {
            this.executeScipt();
        }
    }

    protected void initContext(Context context) {
        this.cx.setOptimizationLevel(-1);
        this.cx.setLanguageVersion(200);
        this.cx.getWrapFactory().setJavaPrimitiveWrap(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void executeScipt() {
        this.scope = new Global();
        this.cx = Context.enter();
        try {
            this.initContext(this.cx);
            this.scope.init(this.cx);
            String preloadClasses = this.preInitClasses();
            this.evalTrusted(preloadClasses);
            this.evalTrusted("global=this;");
            this.initEnvironment();
            this.cleanupClasses();
            try {
                this.evalUNtrusted(this.script.getScript());
            }
            finally {
                this.finalizeEnvironment();
            }
        }
        catch (Throwable e) {
            this.logger.exception("An Error Occured:ID=" + this.script.getID() + "|Name=" + this.script.getName() + "|Trigger=" + (Object)((Object)this.script.getEventTrigger()) + "|Message:" + e.getMessage(), e);
            this.notifyAboutException(e);
        }
        finally {
            try {
                Context.exit();
            }
            finally {
                this.releaseLocks();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseLocks() {
        List<ReentrantReadWriteLock> list = this.locks;
        synchronized (list) {
            while (this.locks.size() > 0) {
                ReentrantReadWriteLock lock = this.locks.remove(0);
                int readLocks = lock.getReadHoldCount();
                for (int free = 0; free < readLocks; ++free) {
                    lock.readLock().unlock();
                }
                int writeLocks = lock.getWriteHoldCount();
                for (int free = 0; free < writeLocks; ++free) {
                    lock.writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLock(ReentrantReadWriteLock lock) {
        if (lock != null) {
            List<ReentrantReadWriteLock> list = this.locks;
            synchronized (list) {
                if (!this.locks.contains(lock)) {
                    this.locks.add(lock);
                }
            }
        }
    }

    public void notifyAboutException(Throwable e) {
        if (this.isDisableOnException()) {
            this.script.setEnabled(false);
            this.extension.refreshScripts();
        }
        if (this.isNotifyOnException()) {
            UIOManager.I().show(ExceptionDialogInterface.class, (UserIODefinition)new ExceptionDialog(2064, "An Error Occured:ID=" + this.script.getID() + "|Name=" + this.script.getName() + "|Trigger=" + (Object)((Object)this.script.getEventTrigger()), e.getMessage(), e, null, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String preInitClasses() {
        void var7_13;
        HashSet<String> dupes = new HashSet<String>();
        HashSet<void> visibleClasses = new HashSet<void>();
        dupes.add("org.mozilla.javascript.Function");
        dupes.add("void");
        StringBuilder preloadClasses = new StringBuilder("");
        for (Class clazz : new Class[]{Boolean.class, Byte.class, Short.class, Integer.class, Long.class, String.class, Double.class, Float.class, ArrayList.class, List.class, LinkedList.class, Map.class, HashMap.class, JsonMap.class, Set.class, HashSet.class, MinimalMemoryMap.class, EcmaError.class, ScriptEnvironment.class, EnvironmentException.class}) {
            void var7_9;
            if (clazz.isArray()) {
                Class<?> clazz2 = clazz.getComponentType();
            }
            if (!dupes.add(var7_9.getName()) || var7_9.isPrimitive()) continue;
            visibleClasses.add(var7_9);
            preloadClasses.append("load=");
            preloadClasses.append(var7_9.getName());
            preloadClasses.append(";\r\n");
        }
        Collection<Class<?>> clazzes = ScriptEnvironment.getRequiredClasses();
        clazzes.addAll((Collection<Class<?>>)this.script.getEventTrigger().getAPIClasses());
        clazzes.add(Object.class);
        for (Class<?> c : clazzes) {
            if (c.isArray()) {
                c = c.getComponentType();
            }
            if (!dupes.add(c.getName()) || c.isPrimitive()) continue;
            preloadClasses.append("load=");
            preloadClasses.append(c.getName());
            preloadClasses.append(";\r\n");
        }
        Field[] fieldArray = ScriptEnvironment.class.getDeclaredFields();
        int n = fieldArray.length;
        boolean bl = false;
        while (var7_13 < n) {
            Field f = fieldArray[var7_13];
            if (f.getAnnotation(ScriptAPI.class) != null) {
                Class<?> c = f.getType();
                if (c.isArray()) {
                    c = c.getComponentType();
                }
                if (dupes.add(c.getName()) && !Clazz.isPrimitive(c)) {
                    preloadClasses.append("load=");
                    preloadClasses.append(c.getName());
                    preloadClasses.append(";\r\n");
                }
            }
            ++var7_13;
        }
        preloadClasses.append("delete load;");
        this.visibleClasses = new ArrayList(visibleClasses);
        return preloadClasses.toString();
    }

    private void initEnvironment() throws IllegalAccessException {
        for (Method method : ScriptEnvironment.class.getDeclaredMethods()) {
            if (method.getAnnotation(ScriptAPI.class) == null) continue;
            this.evalTrusted(method.getName() + "=" + ScriptEnvironment.class.getName() + "." + method.getName() + ";");
        }
        for (AccessibleObject accessibleObject : ScriptEnvironment.class.getDeclaredFields()) {
            if (((Field)accessibleObject).getAnnotation(ScriptAPI.class) == null) continue;
            ScriptableObject.putProperty((Scriptable)this.scope, (String)((Field)accessibleObject).getName(), (Object)ScriptEnvironment.toJSObject(((Field)accessibleObject).get(null)));
        }
        for (Map.Entry entry : this.props.entrySet()) {
            Object existing = ScriptableObject.getProperty((Scriptable)this.scope, (String)((String)entry.getKey()));
            if (existing instanceof NativeJavaMethod) continue;
            ScriptableObject.putProperty((Scriptable)this.scope, (String)((String)entry.getKey()), entry.getValue());
        }
    }

    protected void finalizeEnvironment() throws IllegalAccessException {
        ArrayList<String> keySet = new ArrayList<String>(this.props.keySet());
        for (String key : keySet) {
            Object value = ScriptableObject.getProperty((Scriptable)this.scope, (String)key);
            if (UniqueTag.NOT_FOUND.equals(value) || value instanceof NativeJavaMethod) continue;
            this.props.put(key, value);
        }
    }

    private void evalUNtrusted(String script) {
        this.cx.evaluateString((Scriptable)this.getScope(), script, "", 1, null);
    }

    public Object evalTrusted(String preloadClasses) {
        return JSRhinoPermissionRestricter.evaluateTrustedString((Context)this.cx, (Global)this.getScope(), (String)preloadClasses, (String)"", (int)1, null);
    }

    private void cleanupClasses() {
        List list = JSRhinoPermissionRestricter.getLoaded();
        ScriptableObject.deleteProperty((Scriptable)this.scope, (String)"Packages");
        block2: for (String s : list) {
            while (true) {
                int index;
                try {
                    ScriptableObject.deleteProperty((Scriptable)this.scope, (String)s);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if ((index = s.lastIndexOf(".")) <= 0) continue block2;
                s = s.substring(0, index);
            }
        }
    }

    public void requireJavascript(String fileOrUrl) throws IOException {
        final String permissionID = "ASK_TO_REQUIRE_JS_" + fileOrUrl;
        ConfirmDialog d = new ConfirmDialog(544, T.T.securityLoading_title(), T.T.securityLoading(fileOrUrl), (Icon)new AbstractIcon("server", 32), null, null){

            public String getDontShowAgainKey() {
                return permissionID;
            }

            protected int getPreferredWidth() {
                return 600;
            }

            public void windowClosing(WindowEvent arg0) {
                this.setReturnmask(false);
                this.dispose();
            }
        };
        d.setDoNotShowAgainSelected(true);
        ConfirmDialogInterface dialog = null;
        if (!this.isCheckPermissions() || this.isPermissionSet(permissionID) || (dialog = d.show()).getCloseReason() == CloseReason.OK) {
            String js;
            if (dialog != null && dialog.isDontShowAgainSelected()) {
                this.setPermissionSet(permissionID);
            }
            if (fileOrUrl.matches("^https?\\:\\/\\/.+")) {
                Browser br = new Browser();
                br.setFollowRedirects(true);
                js = br.getPage(fileOrUrl);
            } else {
                File file = new File(fileOrUrl);
                if (!file.exists()) {
                    file = Application.getResource((String)fileOrUrl);
                }
                js = file.exists() ? IO.readFileToString((File)file) : "";
            }
            this.logger.info(js);
            this.evalUNtrusted(js);
        }
    }

    public Context getContext() {
        return this.cx;
    }

    public Global getScope() {
        return this.scope;
    }

    public ScriptEntry getScript() {
        return this.script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureLibrary(String string) {
        HashSet<String> hashSet = this.loadedLibrary;
        synchronized (hashSet) {
            if (this.loadedLibrary.add(string)) {
                try {
                    this.evalTrusted(IO.readURLToString((URL)ScriptEntry.class.getResource(string)));
                }
                catch (IOException e) {
                    throw new WTFException((Throwable)e);
                }
            }
        }
    }

    public Object toNative(Object settings) {
        String json = JSonStorage.serializeToJson((Object)settings);
        Object ret = this.cx.evaluateString((Scriptable)this.scope, "(function(){ return " + json + ";})();", "", 0, null);
        return ret;
    }

    public boolean isClassVisibleToScript(boolean trusted, String className) {
        if (trusted) {
            return true;
        }
        if (className.startsWith("adapter")) {
            return true;
        }
        if ("org.mozilla.javascript.EcmaError".equals(className) || "net.sourceforge.htmlunit.corejs.javascript.EcmaError".equals(className)) {
            LoggerFactory.getDefaultLogger().severe("Javascript error occured");
            return true;
        }
        if ("org.mozilla.javascript.ConsString".equals(className) || "net.sourceforge.htmlunit.corejs.javascript.ConsString".equals(className)) {
            LoggerFactory.getDefaultLogger().severe("Javascript error occured");
            return true;
        }
        if ("org.mozilla.javascript.JavaScriptException".equals(className) || "net.sourceforge.htmlunit.corejs.javascript.JavaScriptException".equals(className)) {
            LoggerFactory.getDefaultLogger().severe("Javascript error occured");
            return true;
        }
        if (EnvironmentException.class.getName().equals(className)) {
            LoggerFactory.getDefaultLogger().severe("Environment error occured");
            return true;
        }
        if ("org.mozilla.javascript.WrappedException".equals(className) || "net.sourceforge.htmlunit.corejs.javascript.WrappedException".equals(className)) {
            LoggerFactory.getDefaultLogger().severe("Script RuntimeException occured");
            return true;
        }
        if ("org.mozilla.javascript.EvaluatorException".equals(className) || "net.sourceforge.htmlunit.corejs.javascript.EvaluatorException".equals(className)) {
            LoggerFactory.getDefaultLogger().severe("Javascript error occured");
            return true;
        }
        try {
            if (this.visibleClasses != null) {
                Class<?> clazz = Class.forName(className, false, null);
                for (Class<?> visibleClass : this.visibleClasses) {
                    if (!visibleClass.equals(clazz) && !visibleClass.isAssignableFrom(clazz) && !visibleClass.equals(clazz.getDeclaringClass())) continue;
                    return true;
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.logger.log((Throwable)e);
        }
        LoggerFactory.getDefaultLogger().severe("Security Violation " + className);
        EcmaError ret = ScriptRuntime.constructError((String)"Security Violation", (String)("Security Violation " + className));
        throw ret;
    }
}

