/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.eventscripter.sandboxobjects;

import java.util.ArrayList;
import jd.controlling.linkcrawler.CrawledLink;
import jd.plugins.DownloadLink;
import org.jdownloader.extensions.eventscripter.sandboxobjects.CrawledLinkSandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.DownloadLinkSandBox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.FilePathSandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.ScriptEnvironment;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.ExtractionStatus;
import org.jdownloader.extensions.extraction.MissingArchiveFile;
import org.jdownloader.extensions.extraction.bindings.crawledlink.CrawledLinkArchiveFile;
import org.jdownloader.extensions.extraction.bindings.downloadlink.DownloadLinkArchiveFile;

public class ArchiveFileSandbox {
    private final ArchiveFile archiveFile;

    public ArchiveFileSandbox(ArchiveFile archiveFile) {
        this.archiveFile = archiveFile;
    }

    public Boolean isComplete() {
        if (this.archiveFile != null) {
            return this.archiveFile.isComplete();
        }
        return null;
    }

    public String getFilePath() {
        if (this.archiveFile != null) {
            return this.archiveFile.getFilePath();
        }
        return null;
    }

    public FilePathSandbox getPath() {
        String filePath = this.getFilePath();
        if (filePath != null) {
            return ScriptEnvironment.getPath(filePath);
        }
        return null;
    }

    public boolean isMissingArchiveFile() {
        return this.archiveFile instanceof MissingArchiveFile;
    }

    public long getFileSize() {
        if (this.archiveFile != null) {
            return this.archiveFile.getFileSize();
        }
        return 0L;
    }

    public CrawledLinkSandbox[] getCrawledLinks() {
        if (this.archiveFile instanceof CrawledLinkArchiveFile) {
            ArrayList<CrawledLinkSandbox> ret = new ArrayList<CrawledLinkSandbox>();
            for (CrawledLink link : ((CrawledLinkArchiveFile)this.archiveFile).getLinks()) {
                ret.add(new CrawledLinkSandbox(link));
            }
            if (ret.size() > 0) {
                return ret.toArray(new CrawledLinkSandbox[0]);
            }
        }
        return null;
    }

    public DownloadLinkSandBox[] getDownloadLinks() {
        if (this.archiveFile instanceof DownloadLinkArchiveFile) {
            ArrayList<DownloadLinkSandBox> ret = new ArrayList<DownloadLinkSandBox>();
            for (DownloadLink link : ((DownloadLinkArchiveFile)this.archiveFile).getDownloadLinks()) {
                ret.add(new DownloadLinkSandBox(link));
            }
            if (ret.size() > 0) {
                return ret.toArray(new DownloadLinkSandBox[0]);
            }
        }
        return null;
    }

    public boolean exists() {
        return this.archiveFile != null && this.archiveFile.exists();
    }

    public String getExtractionStatus() {
        if (this.archiveFile != null) {
            return this.archiveFile.getStatus().name();
        }
        return ExtractionStatus.NA.name();
    }

    public boolean exists(boolean ignoreCache) {
        return this.archiveFile != null && this.archiveFile.exists(ignoreCache);
    }

    public void invalidateExists() {
        if (this.archiveFile != null) {
            this.archiveFile.invalidateExists();
        }
    }

    public String getName() {
        if (this.archiveFile != null) {
            return this.archiveFile.getName();
        }
        return null;
    }

    public Boolean isPartOfAnArchive() {
        if (this.archiveFile != null) {
            return this.archiveFile.isPartOfAnArchive();
        }
        return null;
    }

    public String getArchiveID() {
        if (this.archiveFile != null) {
            return this.archiveFile.getArchiveID();
        }
        return null;
    }
}

