/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.eventscripter.sandboxobjects;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.appwork.utils.StringUtils;
import org.jdownloader.extensions.eventscripter.EnvironmentException;
import org.jdownloader.extensions.eventscripter.ScriptThread;
import org.jdownloader.extensions.eventscripter.sandboxobjects.ArchiveFileSandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.DownloadLinkSandBox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.FilePathSandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.ScriptEnvironment;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFile;
import org.jdownloader.extensions.extraction.ExtractionExtension;
import org.jdownloader.extensions.extraction.ExtractionStatus;

public class ArchiveSandbox {
    private final Archive archive;

    public ArchiveSandbox(Archive archive) {
        this.archive = archive;
    }

    public ArchiveSandbox() {
        this(null);
    }

    public int hashCode() {
        if (this.archive != null) {
            return this.archive.hashCode();
        }
        return super.hashCode();
    }

    public ArchiveSandbox getParentArchive() {
        Archive parent;
        if (this.archive != null && (parent = this.archive.getParentArchive()) != null) {
            return new ArchiveSandbox(parent);
        }
        return null;
    }

    public String getExtractionStatus() {
        String archiveID = this.getArchiveID();
        if (archiveID == null) {
            return ExtractionStatus.NA.name();
        }
        ArchiveFileSandbox[] archiveFiles = this.getArchiveFiles();
        if (archiveFiles == null) {
            return ExtractionStatus.NA.name();
        }
        for (ArchiveFileSandbox archiveFile : archiveFiles) {
            String status;
            if (!archiveID.equals(archiveFile.getArchiveID()) || (status = archiveFile.getExtractionStatus()) == null || ExtractionStatus.NA.name().equals(status)) continue;
            return status;
        }
        return ExtractionStatus.NA.name();
    }

    public ArchiveFileSandbox getLastArchiveFile() {
        ArchiveFile lastArchiveFile;
        if (this.archive != null && (lastArchiveFile = this.archive.getLastArchiveFile()) != null) {
            return new ArchiveFileSandbox(lastArchiveFile);
        }
        return null;
    }

    public ArchiveSandbox getRootArchive() {
        Archive root;
        if (this.archive != null && (root = this.archive.getRootArchive()) != null) {
            return new ArchiveSandbox(root);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArchiveSandbox) {
            return ((ArchiveSandbox)obj).archive == this.archive;
        }
        return super.equals(obj);
    }

    @Deprecated
    public String getExtractionLog() {
        return "DEPRECATED, this method may be removed in future version";
    }

    public boolean isPasswordProtected() {
        if (this.archive != null) {
            return this.archive.isProtected() || this.archive.isPasswordRequiredToOpen();
        }
        return false;
    }

    public String getUsedPassword() {
        if (this.archive != null) {
            return this.archive.getFinalPassword();
        }
        return null;
    }

    public String getArchiveID() {
        if (this.archive != null) {
            return this.archive.getSettings()._getArchiveID();
        }
        return null;
    }

    public String getSettingsID() {
        if (this.archive != null) {
            return this.archive.getSettings()._getSettingsID();
        }
        return null;
    }

    public List<String> getPasswords() {
        if (this.archive != null) {
            return this.archive.getSettings().getPasswords();
        }
        return null;
    }

    public void setPasswords(List<String> passwords) {
        if (this.archive != null) {
            this.archive.setPasswords(passwords);
        }
    }

    @Deprecated
    public DownloadLinkSandBox[] getDownloadLinks() {
        ArchiveFileSandbox[] links = this.getArchiveFiles();
        if (links != null) {
            ArrayList<DownloadLinkSandBox> ret = new ArrayList<DownloadLinkSandBox>();
            for (ArchiveFileSandbox link : links) {
                DownloadLinkSandBox[] downloadLinks = link.getDownloadLinks();
                if (downloadLinks == null) continue;
                ret.addAll(Arrays.asList(downloadLinks));
            }
            if (ret.size() > 0) {
                return ret.toArray(new DownloadLinkSandBox[0]);
            }
        }
        return null;
    }

    public ArchiveFileSandbox[] getArchiveFiles() {
        if (this.archive != null) {
            ArrayList<ArchiveFileSandbox> ret = new ArrayList<ArchiveFileSandbox>();
            for (ArchiveFile file : this.archive.getArchiveFiles()) {
                ret.add(new ArchiveFileSandbox(file));
            }
            if (ret.size() > 0) {
                return ret.toArray(new ArchiveFileSandbox[0]);
            }
        }
        return null;
    }

    public Object getInfo() {
        if (this.archive != null) {
            return ((ScriptThread)Thread.currentThread()).toNative(this.archive.getSettings());
        }
        return null;
    }

    public String getArchiveType() {
        if (this.archive != null) {
            return this.archive.getSplitType() == null ? StringUtils.valueOfOrNull((Object)this.archive.getArchiveType()) : StringUtils.valueOfOrNull((Object)this.archive.getSplitType());
        }
        return null;
    }

    public String getExtractToFolder() {
        return ExtractionExtension.getInstance().getFinalExtractToFolder(this.archive, false).toString();
    }

    public String[] getExtractedFiles() {
        if (this.archive != null && this.archive.getExtractedFiles() != null && this.archive.getExtractedFiles().size() > 0) {
            ArrayList<String> ret = new ArrayList<String>(this.archive.getExtractedFiles().size());
            for (File file : this.archive.getExtractedFiles()) {
                ret.add(file.getAbsolutePath());
            }
            if (ret.size() > 0) {
                return ret.toArray(new String[0]);
            }
        }
        return null;
    }

    public FilePathSandbox[] getExtractedFilePaths() throws EnvironmentException {
        String[] files = this.getExtractedFiles();
        if (files != null && files.length > 0) {
            ArrayList<FilePathSandbox> ret = new ArrayList<FilePathSandbox>(files.length);
            for (String file : files) {
                ret.add(ScriptEnvironment.getPath(file));
            }
            if (ret.size() > 0) {
                return ret.toArray(new FilePathSandbox[0]);
            }
        }
        return null;
    }

    public String getName() {
        if (this.archive != null) {
            return this.archive.getName();
        }
        return null;
    }

    public String getFolder() {
        if (this.archive != null) {
            return this.archive.getFolder().getAbsolutePath();
        }
        return null;
    }
}

