/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.eventscripter.sandboxobjects;

import java.util.List;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkOrigin;
import jd.controlling.linkcollector.LinkOriginDetails;
import org.appwork.utils.StringUtils;

public class CrawlerJobSandbox {
    protected final LinkCollectingJob job;
    private String text = null;

    public CrawlerJobSandbox(LinkCollectingJob job) {
        this.job = job;
        if (job != null) {
            this.text = job.getText();
        }
    }

    public int hashCode() {
        if (this.job != null) {
            return this.job.hashCode();
        }
        return super.hashCode();
    }

    public boolean isAssignJobID() {
        return this.job != null && this.job.isAssignJobID();
    }

    public void setAssignJobID(boolean b) {
        if (this.job != null) {
            this.job.setAssignJobID(b);
        }
    }

    public String getUUID() {
        if (this.job != null) {
            return this.job.getUniqueAlltimeID().toString();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CrawlerJobSandbox) {
            return ((CrawlerJobSandbox)obj).job == this.job;
        }
        return super.equals(obj);
    }

    public CrawlerJobSandbox() {
        this.job = new LinkCollectingJob(LinkOriginDetails.getInstance((LinkOrigin)LinkOrigin.PASTE_LINKS_ACTION, (String)"Test Job for EventScripter"));
        this.job.setText("http://jdownloader.org/_media/knowledge/wiki/development/open_preferences.png");
        this.job.setDeepAnalyse(false);
    }

    public String getOrigin() {
        return this.job.getOrigin() == null ? null : this.job.getOrigin().getOrigin().name();
    }

    public String getPassword() {
        return this.job.getCrawlerPassword();
    }

    public String getSourceUrl() {
        return this.job.getCustomSourceUrl();
    }

    public void setPassword(String text) {
        this.job.setCrawlerPassword(text);
    }

    public boolean isDeepAnalysisEnabled() {
        return this.job.isDeepAnalyse();
    }

    public boolean isOverwritesPackagizerRulesEnabled() {
        return this.job.getPostPackagizerModifier().size() > 0;
    }

    public void setDeepAnalysisEnabled(boolean enabled) {
        this.job.setDeepAnalyse(enabled);
    }

    public List<String> getArchivPasswords() {
        return this.job.getArchivPasswords();
    }

    public String getText() {
        String ret = this.job.getText();
        if (!StringUtils.isEmpty((String)ret)) {
            return ret;
        }
        return this.text;
    }

    public boolean isConsumed() {
        return this.job.isConsumed();
    }

    public boolean setText(String text) {
        if (this.job.setText(text)) {
            this.text = text;
            return true;
        }
        this.text = null;
        return false;
    }
}

