/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.eventscripter.sandboxobjects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.PackageController;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.PluginProgress;
import jd.plugins.download.HashInfo;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JsonKeyValueStorage;
import org.appwork.storage.Storable;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.reflection.Clazz;
import org.jdownloader.api.downloads.v2.DownloadLinkAPIStorableV2;
import org.jdownloader.api.downloads.v2.DownloadsAPIV2Impl;
import org.jdownloader.controlling.Priority;
import org.jdownloader.extensions.eventscripter.ScriptAPI;
import org.jdownloader.extensions.eventscripter.sandboxobjects.ArchiveSandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.ConditionalSkipReasonSandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.FilePackageSandBox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.HTTPProxySandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.LinkInfoSandbox;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.ArchiveFactory;
import org.jdownloader.extensions.extraction.ExtractionStatus;
import org.jdownloader.extensions.extraction.bindings.downloadlink.DownloadLinkArchiveFactory;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.ArchiveValidator;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.myjdownloader.client.json.AvailableLinkState;
import org.jdownloader.myjdownloader.client.json.JsonMap;
import org.jdownloader.plugins.ConditionalSkipReason;
import org.jdownloader.plugins.CustomConditionalSkipReasonMessageIcon;
import org.jdownloader.plugins.DownloadPluginProgress;
import org.jdownloader.plugins.FinalLinkState;
import org.jdownloader.plugins.SkipReason;
import org.jdownloader.plugins.TimeOutCondition;
import org.jdownloader.settings.UrlDisplayType;

@ScriptAPI(description="The context download list link")
public class DownloadLinkSandBox {
    protected final DownloadLink downloadLink;
    private static final WeakHashMap<DownloadLink, HashMap<String, Object>> SESSIONPROPERTIES = new WeakHashMap();

    public DownloadLinkSandBox(DownloadLink downloadLink) {
        this.downloadLink = downloadLink;
    }

    public DownloadLinkSandBox() {
        this(null);
    }

    public String getLinkID() {
        if (this.downloadLink != null) {
            return this.downloadLink.getLinkID();
        }
        return null;
    }

    public String getPriority() {
        if (this.downloadLink != null) {
            return this.downloadLink.getPriorityEnum().name();
        }
        return Priority.DEFAULT.name();
    }

    public void setPriority(String priority) {
        if (this.downloadLink != null) {
            try {
                this.downloadLink.setPriorityEnum(Priority.valueOf((String)priority));
            }
            catch (Throwable e) {
                this.downloadLink.setPriorityEnum(Priority.DEFAULT);
            }
        }
    }

    public long getDownloadTime() {
        if (this.downloadLink != null) {
            long ret = this.downloadLink.getView().getDownloadTime();
            PluginProgress progress = this.downloadLink.getPluginProgress();
            if (progress instanceof DownloadPluginProgress) {
                long ret2 = ret + ((DownloadPluginProgress)progress).getDuration();
                return ret2;
            }
            return ret;
        }
        return -1L;
    }

    public String getContentURL() {
        if (this.downloadLink != null) {
            return LinkTreeUtils.getUrlByType((UrlDisplayType)UrlDisplayType.CONTENT, (AbstractNode)this.downloadLink);
        }
        return null;
    }

    public String getPluginURL() {
        if (this.downloadLink != null) {
            return this.downloadLink.getPluginPatternMatcher();
        }
        return null;
    }

    public String getContainerURL() {
        if (this.downloadLink != null) {
            return LinkTreeUtils.getUrlByType((UrlDisplayType)UrlDisplayType.CONTAINER, (AbstractNode)this.downloadLink);
        }
        return null;
    }

    public String getOriginURL() {
        if (this.downloadLink != null) {
            return LinkTreeUtils.getUrlByType((UrlDisplayType)UrlDisplayType.ORIGIN, (AbstractNode)this.downloadLink);
        }
        return null;
    }

    public String getReferrerURL() {
        if (this.downloadLink != null) {
            return LinkTreeUtils.getUrlByType((UrlDisplayType)UrlDisplayType.REFERRER, (AbstractNode)this.downloadLink);
        }
        return null;
    }

    public String getHashInfo() {
        if (this.downloadLink != null) {
            HashInfo hashInfo = this.downloadLink.getHashInfo();
            return hashInfo != null ? hashInfo.exportAsString() : null;
        }
        return null;
    }

    public long getAddedDate() {
        if (this.downloadLink != null) {
            return this.downloadLink.getCreated();
        }
        return -1L;
    }

    public long getFinishedDate() {
        if (this.downloadLink != null) {
            return this.downloadLink.getFinishedDate();
        }
        return -1L;
    }

    public void abort() {
        if (this.downloadLink != null) {
            ArrayList<DownloadLink> abort = new ArrayList<DownloadLink>();
            abort.add(this.downloadLink);
            DownloadWatchDog.getInstance().abort(abort);
        }
    }

    public boolean isAborting() {
        if (this.downloadLink != null) {
            SingleDownloadController controller = this.downloadLink.getDownloadLinkController();
            return controller != null && controller.isAborting();
        }
        return false;
    }

    public boolean isActive() {
        if (this.downloadLink != null) {
            SingleDownloadController controller = this.downloadLink.getDownloadLinkController();
            return controller != null && controller.isActive();
        }
        return false;
    }

    public Object getProperty(String key) {
        if (this.downloadLink != null) {
            return this.downloadLink.getProperty(key);
        }
        return null;
    }

    public Object getTempProperty(String key) {
        if (this.downloadLink != null) {
            return this.downloadLink.getTempProperties().getProperty(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSessionProperty(String key) {
        if (this.downloadLink != null) {
            WeakHashMap<DownloadLink, HashMap<String, Object>> weakHashMap = SESSIONPROPERTIES;
            synchronized (weakHashMap) {
                HashMap<String, Object> properties = SESSIONPROPERTIES.get(this.downloadLink);
                if (properties != null) {
                    return properties.get(key);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionProperty(String key, Object value) {
        if (this.downloadLink != null) {
            if (value != null && !this.canStore(value)) {
                throw new WTFException("Type " + value.getClass().getSimpleName() + " is not supported");
            }
            WeakHashMap<DownloadLink, HashMap<String, Object>> weakHashMap = SESSIONPROPERTIES;
            synchronized (weakHashMap) {
                HashMap<String, Object> properties = SESSIONPROPERTIES.get(this.downloadLink);
                if (properties == null) {
                    properties = new HashMap();
                    SESSIONPROPERTIES.put(this.downloadLink, properties);
                }
                properties.put(key, value);
            }
        }
    }

    public String getUUID() {
        if (this.downloadLink != null) {
            return this.downloadLink.getUniqueID().toString();
        }
        return null;
    }

    public boolean remove() {
        PackageController controller;
        FilePackage filePackage;
        if (this.downloadLink != null && (filePackage = this.downloadLink.getParentNode()) != null && !FilePackage.isDefaultFilePackage((AbstractPackageNode)filePackage) && (controller = filePackage.getControlledBy()) != null) {
            ArrayList<DownloadLink> children = new ArrayList<DownloadLink>();
            children.add(this.downloadLink);
            controller.removeChildren(children);
            return true;
        }
        return false;
    }

    public void setProperty(String key, Object value) {
        if (this.downloadLink != null) {
            if (value != null && !this.canStore(value)) {
                throw new WTFException("Type " + value.getClass().getSimpleName() + " is not supported");
            }
            this.downloadLink.setProperty(key, value);
        }
    }

    public void setTempProperty(String key, Object value) {
        if (this.downloadLink != null) {
            if (value != null && !this.canStore(value)) {
                throw new WTFException("Type " + value.getClass().getSimpleName() + " is not supported");
            }
            this.downloadLink.getTempProperties().setProperty(key, value);
        }
    }

    public Map<String, Object> getProperties() {
        if (this.downloadLink != null) {
            return this.downloadLink.getProperties();
        }
        return null;
    }

    public Map<String, Object> getTempProperties() {
        if (this.downloadLink != null) {
            return this.downloadLink.getTempProperties().getProperties();
        }
        return null;
    }

    private boolean canStore(Object value) {
        return value == null || Clazz.isPrimitive(value.getClass()) || JsonKeyValueStorage.isWrapperType(value.getClass()) || value instanceof Storable;
    }

    public long getDownloadSessionDuration() {
        SingleDownloadController controller;
        if (this.downloadLink != null && (controller = this.downloadLink.getDownloadLinkController()) != null) {
            return System.currentTimeMillis() - controller.getStartTimestamp();
        }
        return -1L;
    }

    public long getDownloadDuration() {
        PluginProgress progress;
        if (this.downloadLink != null && (progress = this.downloadLink.getPluginProgress()) instanceof DownloadPluginProgress) {
            return ((DownloadPluginProgress)progress).getDuration();
        }
        return -1L;
    }

    public void reset() {
        if (this.downloadLink != null) {
            ArrayList<DownloadLink> l = new ArrayList<DownloadLink>();
            l.add(this.downloadLink);
            DownloadWatchDog.getInstance().reset(l);
        }
    }

    public void resume() {
        if (this.downloadLink != null) {
            ArrayList<DownloadLink> l = new ArrayList<DownloadLink>();
            l.add(this.downloadLink);
            DownloadWatchDog.getInstance().resume(l);
        }
    }

    public long getEta() {
        if (this.downloadLink == null) {
            return -1L;
        }
        PluginProgress progress = this.downloadLink.getPluginProgress();
        if (progress != null) {
            long ret = progress.getETA();
            return ret;
        }
        ConditionalSkipReason conditionalSkipReason = this.downloadLink.getConditionalSkipReason();
        if (conditionalSkipReason != null && !conditionalSkipReason.isConditionReached() && conditionalSkipReason instanceof TimeOutCondition) {
            long ret = ((TimeOutCondition)conditionalSkipReason).getTimeOutLeft();
            return ret;
        }
        return -1L;
    }

    public String getArchiveID() {
        return this.downloadLink != null ? this.downloadLink.getArchiveID() : null;
    }

    public Boolean isPartOfAnArchive() {
        return this.downloadLink != null ? this.downloadLink.isPartOfAnArchive() : null;
    }

    public ArchiveSandbox getArchive() {
        if (this.downloadLink == null || ArchiveValidator.EXTENSION == null) {
            return null;
        }
        Archive archive = ArchiveValidator.EXTENSION.getArchiveByFactory((ArchiveFactory)new DownloadLinkArchiveFactory(this.downloadLink));
        if (archive != null) {
            return new ArchiveSandbox(archive);
        }
        ArrayList<DownloadLink> list = new ArrayList<DownloadLink>();
        list.add(this.downloadLink);
        List archives = ArchiveValidator.getArchivesFromPackageChildren(list);
        return archives == null || archives.size() == 0 ? null : new ArchiveSandbox((Archive)archives.get(0));
    }

    public String getComment() {
        if (this.downloadLink != null) {
            return this.downloadLink.getComment();
        }
        return null;
    }

    public void setComment(String comment) {
        if (this.downloadLink != null) {
            this.downloadLink.setComment(comment);
        }
    }

    public void setEnabled(boolean b) {
        if (this.downloadLink != null) {
            this.downloadLink.setEnabled(b);
        }
    }

    public String getDownloadPath() {
        if (this.downloadLink == null) {
            switch (CrossSystem.getOSFamily()) {
                case WINDOWS: {
                    return "c:\\I am a dummy folder\\Test.txt";
                }
            }
            return "/mnt/Text.txt";
        }
        return this.downloadLink.getFileOutput();
    }

    @ScriptAPI(description="Sets a new filename", parameters={"new Name"})
    public void setName(String name) {
        if (this.downloadLink != null) {
            DownloadWatchDog.getInstance().renameLink(this.downloadLink, name);
        }
    }

    public String getUrl() {
        if (this.downloadLink != null) {
            return this.downloadLink.getView().getDisplayUrl();
        }
        return null;
    }

    public long getBytesLoaded() {
        if (this.downloadLink != null) {
            return this.downloadLink.getView().getBytesLoaded();
        }
        return -1L;
    }

    public long getBytesTotal() {
        if (this.downloadLink != null) {
            return this.downloadLink.getView().getBytesTotal();
        }
        return -1L;
    }

    public long getBytesTotalVerified() {
        if (this.downloadLink == null) {
            return -1L;
        }
        return this.downloadLink.getView().getBytesTotalVerified();
    }

    public String getName() {
        if (this.downloadLink == null) {
            return "Test.txt";
        }
        return this.downloadLink.getName();
    }

    public String getForcedName() {
        if (this.downloadLink == null) {
            return "Test.txt";
        }
        return this.downloadLink.getForcedFileName();
    }

    public String getFinalName() {
        if (this.downloadLink == null) {
            return "Test.txt";
        }
        return this.downloadLink.getFinalFileName();
    }

    public long getSpeed() {
        if (this.downloadLink != null) {
            return this.downloadLink.getView().getSpeedBps();
        }
        return 0L;
    }

    public String getStatus() {
        DownloadLinkAPIStorableV2 ret = this._getStatus();
        if (ret != null) {
            return ret.getStatus();
        }
        return null;
    }

    private DownloadLinkAPIStorableV2 _getStatus() {
        if (this.downloadLink != null) {
            DownloadLinkAPIStorableV2 ret = new DownloadLinkAPIStorableV2(this.downloadLink);
            DownloadsAPIV2Impl.setStatus((DownloadLinkAPIStorableV2)ret, (DownloadLink)this.downloadLink, (Object)new CustomConditionalSkipReasonMessageIcon(){

                public String getMessage(ConditionalSkipReason conditionalSkipReason, AbstractNode node) {
                    return conditionalSkipReason.getMessage((Object)conditionalSkipReason, node);
                }

                public Icon getIcon(ConditionalSkipReason conditionalSkipReason, AbstractNode node) {
                    return conditionalSkipReason.getIcon((Object)conditionalSkipReason, node);
                }
            });
            return ret;
        }
        return null;
    }

    public JsonMap getAdvancedStatus() {
        DownloadLinkAPIStorableV2 ret = this._getStatus();
        if (ret != null) {
            return ret.getAdvancedStatus();
        }
        return null;
    }

    public String getHost() {
        if (this.downloadLink != null) {
            return this.downloadLink.getHost();
        }
        return null;
    }

    public String getDownloadHost() {
        if (this.downloadLink != null) {
            return this.downloadLink.getServiceHost(true);
        }
        return null;
    }

    public HTTPProxySandbox getDownloadProxy() {
        SingleDownloadController controller;
        if (this.downloadLink != null && (controller = this.downloadLink.getDownloadLinkController()) != null) {
            return new HTTPProxySandbox(controller.getProxySelector());
        }
        return null;
    }

    public boolean isSkipped() {
        return this.downloadLink != null && this.downloadLink.isSkipped();
    }

    public LinkInfoSandbox getLinkInfo() {
        if (this.downloadLink == null) {
            return null;
        }
        return new LinkInfoSandbox(this.downloadLink.getLinkInfo());
    }

    public String getSkippedReason() {
        SkipReason skipped;
        if (this.downloadLink != null && (skipped = this.downloadLink.getSkipReason()) != null) {
            return skipped.name();
        }
        return null;
    }

    public ConditionalSkipReasonSandbox getConditionalSkipReason() {
        ConditionalSkipReason condition;
        if (this.downloadLink != null && (condition = this.downloadLink.getConditionalSkipReason()) != null) {
            return new ConditionalSkipReasonSandbox(this.downloadLink, condition);
        }
        return null;
    }

    public String getFinalLinkStatus() {
        FinalLinkState state;
        if (this.downloadLink != null && (state = this.downloadLink.getFinalLinkState()) != null) {
            return state.name();
        }
        return null;
    }

    public void setSkipped(boolean b) {
        if (this.downloadLink == null) {
            return;
        }
        if (b) {
            if (!this.downloadLink.isSkipped()) {
                this.downloadLink.setSkipReason(SkipReason.MANUAL);
            }
        } else {
            ArrayList<DownloadLink> unSkip = new ArrayList<DownloadLink>();
            unSkip.add(this.downloadLink);
            DownloadWatchDog.getInstance().unSkip(unSkip);
        }
    }

    public boolean isRunning() {
        return this.downloadLink != null && this.downloadLink.getDownloadLinkController() != null;
    }

    public boolean isEnabled() {
        return this.downloadLink != null && this.downloadLink.isEnabled();
    }

    public int hashCode() {
        if (this.downloadLink != null) {
            return this.downloadLink.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DownloadLinkSandBox) {
            return ((DownloadLinkSandBox)obj).downloadLink == this.downloadLink;
        }
        return super.equals(obj);
    }

    public String getAvailableState() {
        DownloadLink.AvailableStatus availableStatus;
        if (this.downloadLink != null && (availableStatus = this.downloadLink.getAvailableStatus()) != null) {
            switch (availableStatus) {
                case TRUE: {
                    return AvailableLinkState.ONLINE.name();
                }
                case FALSE: {
                    return AvailableLinkState.OFFLINE.name();
                }
                case UNCHECKED: {
                    return AvailableLinkState.UNKNOWN.name();
                }
                case UNCHECKABLE: {
                    return AvailableLinkState.TEMP_UNKNOWN.name();
                }
            }
            return AvailableLinkState.UNKNOWN.name();
        }
        return AvailableLinkState.UNKNOWN.name();
    }

    public FilePackageSandBox getPackage() {
        if (this.downloadLink == null) {
            return new FilePackageSandBox();
        }
        FilePackage fp = this.downloadLink.getFilePackage();
        if (fp == null || FilePackage.isDefaultFilePackage((AbstractPackageNode)fp)) {
            return null;
        }
        return new FilePackageSandBox(fp);
    }

    public boolean isResumeable() {
        return this.downloadLink != null && this.downloadLink.isResumeable();
    }

    public String toString() {
        return "DownloadLink Instance: " + this.getName();
    }

    public boolean isFinished() {
        return this.downloadLink != null && FinalLinkState.CheckFinished((FinalLinkState)this.downloadLink.getFinalLinkState());
    }

    public String getExtractionStatus() {
        if (this.downloadLink == null) {
            return null;
        }
        ExtractionStatus ret = this.downloadLink.getExtractionStatus();
        return ret == null ? null : ret.name();
    }
}

