/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.eventscripter.sandboxobjects;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.PackageController;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.FilePackageView;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.JsonKeyValueStorage;
import org.appwork.storage.Storable;
import org.appwork.utils.Application;
import org.appwork.utils.reflection.Clazz;
import org.jdownloader.controlling.Priority;
import org.jdownloader.extensions.eventscripter.ScriptAPI;
import org.jdownloader.extensions.eventscripter.sandboxobjects.ArchiveSandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.DownloadLinkSandBox;
import org.jdownloader.extensions.extraction.Archive;
import org.jdownloader.extensions.extraction.contextmenu.downloadlist.ArchiveValidator;
import org.jdownloader.gui.views.components.packagetable.LinkTreeUtils;
import org.jdownloader.gui.views.downloads.table.DownloadsTableModel;

@ScriptAPI(description="The context download list package")
public class FilePackageSandBox {
    private final FilePackage filePackage;

    public FilePackageSandBox(FilePackage parentNode) {
        this.filePackage = parentNode;
    }

    public FilePackageSandBox() {
        this(null);
    }

    public long getBytesLoaded() {
        if (this.filePackage == null) {
            return 0L;
        }
        return new FilePackageView(this.filePackage).aggregate().getDone();
    }

    public ArchiveSandbox[] getArchives() {
        if (this.filePackage == null) {
            return null;
        }
        final ArrayList list = new ArrayList();
        this.filePackage.getModifyLock().runReadLock(new Runnable(){

            @Override
            public void run() {
                List archives = ArchiveValidator.getArchivesFromPackageChildren((List)FilePackageSandBox.this.filePackage.getChildren());
                if (archives != null) {
                    for (Archive archive : archives) {
                        list.add(new ArchiveSandbox(archive));
                    }
                }
            }
        });
        return list.toArray(new ArchiveSandbox[0]);
    }

    public DownloadLinkSandBox[] getDownloadLinks() {
        if (this.filePackage == null) {
            return null;
        }
        final ArrayList ret = new ArrayList();
        this.filePackage.getModifyLock().runReadLock(new Runnable(){

            @Override
            public void run() {
                for (DownloadLink link : FilePackageSandBox.this.filePackage.getChildren()) {
                    ret.add(new DownloadLinkSandBox(link));
                }
            }
        });
        return ret.toArray(new DownloadLinkSandBox[0]);
    }

    public long getBytesTotal() {
        if (this.filePackage == null) {
            return 0L;
        }
        return new FilePackageView(this.filePackage).aggregate().getSize();
    }

    public String getComment() {
        if (this.filePackage == null) {
            return null;
        }
        return this.filePackage.getComment();
    }

    public void setComment(String comment) {
        if (this.filePackage != null) {
            this.filePackage.setComment(comment);
        }
    }

    public void setName(String name) {
        if (this.filePackage != null) {
            this.filePackage.setName(name);
        }
    }

    public int hashCode() {
        if (this.filePackage != null) {
            return this.filePackage.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilePackageSandBox) {
            return ((FilePackageSandBox)obj).filePackage == this.filePackage;
        }
        return super.equals(obj);
    }

    public boolean isFinished() {
        if (this.filePackage == null) {
            return false;
        }
        return new FilePackageView(this.filePackage).aggregate().isFinished();
    }

    public boolean remove() {
        if (this.filePackage != null && !FilePackage.isDefaultFilePackage((AbstractPackageNode)this.filePackage)) {
            PackageController controller = this.filePackage.getControlledBy();
            if (controller != null) {
                controller.removePackage((AbstractPackageNode)this.filePackage);
                return true;
            }
            return false;
        }
        return false;
    }

    public String getUUID() {
        if (this.filePackage != null) {
            return this.filePackage.getUniqueID().toString();
        }
        return null;
    }

    public long getAddedDate() {
        if (this.filePackage != null) {
            return this.filePackage.getCreated();
        }
        return -1L;
    }

    public long getFinishedDate() {
        if (this.filePackage != null) {
            return new FilePackageView(this.filePackage).aggregate().getFinishedDate();
        }
        return -1L;
    }

    public String getDownloadFolder() {
        if (this.filePackage == null) {
            return Application.getResource((String)"").getAbsolutePath();
        }
        return LinkTreeUtils.getDownloadDirectory((AbstractNode)this.filePackage).getAbsolutePath();
    }

    public void setDownloadFolder(String downloadFolder) {
        if (this.filePackage != null) {
            DownloadWatchDog.getInstance().setDownloadDirectory(this.filePackage, downloadFolder);
        }
    }

    public String toString() {
        return "FilePackage Instance: " + this.getName();
    }

    public String getPriority() {
        if (this.filePackage != null) {
            return this.filePackage.getPriorityEnum().name();
        }
        return Priority.DEFAULT.name();
    }

    public void setProperty(String key, Object value) {
        if (this.filePackage != null) {
            if (value != null && !this.canStore(value)) {
                throw new WTFException("Type " + value.getClass().getSimpleName() + " is not supported");
            }
            this.filePackage.setProperty(key, value);
        }
    }

    public Object getProperty(String key) {
        if (this.filePackage != null) {
            return this.filePackage.getProperty(key);
        }
        return null;
    }

    public long getModifiedDate() {
        if (this.filePackage == null) {
            return this.filePackage.getModified();
        }
        return -1L;
    }

    public boolean isExpanded() {
        return this.filePackage != null && this.filePackage.isExpanded();
    }

    public void setExpanded(boolean b) {
        if (this.filePackage != null) {
            if (Application.isHeadless()) {
                this.filePackage.setExpanded(b);
            } else {
                DownloadsTableModel.getInstance().setFilePackageExpand(b, new AbstractPackageNode[]{this.filePackage});
            }
        }
    }

    public int indexOf(DownloadLinkSandBox link) {
        if (this.filePackage != null && link != null && link.downloadLink != null) {
            return this.filePackage.indexOf(link.downloadLink);
        }
        return -1;
    }

    public Map<String, Object> getProperties() {
        if (this.filePackage != null) {
            return this.filePackage.getProperties();
        }
        return null;
    }

    private boolean canStore(Object value) {
        return value == null || Clazz.isPrimitive(value.getClass()) || JsonKeyValueStorage.isWrapperType(value.getClass()) || value instanceof Storable;
    }

    public void setPriority(String priority) {
        if (this.filePackage != null) {
            try {
                this.filePackage.setPriorityEnum(Priority.valueOf((String)priority));
            }
            catch (Throwable e) {
                this.filePackage.setPriorityEnum(Priority.DEFAULT);
            }
        }
    }

    public String getName() {
        if (this.filePackage == null) {
            return "Example FilePackage Name";
        }
        return this.filePackage.getName();
    }
}

