/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.eventscripter.sandboxobjects;

import java.io.File;
import java.io.IOException;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.plugins.LinkInfo;
import org.appwork.utils.Files;
import org.appwork.utils.IO;
import org.jdownloader.extensions.eventscripter.EnvironmentException;
import org.jdownloader.extensions.eventscripter.sandboxobjects.LinkInfoSandbox;
import org.jdownloader.extensions.eventscripter.sandboxobjects.ScriptEnvironment;

public class FilePathSandbox {
    protected final File file;

    public FilePathSandbox(String fileOrUrl) {
        this(new File(fileOrUrl));
    }

    protected FilePathSandbox(File file) {
        this.file = file;
    }

    public int hashCode() {
        if (this.file != null) {
            return this.file.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilePathSandbox) {
            File fA = ((FilePathSandbox)obj).file;
            File fB = this.file;
            return fA == fB || fA != null && fA.equals(fB);
        }
        return super.equals(obj);
    }

    public boolean isFile() throws EnvironmentException {
        ScriptEnvironment.askForPermission("check if a filepath is a file");
        boolean ret = this.file.isFile();
        return ret;
    }

    public boolean isDirectory() throws EnvironmentException {
        ScriptEnvironment.askForPermission("check if a filepath is a directory");
        boolean ret = this.file.isDirectory();
        return ret;
    }

    public boolean exists() throws EnvironmentException {
        ScriptEnvironment.askForPermission("check if a filepath exists");
        boolean ret = this.file.exists();
        return ret;
    }

    public boolean mkdirs() throws EnvironmentException {
        ScriptEnvironment.askForPermission("create folders");
        boolean ret = this.file.mkdirs();
        return ret;
    }

    public long getModifiedDate() {
        long ret = this.file.lastModified();
        return ret;
    }

    public long getCreatedDate() {
        return -1L;
    }

    public FilePathSandbox getParent() {
        return this.newFilePathSandbox(this.file.getParentFile());
    }

    protected FilePathSandbox newFilePathSandbox(File file) {
        return new FilePathSandbox(file);
    }

    public FilePathSandbox[] getChildren() {
        FilePathSandbox[] ret;
        File[] files = this.file.listFiles();
        if (files == null || files.length == 0) {
            ret = new FilePathSandbox[]{};
        } else {
            ret = new FilePathSandbox[files.length];
            for (int i = 0; i < files.length; ++i) {
                ret[i] = this.newFilePathSandbox(files[i].getAbsoluteFile());
            }
        }
        return ret;
    }

    public String getPath() {
        return this.file.getPath();
    }

    public boolean renameTo(String to) throws EnvironmentException {
        return this.rename(to) != null;
    }

    public FilePathSandbox renameName(String newName) throws EnvironmentException {
        ScriptEnvironment.askForPermission("rename file or folder name only");
        File dst = new File(this.file.getParentFile(), newName);
        if (this.file.renameTo(dst)) {
            return this.newFilePathSandbox(dst);
        }
        return null;
    }

    public FilePathSandbox rename(String newDest) throws EnvironmentException {
        ScriptEnvironment.askForPermission("rename file or folder");
        File dst = new File(newDest);
        if (this.file.renameTo(dst)) {
            return this.newFilePathSandbox(dst);
        }
        return null;
    }

    public FilePathSandbox renamePath(String newPath) throws EnvironmentException {
        ScriptEnvironment.askForPermission("rename file or folder path only");
        File dst = new File(newPath, this.getName());
        if (this.file.renameTo(dst)) {
            return this.newFilePathSandbox(dst);
        }
        return null;
    }

    public boolean moveTo(String folder) throws EnvironmentException {
        ScriptEnvironment.askForPermission("move a file to a new folder");
        File dest = new File(folder);
        if (!dest.exists()) {
            this.newFilePathSandbox(dest).mkdirs();
        }
        dest = new File(dest, this.file.getName());
        boolean ret = this.file.renameTo(dest);
        return ret;
    }

    public String getPathSeparator() {
        return File.separator;
    }

    public long getFreeDiskSpace() {
        File file = this.getFile();
        if (file == null) {
            return 0L;
        }
        return Files.getUsableSpace((File)file);
    }

    public long getReservedDiskSpace() {
        File file = this.getFile();
        if (file == null) {
            return 0L;
        }
        return DownloadWatchDog.getInstance().getSession().getDiskSpaceManager().getReservedDiskSpace(file, (Object)this);
    }

    public LinkInfoSandbox getLinkInfo() {
        File file = this.getFile();
        if (file == null) {
            return null;
        }
        LinkInfo info = LinkInfo.getLinkInfo((File)file);
        if (info != null) {
            return new LinkInfoSandbox(info);
        }
        return null;
    }

    public boolean copyTo(String destDirectory, String destName, boolean overwrite) throws EnvironmentException {
        if (this.isFile()) {
            File dest;
            if (destDirectory != null && destName != null) {
                ScriptEnvironment.askForPermission("copy a file to a new file");
                dest = new File(new File(destDirectory), destName);
            } else if (destDirectory == null && destName != null) {
                ScriptEnvironment.askForPermission("copy a file to a new file");
                dest = new File(this.getFile().getParentFile(), destName);
            } else if (destDirectory != null && destName == null) {
                ScriptEnvironment.askForPermission("copy a file to a new folder");
                dest = new File(new File(destDirectory), this.getFile().getName());
            } else {
                return false;
            }
            if (!(!dest.exists() || overwrite && dest.delete())) {
                return false;
            }
            if (!dest.getParentFile().exists()) {
                dest.getParentFile().mkdirs();
            }
            try {
                IO.copyFile((File)this.file, (File)dest);
                return true;
            }
            catch (IOException e) {
                throw new EnvironmentException(e);
            }
        }
        return false;
    }

    public boolean copyTo(String folder) throws EnvironmentException {
        if (this.isFile()) {
            ScriptEnvironment.askForPermission("copy a file to a new folder");
            File dest = new File(folder);
            if (!dest.exists()) {
                dest.mkdirs();
            }
            dest = new File(dest, this.file.getName());
            try {
                if (!dest.exists()) {
                    IO.copyFile((File)this.file, (File)dest);
                    return true;
                }
            }
            catch (IOException e) {
                throw new EnvironmentException(e);
            }
        }
        return false;
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    protected File getFile() {
        return this.file;
    }

    public String toString() {
        return this.getPath();
    }

    public boolean delete() throws EnvironmentException {
        ScriptEnvironment.askForPermission("delete a file or folder");
        return this.file.delete();
    }

    public boolean deleteRecursive() throws EnvironmentException {
        ScriptEnvironment.askForPermission("delete a file or folder RECURSIVE");
        try {
            Files.deleteRecursiv((File)this.file);
        }
        catch (IOException e) {
            throw new EnvironmentException(e);
        }
        return this.file.exists();
    }

    public String getName() {
        return this.file.getName();
    }

    public String getExtension() {
        return Files.getExtension((String)this.file.getName());
    }

    public long getSize() throws EnvironmentException {
        ScriptEnvironment.askForPermission("get the size of a file");
        return this.file.length();
    }
}

