/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.eventscripter.sandboxobjects;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.appwork.utils.Files17;
import org.jdownloader.extensions.eventscripter.sandboxobjects.FilePathSandbox;

public class FilePathSandbox17
extends FilePathSandbox {
    public FilePathSandbox17(String fileOrUrl) {
        super(fileOrUrl);
    }

    protected FilePathSandbox17(File file) {
        super(file);
    }

    @Override
    public long getModifiedDate() {
        File file = this.getFile();
        try {
            if (file != null) {
                return Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime().toMillis();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1L;
    }

    @Override
    protected FilePathSandbox newFilePathSandbox(File file) {
        return new FilePathSandbox17(file);
    }

    @Override
    public long getFreeDiskSpace() {
        File file = this.getFile();
        if (file != null) {
            try {
                return Files17.getUsableSpace((Path)file.toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.getFreeDiskSpace();
    }

    @Override
    public long getCreatedDate() {
        File file = this.getFile();
        try {
            if (file != null) {
                return Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]).creationTime().toMillis();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1L;
    }
}

