/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.extensions.eventscripter.sandboxobjects;

import jd.controlling.proxy.AbstractProxySelectorImpl;
import jd.controlling.proxy.PacProxySelectorImpl;
import jd.controlling.proxy.ProxyController;
import jd.controlling.proxy.SingleBasicProxySelectorImpl;

public class HTTPProxySandbox {
    private final AbstractProxySelectorImpl proxy;

    public HTTPProxySandbox() {
        this(null);
    }

    public HTTPProxySandbox(AbstractProxySelectorImpl proxy) {
        this.proxy = proxy;
    }

    public String getType() {
        return this.proxy != null ? String.valueOf(this.proxy.getType()) : AbstractProxySelectorImpl.Type.NONE.name();
    }

    public String toExportString() {
        return this.proxy != null ? this.proxy.toExportString() : "none://";
    }

    public boolean isEnabled() {
        return this.proxy != null && this.proxy.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        ProxyController.getInstance().setEnabled(this.proxy, enabled);
    }

    public int indexOf() {
        if (this.proxy != null) {
            return ProxyController.getInstance().indexOf(this.proxy);
        }
        return -1;
    }

    public boolean remove() {
        if (this.indexOf() >= 0) {
            ProxyController.getInstance().remove(this.proxy);
            return true;
        }
        return false;
    }

    public String getUsername() {
        if (this.proxy instanceof PacProxySelectorImpl) {
            return ((PacProxySelectorImpl)this.proxy).getUser();
        }
        if (this.proxy instanceof SingleBasicProxySelectorImpl) {
            SingleBasicProxySelectorImpl p = (SingleBasicProxySelectorImpl)this.proxy;
            switch (p.getType()) {
                case DIRECT: 
                case NONE: {
                    return null;
                }
            }
            return p._getUsername();
        }
        return null;
    }

    public String getPassword() {
        if (this.proxy instanceof PacProxySelectorImpl) {
            return ((PacProxySelectorImpl)this.proxy).getPassword();
        }
        if (this.proxy instanceof SingleBasicProxySelectorImpl) {
            SingleBasicProxySelectorImpl p = (SingleBasicProxySelectorImpl)this.proxy;
            switch (p.getType()) {
                case DIRECT: 
                case NONE: {
                    return null;
                }
            }
            return p._getPassword();
        }
        return null;
    }

    public String getHost() {
        if (this.proxy instanceof PacProxySelectorImpl) {
            PacProxySelectorImpl p = (PacProxySelectorImpl)this.proxy;
            return p.getPACUrl();
        }
        if (this.proxy instanceof SingleBasicProxySelectorImpl) {
            SingleBasicProxySelectorImpl p = (SingleBasicProxySelectorImpl)this.proxy;
            switch (p.getType()) {
                case DIRECT: {
                    return p.getProxy().getLocal();
                }
                case NONE: {
                    return null;
                }
            }
            return p.getHost();
        }
        return null;
    }

    public int getPort() {
        if (this.proxy instanceof SingleBasicProxySelectorImpl) {
            SingleBasicProxySelectorImpl p = (SingleBasicProxySelectorImpl)this.proxy;
            switch (p.getType()) {
                case DIRECT: 
                case NONE: {
                    return -1;
                }
            }
            return p.getPort();
        }
        return -1;
    }
}

