/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.Font;
import com.kitfox.svg.MissingGlyph;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGLoaderHelper;
import com.kitfox.svg.ShapeElement;
import com.kitfox.svg.util.FontUtil;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Tspan
extends ShapeElement {
    public static final String TAG_NAME = "tspan";
    float[] x = null;
    float[] y = null;
    float[] dx = null;
    float[] dy = null;
    float[] rotate = null;
    float textLength = -1.0f;
    String lengthAdjust = "spacing";
    private final List<Serializable> content = new ArrayList<Serializable>();
    protected final ArrayList<TextSegment> segments = new ArrayList();
    protected Rectangle2D textBounds;
    protected Path2D fullPath;
    protected FontUtil.FontInfo fontInfo;
    private Font font;

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public void loaderAddChild(SVGLoaderHelper helper, SVGElement child) throws SVGElementException {
        super.loaderAddChild(helper, child);
        this.content.add(child);
    }

    @Override
    public void loaderAddText(SVGLoaderHelper helper, String text) {
        Matcher matchWs = Pattern.compile("\\s*").matcher(text);
        if (!matchWs.matches()) {
            this.content.add((Serializable)((Object)text));
        }
    }

    public List<Serializable> getContent() {
        return this.content;
    }

    public void clearContent() {
        this.content.clear();
    }

    public void appendText(String text) {
        this.content.add((Serializable)((Object)text));
    }

    public void appendTspan(Tspan tspan) throws SVGElementException {
        super.loaderAddChild(null, tspan);
        this.content.add(tspan);
    }

    protected void buildAttributes(StyleAttribute sty) throws SVGException {
        if (this.getPres(sty.setName("x"))) {
            this.x = sty.getFloatListWithUnits();
        }
        if (this.getPres(sty.setName("y"))) {
            this.y = sty.getFloatListWithUnits();
        }
        if (this.getPres(sty.setName("dx"))) {
            this.dx = sty.getFloatListWithUnits();
        }
        if (this.getPres(sty.setName("dy"))) {
            this.dy = sty.getFloatListWithUnits();
        }
        if (this.getPres(sty.setName("rotate"))) {
            this.rotate = sty.getFloatList();
            int i = 0;
            while (i < this.rotate.length) {
                this.rotate[i] = (float)Math.toRadians(this.rotate[i]);
                ++i;
            }
        }
        this.textLength = this.getStyle(sty.setName("textLength")) ? sty.getFloatValueWithUnits() : -1.0f;
        this.lengthAdjust = this.getStyle(sty.setName("lengthAdjust")) ? sty.getStringValue() : "spacing";
    }

    protected void buildShapeInformation() throws SVGException {
        StyleAttribute sty = new StyleAttribute();
        this.buildAttributes(sty);
        this.fontInfo = FontUtil.parseFontInfo(this, sty);
        this.font = FontUtil.getFont(this.fontInfo, this.diagram);
    }

    protected void buildTextShape(Cursor cursor) throws SVGException {
        this.buildShapeInformation();
        this.fullPath = new GeneralPath();
        this.segments.clear();
        this.segments.ensureCapacity(this.content.size());
        int currentCursorOffset = cursor.offset;
        cursor.offset = 0;
        AffineTransform transform = new AffineTransform();
        float spaceAdvance = this.font.getGlyph(" ").getHorizAdvX();
        for (Serializable obj : this.content) {
            if (obj instanceof String) {
                String text = (String)((Object)obj);
                String trimmed = text.trim();
                if (!text.isEmpty() && text.charAt(0) <= ' ') {
                    cursor.x += this.font.getGlyph(" ").getHorizAdvX();
                }
                Path2D textPath = this.createStringSegmentPath(trimmed, this.font, cursor, transform);
                if (!text.isEmpty() && text.charAt(text.length() - 1) <= ' ') {
                    cursor.x += spaceAdvance;
                }
                this.fullPath.append(textPath, false);
                this.segments.add(new TextSegment(textPath, this));
                continue;
            }
            if (!(obj instanceof Tspan)) continue;
            Tspan tspan = (Tspan)obj;
            tspan.buildTextShape(cursor);
            this.fullPath.append(tspan.fullPath, false);
            this.segments.add(new TextSegment(null, (Tspan)obj));
        }
        this.textBounds = this.fullPath.getBounds2D();
        cursor.offset += currentCursorOffset;
    }

    private Path2D createStringSegmentPath(String text, Font font, Cursor cursor, AffineTransform xform) {
        GeneralPath textPath = new GeneralPath();
        int i = 0;
        while (i < text.length()) {
            String unicode;
            MissingGlyph glyph;
            Shape path;
            cursor.x = this.getXCursorForIndex(cursor.x, cursor.offset + i);
            cursor.y = this.getYCursorForIndex(cursor.y, cursor.offset + i);
            xform.setToTranslation(cursor.x, cursor.y);
            if (this.rotate != null && cursor.offset + i < this.rotate.length) {
                xform.rotate(this.rotate[cursor.offset + i]);
            }
            if ((path = (glyph = font.getGlyph(unicode = text.substring(i, i + 1))).getPath()) != null) {
                path = xform.createTransformedShape(path);
                textPath.append(path, false);
            }
            cursor.x += glyph.getHorizAdvX() + this.fontInfo.letterSpacing;
            ++i;
        }
        cursor.offset += text.length();
        this.strokeWidthScalar = 1.0f;
        return textPath;
    }

    protected Cursor createInitialCursor() {
        return new Cursor(this.getXCursorForIndex(0.0f, 0), this.getYCursorForIndex(0.0f, 0));
    }

    private float getXCursorForIndex(float current, int index) {
        return this.getCursorForIndex(current, index, this.x, this.dx);
    }

    private float getYCursorForIndex(float current, int index) {
        return this.getCursorForIndex(current, index, this.y, this.dy);
    }

    private float getCursorForIndex(float current, int index, float[] absolutes, float[] deltas) {
        if (absolutes != null && index < absolutes.length) {
            current = absolutes[index];
        } else if (deltas != null && index < deltas.length) {
            current += deltas[index];
        }
        return current;
    }

    @Override
    protected void doRender(Graphics2D g) throws SVGException {
        this.beginLayer(g);
        for (TextSegment segment : this.segments) {
            if (segment.textPath != null) {
                segment.element.renderShape(g, segment.textPath);
                continue;
            }
            segment.element.doRender(g);
        }
        this.finishLayer(g);
    }

    @Override
    public Shape getShape() {
        return this.shapeToParent(this.fullPath);
    }

    @Override
    public Rectangle2D getBoundingBox() {
        return this.boundsToParent(this.textBounds);
    }

    @Override
    public boolean updateTime(double curTime) throws SVGException {
        return false;
    }

    public String getText() {
        return this.getText(new StringBuilder());
    }

    private String getText(StringBuilder builder) {
        for (Serializable serializable : this.content) {
            if (serializable instanceof Tspan) {
                ((Tspan)serializable).getText(builder);
                builder.append(' ');
                continue;
            }
            if (serializable == null) continue;
            builder.append(serializable).append(' ');
        }
        if (builder.length() > 0) {
            return builder.substring(0, builder.length() - 1);
        }
        return "";
    }

    protected static class Cursor {
        float x;
        float y;
        int offset;

        public Cursor(float x, float y) {
            this.x = x;
            this.y = y;
        }
    }

    protected static class TextSegment {
        final Path2D textPath;
        final Tspan element;

        private TextSegment(Path2D textPath, Tspan element) {
            this.textPath = textPath;
            this.element = element;
        }
    }
}

