/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.awt.Color;

public class Colors {
    public static Color getColor(Color color, int alpha) {
        alpha *= 255;
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha /= 100);
    }

    public static float[] rgb2cmyk(int rgb) {
        float r = rgb >> 16 & 0xFF;
        float g = rgb >> 8 & 0xFF;
        float b = rgb & 0xFF;
        float C = 1.0f - r / 255.0f;
        float M = 1.0f - g / 255.0f;
        float Y = 1.0f - b / 255.0f;
        float var_K = 1.0f;
        if (C < var_K) {
            var_K = C;
        }
        if (M < var_K) {
            var_K = M;
        }
        if (Y < var_K) {
            var_K = Y;
        }
        C = (C - var_K) / (1.0f - var_K);
        M = (M - var_K) / (1.0f - var_K);
        Y = (Y - var_K) / (1.0f - var_K);
        return new float[]{C * 100.0f, M * 100.0f, Y * 100.0f, var_K * 100.0f};
    }

    public static double getColorDifference(int[] rgbA, int[] rgbB) {
        int[] labA = Colors.rgb2lab(rgbA[0], rgbA[1], rgbA[2]);
        int[] labB = Colors.rgb2lab(rgbB[0], rgbB[1], rgbB[2]);
        int dif0 = labA[0] - labB[0];
        int dif1 = labA[1] - labB[1];
        int dif2 = labA[2] - labB[2];
        return Math.sqrt(dif0 * dif0 + dif1 * dif1 + dif2 * dif2);
    }

    public static int[] rgb2lab(int R, int G, int B) {
        int[] lab = new int[3];
        float eps = 0.008856452f;
        float k = 903.2963f;
        float Xr = 0.964221f;
        float Yr = 1.0f;
        float Zr = 0.825211f;
        float r = (float)R / 255.0f;
        float g = (float)G / 255.0f;
        float b = (float)B / 255.0f;
        r = (double)r <= 0.04045 ? (r /= 12.0f) : (float)Math.pow(((double)r + 0.055) / 1.055, 2.4);
        g = (double)g <= 0.04045 ? (g /= 12.0f) : (float)Math.pow(((double)g + 0.055) / 1.055, 2.4);
        b = (double)b <= 0.04045 ? (b /= 12.0f) : (float)Math.pow(((double)b + 0.055) / 1.055, 2.4);
        float X = 0.43605202f * r + 0.3850816f * g + 0.14308742f * b;
        float Y = 0.22249159f * r + 0.71688604f * g + 0.060621485f * b;
        float Z = 0.013929122f * r + 0.097097f * g + 0.7141855f * b;
        float xr = X / Xr;
        float yr = Y / Yr;
        float zr = Z / Zr;
        float fx = xr > eps ? (float)Math.pow(xr, 0.3333333333333333) : (float)(((double)(k * xr) + 16.0) / 116.0);
        float fy = yr > eps ? (float)Math.pow(yr, 0.3333333333333333) : (float)(((double)(k * yr) + 16.0) / 116.0);
        float fz = zr > eps ? (float)Math.pow(zr, 0.3333333333333333) : (float)(((double)(k * zr) + 16.0) / 116.0);
        float Ls = 116.0f * fy - 16.0f;
        float as = 500.0f * (fx - fy);
        float bs = 200.0f * (fy - fz);
        lab[0] = (int)(2.55 * (double)Ls + 0.5);
        lab[1] = (int)((double)as + 0.5);
        lab[2] = (int)((double)bs + 0.5);
        return lab;
    }

    public static float[] rgb2hsb(int r, int g, int b) {
        float[] hsbvals = new float[3];
        Color.RGBtoHSB(r, g, b, hsbvals);
        return hsbvals;
    }

    public static float[] rgb2hsb(int pixelValue) {
        int[] rgbA = Colors.hexToRgb(pixelValue);
        return Colors.rgb2hsb(rgbA[0], rgbA[1], rgbA[2]);
    }

    public static int[] rgb2hsv(int pixelValue) {
        int[] rgbA = Colors.hexToRgb(pixelValue);
        float[] hsb = Colors.rgb2hsb(rgbA[0], rgbA[1], rgbA[2]);
        return new int[]{Math.round(hsb[0] * 360.0f), Math.round(hsb[1] * 100.0f), Math.round(hsb[2] * 100.0f)};
    }

    public static int rgbToHex(int[] value) {
        return (value[0] << 16) + (value[1] << 8) + value[2];
    }

    public static int mixColors(int a, int b, int ga, int gb) {
        int[] av = Colors.hexToRgb(a);
        int[] bv = Colors.hexToRgb(b);
        int R = (av[0] * ga + bv[0] * gb) / (ga + gb);
        int G = (av[1] * ga + bv[1] * gb) / (ga + gb);
        int B = (av[2] * ga + bv[2] * gb) / (ga + gb);
        return Colors.rgbToHex(new int[]{R, G, B});
    }

    public static int mixColors(int a, int b) {
        int[] av = Colors.hexToRgb(a);
        int[] bv = Colors.hexToRgb(b);
        int[] ret = new int[]{(int)((long)av[0] + (long)bv[0] >> 1), (int)((long)av[1] + (long)bv[1] >> 1), (int)((long)av[2] + (long)bv[2] >> 1)};
        return Colors.rgbToHex(ret);
    }

    public static int[] hexToRgb(int value) {
        return new int[]{value >> 16 & 0xFF, value >> 8 & 0xFF, value & 0xFF, 0};
    }

    public static int[] getRGB(int a) {
        Color aa = new Color(a);
        return new int[]{aa.getRed(), aa.getGreen(), aa.getBlue()};
    }

    public static double getHueColorDifference(int a, int b) {
        if (a == b) {
            return 0.0;
        }
        return Colors.getHueColorDifference(Colors.getRGB(a), Colors.getRGB(b));
    }

    public static double getHueColorDifference(int[] rgbA, int[] rgbB) {
        float hsbA = Colors.rgb2hsb(rgbA[0], rgbA[1], rgbA[2])[0] * 100.0f;
        float hsbB = Colors.rgb2hsb(rgbB[0], rgbB[1], rgbB[2])[0] * 100.0f;
        double dif = Math.abs((double)(hsbA - hsbB));
        return dif;
    }

    public static double getHueColorDifference360(int a, int b) {
        if (a == b) {
            return 0.0;
        }
        return Colors.getHueColorDifference360(Colors.getRGB(a), Colors.getRGB(b));
    }

    public static double getHueColorDifference360(int[] rgbA, int[] rgbB) {
        float hsbA = Colors.rgb2hsb(rgbA[0], rgbA[1], rgbA[2])[0] * 360.0f;
        float hsbB = Colors.rgb2hsb(rgbB[0], rgbB[1], rgbB[2])[0] * 360.0f;
        double dif = Math.abs((double)(hsbA - hsbB));
        return dif;
    }

    public static double getSaturationColorDifference(int a, int b) {
        if (a == b) {
            return 0.0;
        }
        return Colors.getSaturationColorDifference(Colors.getRGB(a), Colors.getRGB(b));
    }

    public static double getSaturationColorDifference(int[] rgbA, int[] rgbB) {
        float hsbA = Colors.rgb2hsb(rgbA[0], rgbA[1], rgbA[2])[1] * 100.0f;
        float hsbB = Colors.rgb2hsb(rgbB[0], rgbB[1], rgbB[2])[1] * 100.0f;
        double dif = Math.abs((double)(hsbA - hsbB));
        return dif;
    }

    public static double getBrightnessColorDifference(int a, int b) {
        if (a == b) {
            return 0.0;
        }
        return Colors.getBrightnessColorDifference(Colors.getRGB(a), Colors.getRGB(b));
    }

    public static double getBrightnessColorDifference(int[] rgbA, int[] rgbB) {
        float hsbA = Colors.rgb2hsb(rgbA[0], rgbA[1], rgbA[2])[2] * 100.0f;
        float hsbB = Colors.rgb2hsb(rgbB[0], rgbB[1], rgbB[2])[2] * 100.0f;
        double dif = Math.abs((double)(hsbA - hsbB));
        return dif;
    }

    public static double getColorDifference(int a, int b) {
        if (a == b) {
            return 0.0;
        }
        return Colors.getColorDifference(Colors.getRGB(a), Colors.getRGB(b));
    }

    public static int getRGBDistance(int color) {
        Color c = new Color(color);
        int br = Math.abs(c.getBlue() - c.getRed());
        int bg = Math.abs(c.getBlue() - c.getGreen());
        int rg = Math.abs(c.getGreen() - c.getRed());
        return (br + bg + rg) / 3;
    }

    public static double getRGBColorDifference2(int color, int color2) {
        if (color == color2) {
            return 0.0;
        }
        Color c = new Color(color);
        Color c2 = new Color(color2);
        int dif0 = c.getRed() - c2.getRed();
        int dif1 = c.getGreen() - c2.getGreen();
        int dif2 = c.getBlue() - c2.getBlue();
        return (Math.abs(dif0) + Math.abs(dif1) + Math.abs(dif2)) / 3;
    }

    public static double getRGBColorDifference3(int color, int color2) {
        if (color == color2) {
            return 0.0;
        }
        Color c = new Color(color);
        Color c2 = new Color(color2);
        int dif0 = c.getRed() - c2.getRed();
        int dif1 = c.getGreen() - c2.getGreen();
        int dif2 = c.getBlue() - c2.getBlue();
        return Math.max(Math.abs(dif0), Math.max(Math.abs(dif1), Math.abs(dif2)));
    }

    public static double getRGBColorDifference1(int color, int color2) {
        if (color == color2) {
            return 0.0;
        }
        Color c = new Color(color);
        Color c2 = new Color(color2);
        int dif0 = c.getRed() - c2.getRed();
        int dif1 = c.getGreen() - c2.getGreen();
        int dif2 = c.getBlue() - c2.getBlue();
        return Math.sqrt(dif0 * dif0 + dif1 * dif1 + dif2 * dif2);
    }

    public static double getCMYKColorDifference1(int rgbcolor, int rgbcolor2) {
        if (rgbcolor == rgbcolor2) {
            return 0.0;
        }
        float[] cmyk1 = Colors.rgb2cmyk(rgbcolor);
        float[] cmyk2 = Colors.rgb2cmyk(rgbcolor2);
        double dif0 = cmyk1[0] - cmyk2[0];
        double dif1 = cmyk1[1] - cmyk2[1];
        double dif2 = cmyk1[2] - cmyk2[2];
        double dif3 = cmyk1[3] - cmyk2[3];
        return Math.sqrt(dif0 * dif0 + dif1 * dif1 + dif2 * dif2 + dif3 * dif3);
    }
}

