/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import jd.nutils.encoding.Encoding;
import jd.parser.Regex;
import org.appwork.utils.formatter.StringFormatter;

public class Formatter {
    private static SimpleDateFormat DATE_FORMAT = null;

    public static String formatSeconds(long eta) {
        return Formatter.formatSeconds(eta, true);
    }

    public static String formatSeconds(long eta, boolean showsec) {
        int numFill;
        if (eta < 0L) {
            return "~";
        }
        long days = eta / 86400L;
        long hours = (eta -= days * 24L * 60L * 60L) / 3600L;
        long minutes = (eta -= hours * 60L * 60L) / 60L;
        long seconds = eta - minutes * 60L;
        StringBuilder ret = new StringBuilder();
        if (days != 0L) {
            ret.append(days).append('d');
        }
        if (hours != 0L || ret.length() != 0) {
            if (ret.length() != 0) {
                ret.append(':');
            }
            ret.append(hours).append('h');
        }
        if (minutes != 0L || ret.length() != 0) {
            int n = numFill = ret.length() != 0 ? 2 : 1;
            if (ret.length() != 0) {
                ret.append(':');
            }
            ret.append(Formatter.fillInteger(minutes, numFill, "0")).append('m');
        }
        if (showsec) {
            int n = numFill = ret.length() != 0 ? 2 : 1;
            if (ret.length() != 0) {
                ret.append(':');
            }
            ret.append(Formatter.fillInteger(seconds, numFill, "0")).append('s');
        }
        return ret.toString();
    }

    public static String formatMilliseconds(long ms) {
        return Formatter.formatSeconds(ms / 1000L) + "." + Formatter.fillInteger(ms % 1000L, 3, "0");
    }

    @Deprecated
    public static String formatFilesize(double value, int size) {
        if (value > 1024.0 && size < 5) {
            return Formatter.formatFilesize(value / 1024.0, ++size);
        }
        DecimalFormat c = new DecimalFormat();
        switch (size) {
            case 0: {
                return c.format(value) + " B";
            }
            case 1: {
                return c.format(value) + " KiB";
            }
            case 2: {
                return c.format(value) + " MiB";
            }
            case 3: {
                return c.format(value) + " GiB";
            }
            case 4: {
                return c.format(value) + " TiB";
            }
        }
        return null;
    }

    @Deprecated
    public static String formatReadable(long fileSize) {
        if (fileSize < 0L) {
            fileSize = 0L;
        }
        DecimalFormat c = new DecimalFormat();
        if (fileSize >= 0x10000000000L) {
            return c.format((double)fileSize / 1.099511627776E12) + " TiB";
        }
        if (fileSize >= 0x40000000L) {
            return c.format((double)fileSize / 1.073741824E9) + " GiB";
        }
        if (fileSize >= 0x100000L) {
            return c.format((double)fileSize / 1048576.0) + " MiB";
        }
        if (fileSize >= 1024L) {
            return c.format((double)fileSize / 1024.0) + " KiB";
        }
        return fileSize + " B";
    }

    public static String fillString(String binaryString, String pre, String post, int length) {
        return StringFormatter.fillString((String)binaryString, (String)pre, (String)post, (int)length);
    }

    public static String fillInteger(long i, int num, String fill) {
        String ret = "" + i;
        while (ret.length() < num) {
            ret = fill + ret;
        }
        return ret;
    }

    public static int filterInt(String src) {
        try {
            return Integer.parseInt(Encoding.filterString(src, "1234567890"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static long filterLong(String src) {
        try {
            return Long.parseLong(Encoding.filterString(src, "1234567890"));
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static long getRevision(String rev) {
        if (rev == null) {
            return -1L;
        }
        try {
            String number;
            String base;
            int ret = 0;
            if (!rev.startsWith("$") && (base = new Regex(rev, "Base:\\s*(\\d+)").getMatch(0)) != null) {
                ret = (int)((long)ret + Long.parseLong(base));
            }
            if ((number = new Regex(rev, "Revision:.*?(\\d+)").getMatch(0)) != null) {
                ret = (int)((long)ret + Long.parseLong(number));
                return ret;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return -1L;
    }
}

