/*
 * Decompiled with CFR 0.152.
 */
package jd.nutils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import org.appwork.utils.swing.EDTHelper;

public class Screen {
    public static Point getCenterOfComponent(final Component parent, Component child) {
        Point center = (Point)new EDTHelper<Point>(){

            public Point edtRun() {
                if (parent != null && parent.isShowing()) {
                    return parent.getLocationOnScreen();
                }
                return null;
            }
        }.getReturnValue();
        if (center == null) {
            GraphicsDevice ge = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            Rectangle screenSize = ge.getDefaultConfiguration().getBounds();
            int width = screenSize.width;
            int height = screenSize.height;
            center = new Point(screenSize.x + width / 2, screenSize.y + height / 2);
        } else {
            center.x += parent.getWidth() / 2;
            center.y += parent.getHeight() / 2;
        }
        center.x -= child.getWidth() / 2;
        center.y -= child.getHeight() / 2;
        return center;
    }

    public static Point getDockBottomRight(Component child) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return new Point((int)(screenSize.getWidth() - (double)child.getWidth()), (int)(screenSize.getHeight() - (double)child.getHeight() - 60.0));
    }
}

