/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileFilter;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import jd.captcha.JAntiCaptcha;
import jd.captcha.translate.T;
import jd.captcha.utils.Utilities;
import jd.gui.swing.components.BrowseFile;
import net.miginfocom.swing.MigLayout;
import org.appwork.utils.swing.windowmanager.WindowManager;

public class JACController {
    private static BrowseFile chooser;
    private static JComboBox methods;
    private final JAntiCaptcha jac;
    private final File path;

    public static void showDialog(final boolean isTrain) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.setLayout((LayoutManager)new MigLayout("wrap 2"));
        if (isTrain) {
            frame.setTitle(T.T.train_chooser_title());
        } else {
            frame.setTitle(T.T.showcaptcha_chooser_title());
        }
        frame.setAlwaysOnTop(true);
        frame.setLocation(20, 20);
        File[] meths = new File(Utilities.getMethodDir()).listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        methods = new JComboBox<File>(meths);
        chooser = new BrowseFile();
        if (isTrain) {
            chooser.setFileSelectionMode(1);
        }
        chooser.setEditable(true);
        String chooserText = "";
        chooserText = isTrain ? T.T.train_choose_folder() : T.T.showcaptcha_choose_file();
        frame.add(new JLabel(T.T.train_method()));
        frame.add((Component)methods, "growx, spanx");
        frame.add(new JLabel(chooserText));
        frame.add((Component)chooser, "growx, spanx");
        JButton btnOK = new JButton(T.T.gui_btn_ok());
        btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        JACController jacc = new JACController(new File(chooser.getText()), ((File)methods.getSelectedItem()).getName());
                        if (isTrain) {
                            try {
                                jacc.train();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        } else {
                            try {
                                jacc.showCaptcha();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }).start();
            }
        });
        frame.add((Component)btnOK, "span, right");
        frame.pack();
        frame.setResizable(false);
        WindowManager.getInstance().setVisible((Window)frame, true, WindowManager.FrameState.OS_DEFAULT);
    }

    public JACController(File path, String methode) {
        this.path = path;
        this.jac = new JAntiCaptcha(methode);
    }

    public static void main(String[] args) throws InterruptedException {
        File file = new File("C:\\Users\\Thomas\\.appwork\\captchas\\pybckd\\1337856728166.png");
        new JACController(file, "payback.de").showCaptcha();
    }

    public void showCaptcha() throws InterruptedException {
        this.jac.showPreparedCaptcha(this.path);
    }

    public void train() throws InterruptedException {
        this.jac.trainAllCaptchas(this.path.getAbsolutePath());
        this.jac.saveMTHFile();
    }
}

