/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.easy;

import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jd.captcha.JAntiCaptcha;
import jd.captcha.easy.EasyMethodFile;
import jd.captcha.pixelgrid.Captcha;
import jd.captcha.utils.Utilities;
import org.appwork.utils.ImageProvider.ImageProvider;
import org.jdownloader.logging.LogController;

public class BackgroundFilterCreater {
    public static File create(EasyMethodFile methode) throws InterruptedException {
        return BackgroundFilterCreater.create(methode.getCaptchaFolder().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().matches("(?is).*\\.(jpg|png|gif)");
            }
        }), methode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File create(File[] files, EasyMethodFile methode) throws InterruptedException {
        boolean ignoreBlack = false;
        JAntiCaptcha jac = new JAntiCaptcha(methode.getName());
        Image image = Utilities.loadImage(files[0]);
        Captcha firstCaptcha = jac.createCaptcha(image);
        HashMap[][] grid = new HashMap[firstCaptcha.getWidth()][firstCaptcha.getHeight()];
        for (int x = 0; x < grid.length; ++x) {
            for (int y = 0; y < grid[0].length; ++y) {
                grid[x][y] = new HashMap();
                grid[x][y].put(firstCaptcha.getPixelValue(x, y), 0);
            }
        }
        int i = 0;
        for (File file : files) {
            image = Utilities.loadImage(file);
            Captcha captcha = jac.createCaptcha(image);
            if (captcha == null || captcha.getWidth() != firstCaptcha.getWidth() || captcha.getHeight() != firstCaptcha.getHeight()) {
                LogController.CL().info("ERROR Maske und Bild passen nicht zusammmen");
                continue;
            }
            if (i++ == 100) break;
            for (int x = 0; x < captcha.getWidth(); ++x) {
                for (int y = 0; y < captcha.getHeight(); ++y) {
                    HashMap map = grid[x][y];
                    int val = captcha.getPixelValue(x, y);
                    if (ignoreBlack && val == 0) continue;
                    if (map.containsKey(val)) {
                        map.put(val, (Integer)map.get(val) + 1);
                        continue;
                    }
                    map.put(val, 0);
                }
            }
        }
        for (int x = 0; x < firstCaptcha.getWidth(); ++x) {
            for (int y = 0; y < firstCaptcha.getHeight(); ++y) {
                Set map = grid[x][y].entrySet();
                Map.Entry<Integer, Integer> best = new Map.Entry<Integer, Integer>(){

                    @Override
                    public Integer getKey() {
                        return -1;
                    }

                    @Override
                    public Integer getValue() {
                        return -1;
                    }

                    @Override
                    public Integer setValue(Integer value) {
                        return -1;
                    }
                };
                for (Map.Entry entry : map) {
                    if ((Integer)entry.getValue() <= (Integer)best.getValue()) continue;
                    best = entry;
                }
                firstCaptcha.setPixelValue(x, y, (Integer)best.getKey());
            }
        }
        File ret = new File(methode.file, "mask_" + System.currentTimeMillis() + ".png");
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(ret);
            ImageProvider.writeImage((RenderedImage)firstCaptcha.getImage(), (String)"png", (OutputStream)fos);
        }
        catch (IOException e) {
            LogController.CL().log((Throwable)e);
        }
        finally {
            try {
                fos.close();
            }
            catch (Throwable throwable) {}
        }
        return ret;
    }
}

