/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.easy;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import jd.captcha.JAntiCaptcha;
import jd.captcha.easy.BackGroundImageGUIList;
import jd.captcha.easy.ColorTrainerGUI;
import jd.captcha.easy.CreateHoster;
import jd.captcha.easy.EasyMethodFile;
import jd.captcha.easy.load.LoadCaptchas;
import jd.captcha.translate.T;
import jd.gui.swing.jdgui.views.settings.JDLabelListRenderer;
import jd.gui.swing.laf.LookAndFeelController;
import jd.gui.userio.DummyFrame;
import jd.nutils.Screen;
import jd.utils.JDUtilities;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storage;
import org.appwork.utils.Application;
import org.appwork.utils.swing.EDTHelper;

public class EasyCaptchaTool {
    public static Storage config;
    public static final String CONFIG_LASTSESSION = "CONFIG_LASTSESSION";
    public static final String CONFIG_AUTHOR = "AUTHOR";
    public static JFrame ownerFrame;

    public static void main(String[] args) throws IOException {
        LookAndFeelController.getInstance().setUIManager();
        EasyMethodFile meth = EasyCaptchaTool.getCaptchaMethode();
        EasyCaptchaTool.showToolKid(meth);
    }

    public static EasyMethodFile showMethodes() {
        final EasyMethodFile ef = new EasyMethodFile();
        new EDTHelper<Object>(){

            public Object edtRun() {
                final JDialog cHosterDialog = new JDialog(ownerFrame);
                cHosterDialog.setDefaultCloseOperation(2);
                cHosterDialog.setTitle(T.T.easycaptcha_tool_mothodedialog_title());
                cHosterDialog.setModal(true);
                cHosterDialog.setAlwaysOnTop(true);
                Box box = new Box(1);
                JPanel pa = new JPanel(new GridLayout(2, 1));
                pa.add(new JLabel(T.T.easycaptcha_tool_mothodedialog_selectmethode()));
                EasyMethodFile[] paths = EasyMethodFile.getMethodeList();
                final JComboBox<EasyMethodFile> combox = new JComboBox<EasyMethodFile>(paths);
                combox.setRenderer((ListCellRenderer<EasyMethodFile>)new JDLabelListRenderer());
                combox.setMinimumSize(new Dimension(24, 70));
                pa.add(combox);
                box.add(pa);
                pa = new JPanel(new GridLayout(1, 2));
                JButton ok = new JButton(T.T.gui_btn_ok());
                pa.add(ok);
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EasyMethodFile ef2 = (EasyMethodFile)combox.getSelectedItem();
                        if (ef2 != null) {
                            ef.file = ef2.file;
                            cHosterDialog.dispose();
                        }
                    }
                });
                JButton cancel = new JButton(T.T.gui_btn_cancel());
                pa.add(cancel);
                cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        cHosterDialog.dispose();
                    }
                });
                box.add(pa);
                cHosterDialog.add(box);
                cHosterDialog.pack();
                cHosterDialog.setLocation(Screen.getCenterOfComponent((Component)ownerFrame, (Component)cHosterDialog));
                cHosterDialog.setVisible(true);
                return null;
            }
        }.waitForEDT();
        if (ef.file == null) {
            return null;
        }
        return ef;
    }

    private static EasyMethodFile getCaptchaMethode() {
        return (EasyMethodFile)new EDTHelper<EasyMethodFile>(){

            public EasyMethodFile edtRun() {
                final EasyMethodFile ef = new EasyMethodFile();
                final JDialog dialog = new JDialog(ownerFrame);
                dialog.setDefaultCloseOperation(2);
                dialog.setTitle(T.T.easycaptcha_tool_title());
                dialog.setModal(true);
                JPanel box = new JPanel(new GridLayout(3, 1));
                JButton btcs = new JButton(T.T.easycaptcha_tool_continuelastsession());
                final EasyMethodFile lastEF = (EasyMethodFile)config.get(EasyCaptchaTool.CONFIG_LASTSESSION, null);
                if (lastEF == null) {
                    btcs.setEnabled(false);
                }
                btcs.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ef.file = lastEF.file;
                        new EDTHelper<Object>(){

                            public Object edtRun() {
                                dialog.dispose();
                                return null;
                            }
                        }.waitForEDT();
                    }
                });
                box.add(btcs);
                JButton btl = new JButton(T.T.easycaptcha_tool_loadmethode());
                btl.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EasyMethodFile ef2 = EasyCaptchaTool.showMethodes();
                        if (ef2 != null) {
                            ef.file = ef2.file;
                            dialog.dispose();
                        }
                    }
                });
                box.add(btl);
                JButton btc = new JButton(T.T.easycaptcha_tool_createmethode());
                btc.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        new EDTHelper<Object>(){

                            public Object edtRun() {
                                final JDialog cHosterDialog = new JDialog(ownerFrame);
                                cHosterDialog.setAlwaysOnTop(true);
                                cHosterDialog.setDefaultCloseOperation(2);
                                cHosterDialog.setTitle(T.T.easycaptcha_tool_title());
                                cHosterDialog.setModal(true);
                                JPanel box = new JPanel(new GridLayout(4, 2));
                                final JTextField tfHoster = new JTextField();
                                box.add(new JLabel(T.T.gui_column_host() + ":"));
                                box.add(tfHoster);
                                final JTextField tfAuthor = new JTextField((String)config.get(EasyCaptchaTool.CONFIG_AUTHOR, (Object)"JDTeam"));
                                box.add(new JLabel(T.T.gui_config_jac_column_author() + ":"));
                                box.add(tfAuthor);
                                final JSpinner spMaxLetters = new JSpinner(new SpinnerNumberModel(4, 1, 40, 1));
                                box.add(new JLabel(T.T.easycaptcha_tool_maxletternum() + ":"));
                                box.add(spMaxLetters);
                                JButton ok = new JButton(T.T.gui_btn_ok());
                                box.add(ok);
                                ok.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        if (tfHoster.getText() != null && !tfHoster.getText().matches("\\s*")) {
                                            ef.file = new File(JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath() + "/" + JDUtilities.getJACMethodsDirectory(), tfHoster.getText());
                                            dialog.dispose();
                                            cHosterDialog.dispose();
                                            if (tfAuthor.getText() != null && !tfAuthor.getText().matches("\\s*")) {
                                                config.put(EasyCaptchaTool.CONFIG_AUTHOR, tfAuthor.getText());
                                            }
                                            CreateHoster.create(new EasyMethodFile("easycaptcha"), ef, tfAuthor.getText(), (Integer)spMaxLetters.getValue());
                                        } else {
                                            JOptionPane.showConfirmDialog(null, T.T.easycaptcha_tool_warning_hostnamemissing(), T.T.easycaptcha_tool_warning_hostnamemissing(), -1, 2);
                                        }
                                    }
                                });
                                JButton cancel = new JButton(T.T.gui_btn_cancel());
                                box.add(cancel);
                                cancel.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        cHosterDialog.dispose();
                                    }
                                });
                                cHosterDialog.add(box);
                                cHosterDialog.pack();
                                cHosterDialog.setLocation(Screen.getCenterOfComponent((Component)ownerFrame, (Component)cHosterDialog));
                                cHosterDialog.setVisible(true);
                                return null;
                            }
                        }.waitForEDT();
                    }
                });
                box.add(btc);
                dialog.add(box);
                dialog.pack();
                dialog.setLocation(Screen.getCenterOfComponent((Component)ownerFrame, (Component)dialog));
                dialog.setVisible(true);
                if (ef.file != null) {
                    EasyCaptchaTool.saveConfig();
                    return ef;
                }
                return null;
            }
        }.getReturnValue();
    }

    public static void saveConfig() {
        config.save();
    }

    public static void checkReadyToTrain(final EasyMethodFile meth, final JButton btnTrain) {
        new EDTHelper<Object>(){

            public Object edtRun() {
                btnTrain.setEnabled(meth.isReadyToTrain());
                return null;
            }
        }.waitForEDT();
    }

    public static void showToolKid(final EasyMethodFile meth) {
        CreateHoster.setImageType(meth);
        File folder = meth.getCaptchaFolder();
        if (!folder.exists() || folder.list().length < 1) {
            System.exit(0);
        }
        final JAntiCaptcha jac = new JAntiCaptcha(meth.getName());
        JDialog dialog = new JDialog(ownerFrame);
        dialog.setAlwaysOnTop(true);
        dialog.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        dialog.setLocation(Screen.getCenterOfComponent((Component)ownerFrame, (Component)dialog));
        dialog.setTitle(T.T.easycaptcha_tool_title());
        JPanel box = new JPanel(new GridLayout(5, 1));
        final JButton btnTrain = new JButton(T.T.easycaptcha_tool_btn_train());
        btnTrain.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            jac.trainAllCaptchas(meth.getCaptchaFolder().getAbsolutePath());
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }).start();
            }
        });
        box.add(btnTrain);
        JButton btnShowLetters = new JButton(T.T.easycaptcha_tool_btn_letterdb());
        btnShowLetters.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        jac.displayLibrary();
                    }
                }).start();
            }
        });
        box.add(btnShowLetters);
        JButton btnColorTrainer = new JButton(T.T.easycaptcha_tool_btn_colortrainer());
        btnColorTrainer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ColorTrainerGUI.getColor(meth, ownerFrame);
                            EasyCaptchaTool.checkReadyToTrain(meth, btnTrain);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }).start();
            }
        });
        box.add(btnColorTrainer);
        JButton btnBackGround = new JButton(T.T.easycaptcha_tool_btn_background());
        btnBackGround.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            new BackGroundImageGUIList(meth, ownerFrame).show();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }).start();
            }
        });
        box.add(btnBackGround);
        JButton btnColorLoadCaptchas = new JButton(T.T.easycaptcha_tool_btn_loadcaptchas());
        btnColorLoadCaptchas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        new LoadCaptchas(ownerFrame, meth.file.getName()).start();
                    }
                }).start();
            }
        });
        if (!meth.isEasyCaptchaMethode()) {
            btnColorTrainer.setEnabled(false);
            btnBackGround.setEnabled(false);
        } else {
            EasyCaptchaTool.checkReadyToTrain(meth, btnTrain);
        }
        box.add(btnColorLoadCaptchas);
        dialog.add(box);
        dialog.pack();
        dialog.setVisible(true);
    }

    static {
        Application.setApplication((String)".jd_home");
        config = JSonStorage.getPlainStorage((String)"EasyCaptchaTool");
        ownerFrame = DummyFrame.getDialogParent();
    }
}

