/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.pixelgrid;

import java.util.Vector;
import jd.captcha.JAntiCaptcha;
import jd.captcha.LetterComperator;
import jd.captcha.gui.BasicWindow;
import jd.captcha.pixelgrid.PixelGrid;
import jd.captcha.pixelobject.PixelObject;
import jd.captcha.utils.Utilities;

public class Letter
extends PixelGrid {
    private static final long serialVersionUID = 1L;
    private int angle;
    private int badDetections = 0;
    private String decodedValue;
    public LetterComperator detected = null;
    private int elementPixel = 0;
    private int goodDetections = 0;
    private int id;
    private String sourcehash;

    public Letter() {
        super(0, 0);
    }

    public Letter(int averageWidth, int height) {
        super(averageWidth, height);
    }

    public Letter align(double objectContrast) {
        PixelObject obj = this.toPixelObject(objectContrast);
        PixelObject aligned = obj.align();
        Letter newLetter = aligned.toLetter();
        this.setGrid(newLetter.grid);
        return this;
    }

    public Letter align(double objectContrast, int angleA, int angleB) {
        PixelObject obj = this.toPixelObject(objectContrast);
        PixelObject aligned = obj.align(angleA, angleB);
        Letter newLetter = aligned.toLetter();
        this.setGrid(newLetter.grid);
        return this;
    }

    public Letter align(int angleA, int angleB) {
        if (angleB < angleA) {
            int tmp = angleB;
            angleB = angleA;
            angleA = tmp;
        }
        int accuracy = this.owner.getJas().getInteger("AlignAngleSteps");
        double bestValue = Double.MAX_VALUE;
        Letter res = null;
        for (int angle = angleA; angle < angleB; angle += accuracy) {
            Letter tmp = this.turn(angle < 0 ? (double)(360 + angle) : (double)angle);
            if (!((double)tmp.getWidth() / (double)tmp.getHeight() < bestValue)) continue;
            bestValue = (double)tmp.getWidth() / (double)tmp.getHeight();
            res = tmp;
        }
        return res;
    }

    public Letter betterAlign(int angleA, int angleB) {
        if (angleB < angleA) {
            int tmp = angleB;
            angleB = angleA;
            angleA = tmp;
        }
        int accuracy = this.owner.getJas().getInteger("AlignAngleSteps");
        int bestPix = this.getFirstAndLastLinePixels();
        Letter res = null;
        Letter tmp = this;
        for (int angle = angleA; angle < angleB; angle += accuracy) {
            tmp = this.turn(angle < 0 ? (double)(360 + angle) : (double)angle);
            int pix = tmp.getFirstAndLastLinePixels();
            if (pix <= bestPix) continue;
            bestPix = pix;
            res = tmp;
        }
        return res;
    }

    public void invertIfMoreBackground() {
        long b = 0L;
        long w = 0L;
        int avg = this.getAverage();
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                if (this.isElement(this.getPixelValue(x, y), avg)) {
                    ++b;
                    continue;
                }
                ++w;
            }
        }
        if (b > w) {
            this.invert();
        }
    }

    public void colorize(int color) {
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                if (this.grid[x][y] >= 40) continue;
                this.grid[x][y] = color;
            }
        }
    }

    public void fillWithObject(PixelObject p, int color) {
        for (int i = 0; i < p.getSize(); ++i) {
            int[] point = p.elementAt(i);
            this.grid[point[0]][point[1]] = color < 0 ? point[2] : color;
        }
    }

    private void followPixelObject(int x, int y, int[][] map, boolean[][] bmap) {
        if (bmap[x][y]) {
            return;
        }
        bmap[x][y] = true;
        int posX = -1;
        int posY = -1;
        try {
            if (map[x + posX][y + posY] == 0) {
                this.followPixelObject(x + posX, y + posY, map, bmap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        posX = -1;
        posY = 0;
        try {
            if (map[x + posX][y + posY] == 0) {
                this.followPixelObject(x + posX, y + posY, map, bmap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        posX = -1;
        posY = 1;
        try {
            if (map[x + posX][y + posY] == 0) {
                this.followPixelObject(x + posX, y + posY, map, bmap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        posX = 0;
        posY = 1;
        try {
            if (map[x + posX][y + posY] == 0) {
                this.followPixelObject(x + posX, y + posY, map, bmap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        posX = 1;
        posY = 1;
        try {
            if (map[x + posX][y + posY] == 0) {
                this.followPixelObject(x + posX, y + posY, map, bmap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        posX = 1;
        posY = 0;
        try {
            if (map[x + posX][y + posY] == 0) {
                this.followPixelObject(x + posX, y + posY, map, bmap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        posX = 1;
        posY = -1;
        try {
            if (map[x + posX][y + posY] == 0) {
                this.followPixelObject(x + posX, y + posY, map, bmap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        posX = 0;
        posY = -1;
        try {
            if (map[x + posX][y + posY] == 0) {
                this.followPixelObject(x + posX, y + posY, map, bmap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getAngle() {
        return this.angle;
    }

    public int getArea() {
        return this.getWidth() * this.getHeight();
    }

    public int getBadDetections() {
        return this.badDetections;
    }

    public String getDecodedValue() {
        return this.decodedValue;
    }

    public int getElementPixel() {
        if (this.elementPixel > 0) {
            return this.elementPixel;
        }
        this.elementPixel = 0;
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                if (this.grid[x][y] != 0) continue;
                ++this.elementPixel;
            }
        }
        return this.elementPixel;
    }

    private int getFirstAndLastLinePixels() {
        int c = 0;
        int avg = this.getAverage();
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                if (!this.isElement(this.getPixelValue(x, y), avg)) continue;
                ++c;
            }
            if (c > 0) break;
        }
        int c2 = 0;
        for (int y = this.getHeight() - 1; y > 0; --y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                if (!this.isElement(this.getPixelValue(x, y), avg)) continue;
                ++c2;
            }
            if (c2 > 0) break;
        }
        return c + c2;
    }

    public int getGoodDetections() {
        return this.goodDetections;
    }

    public int getId() {
        return this.id;
    }

    public Letter getLinedLetter() {
        int changed;
        Letter ret = new Letter();
        ret.setOwner(this.owner);
        int count = 0;
        int firstChange = 0;
        do {
            ++count;
            changed = 0;
            PixelObject po = this.toPixelObject(0.85);
            Vector<int[]> border = po.getBorderVector(this);
            for (int i = 0; i < border.size(); ++i) {
                int ax = border.get(i)[0];
                int ay = border.get(i)[1];
                this.logger.info(ax + "/" + ay);
                int[][] map = this.getLocalMap(this.grid, ax, ay);
                int a = this.getObjectsNum(map);
                map[1][1] = 1044480;
                int b = this.getObjectsNum(map);
                this.logger.info(a + " --->> " + b);
                if (a == b) {
                    ++changed;
                    this.setPixelValue(ax, ay, 0xFF0000);
                    continue;
                }
                this.logger.info(map[0][0] + "-" + map[1][0] + "-" + map[2][0]);
                this.logger.info(map[0][1] + "-" + map[1][1] + "-" + map[2][1]);
                this.logger.info(map[0][2] + "-" + map[1][2] + "-" + map[2][2]);
                this.setPixelValue(ax, ay, 0);
            }
            BasicWindow.showImage(this.getImage(5));
            this.logger.info("changed " + changed);
            if (firstChange != 0) continue;
            firstChange = changed;
        } while (changed * 20 > firstChange);
        ret.setGrid(this.grid);
        return ret;
    }

    public int[][] getLocalMap(int[][] grid, int x, int y) {
        int[][] map = new int[3][3];
        for (int xx = -1; xx <= 1; ++xx) {
            for (int yy = -1; yy <= 1; ++yy) {
                try {
                    map[xx + 1][yy + 1] = grid[x + xx][y + yy];
                    continue;
                }
                catch (Exception e) {
                    map[xx + 1][yy + 1] = -1;
                }
            }
        }
        return map;
    }

    /*
     * Exception decompiling
     */
    public Letter getMassLetter() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int getObjectsNum(int[][] map) {
        boolean[][] bmap = new boolean[3][3];
        int ret = 0;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                if (bmap[x][y] || map[x][y] != 0) continue;
                this.followPixelObject(x, y, map, bmap);
                ++ret;
            }
        }
        return ret;
    }

    public String getPixelString() {
        StringBuilder ret = new StringBuilder();
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                ret.append(this.getPixelValue(x, y) / this.getMaxPixelValue());
            }
            ret.append('|');
        }
        String ps = ret.toString();
        if (ps.length() == 0) {
            System.out.println("IK");
        }
        return ps.length() == 0 ? ps : ps.substring(0, ps.length() - 1);
    }

    public Letter getSimplified(double faktor) {
        int y;
        int x;
        if (faktor == 1.0 || faktor == 0.0) {
            return this;
        }
        int newWidth = (int)Math.ceil((double)this.getWidth() / faktor);
        int newHeight = (int)Math.ceil((double)this.getHeight() / faktor);
        Letter ret = new Letter();
        ret.setOwner(this.owner);
        int avg = this.getAverage();
        this.logger.info(newWidth + " - " + newHeight);
        int[][] newGrid = new int[newWidth][newHeight];
        for (x = 0; x < newWidth; ++x) {
            for (y = 0; y < newHeight; ++y) {
                PixelGrid.setPixelValue(x, y, newGrid, this.getMaxPixelValue());
            }
        }
        this.elementPixel = 0;
        for (x = 0; x < this.getWidth(); ++x) {
            for (y = 0; y < this.getHeight(); ++y) {
                if (!this.isElement(this.getPixelValue(x, y), avg)) continue;
                int newX = (int)Math.floor((double)x / faktor);
                int newY = (int)Math.floor((double)y / faktor);
                PixelGrid.setPixelValue(newX, newY, newGrid, 0);
            }
        }
        ret.setGrid(newGrid);
        ret.clean();
        return ret;
    }

    public String getSourcehash() {
        return this.sourcehash;
    }

    public void markBad() {
        ++this.badDetections;
        this.logger.warning("Bad detection : (" + this.toString() + ") ");
    }

    public void markGood() {
        ++this.goodDetections;
        this.logger.warning("GOOD detection : (" + this.toString() + ") ");
    }

    public void resizetoWidth(int newWidth) {
        double faktor = (double)newWidth / (double)this.getWidth();
        int newHeight = (int)Math.ceil((double)this.getHeight() * faktor);
        int[][] newGrid = new int[newWidth][newHeight];
        int elementPixel = 0;
        for (int x = 0; x < newWidth; ++x) {
            for (int y = 0; y < newHeight; ++y) {
                int v;
                newGrid[x][y] = v = this.grid[(int)Math.floor((double)x / faktor)][(int)Math.floor((double)y / faktor)];
                if (newGrid[x][y] != 0) continue;
                ++elementPixel;
            }
        }
        this.setElementPixel(elementPixel);
        this.setGrid(newGrid);
    }

    public void resizetoHeight(int newHeight) {
        double faktor = (double)newHeight / (double)this.getHeight();
        int newWidth = (int)Math.ceil((double)this.getWidth() * faktor);
        int[][] newGrid = new int[newWidth][newHeight];
        int elementPixel = 0;
        for (int x = 0; x < newWidth; ++x) {
            for (int y = 0; y < newHeight; ++y) {
                int v;
                newGrid[x][y] = v = this.grid[(int)Math.floor((double)x / faktor)][(int)Math.floor((double)y / faktor)];
                if (newGrid[x][y] != 0) continue;
                ++elementPixel;
            }
        }
        this.setElementPixel(elementPixel);
        this.setGrid(newGrid);
    }

    public void resizetoHeight(int newHeight, double d) {
        double faktor = (double)newHeight / (double)this.getHeight();
        if (Math.abs(faktor - 1.0) < d) {
            this.resizetoHeight(newHeight);
        }
    }

    private void setAngle(int angle) {
        this.angle = angle;
    }

    public void setBadDetections(int badDetections) {
        this.badDetections = badDetections;
    }

    public void setDecodedValue(String decodedValue) {
        this.decodedValue = decodedValue;
    }

    public void setElementPixel(int elementPixel) {
        this.elementPixel = elementPixel;
    }

    public void setGoodDetections(int goodDetections) {
        this.goodDetections = goodDetections;
    }

    @Override
    public void setOwner(JAntiCaptcha owner) {
        this.owner = owner;
    }

    public void setSourcehash(String sourcehash) {
        this.sourcehash = sourcehash;
    }

    public boolean setTextGrid(String content) {
        String[] code = content.split("\\|");
        this.grid = null;
        int width = 0;
        int elementPixel = 0;
        for (int y = 0; y < code.length; ++y) {
            String line = code[y];
            width = line.length();
            if (this.grid == null) {
                this.grid = new int[width][code.length];
                if (width < 1 || code.length < 2) {
                    return false;
                }
            }
            for (int x = 0; x < width; ++x) {
                try {
                    this.grid[x][y] = Integer.parseInt(String.valueOf(line.charAt(x))) * this.getMaxPixelValue();
                }
                catch (Exception e) {
                    this.logger.log((Throwable)e);
                    return false;
                }
                if (this.grid[x][y] != 0) continue;
                ++elementPixel;
            }
        }
        this.setElementPixel(elementPixel);
        return true;
    }

    public PixelObject toPixelObject(double objectContrast) {
        PixelObject object = new PixelObject(this);
        object.setWhiteContrast(objectContrast);
        for (int x = 0; x < this.getWidth(); ++x) {
            for (int y = 0; y < this.getHeight(); ++y) {
                if (!((double)this.getPixelValue(x, y) < (double)this.getMaxPixelValue() * objectContrast)) continue;
                object.add(x, y, this.getPixelValue(x, y));
            }
        }
        return object;
    }

    public String toString() {
        return this.getDecodedValue() + " [" + this.getSourcehash() + "][" + this.getGoodDetections() + "/" + this.getBadDetections() + "]";
    }

    public boolean trim(int left, int right) {
        int width = right - left;
        int[][] tmp = new int[width][this.getHeight()];
        this.setLocation(new int[]{left, 0});
        if (this.getWidth() < right) {
            this.logger.severe("Letter dim: " + this.getWidth() + " - " + this.getHeight() + ". Cannot trim to " + left + "-" + right);
            return false;
        }
        for (int x = 0; x < width; ++x) {
            tmp[x] = this.grid[x + left];
        }
        this.grid = tmp;
        return true;
    }

    @Override
    public Letter turn(double angle) {
        if (angle == 0.0) {
            return this;
        }
        while (angle < 0.0) {
            angle += 360.0;
        }
        Letter l = this.createLetter();
        int newWidth = (int)(Math.abs(Math.cos((angle /= 180.0) * Math.PI) * (double)this.getWidth()) + Math.abs(Math.sin(angle * Math.PI) * (double)this.getHeight()));
        int newHeight = (int)(Math.abs(Math.sin(angle * Math.PI) * (double)this.getWidth()) + Math.abs(Math.cos(angle * Math.PI) * (double)this.getHeight()));
        int left = (newWidth - this.getWidth()) / 2;
        int top = (newHeight - this.getHeight()) / 2;
        int elementPixel = 0;
        int[][] newGrid = new int[newWidth][newHeight];
        for (int x = 0; x < newWidth; ++x) {
            for (int y = 0; y < newHeight; ++y) {
                int[] n = Utilities.turnCoordinates(x - left, y - top, this.getWidth() / 2, this.getHeight() / 2, -(angle * 180.0));
                if (n[0] < 0 || n[0] >= this.getWidth() || n[1] < 0 || n[1] >= this.getHeight()) {
                    newGrid[x][y] = this.owner.getJas().getColorFaktor() - 1;
                    if (newGrid[x][y] != 0) continue;
                    ++elementPixel;
                    continue;
                }
                newGrid[x][y] = this.grid[n[0]][n[1]];
                if (newGrid[x][y] != 0) continue;
                ++elementPixel;
            }
        }
        l.setGrid(newGrid);
        l.setElementPixel(elementPixel);
        l.clean();
        l.id = this.id;
        l.setDecodedValue(this.getDecodedValue());
        l.setAngle((int)(angle * 180.0));
        return l;
    }

    public void setId(int id) {
        this.id = id;
    }
}

