/*
 * Decompiled with CFR 0.152.
 */
package jd.captcha.utils;

import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import jd.utils.JDUtilities;
import org.appwork.utils.ImageProvider.ImageProvider;

public final class Utilities {
    private Utilities() {
    }

    public static boolean checkJumper(int x, int from, int to) {
        return x >= from && x <= to;
    }

    public static File directoryChooser() {
        JFileChooser fc = new JFileChooser();
        fc.setApproveButtonText("OK");
        fc.setFileSelectionMode(1);
        if (fc.showOpenDialog(null) == 0) {
            return fc.getSelectedFile();
        }
        return null;
    }

    public static String getMethodDir() {
        return JDUtilities.getJDHomeDirectoryFromEnvironment().getAbsolutePath() + "/" + JDUtilities.getJACMethodsDirectory();
    }

    public static GridBagConstraints getGBC(int x, int y, int width, int height) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 18;
        gbc.insets = new Insets(1, 1, 1, 1);
        return gbc;
    }

    public static int getJumperStart(int from, int to) {
        return from + (to - from) / 2;
    }

    public static int getPercent(int a, int b) {
        return b == 0 ? 100 : a * 100 / b;
    }

    public static Image loadImage(File file) {
        try {
            return ImageProvider.read((File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int nextJump(int x, int from, int to, int step) {
        int ret;
        int start = Utilities.getJumperStart(from, to);
        if (x == start) {
            ret = start + step;
            if (ret > to) {
                ret = start - step;
            }
        } else if (x > start) {
            int dif = x - start;
            ret = start - dif;
        } else {
            int dif = start - x + step;
            ret = start + dif;
            if (ret > to) {
                ret = start - dif;
            }
        }
        return ret;
    }

    public static int[] turnCoordinates(int x, int y, int nullX, int nullY, double winkel) {
        winkel /= 180.0;
        int newX = x - nullX;
        int newY = y - nullY;
        double aktAngle = Math.atan2(newY, newX);
        int[] ret = new int[2];
        double radius = Math.sqrt(newX * newX + newY * newY);
        int yTrans = (int)Math.round(radius * Math.sin(aktAngle + winkel * Math.PI));
        int xTrans = (int)Math.round(radius * Math.cos(aktAngle + winkel * Math.PI));
        ret[0] = xTrans + nullX;
        ret[1] = yTrans + nullY;
        return ret;
    }
}

