/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.console;

import java.io.IOException;
import org.appwork.console.AbstractConsole;
import org.appwork.console.ConsoleDialogInterface;
import org.appwork.utils.Application;
import org.appwork.utils.Exceptions;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;

public class ConsoleDialog
implements ConsoleDialogInterface {
    private final AbstractConsole console;
    private boolean stdBefore;
    private boolean errBefore;
    private final String title;

    public ConsoleDialog(AbstractConsole console, String string) {
        if (console == null) {
            throw new IllegalStateException("No Console Available!");
        }
        this.console = console;
        this.title = string;
    }

    public ConsoleDialog(String string) {
        this(AbstractConsole.newInstance(), string);
    }

    public void start() {
        this.stdBefore = false;
        this.errBefore = false;
        try {
            this.stdBefore = Application.STD_OUT.setBufferEnabled(true);
            this.errBefore = Application.ERR_OUT.setBufferEnabled(true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.console.println("|---------------------------Headless Information-------------------------------");
        this.console.println("|\t" + this.title);
    }

    public void end() {
        this.console.println("|------------------------------------------------------------------------------");
        try {
            Application.STD_OUT.setBufferEnabled(this.stdBefore);
            Application.STD_OUT.flush();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            Application.ERR_OUT.setBufferEnabled(this.errBefore);
            Application.ERR_OUT.flush();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void println(String string) {
        this.console.println("|\t" + string);
    }

    public void waitYesOrNo(int flags, String yes, String no) throws DialogCanceledException, DialogClosedException {
        if ((flags & 8) != 0 || (flags & 0x10) != 0) {
            this.waitToContinue((flags & 8) != 0 ? yes : no);
            if ((flags & 8) == 0) {
                if ((flags & 0x10) != 0) {
                    throw new DialogCanceledException(4);
                }
                throw new DialogClosedException(64);
            }
        } else {
            String c;
            do {
                this.println("Enter y -> " + yes);
                this.println("Enter n -> " + no);
                c = this.console.readLine();
                if (!c.trim().equalsIgnoreCase("y")) continue;
                return;
            } while (!c.trim().equalsIgnoreCase("n"));
            throw new DialogCanceledException(4);
        }
    }

    public void printLines(String stackTrace) {
        for (String l : stackTrace.split("[\r\n]+")) {
            this.println(l);
        }
    }

    public void waitToContinue() {
        this.waitToContinue("continue");
    }

    public void waitToContinue(String string) {
        if (string == null) {
            string = "continue";
        }
        this.println("Press Enter to " + string);
        this.console.readLine();
    }

    public void print(String string) {
        this.console.print(string);
    }

    public String ask(String string) {
        this.println(string);
        this.print("|>\t");
        return this.console.readLine();
    }

    public String askHidden(String string) {
        this.println(string);
        this.print("|>\t");
        return this.console.readPassword();
    }

    public void flush() {
        this.console.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean showExceptionDialog(String title, String message, Throwable e) {
        if (!Application.isHeadless()) {
            return false;
        }
        Object object = AbstractConsole.LOCK;
        synchronized (object) {
            boolean bl;
            ConsoleDialog cd = new ConsoleDialog("Exception occured");
            cd.start();
            try {
                cd.println(title);
                cd.printLines(message);
                cd.printLines(Exceptions.getStackTrace(e));
                cd.waitToContinue();
                bl = true;
                cd.end();
            }
            catch (Throwable throwable) {
                cd.end();
                throw throwable;
            }
            return bl;
        }
    }
}

