/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.jna.windows.wmi;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.Unknown;
import com.sun.jna.platform.win32.COM.Wbemcli;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.OaIdlUtil;
import com.sun.jna.platform.win32.Ole32;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.appwork.jna.windows.wmi.ExtIWbemClassObject;
import org.appwork.jna.windows.wmi.WMIException;
import org.appwork.loggingv3.LogV3;
import org.appwork.loggingv3.simple.SimpleLoggerFactory;
import org.appwork.loggingv3.simple.sink.LogToStdOutSink;
import org.appwork.serializer.Deser;
import org.appwork.serializer.SC;
import org.appwork.storage.TypeRef;
import org.appwork.utils.DebugMode;
import org.appwork.utils.Joiner;
import org.appwork.utils.StringUtils;
import org.appwork.utils.Time;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.processes.command.Command;
import org.appwork.utils.processes.command.ProcessOutputHandler;

public class JNAWMIUtils {
    private static final String DEFAULT_LANGUAGE = "MS_409";
    private static Map<Integer, String> WMI_ERRORS = new HashMap<Integer, String>();
    private static final String PRODUCT_STATE = "productState";
    private static final String DISPLAY_NAME = "displayName";
    private static final int TIMEOUT = 60000;
    private static boolean SECURITY_INITIALIZED;

    private static String decodeProductState(int productState) {
        String productStateStr = JNAWMIUtils.getProductStateDescription(productState & 0xF000);
        String productOwnerStr = JNAWMIUtils.getProductOwnerDescription(productState & 0xF00);
        String signatureStatusStr = JNAWMIUtils.getSignatureStatusDescription(productState & 0xF0);
        return StringUtils.join(",", productStateStr, signatureStatusStr, productOwnerStr);
    }

    private static String getProductStateDescription(int productState) {
        switch (productState) {
            case 0: {
                return "off";
            }
            case 4096: {
                return "on";
            }
            case 8192: {
                return "snoozed";
            }
            case 12288: {
                return "expired";
            }
        }
        return "unknown_" + Integer.toHexString(productState);
    }

    private static String getProductOwnerDescription(int productOwner) {
        switch (productOwner) {
            case 0: {
                return "non_ms";
            }
            case 256: {
                return "ms";
            }
        }
        return "unknown_" + Integer.toHexString(productOwner);
    }

    private static String getSignatureStatusDescription(int signatureStatus) {
        switch (signatureStatus) {
            case 0: {
                return "up_to_date";
            }
            case 16: {
                return "out_of_date";
            }
        }
        return "unknown_" + Integer.toHexString(signatureStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static ArrayList<Map<String, Object>> query(String namespace, String query, String ... properties) throws WMIException, InterruptedException {
        if (namespace == null) {
            namespace = "ROOT\\CIMV2";
        }
        list = new ArrayList<Map<String, Object>>();
        try {
            comUnInitRequired = false;
            try {
                hres = Ole32.INSTANCE.CoInitializeEx(null, 0);
                switch (hres.intValue()) {
                    case 0: 
                    case 1: {
                        comUnInitRequired = true;
                        break;
                    }
                    case -2147417850: {
                        DebugMode.debugger();
                        hres = Ole32.INSTANCE.CoInitializeEx(null, 2);
                        switch (hres.intValue()) {
                            case 0: 
                            case 1: {
                                comUnInitRequired = true;
                                break;
                            }
                            default: {
                                throw new COMException("Failed to initialize COM library #2.", hres);
                            }
                        }
                    }
                    default: {
                        throw new COMException("Failed to initialize COM library #1.", hres);
                    }
                }
                var6_10 = JNAWMIUtils.class;
                synchronized (JNAWMIUtils.class) {
                    if (!JNAWMIUtils.SECURITY_INITIALIZED) {
                        hres = Ole32.INSTANCE.CoInitializeSecurity(null, -1, null, null, 0, 3, null, 0, null);
                        if (COMUtils.FAILED((WinNT.HRESULT)hres) && hres.intValue() != -2147417831) {
                            throw new COMException("Failed to initialize security: " + JNAWMIUtils.WMI_ERRORS.get(hres.intValue()), hres);
                        }
                        LogV3.info("CoInitializeSecurity - set  COM security configuration for this process");
                        JNAWMIUtils.SECURITY_INITIALIZED = true;
                    }
                    // ** MonitorExit[var6_10] (shouldn't be in output)
                    loc = Wbemcli.IWbemLocator.create();
                    if (loc == null) {
                        throw new COMException("Failed to create WbemLocator object.");
                    }
                    svc = loc.ConnectServer(namespace, null, null, "MS_409", 0, null, null);
                    pType = new IntByReference();
                    try {
                        loc.Release();
                        hres = Ole32.INSTANCE.CoSetProxyBlanket((Unknown)svc, 10, 0, null, 3, 3, null, 0);
                        if (COMUtils.FAILED((WinNT.HRESULT)hres)) {
                            throw new COMException("Could not set proxy blanket: " + JNAWMIUtils.WMI_ERRORS.get(hres.intValue()), hres);
                        }
                        enumRes = svc.ExecQuery("WQL", query, 48, null);
                        try {
                            while (enumRes.getPointer() != Pointer.NULL && (hres = enumRes.Next(60000, (pclsObj = new Pointer[1]).length, pclsObj, new IntByReference(0))).intValue() != 1) {
                                if (hres.intValue() == 262149) {
                                    break;
                                }
                                if (hres.intValue() == 262148) {
                                    DebugMode.debugger();
                                    throw new TimeoutException("No results after 60000 ms: " + JNAWMIUtils.WMI_ERRORS.get(hres.intValue()));
                                }
                                if (COMUtils.FAILED((WinNT.HRESULT)hres)) {
                                    message = JNAWMIUtils.WMI_ERRORS.get(hres.intValue());
                                    throw new COMException(message == null ? "Unknown Error" : message, hres);
                                }
                                classObject = new ExtIWbemClassObject(pclsObj[0]);
                                try {
                                    if (properties == null || properties.length == 0) {
                                        properties = classObject.GetNames(null, 0, null);
                                    }
                                    map = new HashMap<String, Object>();
                                    vtType = -1;
                                    block46: for (String property : properties) {
                                        try {
                                            clear = true;
                                            pVal = new Variant.VARIANT.ByReference();
                                            try {
                                                vtType = -1;
                                                OleAuto.INSTANCE.VariantInit(pVal);
                                                COMUtils.checkRC((WinNT.HRESULT)classObject.Get(property, 0, pVal, pType, null));
                                                vtType = pVal.getValue() == null ? Integer.valueOf(1) : pVal.getVarType();
                                                switch (vtType) {
                                                    case 16: 
                                                    case 17: {
                                                        map.put(property, pVal.byteValue());
                                                        ** break;
lbl79:
                                                        // 1 sources

                                                        continue block46;
                                                    }
                                                    case 2: 
                                                    case 18: {
                                                        map.put(property, pVal.shortValue());
                                                        ** break;
lbl84:
                                                        // 1 sources

                                                        continue block46;
                                                    }
                                                    case 3: 
                                                    case 19: {
                                                        map.put(property, pVal.intValue());
                                                        ** break;
lbl89:
                                                        // 1 sources

                                                        continue block46;
                                                    }
                                                    case 20: 
                                                    case 21: {
                                                        map.put(property, pVal.longValue());
                                                        ** break;
lbl94:
                                                        // 1 sources

                                                        continue block46;
                                                    }
                                                    case 8: {
                                                        map.put(property, pVal.stringValue());
                                                        ** break;
lbl99:
                                                        // 1 sources

                                                        continue block46;
                                                    }
                                                    case 7: {
                                                        map.put(property, pVal.dateValue());
                                                        ** break;
lbl104:
                                                        // 1 sources

                                                        continue block46;
                                                    }
                                                    case 11: {
                                                        map.put(property, pVal.booleanValue());
                                                        ** break;
lbl109:
                                                        // 1 sources

                                                        continue block46;
                                                    }
                                                    case 4: {
                                                        map.put(property, Float.valueOf(pVal.floatValue()));
                                                        ** break;
lbl114:
                                                        // 1 sources

                                                        continue block46;
                                                    }
                                                    case 5: {
                                                        map.put(property, pVal.doubleValue());
                                                        ** break;
lbl119:
                                                        // 1 sources

                                                        continue block46;
                                                    }
                                                    case 0: 
                                                    case 1: {
                                                        map.put(property, null);
                                                        ** break;
lbl124:
                                                        // 1 sources

                                                        continue block46;
                                                    }
                                                    default: {
                                                        value = pVal.getValue();
                                                        if (value instanceof OaIdl.SAFEARRAY) {
                                                            array = OaIdlUtil.toPrimitiveArray((OaIdl.SAFEARRAY)((OaIdl.SAFEARRAY)value), (boolean)false);
                                                            ((OaIdl.SAFEARRAY)value).destroy();
                                                            clear = false;
                                                            map.put(property, array);
                                                            ** break;
lbl134:
                                                            // 1 sources

                                                            continue block46;
                                                        }
                                                        map.put(property, null);
                                                        continue block46;
                                                    }
                                                }
                                            }
                                            finally {
                                                if (clear) {
                                                    if (pVal.getValue() instanceof OaIdl.SAFEARRAY) {
                                                        DebugMode.debugger();
                                                    }
                                                    OleAuto.INSTANCE.VariantClear((Variant.VARIANT)pVal);
                                                }
                                            }
                                        }
                                        catch (Throwable e) {
                                            for (Field f : Variant.class.getFields()) {
                                                try {
                                                    if (!f.getName().startsWith("VT_") || vtType != f.getInt(null)) continue;
                                                    LogV3.info("Error Type: " + f.getName());
                                                    break;
                                                }
                                                catch (Exception e1) {
                                                    e1.printStackTrace();
                                                }
                                            }
                                            LogV3.info("Error Prop: " + property);
                                            LogV3.log(e);
                                        }
                                    }
                                    list.add(map);
                                }
                                finally {
                                    classObject.Release();
                                }
                            }
                        }
                        finally {
                            enumRes.Release();
                        }
                    }
                    finally {
                        svc.Release();
                    }
                }
            }
            finally {
                if (comUnInitRequired) {
                    Ole32.INSTANCE.CoUninitialize();
                }
            }
            {
                return list;
            }
        }
        catch (Exception org) {
            if (org instanceof COMException && JNAWMIUtils.WMI_ERRORS.containsKey(code = ((COMException)org).getHresult().intValue())) {
                throw WMIException.wrap(org);
            }
            LogV3.log(org);
            LogV3.info("Try Fallback via PowerShell");
            try {
                ret = JNAWMIUtils.wmiQueryViaPowerShell(namespace, query, properties);
                return ret;
            }
            catch (WMIException var5_9) {
                throw WMIException.wrap(org);
            }
        }
    }

    public static ArrayList<Map<String, Object>> wmiQueryViaPowerShell(String namespace, String query, String ... properties) throws WMIException, InterruptedException {
        try {
            Object o;
            if (namespace == null) {
                namespace = "ROOT\\CIMV2";
            }
            String q = "Get-WmiObject -Locale MS_409 -Namespace " + namespace + " -Query \\\"" + query + "\\\"";
            if (properties != null && properties.length > 0) {
                q = q + " | Select-Object " + new Joiner(", ").join(properties);
            }
            q = q + " | ConvertTo-Json";
            Command c = new Command("powershell.exe", "-Command", q);
            ProcessOutputHandler poh = new ProcessOutputHandler();
            c.setOutputHandler(poh);
            c.start(true);
            int exitCode = c.waitFor();
            if (exitCode != 0) {
                System.out.println(poh.getResult().getErrOutString());
                throw new WMIException("PowerShell: " + poh.getResult().getErrOutString());
            }
            String json = poh.getResult().getStdOutString();
            if ("".equals(json)) {
                json = "{}";
            }
            if ((o = Deser.get().fromString(json, TypeRef.OBJECT, new Object[0])) instanceof List) {
                return Deser.get().convert(o, new TypeRef<ArrayList<Map<String, Object>>>(){}, new Object[0]);
            }
            ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
            Map<String, Object> obj = Deser.get().convert(o, TypeRef.MAP, new Object[0]);
            ret.add(obj);
            return ret;
        }
        catch (IOException e) {
            throw WMIException.wrap(e);
        }
    }

    public static void main(String[] args) throws WMIException, InterruptedException {
        SimpleLoggerFactory f = new SimpleLoggerFactory();
        f.setSinkToConsole(new LogToStdOutSink());
        LogV3.setFactory(f);
        HashSet<String> expected = new HashSet<String>();
        expected.add(";DisplayName: Windows Defender - on,up_to_date,ms;{\"__NAMESPACE\":\"ROOT\\\\SecurityCenter2\",\"pathToSignedReportingExe\":\"%ProgramFiles%\\\\Windows Defender\\\\MsMpeng.exe\",\"displayName\":\"Windows Defender\",\"pathToSignedProductExe\":\"windowsdefender://\",\"productState\":397568,\"__PROPERTY_COUNT\":6,\"__DYNASTY\":\"AntiVirusProduct\",\"__DERIVATION\":[],\"__SERVER\":\"DESKTOP-7KP0VLD\",\"__CLASS\":\"AntiVirusProduct\",\"__RELPATH\":\"AntiVirusProduct.instanceGuid=\\\"{D68DDC3A-831F-4fae-9E44-DA132C1ACF46}\\\"\",\"__PATH\":\"\\\\\\\\DESKTOP-7KP0VLD\\\\ROOT\\\\SecurityCenter2:AntiVirusProduct.instanceGuid=\\\"{D68DDC3A-831F-4fae-9E44-DA132C1ACF46}\\\"\",\"__GENUS\":2,\"instanceGuid\":\"{D68DDC3A-831F-4fae-9E44-DA132C1ACF46}\",\"__SUPERCLASS\":null,\"timestamp\":\"Tue, 30 Jul 2024 15:06:30 GMT\"}");
        expected.add(";DisplayName: Windows Defender - on,up_to_date,ms;{\"__NAMESPACE\":\"ROOT\\\\SecurityCenter2\",\"pathToSignedReportingExe\":\"%ProgramFiles%\\\\Windows Defender\\\\MsMpeng.exe\",\"displayName\":\"Windows Defender\",\"pathToSignedProductExe\":\"windowsdefender://\",\"productState\":397568,\"__PROPERTY_COUNT\":6,\"__DYNASTY\":\"AntiVirusProduct\",\"__SERVER\":\"DESKTOP-7KP0VLD\",\"__CLASS\":\"AntiVirusProduct\",\"__RELPATH\":\"AntiVirusProduct.instanceGuid=\\\"{D68DDC3A-831F-4fae-9E44-DA132C1ACF46}\\\"\",\"__PATH\":\"\\\\\\\\DESKTOP-7KP0VLD\\\\ROOT\\\\SecurityCenter2:AntiVirusProduct.instanceGuid=\\\"{D68DDC3A-831F-4fae-9E44-DA132C1ACF46}\\\"\",\"__GENUS\":2,\"instanceGuid\":\"{D68DDC3A-831F-4fae-9E44-DA132C1ACF46}\",\"__SUPERCLASS\":null,\"timestamp\":\"Tue, 30 Jul 2024 15:06:30 GMT\"}");
        final AtomicLong lastGC = new AtomicLong();
        for (int i = 0; i < 1; ++i) {
            new Thread(){
                private int counter = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        try {
                            String namespace;
                            this.setName(new Date().toString() + " - " + this.counter);
                            switch (CrossSystem.getOS()) {
                                case WINDOWS_XP: {
                                    namespace = "ROOT\\SecurityCenter";
                                    break;
                                }
                                default: {
                                    namespace = "ROOT\\SecurityCenter2";
                                }
                            }
                            String query = "SELECT * from AntiVirusProduct";
                            ArrayList<Map<String, Object>> list = JNAWMIUtils.query(namespace, "SELECT * from AntiVirusProduct", new String[0]);
                            StringBuilder sb = new StringBuilder();
                            if (list.size() > 0) {
                                for (Map map : list) {
                                    String displayName = StringUtils.valueOfOrNull(map.get(JNAWMIUtils.DISPLAY_NAME));
                                    int state = ((Number)map.get(JNAWMIUtils.PRODUCT_STATE)).intValue();
                                    String stateString = JNAWMIUtils.decodeProductState(state);
                                    sb.append(";DisplayName: " + displayName + " - " + stateString);
                                    sb.append(";" + Deser.get().toString(map, new Object[]{SC.LOG_SINGLELINE}));
                                }
                            }
                            AtomicLong atomicLong = lastGC;
                            synchronized (atomicLong) {
                                if (Time.now() - lastGC.get() > 1000L) {
                                    lastGC.set(Time.now());
                                    LogV3.info("GC");
                                    System.gc();
                                    Thread.sleep(200L);
                                }
                            }
                            ++this.counter;
                        }
                        catch (Throwable e) {
                            LogV3.log(e);
                        }
                    }
                }
            }.start();
        }
    }

    public static String escape(String input) {
        return input.replace("\\", "\\\\").replace("'", "\\'").replace("\"", "\\\"").replace("%", "\\%");
    }

    static {
        WMI_ERRORS.put(-2147217407, "WBEM_E_FAILED");
        WMI_ERRORS.put(-2147217406, "WBEM_E_NOT_FOUND");
        WMI_ERRORS.put(-2147217405, "WBEM_E_ACCESS_DENIED");
        WMI_ERRORS.put(-2147217404, "WBEM_E_PROVIDER_FAILURE");
        WMI_ERRORS.put(-2147217403, "WBEM_E_TYPE_MISMATCH");
        WMI_ERRORS.put(-2147217402, "WBEM_E_OUT_OF_MEMORY");
        WMI_ERRORS.put(-2147217401, "WBEM_E_INVALID_CONTEXT");
        WMI_ERRORS.put(-2147217400, "WBEM_E_INVALID_PARAMETER");
        WMI_ERRORS.put(-2147217399, "WBEM_E_NOT_AVAILABLE");
        WMI_ERRORS.put(-2147217398, "WBEM_E_CRITICAL_ERROR");
        WMI_ERRORS.put(-2147217397, "WBEM_E_INVALID_STREAM");
        WMI_ERRORS.put(-2147217396, "WBEM_E_NOT_SUPPORTED");
        WMI_ERRORS.put(-2147217395, "WBEM_E_INVALID_SUPERCLASS");
        WMI_ERRORS.put(-2147217394, "WBEM_E_INVALID_NAMESPACE");
        WMI_ERRORS.put(-2147217393, "WBEM_E_INVALID_OBJECT");
        WMI_ERRORS.put(-2147217392, "WBEM_E_INVALID_CLASS");
        WMI_ERRORS.put(-2147217391, "WBEM_E_PROVIDER_NOT_FOUND");
        WMI_ERRORS.put(-2147217390, "WBEM_E_INVALID_PROVIDER_REGISTRATION");
        WMI_ERRORS.put(-2147217389, "WBEM_E_PROVIDER_LOAD_FAILURE");
        WMI_ERRORS.put(-2147217388, "WBEM_E_INITIALIZATION_FAILURE");
        WMI_ERRORS.put(-2147217387, "WBEM_E_TRANSPORT_FAILURE");
        WMI_ERRORS.put(-2147217386, "WBEM_E_INVALID_OPERATION");
        WMI_ERRORS.put(-2147217385, "WBEM_E_INVALID_QUERY");
        WMI_ERRORS.put(-2147217384, "WBEM_E_INVALID_QUERY_TYPE");
        WMI_ERRORS.put(-2147217383, "WBEM_E_ALREADY_EXISTS");
        WMI_ERRORS.put(-2147217382, "WBEM_E_OVERRIDE_NOT_ALLOWED");
        WMI_ERRORS.put(-2147217381, "WBEM_E_PROPAGATED_QUALIFIER");
        WMI_ERRORS.put(-2147217380, "WBEM_E_PROPAGATED_PROPERTY");
        WMI_ERRORS.put(-2147217379, "WBEM_E_UNEXPECTED");
        WMI_ERRORS.put(-2147217378, "WBEM_E_ILLEGAL_OPERATION");
        WMI_ERRORS.put(-2147217377, "WBEM_E_CANNOT_BE_KEY");
        WMI_ERRORS.put(-2147217376, "WBEM_E_INCOMPLETE_CLASS");
        WMI_ERRORS.put(-2147217375, "WBEM_E_INVALID_SYNTAX");
        WMI_ERRORS.put(-2147217374, "WBEM_E_NONDECORATED_OBJECT");
        WMI_ERRORS.put(-2147217373, "WBEM_E_READ_ONLY");
        WMI_ERRORS.put(-2147217372, "WBEM_E_PROVIDER_NOT_CAPABLE");
        WMI_ERRORS.put(-2147217371, "WBEM_E_CLASS_HAS_CHILDREN");
        WMI_ERRORS.put(-2147217370, "WBEM_E_CLASS_HAS_INSTANCES");
        WMI_ERRORS.put(-2147217369, "WBEM_E_QUERY_NOT_IMPLEMENTED");
        WMI_ERRORS.put(-2147217368, "WBEM_E_ILLEGAL_NULL");
        WMI_ERRORS.put(-2147217367, "WBEM_E_INVALID_QUALIFIER_TYPE");
        WMI_ERRORS.put(-2147217366, "WBEM_E_INVALID_PROPERTY_TYPE");
        WMI_ERRORS.put(-2147217365, "WBEM_E_VALUE_OUT_OF_RANGE");
        WMI_ERRORS.put(-2147217364, "WBEM_E_CANNOT_BE_SINGLETON");
        WMI_ERRORS.put(-2147217363, "WBEM_E_INVALID_CIM_TYPE");
        WMI_ERRORS.put(-2147217362, "WBEM_E_INVALID_METHOD");
        WMI_ERRORS.put(-2147217361, "WBEM_E_INVALID_METHOD_PARAMETERS");
        WMI_ERRORS.put(-2147217360, "WBEM_E_SYSTEM_PROPERTY");
        WMI_ERRORS.put(-2147217359, "WBEM_E_INVALID_PROPERTY");
        WMI_ERRORS.put(-2147217358, "WBEM_E_CALL_CANCELLED");
        WMI_ERRORS.put(-2147217357, "WBEM_E_SHUTTING_DOWN");
    }
}

