/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.loggingv3.simple;

import org.appwork.loggingv3.simple.LogRecord2;
import org.appwork.loggingv3.simple.LogV3Level;
import org.appwork.loggingv3.simple.LogVetoListener;
import org.appwork.loggingv3.simple.SimpleLoggerFactory;
import org.appwork.loggingv3.simple.sink.Sink;

public class BlockLogsFromCurrentThreadVetoListener
implements LogVetoListener {
    protected final LogV3Level[] blockedLevels;
    protected final Thread thread = Thread.currentThread();

    public BlockLogsFromCurrentThreadVetoListener(LogV3Level ... levels) {
        this.blockedLevels = levels;
    }

    @Override
    public boolean blockLogPublishing(SimpleLoggerFactory simpleLoggerFactory, Sink sink, LogRecord2 record) {
        if (Thread.currentThread() == this.thread && this.blockedLevels.length > 0) {
            for (int i = 0; i < this.blockedLevels.length; ++i) {
                LogV3Level blockedLevel = this.blockedLevels[i];
                if (record.getLevel() != blockedLevel) continue;
                return true;
            }
        }
        return false;
    }
}

