/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.net.protocol.http;

import java.text.SimpleDateFormat;
import java.util.Locale;
import org.appwork.net.protocol.http.ResponseCodeInterface;

public class HTTPConstants {
    public static final String HEADER_REQUEST_ACCEPT = "Accept";
    public static final String HEADER_REQUEST_ACCEPT_CHARSET = "Accept-Charset";
    public static final String HEADER_REQUEST_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HEADER_REQUEST_ACCEPT_LANGUAGE = "Accept-Language";
    public static final String HEADER_REQUEST_AUTHORIZATION = "Authorization";
    public static final String HEADER_REQUEST_CACHE_CONTROL = "Cache-Control";
    public static final String HEADER_REQUEST_CONNECTION = "Connection";
    public static final String HEADER_REQUEST_COOKIE = "Cookie";
    public static final String HEADER_RESPONSE_CONTENT_LENGTH = "Content-Length";
    public static final String HEADER_RESPONSE_WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final String HEADER_REQUEST_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_RESPONSE_CONTENT_RANGE = "Content-Range";
    public static final String HEADER_RESPONSE_SET_COOKIE = "Set-Cookie";
    public static final String HEADER_RESPONSE_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String HEADER_REQUEST_DATE = "Date";
    public static final String HEADER_REQUEST_EXPECT = "Expect";
    public static final String HEADER_REQUEST_FROM = "From";
    public static final String HEADER_REQUEST_HOST = "Host";
    public static final String HEADER_REQUEST_IF_MATCH = "If-Match";
    public static final String HEADER_REQUEST_IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String HEADER_REQUEST_IF_NON_MATCH = "If-None-Match";
    public static final String HEADER_REQUEST_ID_RANGE = "If-Range";
    public static final String HEADER_REQUEST_ID_MODIFIED_SINCE = "If-Unmodified-Since";
    public static final String HEADER_REQUEST_MAX_FORWARDS = "Max-Forwards";
    public static final String HEADER_REQUEST_PRAGMA = "Pragma";
    public static final String HEADER_REQUEST_PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String HEADER_RESPONSE_PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String HEADER_REQUEST_PROXY_CONNECTION = "Proxy-Connection";
    public static final String HEADER_REQUEST_RANGE = "Range";
    public static final String HEADER_ETAG = "ETag";
    public static final String HEADER_REQUEST_REFERER = "Referer";
    public static final String HEADER_REQUEST_TE = "TE";
    public static final String HEADER_REQUEST_UPGRADE = "Upgrade";
    public static final String HEADER_REQUEST_USER_AGENT = "User-Agent";
    public static final String HEADER_REQUEST_VIA = "Via";
    public static final String HEADER_REQUEST_LOCATION = "Location";
    public static final String HEADER_REQUEST_X_FORWARDED_FOR = "X-Forwarded-For";
    public static final String HEADER_REQUEST_X_CLIENT_IP = "X-Client-IP";
    public static final String HEADER_REQUEST_WARNING = "Warning";
    public static final String HTTP_KEEP_ALIVE = "Keep-Alive";
    public static final String HEADER_RESPONSE_CONTENT_TYPE = "Content-Type";
    public static final String HEADER_RESPONSE_CONTENT_TRANSFER_ENCODING = "Content-Transfer-Encoding";
    public static final String HEADER_RESPONSE_TRANSFER_ENCODING = "Transfer-Encoding";
    public static final String HEADER_RESPONSE_TRANSFER_ENCODING_CHUNKED = "chunked";
    public static final String HEADER_RESPONSE_ACCEPT_RANGES = "Accept-Ranges";
    public static final String HEADER_RESPONSE_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_REQUEST_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_RESPONSE_LOCATION = "Location";
    public static final String HEADER_RESPONSE_SERVER = "Server";
    public static final String HEADER_RESPONSE_ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String HEADER_RESPONSE_ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String HEADER_RESPONSE_ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String HEADER_RESPONSE_ACCESS_CONTROL_MAX_AGE = "Access-Control-Max-Age";
    public static final String HEADER_RESPONSE_CONTENT_SECURITY_POLICY = "Content-Security-Policy";
    public static final String HEADER_RESPONSE_X_FRAME_OPTIONS = "X-Frame-Options";
    public static final String HEADER_RESPONSE_X_XSS_PROTECTION = "X-Xss-Protection";
    public static final String HEADER_RESPONSE_REFERRER_POLICY = "Referrer-Policy";
    public static final String HEADER_REQUEST_CONTROL_HEADERS = "Access-Control-Request-Headers";
    public static final String HEADER_RESPONSE_RETRY_AFTER = "Retry-After";
    public static final String HEADER_RESPONSE_X_CONTENT_TYPE_OPTIONS = "X-Content-Type-Options";
    public static final String HEADER_REQUEST_ORIGIN = "Origin";
    public static final String HEADER_RESPONSE_ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final String HEADER_VALUE_CONTENTTYPE_JSON_UTF_8 = "application/json; charset=utf-8";
    public static final String HEADER_VALUE_CONTENTTYPE_TEXT_UTF_8 = "text/plain; charset=utf-8";
    public static final String HEADER_VALUE_ENCODING_GZIP = "gzip";
    public static final SimpleDateFormat DATE_FORMAT_HTTP_DATE_RFC1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);
    public static final SimpleDateFormat DATE_FORMAT_HTTP_DATE_RFC1036 = new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss zzz", Locale.ENGLISH);
    public static final String HEADER_VALUE_ENCODING_DEFLATE = "deflate";
    public static final String HEADER_RESPONSE_LAST_MODFIED = "Last-Modified";
    public static final String HEADER_REQUEST_UPGRADE_INSECURE_REQUESTS = "Upgrade-Insecure-Requests";

    public static enum ResponseCode implements ResponseCodeInterface
    {
        INFORMATION_CONTINUE(100, "Continue"),
        SWITCHING_PROTOCOLS(101, "Switching Protocols"),
        SUCCESS_OK(200, "OK"),
        SUCCESS_NO_CONTENT(204, "No Content"),
        SUCCESS_PARTIAL_CONTENT(206, "Partial Content"),
        MOVED_PERMANENTLY(301, "Moved Permanently"),
        REDIRECT_FOUND(302, "Found"),
        RESUME_INCOMPLETE(308, "Resume Incomplete"),
        ERROR_BAD_REQUEST(400, "Bad Request"),
        ERROR_UNAUTHORIZED(401, "Unauthorized"),
        ERROR_FORBIDDEN(403, "Forbidden"),
        PROXY_AUTH_REQUIRED(407, "Forbidden"),
        ERROR_NOT_FOUND(404, "Not Found"),
        METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
        ERROR_CONFLICT(409, "Conflict"),
        ERROR_GONE(410, "Gone"),
        LENGTH_REQUIRED(411, "Length Required"),
        REQUEST_ENTITY_TOO_LARGE(413, "Request Entity Too Large"),
        REQUEST_URL_TOO_LONG(414, "Request-URL Too Long"),
        REQUEST_HEADER_FIELDS_TOO_LARGE(431, "Request Header Fields Too Large"),
        ERROR_RANGE_NOT_SUPPORTED(416, "Range requests not supported"),
        TOO_MANY_REQUESTS(429, "Too Many Requests"),
        UNAVAILABLE_FOR_LEGAL_REASONS(451, "Unavailable For Legal Reasons"),
        SERVERERROR_INTERNAL(500, "Internal Server Error"),
        SERVERERROR_NOT_IMPLEMENTED(501, "Not Implemented"),
        SERVERERROR_BAD_GATEWAY(502, "Bad Gateway"),
        SERVERERROR_SERVICE_UNAVAILABLE(503, "Service Unavailable"),
        GATEWAY_TIMEOUT(504, "Gateway Time-out"),
        WEB_SERVER_DOWN(521, "Cloudflare, Web server is down");

        private final int code;
        private final String description;
        private final byte[] bytes;

        public static ResponseCode get(int responseCode) {
            for (ResponseCode rc : ResponseCode.values()) {
                if (responseCode != rc.getCode()) continue;
                return rc;
            }
            return null;
        }

        private ResponseCode(int code, String desc) {
            this.code = code;
            this.description = desc;
            this.bytes = (code + " " + desc).getBytes();
        }

        public boolean matches(int code) {
            return this.getCode() == code;
        }

        @Override
        public byte[] getBytes() {
            return this.bytes;
        }

        @Override
        public int getCode() {
            return this.code;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

