/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.resources;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.appwork.loggingv3.LogV3;
import org.appwork.resources.DefaultIconFactory;
import org.appwork.resources.IconFactory;
import org.appwork.resources.MultiResolutionImageHelper;
import org.appwork.resources.SourceImageTooSmallException;
import org.appwork.resources.ThemeContext;
import org.appwork.storage.config.MinTimeWeakReference;
import org.appwork.storage.config.MinTimeWeakReferenceCleanup;
import org.appwork.swing.components.CheckBoxIcon;
import org.appwork.swing.components.HeadlessCheckboxIconRef;
import org.appwork.utils.Application;
import org.appwork.utils.DebugMode;
import org.appwork.utils.IO;
import org.appwork.utils.JavaVersion;
import org.appwork.utils.StringUtils;
import org.appwork.utils.images.DebugIcon;
import org.appwork.utils.images.IconDebugger;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.images.IconPipe;
import org.appwork.utils.images.Interpolation;
import org.appwork.utils.images.ModificationType;
import org.appwork.utils.images.ScalableIcon;
import org.appwork.utils.reflection.Clazz;

public class Theme
implements MinTimeWeakReferenceCleanup {
    private static final String _VECTOR = "?vector";
    public static final String NO_IMAGE_AVAILABLE = "No Image/Icon available: ";
    public static final String FINAL = "final_";
    private static final String ENHANCE_DOUBLE_SIZE_TAG = "@2x";
    private String path;
    protected final HashMap<String, MinTimeWeakReference<Icon>> imageIconCache = new HashMap();
    private long cacheLifetime = 20000L;
    private String theme;
    private String nameSpace;
    private final boolean doLogMissing = "false".equals(System.getProperty("DO_NOT_LOG_MISSING_ICONS_EXCEPTION", "false"));
    private boolean useHighDPI;
    private static final String MAX_SIZE_KEY = "ORIGINAL";
    public static final int[] FRAME_ICON_SIZES_WINDOWS = new int[]{128, 64, 48, 32, 24, 20, 16};
    private static final boolean ICONDEBUGGER = System.getProperty("ICONDEBUGGER") != null;
    private Theme delegate;
    private String defaultPath;
    public static File RESOURCE_HELPER_ROOT;
    private static IconFactory FACTORY;
    private HashMap<String, AtomicInteger> debugLoadingMap = new HashMap();
    protected final HashMap<String, HashMap<String, MinTimeWeakReference<Image>>> imageCache = new HashMap();

    public Theme(String namespace) {
        this.setNameSpace(namespace);
        this.setTheme("standard");
        this.useHighDPI = false;
        if (JavaVersion.getVersion().isMinimum(JavaVersion.JVM_9_0)) {
            this.useHighDPI = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cache(Icon ret, String key) {
        if (ret != null) {
            HashMap<String, MinTimeWeakReference<Icon>> hashMap = this.imageIconCache;
            synchronized (hashMap) {
                this.imageIconCache.put(key, new MinTimeWeakRefNamed(ret, this.getCacheLifetime(), key, this));
            }
        }
    }

    public void setDelegate(Theme i) {
        this.delegate = i == this ? null : i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        HashMap<String, MinTimeWeakReference<Icon>> hashMap = this.imageIconCache;
        synchronized (hashMap) {
            this.imageIconCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getCached(String key) {
        HashMap<String, MinTimeWeakReference<Icon>> hashMap = this.imageIconCache;
        synchronized (hashMap) {
            MinTimeWeakReference<Icon> cache = this.imageIconCache.get(key);
            if (cache != null) {
                return cache.get();
            }
            return null;
        }
    }

    protected String getCacheKey(Object ... objects) {
        StringBuilder sb = new StringBuilder();
        for (Object o : objects) {
            if (o == null) {
                o = "null";
            }
            if (sb.length() > 0) {
                sb.append("_");
            }
            if (o instanceof ThemeContext) {
                sb.append(((ThemeContext)o).toKeyID());
                continue;
            }
            if (Clazz.isPrimitive(o.getClass())) {
                sb.append(String.valueOf(o));
                continue;
            }
            if (Clazz.isString(o.getClass())) {
                sb.append(String.valueOf(o));
                continue;
            }
            DebugMode.debugger("Forbidden key element");
        }
        return sb.toString();
    }

    public long getCacheLifetime() {
        return this.cacheLifetime;
    }

    public Icon getDisabledIcon(Icon input) {
        return this.getDisabledIcon(null, input);
    }

    protected Theme getDelegate() {
        return this.delegate;
    }

    public Icon getDisabledIcon(JComponent component, Icon input) {
        if (input != null) {
            Icon ret = null;
            Theme delegate = this.getDelegate();
            if (delegate != null) {
                ret = delegate.getDisabledIcon(input);
            }
            if (ret == null) {
                ret = FACTORY.getDisabled(component, input);
            }
            return ret;
        }
        return null;
    }

    public Icon getIcon(String relativePath, int size) {
        return this.getIcon(relativePath, size, size, null);
    }

    public Icon getIcon(String relativePath, int width, int height) {
        return this.getIcon(relativePath, width, height, null);
    }

    protected Icon onIconNotAvailable(String relativePath, ThemeContext context, String cacheKey, int width, int height) {
        if (context.getTarget() != ThemeContext.Target.ICON) {
            DebugMode.debugger();
            return null;
        }
        LogV3.info(NO_IMAGE_AVAILABLE + relativePath);
        if (this.doLogMissing) {
            LogV3.log(new Exception("Icon missing: " + this.buildPath("images/", relativePath, ".png|svg|ico|exe", false)));
        }
        DebugMode.debugger();
        BufferedImage ret = this.createNotAvailableImage(width, height);
        Icon icon = FACTORY.imageToIcon(ret, width, height);
        if (context.isUsecache()) {
            this.cache(icon, cacheKey);
        }
        return icon;
    }

    private BufferedImage createNotAvailableImage(int width, int height) {
        if (width <= 0) {
            width = 32;
        }
        if (height <= 0) {
            height = 32;
        }
        BufferedImage ret = IconIO.createEmptyImage(width, height);
        if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
            Graphics2D g = (Graphics2D)ret.getGraphics();
            g.setColor(Color.RED);
            g.fillRect(0, 0, width, height);
            g.dispose();
        }
        return ret;
    }

    public Icon getIcon(String relativePath, int width, int height, ThemeContext context) {
        Icon cachedRawIcon;
        Icon ret = null;
        Theme delegate = this.getDelegate();
        if (delegate != null && (ret = delegate.getIcon(relativePath, width, height, context)) != null) {
            return ret;
        }
        String cacheKey = null;
        if ((context == null || context.isUsecache()) && (ret = this.getCached(cacheKey = this.getCacheKey(relativePath, context, width, height))) == null && (cachedRawIcon = this.getCached(relativePath)) instanceof ScalableIcon) {
            ret = FACTORY.scale(cachedRawIcon, width, height);
            this.cache(ret, cacheKey);
            return ret;
        }
        if (ret != null) {
            return ret;
        }
        if (context == null) {
            context = this.createNewDefaultContext();
        }
        if (StringUtils.equalsIgnoreCase(relativePath, "disabled") || ThemeContext.Target.ICON.equals((Object)context.getTarget()) && HeadlessCheckboxIconRef.HEADLESS_checkbox_false.path().equals(relativePath)) {
            ret = new CheckBoxIcon(Math.max(width, height), false, true);
        } else if (StringUtils.equalsIgnoreCase(relativePath, "enabled") || ThemeContext.Target.ICON.equals((Object)context.getTarget()) && HeadlessCheckboxIconRef.HEADLESS_checkbox_true.path().equals(relativePath)) {
            ret = new CheckBoxIcon(Math.max(width, height), true, true);
        } else if (StringUtils.equalsIgnoreCase(relativePath, "checkbox_undefined")) {
            ret = new CheckBoxIcon(Math.max(width, height), true, false);
        }
        context.ensureTarget(ThemeContext.Target.ICON);
        if (ret == null) {
            Image image;
            URL url = this.lookupImageUrl(relativePath, context);
            if (url == null) {
                return this.onIconNotAvailable(relativePath, context, cacheKey, width, height);
            }
            ret = FACTORY.urlToVectorIcon(url, width, height);
            if (ret != null) {
                Icon search = ret;
                while (search != null) {
                    if (search instanceof ScalableIcon) {
                        this.cache(search, relativePath);
                        break;
                    }
                    if (!(search instanceof IconPipe)) break;
                    Set<ModificationType> mods = ((IconPipe)((Object)search)).getModifications();
                    if (mods != null && !mods.contains((Object)ModificationType.NONE)) continue;
                    search = ((IconPipe)((Object)search)).getDelegate();
                }
                LogV3.info("Loaded vector icon: " + url);
            }
            if (ret == null && context.getTarget() == ThemeContext.Target.ICON && (image = this.getImage(relativePath, width, height, context)) != null) {
                ret = FACTORY.imageToIcon(image, width, height);
            }
        }
        if (ret == null) {
            if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
                DebugMode.breakIf(ret == null && this.lookupImageUrl(relativePath, context) != null, new Object[0]);
            }
            if ((ret = this.onIconNotAvailable(relativePath, context, cacheKey, width, height)) != null && context.isDebugDrawEnabled() && context.getTarget() == ThemeContext.Target.ICON) {
                ret = new DebugIcon(ret);
            }
            return ret;
        }
        if (context.isDebugDrawEnabled() && context.getTarget() == ThemeContext.Target.ICON) {
            ret = new DebugIcon(ret);
        }
        if (context.isUsecache()) {
            this.cache(ret, cacheKey);
        }
        return ret;
    }

    public static IconFactory getFACTORY() {
        return FACTORY;
    }

    public static void setFACTORY(IconFactory fACTORY) {
        if (fACTORY == null) {
            throw new IllegalArgumentException();
        }
        FACTORY = fACTORY;
    }

    protected URL lookupImageUrl(String relativePath, ThemeContext context) {
        URL url;
        URL uRL = url = context == null ? null : context.getURL(relativePath);
        if (url != null) {
            return url;
        }
        for (boolean useStandardPath : new boolean[]{false, true}) {
            url = this.getURL("images/", relativePath, "", useStandardPath);
            if (url == null && IconIO.getSvgFactory() != null) {
                url = this.getURL("images/", relativePath, ".svg", useStandardPath);
            }
            if (url == null) {
                url = this.getURL("images/", relativePath, ".png", useStandardPath);
            }
            if (url == null && IconIO.isIcoSupported()) {
                url = this.getURL("images/", relativePath, ".ico", useStandardPath);
            }
            if (url == null && IconIO.isExeSupported()) {
                url = this.getURL("images/", relativePath, ".exe", useStandardPath);
            }
            if (url == null) continue;
            if (context != null) {
                context.putURL(relativePath, url);
            }
            return url;
        }
        return null;
    }

    private static IconFactory createIconFactory() {
        String iconFactoryClass = System.getProperty("ICON_FACTORY");
        if (StringUtils.isEmpty(iconFactoryClass)) {
            iconFactoryClass = DefaultIconFactory.class.getName();
        }
        try {
            return (IconFactory)Class.forName(iconFactoryClass).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            LogV3.log(e);
            return new DefaultIconFactory();
        }
    }

    public Image getImage(String relativePath, int size) {
        return this.getImage(relativePath, size, size);
    }

    public Image getImage(String key, int width, int height) {
        return this.getImage(key, width, height, null);
    }

    protected ThemeContext createNewDefaultContext() {
        return new ThemeContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage(String key, int width, int height, ThemeContext context) {
        Image betterImage;
        Image baseImage;
        Image image;
        Theme delegate = this.getDelegate();
        if (delegate != null && (image = delegate.getImage(key, width, height, context)) != null) {
            return image;
        }
        HashMap<String, MinTimeWeakReference<Image>> cached = null;
        String finalKey = FINAL + width + "_" + height + "_" + (context == null ? null : context.toKeyID());
        if (context == null || context.isUsecache()) {
            HashMap<String, HashMap<String, MinTimeWeakReference<Image>>> hashMap = this.imageCache;
            synchronized (hashMap) {
                cached = this.imageCache.get(key);
                if (cached == null) {
                    cached = new HashMap();
                    this.imageCache.put(key, cached);
                } else {
                    Image img;
                    MinTimeWeakReference<Image> finalCache = cached.get(finalKey);
                    if (finalCache != null && (img = finalCache.get()) != null) {
                        return img;
                    }
                }
            }
        }
        if (context == null) {
            context = this.createNewDefaultContext();
        }
        context.ensureTarget(ThemeContext.Target.IMAGE);
        double highestRequiredScale = MultiResolutionImageHelper.getHighestMonitorScaling();
        int highDPIWidth = width;
        int highDPIHeight = height;
        if (context.isCreateMultiResolutionImages() && this.isUseHighDPI() && highestRequiredScale > 1.0) {
            highDPIWidth = (int)Math.round((double)width * highestRequiredScale);
            highDPIHeight = (int)Math.round((double)height * highestRequiredScale);
        }
        boolean returnMultiResImage = width != highDPIWidth || height != highDPIHeight;
        ImageMatch cachedEntry = this.findBestMatch(cached, height, width);
        Image image2 = baseImage = cachedEntry == null ? null : cachedEntry.image;
        if (width <= 0 && height <= 0) {
            DebugMode.breakIf(cachedEntry != null && cachedEntry.sizeKey != MAX_SIZE_KEY, new Object[0]);
            if (cachedEntry != null && cachedEntry.sizeKey.equals("ORIGINAL@2x")) {
                return baseImage;
            }
            betterImage = this.loadImageFromDisc(key, ENHANCE_DOUBLE_SIZE_TAG, cached, width, height, context);
            if (betterImage != null) {
                this.putFinalCache(key, context, cached, finalKey, betterImage);
                return betterImage;
            }
            if (baseImage == null && (baseImage = this.loadImageFromDisc(key, "", cached, width, height, context)) != null) {
                this.putFinalCache(key, context, cached, finalKey, baseImage);
            }
            if (baseImage != null) {
                this.debugDrawSizeInImages(context, width, height, baseImage);
                return baseImage;
            }
        } else if (baseImage == null) {
            baseImage = this.loadImageFromDisc(key, "", cached, width, height, context);
        }
        if (baseImage == null) {
            return this.onImageNotAvailable(key, context, width, height, cached, finalKey);
        }
        if (!IconIO.isImageCanGetDownscaled(width, height, baseImage) && (betterImage = this.loadImageFromDisc(key, ENHANCE_DOUBLE_SIZE_TAG, cached, width, height, context)) != null) {
            baseImage = betterImage;
        }
        Image baseImageHighDPIFinal = null;
        Image highDPIbase = null;
        double targetBaseFactor = Math.max((double)baseImage.getWidth(null) / (double)width, (double)baseImage.getHeight(null) / (double)height);
        double baseWidthFinal = Math.round((double)baseImage.getWidth(null) / targetBaseFactor);
        double baseHeightFinal = Math.round((double)baseImage.getHeight(null) / targetBaseFactor);
        if (returnMultiResImage) {
            Image betterImage2;
            double targetHighDPIWidth = (int)Math.round(baseWidthFinal * highestRequiredScale);
            double targetHighDPIHeight = (int)Math.round(baseHeightFinal * highestRequiredScale);
            cachedEntry = this.findBestMatch(cached, highDPIWidth, highDPIHeight);
            Image image3 = highDPIbase = cachedEntry == null ? null : cachedEntry.image;
            if (highDPIbase == null) {
                highDPIbase = this.loadImageFromDisc(key, "", cached, highDPIWidth, highDPIHeight, context);
            }
            if (!(cachedEntry != null && cachedEntry.sizeKey.endsWith(ENHANCE_DOUBLE_SIZE_TAG) || highDPIbase != null && IconIO.isImageCanGetDownscaled(highDPIWidth, highDPIHeight, highDPIbase) || (betterImage2 = this.loadImageFromDisc(key, ENHANCE_DOUBLE_SIZE_TAG, cached, width, height, context)) == null)) {
                highDPIbase = betterImage2;
            }
            if (highDPIbase != null) {
                if (IconIO.isImageMaxSizeInViewport(highDPIWidth, highDPIHeight, highDPIbase)) {
                    baseImageHighDPIFinal = highDPIbase;
                } else {
                    URL url;
                    if (context.isDoNotUpscaleButThrowException() && !IconIO.isImageCanGetDownscaled(highDPIWidth, highDPIHeight, highDPIbase)) {
                        throw new SourceImageTooSmallException(key, highDPIbase, highDPIWidth, highDPIHeight);
                    }
                    if (DebugMode.TRUE_IN_IDE_ELSE_FALSE && (url = this.lookupImageUrl(key, context)) != null && url.getPath().endsWith(".svg")) {
                        DebugMode.debugger();
                    }
                    baseImageHighDPIFinal = this.scaleAndCache(key, context, cached, (int)Math.round(targetHighDPIWidth), (int)Math.round(targetHighDPIHeight), highDPIbase);
                }
            }
        }
        if (highDPIbase == baseImage && baseImageHighDPIFinal != null) {
            baseImage = baseImageHighDPIFinal;
        }
        Image baseImageTargetFinal = null;
        if (IconIO.isImageMaxSizeInViewport(width, height, baseImage)) {
            baseImageTargetFinal = baseImage;
        } else {
            URL url;
            if (context.isDoNotUpscaleButThrowException() && !IconIO.isImageCanGetDownscaled(width, height, baseImage)) {
                throw new SourceImageTooSmallException(key, baseImage, width, height);
            }
            if (DebugMode.TRUE_IN_IDE_ELSE_FALSE && (url = this.lookupImageUrl(key, context)) != null && url.getPath().endsWith(".svg")) {
                DebugMode.debugger();
            }
            baseImageTargetFinal = this.scaleAndCache(key, context, cached, (int)Math.round(baseWidthFinal), (int)Math.round(baseHeightFinal), baseImage);
        }
        if (baseImageTargetFinal.getWidth(null) % 4 != 0 || baseImageTargetFinal.getHeight(null) % 4 != 0) {
            LogV3.warning("Image warning: width and height should be dividable by 4 for proper highDPI display!: " + key + ": " + baseImageTargetFinal.getWidth(null) + "x" + baseImageTargetFinal.getHeight(null));
        }
        if (returnMultiResImage && baseImageHighDPIFinal != null && baseImageTargetFinal != null && baseImageHighDPIFinal != baseImageTargetFinal && baseImageHighDPIFinal.getWidth(null) != baseImageTargetFinal.getWidth(null) && baseImageHighDPIFinal.getHeight(null) != baseImageTargetFinal.getHeight(null)) {
            baseImageTargetFinal = MultiResolutionImageHelper.create(0, baseImageTargetFinal, baseImageHighDPIFinal);
        }
        this.putFinalCache(key, context, cached, finalKey, baseImageTargetFinal);
        return baseImageTargetFinal;
    }

    protected Image onImageNotAvailable(String relativePath, ThemeContext context, int width, int height, HashMap<String, MinTimeWeakReference<Image>> cached, String finalKey) {
        if (context.getTarget() != ThemeContext.Target.IMAGE) {
            DebugMode.debugger();
            return null;
        }
        LogV3.info(NO_IMAGE_AVAILABLE + relativePath);
        if (this.doLogMissing) {
            LogV3.log(new Exception("Icon missing: " + this.buildPath("images/", relativePath, ".png|svg|ico", false)));
        }
        DebugMode.debugger();
        BufferedImage ret = this.createNotAvailableImage(width, height);
        this.putFinalCache(relativePath, context, cached, finalKey, ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putFinalCache(String key, ThemeContext context, HashMap<String, MinTimeWeakReference<Image>> cached, String finalKey, Image image) {
        if (ICONDEBUGGER) {
            IconDebugger.show(image, "Image:" + key + " - " + finalKey + "- " + this.lookupImageUrl(key, context));
        }
        if (cached != null) {
            HashMap<String, MinTimeWeakReference<Image>> hashMap = cached;
            synchronized (hashMap) {
                if (cached != null) {
                    MinTimeWeakRefNamed ref = new MinTimeWeakRefNamed(image, this.getCacheLifetime(), finalKey + Theme.getSizeKey(image.getWidth(null), image.getHeight(null)), this);
                    cached.put(finalKey, ref);
                }
            }
        }
    }

    protected void drawTextInViewport(int viewportWidth, int viewportHeight, String text, Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, Interpolation.BILINEAR.getHint());
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font baseFont = new Font("SansSerif", 0, viewportWidth);
        g2d.setFont(baseFont);
        FontMetrics metrics = g2d.getFontMetrics();
        int textWidth = metrics.stringWidth(text);
        int textHeight = metrics.getAscent() + metrics.getDescent();
        double scaleX = (double)viewportWidth / (double)textWidth;
        double scaleY = (double)viewportHeight / (double)textHeight;
        double scale = Math.min(scaleX, scaleY);
        double scaledTextWidth = (double)textWidth * scale;
        double scaledTextHeight = (double)textHeight * scale;
        double offsetX = ((double)viewportWidth - scaledTextWidth) / 2.0;
        double offsetY = ((double)viewportHeight - scaledTextHeight) / 2.0;
        g2d.translate(offsetX, offsetY);
        g2d.scale(scale, scale);
        FontRenderContext frc = g2d.getFontRenderContext();
        GlyphVector gv = baseFont.createGlyphVector(frc, text);
        Shape textShape = gv.getOutline(0.0f, metrics.getAscent());
        g2d.setStroke(new BasicStroke(3.0f / (float)scale, 1, 1));
        Color color = g2d.getColor();
        g2d.setColor(Color.WHITE);
        g2d.draw(textShape);
        g2d.setColor(color);
        g2d.fill(textShape);
        g2d.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Image scaleAndCache(String key, ThemeContext context, HashMap<String, MinTimeWeakReference<Image>> cached, int targetWidth, int targetHeight, Image input) {
        double faktor = Math.max((double)input.getWidth(null) / (double)targetWidth, (double)input.getHeight(null) / (double)targetHeight);
        Image baseImageHighDPIFinal = IconIO.getScaledInstance(input, targetWidth, targetHeight, faktor > 1.0 ? Interpolation.BICUBIC : Interpolation.BILINEAR, true, false);
        baseImageHighDPIFinal = this.debugDrawSizeInImages(context, targetWidth, targetHeight, baseImageHighDPIFinal);
        DebugMode.breakIf(baseImageHighDPIFinal.getWidth(null) != targetWidth && baseImageHighDPIFinal.getHeight(null) != targetHeight, new Object[0]);
        DebugMode.breakIf(targetWidth > 0 && baseImageHighDPIFinal.getWidth(null) > targetWidth || targetHeight > 0 && baseImageHighDPIFinal.getHeight(null) > targetHeight, new Object[0]);
        this.debugWriteScaledImagesToDisk(key, targetWidth, targetHeight, input, baseImageHighDPIFinal);
        if (cached != null) {
            HashMap<String, MinTimeWeakReference<Image>> hashMap = cached;
            synchronized (hashMap) {
                String actualSizeKey = Theme.getSizeKey(baseImageHighDPIFinal.getWidth(null), baseImageHighDPIFinal.getHeight(null));
                MinTimeWeakRefNamed ref = new MinTimeWeakRefNamed(baseImageHighDPIFinal, this.getCacheLifetime(), key + actualSizeKey, this);
                cached.put(Theme.getSizeKey(targetWidth, targetHeight), ref);
                cached.put(actualSizeKey, ref);
            }
        }
        return baseImageHighDPIFinal;
    }

    protected void debugWriteScaledImagesToDisk(String key, int targetWidth, int targetHeight, Image input, Image baseImageHighDPIFinal) {
        if (baseImageHighDPIFinal != input && DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
            File file = Application.getResource("tmp/scaledimage/" + key + "_" + Theme.getSizeKey(targetWidth, targetHeight) + ".png");
            file.delete();
            file.getParentFile().mkdirs();
            try {
                ImageIO.write((RenderedImage)IconIO.toBufferedImage(baseImageHighDPIFinal), "png", file);
            }
            catch (IOException e) {
                LogV3.log(e);
            }
        }
    }

    protected Image debugDrawSizeInImages(ThemeContext context, int targetWidth, int targetHeight, Image src) {
        if (!context.isDebugDrawEnabled() || context.getTarget() != ThemeContext.Target.IMAGE) {
            return src;
        }
        int w = src.getWidth(null);
        int h = src.getHeight(null);
        BufferedImage image = IconIO.createEmptyImage(w, h, 2, 3);
        Graphics2D g = image.createGraphics();
        g.drawImage(src, 0, 0, null);
        g.setColor(Color.BLUE);
        this.drawTextInViewport(src.getWidth(null), src.getHeight(null), targetWidth + "", g);
        g.dispose();
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageMatch findBestMatch(HashMap<String, MinTimeWeakReference<Image>> cached, int height, int width) {
        if (cached == null) {
            return null;
        }
        HashMap<String, MinTimeWeakReference<Image>> hashMap = cached;
        synchronized (hashMap) {
            Image img;
            if (cached.size() == 0) {
                return null;
            }
            String sizeKey = Theme.getSizeKey(width, height);
            MinTimeWeakReference<Image> ret = null;
            if (sizeKey == MAX_SIZE_KEY && (ret = cached.get(sizeKey + ENHANCE_DOUBLE_SIZE_TAG)) != null && (img = ret.get()) != null) {
                return new ImageMatch(img, sizeKey + ENHANCE_DOUBLE_SIZE_TAG);
            }
            ret = cached.get(sizeKey);
            if (ret == null) {
                ret = cached.get(sizeKey + _VECTOR);
            }
            if (ret != null && (img = ret.get()) != null) {
                return new ImageMatch(img, sizeKey);
            }
            if (height <= 0 && width <= 0) {
                return null;
            }
            String bestKeyTarget = null;
            Image baseImageTarget = null;
            for (Map.Entry<String, MinTimeWeakReference<Image>> es : cached.entrySet()) {
                MinTimeWeakReference<Image> ref;
                Image img2;
                if (es.getKey().startsWith(FINAL) || es.getValue() == null || (img2 = (ref = es.getValue()).superget()) == null || !IconIO.isImageCanGetDownscaled(width, height, img2) || baseImageTarget != null && img2.getWidth(null) * img2.getHeight(null) >= baseImageTarget.getWidth(null) * baseImageTarget.getHeight(null)) continue;
                if (es.getKey().endsWith(_VECTOR)) {
                    if (!IconIO.isImageMaxSizeInViewport(width, height, img2)) continue;
                    baseImageTarget = img2;
                    bestKeyTarget = es.getKey();
                    ref.get();
                    return new ImageMatch(img2, bestKeyTarget);
                }
                baseImageTarget = img2;
                bestKeyTarget = es.getKey();
                if (!IconIO.isImageMaxSizeInViewport(width, height, img2)) continue;
                ref.get();
                return new ImageMatch(img2, bestKeyTarget);
            }
            if (baseImageTarget != null) {
                MinTimeWeakReference<Image> ref = cached.get(bestKeyTarget);
                if (ref != null) {
                    ref.get();
                }
                return new ImageMatch(baseImageTarget, bestKeyTarget);
            }
            MinTimeWeakReference<Image> max = cached.get("ORIGINAL@2x");
            if (max != null && (baseImageTarget = max.get()) != null) {
                bestKeyTarget = "ORIGINAL@2x";
                return new ImageMatch(baseImageTarget, bestKeyTarget);
            }
            max = cached.get(MAX_SIZE_KEY);
            if (max != null && (baseImageTarget = max.get()) != null) {
                bestKeyTarget = MAX_SIZE_KEY;
                return new ImageMatch(baseImageTarget, bestKeyTarget);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Image loadImageFromDisc(String key, String enhanceTag, HashMap<String, MinTimeWeakReference<Image>> cached, int widthForVectorGraphics, int heightForVectorGraphics, ThemeContext context) {
        URL url;
        Object cachedEntry;
        boolean cacheMaxSize = true;
        if (cached != null) {
            HashMap<String, MinTimeWeakReference<Image>> hashMap = cached;
            synchronized (hashMap) {
                if (cached.containsKey(MAX_SIZE_KEY + enhanceTag) && (cachedEntry = cached.get(MAX_SIZE_KEY + enhanceTag)) == null) {
                    return null;
                }
            }
        }
        if ((url = this.lookupImageUrl(key + enhanceTag, context)) == null) {
            if (cached != null) {
                cachedEntry = cached;
                synchronized (cachedEntry) {
                    cached.put(MAX_SIZE_KEY + enhanceTag, null);
                }
            }
            return null;
        }
        Image baseImage = null;
        baseImage = FACTORY.urlToImage(url);
        boolean vectorIconSource = false;
        if (baseImage == null && context.getTarget() == ThemeContext.Target.IMAGE) {
            Icon icon = this.getIcon(key + enhanceTag, widthForVectorGraphics, heightForVectorGraphics, context);
            if (icon != null) {
                vectorIconSource = true;
                LogV3.warning("Loaded an Vector graphic as Image. Use getIcon if possible! " + key + enhanceTag + " " + widthForVectorGraphics + ":" + heightForVectorGraphics);
                cacheMaxSize = false;
                baseImage = IconIO.toImage(icon);
            }
        } else {
            this.debugLogImageLoading(key + enhanceTag, url);
        }
        if (vectorIconSource) {
            enhanceTag = enhanceTag + _VECTOR;
        }
        DebugMode.breakIf(baseImage == null && url != null, new Object[0]);
        if (baseImage != null) {
            HashMap<String, MinTimeWeakReference<Image>> hashMap;
            if (MultiResolutionImageHelper.isInstanceOf(baseImage)) {
                if (cached != null) {
                    hashMap = cached;
                    synchronized (hashMap) {
                        Image largest = null;
                        for (Image img : MultiResolutionImageHelper.getResolutionVariants(baseImage)) {
                            String actualSizeKey = Theme.getSizeKey(img.getWidth(null), img.getHeight(null));
                            MinTimeWeakRefNamed ref = new MinTimeWeakRefNamed(img, this.getCacheLifetime(), key + actualSizeKey, this);
                            if (largest == null || img.getWidth(null) * img.getHeight(null) > largest.getWidth(null) * largest.getHeight(null)) {
                                largest = img;
                            }
                            cached.put(actualSizeKey + enhanceTag, ref);
                        }
                        if (cacheMaxSize && largest != null) {
                            String actualSizeKey = Theme.getSizeKey(largest.getWidth(null), largest.getHeight(null));
                            MinTimeWeakRefNamed ref = new MinTimeWeakRefNamed(largest, this.getCacheLifetime(), key + actualSizeKey, this);
                            cached.put(MAX_SIZE_KEY + enhanceTag, ref);
                        }
                    }
                }
            } else if (cached != null) {
                hashMap = cached;
                synchronized (hashMap) {
                    String actualSizeKey = Theme.getSizeKey(baseImage.getWidth(null), baseImage.getHeight(null));
                    MinTimeWeakRefNamed ref = new MinTimeWeakRefNamed(baseImage, this.getCacheLifetime(), key + actualSizeKey, this);
                    if (cacheMaxSize) {
                        cached.put(MAX_SIZE_KEY + enhanceTag, ref);
                    }
                    cached.put(actualSizeKey + enhanceTag, ref);
                }
            }
        }
        return baseImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void debugLogImageLoading(String key, URL url) {
        if (DebugMode.TRUE_IN_IDE_ELSE_FALSE) {
            LogV3.warning("Read Icon from Disk: " + url);
            HashMap<String, AtomicInteger> hashMap = this.debugLoadingMap;
            synchronized (hashMap) {
                String debugKey = "READ:" + key;
                AtomicInteger ex = this.debugLoadingMap.get(debugKey);
                if (ex != null) {
                    ex.incrementAndGet();
                    LogV3.warning("Read Icon from Disk AGAIN(" + ex + "): " + url);
                } else {
                    this.debugLoadingMap.put(debugKey, new AtomicInteger(1));
                }
            }
        }
    }

    public boolean isUseHighDPI() {
        return this.useHighDPI;
    }

    private static String getSizeKey(int w, int h) {
        if (w <= 0) {
            w = -1;
        }
        if (h <= 0) {
            h = -1;
        }
        if (h < 0 && w < 0) {
            return MAX_SIZE_KEY;
        }
        return w + "x" + h;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String getPath() {
        return this.path;
    }

    protected String buildPath(String pre, String path, String ext, boolean fallback) {
        Theme delegate = this.getDelegate();
        String ret = null;
        if (delegate != null) {
            ret = delegate.buildPath(pre, path, ext, fallback);
        }
        if (ret == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(fallback ? this.defaultPath : this.path);
            sb.append(pre);
            sb.append(path);
            sb.append(ext);
            ret = sb.toString();
        }
        return ret;
    }

    public String getText(String string) {
        String ret = null;
        Theme delegate = this.getDelegate();
        if (delegate != null) {
            ret = delegate.getText(string);
        }
        if (ret == null) {
            try {
                URL url = this.getURL("", string, "");
                if (url != null) {
                    ret = IO.readURLToString(url);
                }
            }
            catch (IOException e) {
                LogV3.log(e);
            }
        }
        return ret;
    }

    public String getTheme() {
        return this.theme;
    }

    public URL getURL(String pre, String relativePath, String ext) {
        URL ret = this.getURL(pre, relativePath, ext, false);
        if (ret == null) {
            ret = this.getURL(pre, relativePath, ext, true);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNonEmptyStream(URL url) {
        boolean bl;
        InputStream is = url.openStream();
        try {
            bl = is.read() != -1;
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        is.close();
        return bl;
    }

    private URL getURL(String pre, String relativePath, String ext, boolean useStandardIconPath) {
        URL url = null;
        Theme delegate = this.getDelegate();
        if (delegate != null) {
            url = delegate.getURL(pre, relativePath, ext, useStandardIconPath);
        }
        if (url == null) {
            String path = this.buildPath(pre, relativePath, ext, useStandardIconPath);
            try {
                File file = new File(path);
                if (!file.isAbsolute()) {
                    file = Application.getResource(path);
                }
                if (file.isFile() && file.length() > 0L) {
                    url = file.toURI().toURL();
                }
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (url == null) {
                url = Theme.class.getResource((path.startsWith("/") ? "" : "/") + path);
                if (url != null && url.getPath().endsWith("/")) {
                    url = null;
                } else if (url != null && !this.isNonEmptyStream(url)) {
                    url = null;
                }
            }
        }
        return url;
    }

    public File getImagesDirectory() {
        File ret = null;
        Theme delegate = this.getDelegate();
        if (delegate != null) {
            ret = delegate.getImagesDirectory();
        }
        if (ret == null) {
            ret = Application.getResource(this.buildPath("images/", "image", ".file", false)).getParentFile();
        }
        return ret;
    }

    public boolean hasIcon(String key) {
        boolean hasIcon = false;
        Theme delegate = this.getDelegate();
        if (delegate != null) {
            hasIcon = delegate.hasIcon(key);
        }
        if (!hasIcon) {
            hasIcon = this.lookupImageUrl(key, null) != null;
        }
        return hasIcon;
    }

    public String getIconType(String key) {
        URL url = this.getIconURL(key);
        if (url == null) {
            return null;
        }
        String path = url.getPath().toLowerCase(Locale.ROOT);
        int nameIndex = path.lastIndexOf("/");
        int index = path.lastIndexOf(".");
        if (index <= nameIndex) {
            return null;
        }
        if (index < 0) {
            return "";
        }
        return path.substring(index + 1);
    }

    public URL getIconURL(String string) {
        URL ret = null;
        Theme delegate = this.getDelegate();
        if (delegate != null) {
            ret = delegate.getIconURL(string);
        }
        if (ret == null) {
            ret = this.lookupImageUrl(string, null);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMinTimeWeakReferenceCleanup(MinTimeWeakReference<?> minTimeWeakReference) {
        HashMap<String, MinTimeWeakReference<Icon>> hashMap = this.imageIconCache;
        synchronized (hashMap) {
            this.imageIconCache.remove(minTimeWeakReference.getID());
        }
    }

    public void setCacheLifetime(long cacheLifetime) {
        this.cacheLifetime = cacheLifetime;
    }

    public void setNameSpace(String nameSpace) {
        if (!StringUtils.equals(this.getNameSpace(), nameSpace) && StringUtils.isNotEmpty(nameSpace)) {
            this.nameSpace = nameSpace;
            this.updatePath();
            this.clearCache();
        }
    }

    private void updatePath() {
        this.path = "themes/" + this.getTheme() + "/" + this.getNameSpace();
        this.defaultPath = "themes/standard/" + this.getNameSpace();
    }

    public void setTheme(String theme) {
        if (!StringUtils.equals(this.getTheme(), theme) && StringUtils.isNotEmpty(theme)) {
            this.theme = theme;
            this.updatePath();
            this.clearCache();
        }
    }

    static {
        FACTORY = Theme.createIconFactory();
    }

    private class ImageMatch {
        private final Image image;
        private String sizeKey;

        private ImageMatch(Image img, String sizeKey) {
            this.image = img;
            this.sizeKey = sizeKey;
        }
    }

    private final class MinTimeWeakRefNamed<IconType>
    extends MinTimeWeakReference<IconType> {
        private String name;

        private MinTimeWeakRefNamed(IconType ret, long minLifeTime, String id, MinTimeWeakReferenceCleanup cleanupMinTimeWeakReference) {
            super(ret, minLifeTime, id, cleanupMinTimeWeakReference);
            this.name = ret instanceof Icon ? id + "_" + ((Icon)ret).getIconWidth() + ":" + ((Icon)ret).getIconHeight() : id + "_" + ((Image)ret).getWidth(null) + ":" + ((Image)ret).getHeight(null);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

