/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.handler;

import java.lang.annotation.Annotation;
import org.appwork.storage.Storage;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.DefaultFloatValue;
import org.appwork.storage.config.annotations.FloatSpinnerValidator;
import org.appwork.storage.config.annotations.LookUpKeys;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.utils.StringUtils;

public class FloatKeyHandler
extends KeyHandler<Float> {
    private FloatSpinnerValidator validator;

    public FloatKeyHandler(StorageHandler<?> storageHandler, String key) {
        super(storageHandler, key);
    }

    @Override
    protected Class<? extends Annotation> getDefaultAnnotation() {
        return DefaultFloatValue.class;
    }

    @Override
    protected Class<? extends Annotation>[] getAllowedAnnotations() {
        return new Class[]{LookUpKeys.class, FloatSpinnerValidator.class};
    }

    @Override
    protected void initDefaults() throws Throwable {
        this.setDefaultValue(Float.valueOf(0.0f));
    }

    @Override
    protected Float getValueStorage() {
        Object rawValue = this.getRawValueStorage();
        if (rawValue instanceof Number) {
            return Float.valueOf(((Number)rawValue).floatValue());
        }
        if (rawValue instanceof String) {
            String stringValue = (String)rawValue;
            if (StringUtils.equalsIgnoreCase("null", stringValue)) {
                if (this.isRealPrimitive()) {
                    return Float.valueOf(0.0f);
                }
                return null;
            }
            return Float.valueOf(stringValue);
        }
        return (Float)rawValue;
    }

    @Override
    protected boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x instanceof Float && y instanceof Float) {
            return x.equals(y);
        }
        return false;
    }

    @Override
    protected void initHandler() {
        this.validator = this.getAnnotation(FloatSpinnerValidator.class);
        try {
            this.setDefaultValue(Float.valueOf(this.getAnnotation(DefaultFloatValue.class).value()));
        }
        catch (NullPointerException e) {
            this.setDefaultValue(Float.valueOf(0.0f));
        }
        this.setStorageSyncMode(this.getDefaultStorageSyncMode());
    }

    @Override
    protected void putValue(Float object) {
        Storage storage = this.storageHandler.getPrimitiveStorage(this);
        if (storage != null) {
            storage.put(this.getKey(), object);
        }
    }

    @Override
    protected void validateValue(Float object) throws Throwable {
        if (this.validator != null) {
            float v = object.floatValue();
            float min = this.validator.min();
            float max = this.validator.max();
            if (v < min) {
                throw new ValidationException("value=" + v + " < min=" + min);
            }
            if (v > max) {
                throw new ValidationException("value=" + v + " > max=" + max);
            }
        }
    }
}

