/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.handler;

import java.lang.annotation.Annotation;
import org.appwork.storage.Storage;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.DefaultLongValue;
import org.appwork.storage.config.annotations.LookUpKeys;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.utils.StringUtils;

public class LongKeyHandler
extends KeyHandler<Long> {
    private SpinnerValidator validator;

    public LongKeyHandler(StorageHandler<?> storageHandler, String key) {
        super(storageHandler, key);
    }

    @Override
    protected Class<? extends Annotation>[] getAllowedAnnotations() {
        return new Class[]{LookUpKeys.class, SpinnerValidator.class};
    }

    @Override
    protected Class<? extends Annotation> getDefaultAnnotation() {
        return DefaultLongValue.class;
    }

    @Override
    protected void initDefaults() throws Throwable {
        this.setDefaultValue(0L);
    }

    @Override
    protected void initHandler() {
        this.validator = this.getAnnotation(SpinnerValidator.class);
        this.setStorageSyncMode(this.getDefaultStorageSyncMode());
    }

    @Override
    protected Long getValueStorage() {
        Object rawValue = this.getRawValueStorage();
        if (rawValue instanceof Number) {
            return ((Number)rawValue).longValue();
        }
        if (rawValue instanceof String) {
            String stringValue = (String)rawValue;
            if (StringUtils.equalsIgnoreCase("null", stringValue)) {
                if (this.isRealPrimitive()) {
                    return 0L;
                }
                return null;
            }
            return Long.valueOf(stringValue);
        }
        return (Long)rawValue;
    }

    @Override
    protected void putValue(Long object) {
        Storage storage = this.storageHandler.getPrimitiveStorage(this);
        if (storage != null) {
            storage.put(this.getKey(), object);
        }
    }

    @Override
    protected boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x instanceof Long && y instanceof Long) {
            return x.equals(y);
        }
        return false;
    }

    @Override
    protected void validateValue(Long object) throws Throwable {
        if (this.validator != null) {
            long v = object;
            long min = this.validator.min();
            long max = this.validator.max();
            if (v < min) {
                throw new ValidationException("value=" + v + " < min=" + min);
            }
            if (v > max) {
                throw new ValidationException("value=" + v + " > max=" + max);
            }
        }
    }
}

