/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.swing.models;

import java.awt.Toolkit;
import java.util.Comparator;
import java.util.List;
import javax.swing.SpinnerNumberModel;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.FloatSpinnerValidator;
import org.appwork.storage.config.handler.FloatKeyHandler;
import org.appwork.storage.config.swing.ValueProvider;
import org.appwork.storage.config.swing.ValueProviderListener;
import org.appwork.storage.config.swing.models.KeyHandlerProviderBridge;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.swing.EDTRunner;

public class ConfigFloatSpinnerModel
extends SpinnerNumberModel
implements ValueProviderListener<Float> {
    private static final long serialVersionUID = 1L;
    private final ValueProvider<Float> provider;

    public ConfigFloatSpinnerModel(FloatKeyHandler keyHandler) {
        this(new KeyHandlerProviderBridge<Float>(keyHandler));
    }

    public ConfigFloatSpinnerModel(ValueProvider<Float> provider) {
        this.provider = provider;
        provider.register(this, true);
        List<FloatSpinnerValidator> spinn = provider.getAnnotations(FloatSpinnerValidator.class);
        if (spinn != null && spinn.size() > 0) {
            this.setMinimum((Comparable)Float.valueOf(spinn.get(0).min()));
            this.setMaximum((Comparable)Float.valueOf(spinn.get(0).max()));
            this.setStepSize(Float.valueOf(spinn.get(0).step()));
        }
    }

    public ValueProvider<Float> getProvider() {
        return this.provider;
    }

    public void setMinimum(Comparable minimum) {
        super.setMinimum(Float.valueOf(((Number)((Object)minimum)).floatValue()));
    }

    public void setMaximum(Comparable maximum) {
        super.setMaximum(Float.valueOf(((Number)((Object)maximum)).floatValue()));
    }

    @Override
    public void setStepSize(Number stepSize) {
        super.setStepSize(Float.valueOf(stepSize.floatValue()));
    }

    @Override
    public Number getNumber() {
        return this.getProvider().get();
    }

    @Override
    public Object getNextValue() {
        return this.incrValue(1.0f);
    }

    @Override
    public Object getPreviousValue() {
        return this.incrValue(-1.0f);
    }

    protected static <T extends Number> T incrValue(ConfigFloatSpinnerModel model, Class<T> numClass, float i) {
        Comparator<Number> comparator;
        Float checkAgainst;
        float stepSize = model.getStepSize().floatValue();
        Float current = Float.valueOf(((Number)model.getValue()).floatValue());
        Float maximum = Float.valueOf(((Number)((Object)model.getMaximum())).floatValue());
        Float minimum = Float.valueOf(((Number)((Object)model.getMinimum())).floatValue());
        if (i > 0.0f) {
            if (((Number)current).intValue() == -1 && CompareUtils.compareNumber(current, minimum) == 0) {
                return (T)((Number)ReflectionUtils.cast(0, numClass));
            }
            checkAgainst = maximum;
            comparator = new Comparator<Number>(){

                @Override
                public int compare(Number o1, Number o2) {
                    return CompareUtils.compareNumber(o2, o1);
                }
            };
        } else {
            checkAgainst = minimum;
            comparator = new Comparator<Number>(){

                @Override
                public int compare(Number o1, Number o2) {
                    return CompareUtils.compareNumber(o1, o2);
                }
            };
        }
        float ret = ((Number)current).floatValue() + stepSize * i;
        if (comparator.compare(Float.valueOf(ret), checkAgainst) < 0) {
            while (stepSize > 0.0f) {
                stepSize = stepSize % 10.0f == 0.0f ? (stepSize /= 10.0f) : (stepSize /= 2.0f);
                float check = ((Number)current).floatValue() + stepSize * i;
                if (comparator.compare(Float.valueOf(check), checkAgainst) < 0) continue;
                break;
            }
            if (stepSize == 0.0f) {
                stepSize = 1.0f;
            }
            ret = ((Number)current).floatValue() + stepSize * i;
        }
        return (T)((Number)ReflectionUtils.cast(Float.valueOf(ret), numClass));
    }

    protected Number incrValue(float i) {
        return ConfigFloatSpinnerModel.incrValue(this, Float.class, i);
    }

    @Override
    public Object getValue() {
        return this.getNumber();
    }

    @Override
    public void setValue(Object value) {
        block5: {
            try {
                if (value instanceof Number) {
                    this.getProvider().set(Float.valueOf(((Number)value).floatValue()));
                    break block5;
                }
                if (!(value instanceof String)) break block5;
                try {
                    this.getProvider().set(Float.valueOf(String.valueOf(value)));
                }
                catch (NumberFormatException e) {
                    throw new ValidationException(e);
                }
            }
            catch (ValidationException e) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    @Override
    public void onValueModified(ValueProvider<Float> owner, Float newValue) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ConfigFloatSpinnerModel.this.fireStateChanged();
            }
        };
    }

    @Override
    public void onValueValidationError(ValueProvider<Float> owner, Float invalidValue, Exception exception) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ConfigFloatSpinnerModel.this.fireStateChanged();
            }
        };
    }
}

