/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.swing.models;

import java.awt.Toolkit;
import java.util.Comparator;
import java.util.List;
import javax.swing.SpinnerNumberModel;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.appwork.storage.config.handler.IntegerKeyHandler;
import org.appwork.storage.config.swing.ValueProvider;
import org.appwork.storage.config.swing.ValueProviderListener;
import org.appwork.storage.config.swing.models.KeyHandlerProviderBridge;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.ReflectionUtils;
import org.appwork.utils.swing.EDTRunner;

public class ConfigIntSpinnerModel
extends SpinnerNumberModel
implements ValueProviderListener<Integer> {
    private static final long serialVersionUID = 1L;
    private final ValueProvider<Integer> provider;

    public ConfigIntSpinnerModel(IntegerKeyHandler keyHandler) {
        this(new KeyHandlerProviderBridge<Integer>(keyHandler));
    }

    public ConfigIntSpinnerModel(ValueProvider<Integer> provider) {
        this.provider = provider;
        provider.register(this, true);
        List<SpinnerValidator> spinn = provider.getAnnotations(SpinnerValidator.class);
        if (spinn != null && spinn.size() > 0) {
            this.setMinimum((Comparable)Long.valueOf(spinn.get(0).min()));
            this.setMaximum((Comparable)Long.valueOf(spinn.get(0).max()));
            this.setStepSize(spinn.get(0).step());
        }
    }

    public ValueProvider<Integer> getProvider() {
        return this.provider;
    }

    public void setMinimum(Comparable minimum) {
        super.setMinimum(Integer.valueOf(((Number)((Object)minimum)).intValue()));
    }

    public void setMaximum(Comparable maximum) {
        super.setMaximum(Integer.valueOf(((Number)((Object)maximum)).intValue()));
    }

    @Override
    public void setStepSize(Number stepSize) {
        super.setStepSize(stepSize.intValue());
    }

    @Override
    public Number getNumber() {
        return this.getProvider().get();
    }

    @Override
    public Object getNextValue() {
        return this.incrValue(1);
    }

    @Override
    public Object getPreviousValue() {
        return this.incrValue(-1);
    }

    protected static <T extends Number> T incrValue(SpinnerNumberModel model, Class<T> numClass, int i) {
        Comparator<Number> comparator;
        Long checkAgainst;
        long stepSize = model.getStepSize().longValue();
        Long current = ((Number)model.getValue()).longValue();
        Long maximum = ((Number)((Object)model.getMaximum())).longValue();
        Long minimum = ((Number)((Object)model.getMinimum())).longValue();
        if (i > 0) {
            if (((Number)current).intValue() == -1 && CompareUtils.compareNumber(current, minimum) == 0) {
                return (T)((Number)ReflectionUtils.cast(0, numClass));
            }
            checkAgainst = maximum;
            comparator = new Comparator<Number>(){

                @Override
                public int compare(Number o1, Number o2) {
                    return CompareUtils.compareNumber(o2, o1);
                }
            };
        } else {
            checkAgainst = minimum;
            comparator = new Comparator<Number>(){

                @Override
                public int compare(Number o1, Number o2) {
                    return CompareUtils.compareNumber(o1, o2);
                }
            };
        }
        long ret = current + stepSize * (long)i;
        if (comparator.compare(ret, checkAgainst) < 0) {
            while (stepSize > 0L) {
                stepSize = stepSize % 10L == 0L ? (stepSize /= 10L) : (stepSize /= 2L);
                long check = current + stepSize * (long)i;
                if (comparator.compare(check, checkAgainst) < 0) continue;
                break;
            }
            if (stepSize == 0L) {
                stepSize = 1L;
            }
            ret = current + stepSize * (long)i;
        }
        return (T)((Number)ReflectionUtils.cast(ret, numClass));
    }

    protected Number incrValue(int i) {
        return ConfigIntSpinnerModel.incrValue(this, Integer.class, i);
    }

    @Override
    public Object getValue() {
        return this.getNumber();
    }

    @Override
    public void setValue(Object value) {
        try {
            if (value instanceof Number) {
                this.getProvider().set(((Number)value).intValue());
            } else if (value instanceof String && ((String)value).matches("^-?\\d+$")) {
                this.getProvider().set(Integer.valueOf(String.valueOf(value)));
            }
        }
        catch (ValidationException e) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    @Override
    public void onValueModified(ValueProvider<Integer> owner, Integer newValue) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ConfigIntSpinnerModel.this.fireStateChanged();
            }
        };
    }

    @Override
    public void onValueValidationError(ValueProvider<Integer> owner, Integer invalidValue, Exception exception) {
        new EDTRunner(){

            @Override
            protected void runInEDT() {
                ConfigIntSpinnerModel.this.fireStateChanged();
            }
        };
    }
}

