/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.config.validators;

import java.text.SimpleDateFormat;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.annotations.AbstractValidator;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.StringUtils;

public class DefaultSimpleDateValidator
extends AbstractValidator<String> {
    @Override
    public void validate(KeyHandler<String> keyHandler, String pattern) throws ValidationException {
        if (pattern == null) {
            return;
        }
        if (StringUtils.isEmpty(pattern)) {
            throw new ValidationException("Key:" + keyHandler.getKey() + "|Pattern is empty");
        }
        try {
            new SimpleDateFormat(pattern).toPattern();
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Key:" + keyHandler.getKey() + "|SimpleDate pattern is invalid:" + pattern, e);
        }
    }
}

