/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.SimpleTypeRef;
import org.appwork.storage.TypeRef;
import org.appwork.storage.flexijson.FlexiCommentJsonNode;
import org.appwork.storage.flexijson.FlexiJSonArray;
import org.appwork.storage.flexijson.FlexiJSonComments;
import org.appwork.storage.flexijson.FlexiJSonNode;
import org.appwork.storage.flexijson.FlexiJSonValue;
import org.appwork.storage.flexijson.FlexiUtils;
import org.appwork.storage.flexijson.InvalidPathException;
import org.appwork.storage.flexijson.JSPath;
import org.appwork.storage.flexijson.KeyValueElement;
import org.appwork.storage.flexijson.mapper.FlexiJSonMapper;
import org.appwork.storage.flexijson.mapper.FlexiMapperException;
import org.appwork.storage.flexijson.mapper.FlexiMapperTags;
import org.appwork.storage.flexijson.stringify.FlexiJSonPrettyStringify;
import org.appwork.storage.flexijson.stringify.FlexiJSonStringBuilder;
import org.appwork.storage.simplejson.JSonUtils;
import org.appwork.utils.reflection.CompiledType;

public class FlexiJSonObject
implements FlexiJSonNode {
    private final LinkedList<KeyValueElement> elements = new LinkedList();
    private HashSet<FlexiMapperTags> tags;
    private int size = 0;
    private final LinkedHashSet<String> keys = new LinkedHashSet();
    private FlexiJSonComments commentsBefore;
    private FlexiJSonComments commentsInside;
    private FlexiJSonComments commentsAfter;
    private FlexiJSonNode parent;
    protected String close = "\r\n}";
    protected String keyValueDeliminator = " : ";
    protected String empty = "{}";
    protected String open = "{\r\n";
    protected String fieldDeliminator = ",\r\n";
    public static String PRETTY_PRINT_LAYER_INSET = " ";

    public LinkedList<KeyValueElement> getElements() {
        return this.elements;
    }

    @Override
    public void tag(FlexiMapperTags tag) {
        if (this.tags == null) {
            this.tags = new HashSet();
        }
        if (tag != null) {
            this.tags.add(tag);
        }
    }

    @Override
    public Set<FlexiMapperTags> getTags() {
        return this.tags;
    }

    public FlexiJSonComments getCommentsInside() {
        return this.commentsInside;
    }

    public void setCommentsInside(FlexiJSonComments commentsInside) {
        if (commentsInside != null) {
            commentsInside.setParent(this);
            for (FlexiCommentJsonNode comment : commentsInside) {
                comment.setLocation(FlexiCommentJsonNode.AttachLocation.INSIDE_OBJECT);
            }
        }
        this.commentsInside = commentsInside;
    }

    @Override
    public FlexiJSonComments getCommentsBefore() {
        return this.commentsBefore;
    }

    @Override
    public void setCommentsBefore(FlexiJSonComments commentsBefore) {
        if (commentsBefore != null) {
            commentsBefore.setParent(this);
            for (FlexiCommentJsonNode comment : commentsBefore) {
                comment.setLocation(FlexiCommentJsonNode.AttachLocation.BEFORE_OBJECT);
            }
        }
        this.commentsBefore = commentsBefore;
    }

    @Override
    public FlexiJSonComments getCommentsAfter() {
        return this.commentsAfter;
    }

    @Override
    public void setCommentsAfter(FlexiJSonComments commentsAfter) {
        if (commentsAfter != null) {
            commentsAfter.setParent(this);
            for (FlexiCommentJsonNode comment : commentsAfter) {
                comment.setLocation(FlexiCommentJsonNode.AttachLocation.AFTER_OBJECT);
            }
        }
        this.commentsAfter = commentsAfter;
    }

    public boolean containsKey(String key) {
        return this.keys.contains(key);
    }

    public KeyValueElement add(KeyValueElement element) {
        KeyValueElement removed = this.remove(element.getKey());
        element.getValue().setParent(this);
        FlexiJSonComments comment = element.getCommentsAfterKey();
        if (comment != null) {
            comment.setParent(this);
        }
        if ((comment = element.getCommentsBeforeKey()) != null) {
            comment.setParent(this);
        }
        this.elements.add(element);
        if (element.getKey() != null) {
            this.keys.add(element.getKey());
            ++this.size;
        }
        return removed;
    }

    @Override
    public void setParent(FlexiJSonNode parent) {
        this.parent = parent;
    }

    @Override
    public FlexiJSonNode getParent() {
        return this.parent;
    }

    public int size() {
        return this.size;
    }

    public void addCommentsInside(FlexiJSonComments comments) {
        if (comments == null) {
            return;
        }
        comments.setParent(this);
        for (FlexiCommentJsonNode comment : comments) {
            comment.setLocation(FlexiCommentJsonNode.AttachLocation.INSIDE_OBJECT);
        }
        if (this.commentsInside == null) {
            this.commentsInside = comments;
        } else {
            this.commentsInside.addAll(comments);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + FlexiUtils.getPathString(this) + "\r\n" + new FlexiJSonPrettyStringify().toJSONString(this);
    }

    protected String toStringKey(String key) {
        return "\"" + JSonUtils.escape(key) + "\"";
    }

    @Override
    public void addCommentsBefore(FlexiJSonComments comments) {
        if (comments == null) {
            return;
        }
        comments.setParent(this);
        for (FlexiCommentJsonNode comment : comments) {
            comment.setLocation(FlexiCommentJsonNode.AttachLocation.BEFORE_OBJECT);
        }
        if (this.commentsBefore == null) {
            this.commentsBefore = comments;
        } else {
            this.commentsBefore.addAll(comments);
        }
    }

    @Override
    public void addCommentsAfter(FlexiJSonComments comments) {
        if (comments == null) {
            return;
        }
        comments.setParent(this);
        for (FlexiCommentJsonNode comment : comments) {
            comment.setLocation(FlexiCommentJsonNode.AttachLocation.AFTER_OBJECT);
        }
        if (this.commentsAfter == null) {
            this.commentsAfter = comments;
        } else {
            this.commentsAfter.addAll(comments);
        }
    }

    public KeyValueElement last() {
        if (this.elements.size() == 0) {
            return null;
        }
        return this.elements.get(this.elements.size() - 1);
    }

    @Override
    public void writeToStream(FlexiJSonStringBuilder stringifier, FlexiJSonStringBuilder.JSONBuilderOutputStream out, int layer, LinkedList<String> path) throws IOException {
        stringifier.appendObject(this, out, layer, path);
    }

    public boolean hasCommentsInside() {
        return this.getCommentsInside() != null && this.getCommentsInside().size() > 0;
    }

    @Override
    public boolean hasComments() {
        if (this.getCommentsInside() != null && this.getCommentsInside().size() > 0) {
            return true;
        }
        if (this.getCommentsAfter() != null && this.getCommentsAfter().size() > 0) {
            return true;
        }
        return this.getCommentsBefore() != null && this.getCommentsBefore().size() > 0;
    }

    public KeyValueElement getElement(String key) {
        for (KeyValueElement e : this.elements) {
            if (!(key == null ? e.getKey() == null : key.equals(e.getKey()))) continue;
            return e;
        }
        return null;
    }

    public FlexiJSonNode resolvePath(String path) throws InvalidPathException {
        return this.resolvePath(JSPath.fromPathString(path));
    }

    @Override
    public FlexiJSonNode resolvePath(JSPath path) {
        FlexiJSonObject obj = this;
        return FlexiJSonObject.resolvePath(path, obj);
    }

    public static FlexiJSonNode resolvePath(JSPath path, FlexiJSonNode obj) {
        int depths = 0;
        for (Object key : path.getElements()) {
            if (obj == null) {
                return null;
            }
            if ("".equals(key)) {
                ++depths;
                continue;
            }
            if (obj instanceof FlexiJSonObject) {
                KeyValueElement el = ((FlexiJSonObject)obj).getElement(String.valueOf(key));
                if (el == null) {
                    return null;
                }
                obj = el.getValue();
                ++depths;
                continue;
            }
            if (obj instanceof FlexiJSonArray) {
                try {
                    if (!(key instanceof Number)) {
                        key = Integer.parseInt(String.valueOf(key));
                    }
                    obj = (FlexiJSonNode)((FlexiJSonArray)obj).get(((Number)key).intValue());
                    ++depths;
                    continue;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            if (depths == path.size() - 1) {
                return obj;
            }
            return null;
        }
        return obj;
    }

    public static int minIndex(int ... options) {
        int ret = Integer.MAX_VALUE;
        for (int i : options) {
            if (i < 0) continue;
            ret = Math.min(ret, i);
        }
        return ret == Integer.MAX_VALUE ? -1 : ret;
    }

    public KeyValueElement remove(String key) {
        if (!this.keys.contains(key)) {
            return null;
        }
        for (KeyValueElement e : this.elements) {
            if (!e.getKey().equals(key)) continue;
            this.elements.remove(e);
            if (key != null) {
                this.keys.remove(key);
                --this.size;
            }
            return e;
        }
        return null;
    }

    public int hashCode() {
        return FlexiJSonObject.class.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof FlexiJSonObject)) {
            return false;
        }
        FlexiJSonObject other = (FlexiJSonObject)obj;
        if (other.size() != this.size()) {
            return false;
        }
        if (!other.keys.equals(this.keys)) {
            return false;
        }
        FlexiJSonStringBuilder stringify = new FlexiJSonStringBuilder();
        return stringify.toJSONString(other).equals(stringify.toJSONString(this));
    }

    public void replace(String path, FlexiJSonNode newValue) throws InvalidPathException {
        JSPath split = JSPath.fromPathString(path);
        FlexiJSonNode old = this.resolvePath(split);
        FlexiJSonNode oldParent = old.getParent();
        newValue.setParent(oldParent);
        Object last = split.getLast();
        if (oldParent instanceof FlexiJSonObject && last instanceof String) {
            ((FlexiJSonObject)oldParent).getElement((String)last).setValue(newValue);
        } else if (oldParent instanceof FlexiJSonArray && last instanceof Number) {
            ((FlexiJSonArray)oldParent).set(((Number)last).intValue(), newValue);
        } else {
            throw new WTFException("Unknown container type");
        }
    }

    @Override
    public boolean remove(FlexiJSonNode node) {
        FlexiJSonValue.removeCommentsFromNode(node, this);
        if (node instanceof FlexiJSonComments && node == this.getCommentsInside()) {
            this.setCommentsInside(null);
            return true;
        }
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            if (((KeyValueElement)it.next()).getValue() != node) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public KeyValueElement getElementByNode(FlexiJSonNode node) {
        for (KeyValueElement e : this.elements) {
            if (e.getValue() != node) continue;
            return e;
        }
        return null;
    }

    public void put(String key, Object obj) throws FlexiMapperException {
        if (obj instanceof FlexiJSonNode) {
            this.add(new KeyValueElement(this, key, (FlexiJSonNode)obj));
        } else {
            this.add(new KeyValueElement(this, key, new FlexiJSonMapper().objectToJsonNode(obj)));
        }
    }

    public FlexiJSonNode getNode(String key) {
        KeyValueElement el = this.getElement(key);
        if (el != null) {
            return el.getValue();
        }
        return null;
    }

    public Set<String> getKeys() {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        for (KeyValueElement e : this.elements) {
            if (e.getKey() == null) continue;
            ret.add(e.getKey());
        }
        return ret;
    }

    public void sort(Comparator<KeyValueElement> comparator) {
        Collections.sort(this.elements, comparator);
    }

    public <T> T get(String path, Class<T> type) throws FlexiMapperException, InvalidPathException {
        return this.get(JSPath.fromPathString(path), type);
    }

    public <T> T get(JSPath path, Class<T> type) throws FlexiMapperException {
        return this.get(path, new SimpleTypeRef(type));
    }

    public <T> T get(JSPath path, TypeRef<T> type) throws FlexiMapperException {
        FlexiJSonNode value = this.resolvePath(path);
        CompiledType ct = CompiledType.create(type);
        if (value == null || ct.isInstanceOf(value.getClass())) {
            return (T)value;
        }
        return (T)new FlexiJSonMapper().jsonToObject(value, ct);
    }

    public <T> T getNE(String path, Class<T> type) {
        try {
            return this.get(path, type);
        }
        catch (FlexiMapperException e) {
            throw new WTFException(e);
        }
        catch (InvalidPathException e) {
            throw new WTFException(e);
        }
    }

    public void replaceNE(String path, FlexiJSonValue newNode) {
        try {
            this.replace(path, newNode);
        }
        catch (InvalidPathException e) {
            throw new WTFException(e);
        }
    }
}

