/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.mapper.mod.tests;

import java.util.Arrays;
import java.util.HashSet;
import org.appwork.storage.flexijson.FlexiJSonObject;
import org.appwork.storage.flexijson.FlexiUtils;
import org.appwork.storage.flexijson.mapper.mod.FlexiModifier;
import org.appwork.storage.flexijson.mapper.mod.IllegalPathException;
import org.appwork.storage.flexijson.mapper.mod.JsonModification;
import org.appwork.testframework.AWTest;

public class FlexiMergerTest
extends AWTest {
    @Override
    public void runTest() throws Exception {
        FlexiJSonObject base = new FlexiJSonObject();
        FlexiModifier mod = new FlexiModifier(base);
        JsonModification mods = new JsonModification();
        FlexiJSonObject set = new FlexiJSonObject();
        set.put("a.b.c", 1);
        set.put("a.array.1", 1);
        set.put("a.array.3", 3);
        set.put("bool", true);
        mods.setSet(set);
        mod.setAutoCreateStructures(false);
        try {
            mod.merge(mods);
            throw new Exception("IllegalPathException expected");
        }
        catch (IllegalPathException illegalPathException) {
            mod.setAutoCreateStructures(true);
            mod.merge(mods);
            String json = FlexiUtils.serializeMinimized(base);
            FlexiMergerTest.assertEquals("{\"a\":{\"b\":{\"c\":1},\"array\":[null,1,null,3]},\"bool\":true}", json);
            set = new FlexiJSonObject();
            set.put("[0]", true);
            mods.setSet(set);
            try {
                mod.merge(mods);
                throw new Exception("IllegalPathException expected");
            }
            catch (IllegalPathException illegalPathException2) {
                json = FlexiUtils.serializeMinimized(base);
                set = new FlexiJSonObject();
                set.put("0", true);
                mods.setSet(set);
                try {
                    mod.merge(mods);
                    throw new Exception("IllegalPathException expected");
                }
                catch (IllegalPathException illegalPathException3) {
                    json = FlexiUtils.serializeMinimized(base);
                    set = new FlexiJSonObject();
                    mods.setSet(set);
                    mods.setUnset(new HashSet<String>(Arrays.asList("a.b.c", "a.b.array[0]", "a.array[0]")));
                    mod.merge(mods);
                    json = FlexiUtils.serializeMinimized(base);
                    FlexiMergerTest.assertEquals("{\"a\":{\"b\":{},\"array\":[1,null,3]},\"bool\":true}", json);
                    set = new FlexiJSonObject();
                    set.put("newEntry", "test");
                    set.put("a", null);
                    set.put("a.b.newEntry2", "yeah");
                    mods.setSet(null);
                    mods.setUnset(null);
                    mods.setSetIfUnset(set);
                    mod.merge(mods);
                    json = FlexiUtils.serializeMinimized(base);
                    FlexiMergerTest.assertEquals("{\"a\":{\"b\":{\"newEntry2\":\"yeah\"},\"array\":[1,null,3]},\"bool\":true,\"newEntry\":\"test\"}", json);
                    System.out.println(json);
                    return;
                }
            }
        }
    }

    public static void main(String[] args) {
        FlexiMergerTest.run();
    }
}

