/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.flexijson.mapper.tests;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.appwork.storage.SimpleTypeRef;
import org.appwork.storage.TypeRef;
import org.appwork.storage.flexijson.FlexiParserException;
import org.appwork.storage.flexijson.FlexiUtils;
import org.appwork.storage.flexijson.mapper.FlexiMapperException;
import org.appwork.testframework.AWTest;
import org.appwork.utils.reflection.tests.GenericsInDifferentLayersFullyResolved;
import org.appwork.utils.reflection.tests.ReReGenericDefinition;

public class FlexiMapperTestOnGenericMapsAndCollections
extends AWTest {
    public static void main(String[] args) throws FlexiMapperException, FlexiParserException {
        FlexiMapperTestOnGenericMapsAndCollections.run();
    }

    @Override
    public void runTest() throws Exception {
        this.testOnGenericsInDifferentLayersFullyResolved();
        this.testOnReReGenericDefinition();
        HashMap obj = new HashMap();
        ArrayList<Boolean> list = new ArrayList<Boolean>(Arrays.asList(true, false));
        HashMap<String, ArrayList<Boolean>> innerMap = new HashMap<String, ArrayList<Boolean>>();
        innerMap.put("InnerKey", list);
        obj.put("outerKey2", innerMap);
        String serialized = FlexiUtils.serializeMinimized(obj);
        FlexiMapperTestOnGenericMapsAndCollections.assertEquals(serialized, "{\"outerKey2\":{\"InnerKey\":[true,false]}}");
        HashMap<String, HashMap<String, ArrayList<Boolean>>> restored = FlexiUtils.jsonToObject(serialized, new TypeRef<HashMap<String, HashMap<String, ArrayList<Boolean>>>>(){});
        FlexiMapperTestOnGenericMapsAndCollections.assertEqualsDeep(restored, obj);
    }

    public void testOnGenericsInDifferentLayersFullyResolved() throws FlexiMapperException, Exception, FlexiParserException {
        GenericsInDifferentLayersFullyResolved obj = new GenericsInDifferentLayersFullyResolved();
        obj.put("mykey", 123L);
        String serialized = FlexiUtils.serializeToPrettyJson(obj);
        FlexiMapperTestOnGenericMapsAndCollections.assertEquals(serialized, "{\"mykey\":123}");
        GenericsInDifferentLayersFullyResolved restored = (GenericsInDifferentLayersFullyResolved)FlexiUtils.jsonToObject(serialized, new SimpleTypeRef((Type)((Object)GenericsInDifferentLayersFullyResolved.class)));
        FlexiMapperTestOnGenericMapsAndCollections.assertEqualsDeep(restored, obj);
    }

    public void testOnReReGenericDefinition() throws FlexiMapperException, Exception, FlexiParserException {
        ReReGenericDefinition testobj = new ReReGenericDefinition();
        testobj.put("Test", "Value");
        String serialized = FlexiUtils.serializeToPrettyJson(testobj);
        FlexiMapperTestOnGenericMapsAndCollections.assertEquals(serialized, "{\"Test\":\"Value\"}");
        ReReGenericDefinition restored = (ReReGenericDefinition)FlexiUtils.jsonToObject(serialized, new SimpleTypeRef((Type)((Object)ReReGenericDefinition.class)));
        FlexiMapperTestOnGenericMapsAndCollections.assertEqualsDeep(restored, testobj);
    }
}

