/*
 * Decompiled with CFR 0.152.
 */
package org.appwork.storage.simplejson;

import java.util.Locale;
import org.appwork.utils.formatter.HexFormatter;

public class JSonUtils {
    public static String escape(String s) {
        return JSonUtils.escape(s, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String escape(String s, boolean doubleQuoteEscape) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (true) {
            block15: {
                if (i >= s.length()) {
                    return sb.toString();
                }
                char ch = s.charAt(i);
                switch (ch) {
                    case '\"': {
                        if (!doubleQuoteEscape) break;
                        sb.append("\\\"");
                        break block15;
                    }
                    case '\'': {
                        if (doubleQuoteEscape) break;
                        sb.append("\\'");
                        break block15;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        break block15;
                    }
                    case '\b': {
                        sb.append("\\b");
                        break block15;
                    }
                    case '\f': {
                        sb.append("\\f");
                        break block15;
                    }
                    case '\n': {
                        sb.append("\\n");
                        break block15;
                    }
                    case '\r': {
                        sb.append("\\r");
                        break block15;
                    }
                    case '\t': {
                        sb.append("\\t");
                        break block15;
                    }
                }
                if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                    String ss = Integer.toHexString(ch);
                    sb.append("\\u");
                    for (int k = 0; k < 4 - ss.length(); ++k) {
                        sb.append('0');
                    }
                    sb.append(ss.toUpperCase(Locale.ENGLISH));
                } else {
                    sb.append(ch);
                }
            }
            ++i;
        }
    }

    public static void main(String[] args) {
        String str = "\\\r\t\b\n\f\"abc\u2011&\uffff";
        for (int i = 0; i < "\\\r\t\b\n\f\"abc\u2011&\uffff".length(); ++i) {
            String s = "\\\r\t\b\n\f\"abc\u2011&\uffff".substring(i, i + 1);
            String str2 = JSonUtils.escape(s);
            String str3 = JSonUtils.unescape(str2);
            System.out.println(str3);
            System.out.println(s + " - " + HexFormatter.byteArrayToHex(s.getBytes()));
            System.out.println("OK: " + s + "|" + str3.equals(s));
        }
        String s = "\\\r\t\b\n\f\"abc\u2011&\uffff";
        String str2 = JSonUtils.escape("\\\r\t\b\n\f\"abc\u2011&\uffff");
        String str3 = JSonUtils.unescape(str2);
        System.out.println(HexFormatter.byteArrayToHex(str3.getBytes()));
        System.out.println(HexFormatter.byteArrayToHex("\\\r\t\b\n\f\"abc\u2011&\uffff".getBytes()));
        System.out.println("OK: |" + str3.equals("\\\r\t\b\n\f\"abc\u2011&\uffff"));
        System.out.println("Max Value: " + ('\uffff' == JSonUtils.unescape("\\uFFFF").charAt(0)));
    }

    public static String unescape(String s) {
        StringBuilder sb = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        block13: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\\': {
                    ch = s.charAt(++i);
                    switch (ch) {
                        case '\"': {
                            sb.append('\"');
                            continue block13;
                        }
                        case '\\': {
                            sb.append('\\');
                            continue block13;
                        }
                        case 'r': {
                            sb.append('\r');
                            continue block13;
                        }
                        case 'n': {
                            sb.append('\n');
                            continue block13;
                        }
                        case 't': {
                            sb.append('\t');
                            continue block13;
                        }
                        case 'f': {
                            sb.append('\f');
                            continue block13;
                        }
                        case 'b': {
                            sb.append('\b');
                            continue block13;
                        }
                        case 'u': {
                            sb2.delete(0, sb2.length());
                            int ii = ++i + 4;
                            while (i < ii) {
                                ch = s.charAt(i);
                                if (sb2.length() > 0 || ch != '0') {
                                    sb2.append(ch);
                                }
                                ++i;
                            }
                            --i;
                            sb.append((char)Integer.parseInt(sb2.toString(), 16));
                            continue block13;
                        }
                    }
                    sb.append(ch);
                    continue block13;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }
}

